/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcBatchUpdateException;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcResultSet;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcTypeInfo;

public class JdbcOdbcStatement
extends JdbcOdbcObject
implements Statement {
    protected JdbcOdbc OdbcApi = null;
    protected long hDbc = 0L;
    protected long hStmt = 0L;
    protected SQLWarning lastWarning = null;
    protected Hashtable typeInfo;
    protected ResultSet myResultSet;
    protected JdbcOdbcConnectionInterface myConnection;
    protected int rsType;
    protected int rsConcurrency;
    protected int fetchDirection;
    protected int fetchSize;
    protected Vector batchSqlVec;
    protected boolean batchSupport;
    protected int batchRCFlag;
    protected String mySql;
    protected boolean batchOn;
    protected int rsBlockSize;
    protected int moreResults;
    protected boolean closeCalledFromFinalize;

    public JdbcOdbcStatement(JdbcOdbcConnectionInterface paramJdbcOdbcConnectionInterface) {
        this.myConnection = paramJdbcOdbcConnectionInterface;
        this.rsType = 1003;
        this.rsConcurrency = 1007;
        this.fetchDirection = 1000;
        this.fetchSize = 1;
        this.batchRCFlag = -1;
        this.batchSupport = false;
        this.moreResults = 1;
    }

    protected void finalize() {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("Statement.finalize " + this);
        }
        try {
            this.closeCalledFromFinalize = true;
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void initialize(JdbcOdbc paramJdbcOdbc, long paramLong1, long paramLong2, Hashtable paramHashtable, int paramInt1, int paramInt2) throws SQLException {
        block17: {
            block16: {
                this.OdbcApi = paramJdbcOdbc;
                this.hDbc = paramLong1;
                this.hStmt = paramLong2;
                this.rsType = paramInt1;
                this.rsConcurrency = paramInt2;
                this.typeInfo = paramHashtable;
                this.batchRCFlag = this.myConnection.getBatchRowCountFlag(1);
                this.batchSupport = this.batchRCFlag > 0 && this.batchRCFlag == 2;
                if (this.rsType == 1003 || this.rsType == 1004 || this.rsType == 1005) {
                    if (this.rsConcurrency != 1007 && this.rsConcurrency != 1008) {
                        this.close();
                        throw new SQLException("Invalid Concurrency Type.");
                    }
                } else {
                    this.close();
                    throw new SQLException("Invalid Cursor Type.");
                }
                int i = this.myConnection.getOdbcCursorType(this.rsType);
                if (i == -1) {
                    i = this.myConnection.getBestOdbcCursorType();
                    if (i == -1) {
                        throw new SQLException("The result set type is not supported.");
                    }
                    this.setWarning(new SQLWarning("The result set type has been downgraded and changed."));
                    switch (i) {
                        case 0: {
                            this.rsType = 1003;
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.rsType = 1004;
                        }
                    }
                }
                if (this.rsConcurrency == 1008) {
                    i = 2;
                }
                try {
                    this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)6, i);
                }
                catch (SQLWarning localSQLWarning1) {
                    this.setWarning(localSQLWarning1);
                }
                catch (SQLException localSQLException1) {
                    if (i == 0) break block16;
                    localSQLException1.fillInStackTrace();
                    throw localSQLException1;
                }
            }
            short j = this.myConnection.getOdbcConcurrency(this.rsConcurrency);
            try {
                this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)7, j);
            }
            catch (SQLWarning localSQLWarning2) {
                this.setWarning(localSQLWarning2);
            }
            catch (SQLException localSQLException2) {
                if (j == 1) break block17;
                localSQLException2.fillInStackTrace();
                throw localSQLException2;
            }
        }
    }

    @Override
    public ResultSet executeQuery(String paramString) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.executeQuery (" + paramString + ")");
        }
        ResultSet localResultSet = null;
        if (!this.execute(paramString)) {
            throw new SQLException("No ResultSet was produced");
        }
        localResultSet = this.getResultSet(false);
        if (this.batchOn) {
            this.clearBatch();
        }
        return localResultSet;
    }

    @Override
    public int executeUpdate(String paramString) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.executeUpdate (" + paramString + ")");
        }
        int i = -1;
        if (this.execute(paramString)) {
            throw new SQLException("No row count was produced");
        }
        i = this.getUpdateCount();
        if (this.batchOn) {
            this.clearBatch();
        }
        return i;
    }

    @Override
    public synchronized boolean execute(String paramString) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.execute (" + paramString + ")");
        }
        boolean bool = false;
        SQLWarning localObject = null;
        this.setSql(paramString);
        this.reset();
        this.lockIfNecessary(paramString);
        try {
            this.OdbcApi.SQLExecDirect(this.hStmt, paramString);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        if (this.getColumnCount() > 0) {
            bool = true;
        }
        if (this.batchOn) {
            this.clearBatch();
        }
        return bool;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getResultSet");
        }
        if (this.myResultSet != null) {
            return this.myResultSet;
        }
        this.myResultSet = this.getResultSet(true);
        return this.myResultSet;
    }

    public synchronized ResultSet getResultSet(boolean paramBoolean) throws SQLException {
        if (this.myResultSet != null) {
            throw new SQLException("Invalid state for getResultSet");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        int i = 1;
        if (paramBoolean) {
            i = this.getColumnCount();
        }
        if (i > 0) {
            if (this.rsType != 1003) {
                this.checkCursorDowngrade();
            }
            localJdbcOdbcResultSet = new JdbcOdbcResultSet();
            localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, this.hStmt, true, this);
            this.myResultSet = localJdbcOdbcResultSet;
        } else {
            this.clearMyResultSet();
        }
        return localJdbcOdbcResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getUpdateCount");
        }
        int i = -1;
        if (this.moreResults == 3) {
            return i;
        }
        if (this.getColumnCount() == 0) {
            i = this.getRowCount();
        }
        return i;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0L) {
                if (this.closeCalledFromFinalize) {
                    if (!this.myConnection.isFreeStmtsFromConnectionOnly()) {
                        this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                    }
                } else {
                    this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                }
                this.hStmt = 0L;
            }
        }
        catch (SQLException localSQLException) {
            localSQLException.printStackTrace();
        }
        this.myConnection.deregisterStatement(this);
    }

    protected void reset() throws SQLException {
        this.clearWarnings();
        this.clearMyResultSet();
        if (this.hStmt != 0L) {
            this.OdbcApi.SQLFreeStmt(this.hStmt, 0);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getMoreResults");
        }
        SQLWarning localObject = null;
        boolean bool = false;
        if (this.moreResults == 1) {
            this.moreResults = 3;
        }
        this.clearWarnings();
        try {
            this.moreResults = this.OdbcApi.SQLMoreResults(this.hStmt) ? 2 : 3;
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        if (this.moreResults == 2 && this.getColumnCount() != 0) {
            bool = true;
        }
        this.setWarning(localObject);
        return bool;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getMaxFieldSize");
        }
        return this.getStmtOption((short)3);
    }

    @Override
    public void setMaxFieldSize(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.setMaxFieldSize (" + paramInt + ")");
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)3, paramInt);
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getMaxRows");
        }
        return this.getStmtOption((short)1);
    }

    @Override
    public void setMaxRows(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.setMaxRows (" + paramInt + ")");
        }
        if (paramInt < 0) {
            throw new SQLException("Invalid new max row limit");
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)1, paramInt);
    }

    @Override
    public void setEscapeProcessing(boolean paramBoolean) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.setEscapeProcessing (" + paramBoolean + ")");
        }
        int i = 0;
        if (!paramBoolean) {
            i = 1;
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)2, i);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getQueryTimeout");
        }
        return this.getStmtOption((short)0);
    }

    @Override
    public void setQueryTimeout(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.setQueryTimeout (" + paramInt + ")");
        }
        this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)0, paramInt);
    }

    @Override
    public void cancel() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.cancel");
        }
        this.clearWarnings();
        try {
            this.OdbcApi.SQLCancel(this.hStmt);
        }
        catch (SQLWarning localSQLWarning) {
            this.setWarning(localSQLWarning);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.getWarnings");
        }
        return this.lastWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public void setWarning(SQLWarning paramSQLWarning) {
        this.lastWarning = paramSQLWarning;
    }

    @Override
    public void setCursorName(String paramString) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.setCursorName " + paramString + ")");
        }
        this.OdbcApi.SQLSetCursorName(this.hStmt, paramString);
    }

    @Override
    public void setFetchDirection(int paramInt) throws SQLException {
        if (paramInt != 1000 && paramInt != 1001 && paramInt != 1002) {
            throw new SQLException("Invalid fetch direction");
        }
        this.fetchDirection = paramInt;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int paramInt) throws SQLException {
        if (0 > paramInt || paramInt > this.getMaxRows()) {
            throw new SQLException("Invalid Fetch Size");
        }
        this.fetchSize = paramInt;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    @Override
    public void addBatch(String paramString) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.addBatch (" + paramString + ")");
        }
        try {
            if (paramString != null) {
                this.batchSqlVec = this.myConnection.getBatchVector(this);
                if (this.batchSqlVec == null) {
                    this.batchSqlVec = new Vector(5, 10);
                }
                this.batchSqlVec.addElement(paramString);
                this.myConnection.setBatchVector(this.batchSqlVec, this);
                this.batchOn = true;
            }
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    @Override
    public void clearBatch() {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*Statement.clearBatch");
        }
        try {
            if (this.batchSqlVec != null) {
                this.myConnection.removeBatchVector(this);
                this.batchSqlVec = null;
                this.batchOn = false;
            }
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    @Override
    public int[] executeBatch() throws BatchUpdateException {
        return this.executeBatchUpdate();
    }

    protected int[] executeBatchUpdate() throws BatchUpdateException {
        int[] arrayOfInt1;
        block10: {
            arrayOfInt1 = new int[]{};
            int[] arrayOfInt2 = null;
            int i = 0;
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("*Statement.executeBatch");
            }
            if (!this.batchSupport) {
                return this.emulateBatchUpdate();
            }
            this.batchSqlVec = this.myConnection.getBatchVector(this);
            if (this.batchSqlVec != null) {
                int k;
                Enumeration localEnumeration = this.batchSqlVec.elements();
                arrayOfInt1 = new int[this.batchSqlVec.size()];
                int j = arrayOfInt1.length;
                StringBuffer localStringBuffer = new StringBuffer();
                for (k = 0; k < j; ++k) {
                    if (!localEnumeration.hasMoreElements()) continue;
                    String str = (String)localEnumeration.nextElement();
                    localStringBuffer.append(str + "\n");
                }
                try {
                    if (!this.execute(localStringBuffer.toString())) {
                        while ((k = this.getUpdateCount()) != -1) {
                            arrayOfInt1[i++] = k;
                            this.getMoreResults();
                        }
                        if (i < j) {
                            arrayOfInt2 = new int[i];
                            for (k = 0; k < i; ++k) {
                                arrayOfInt2[k] = arrayOfInt1[k];
                            }
                            this.clearBatch();
                            throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", arrayOfInt2);
                        }
                        break block10;
                    }
                    this.clearBatch();
                    throw new JdbcOdbcBatchUpdateException("SQL Attempt to produce a ResultSet from executeBatch", null);
                }
                catch (SQLException localSQLException) {
                    this.clearBatch();
                    throw new JdbcOdbcBatchUpdateException(localSQLException.getMessage(), localSQLException.getSQLState(), arrayOfInt2);
                }
            }
        }
        this.clearBatch();
        return arrayOfInt1;
    }

    protected int[] emulateBatchUpdate() throws BatchUpdateException {
        int[] arrayOfInt1 = new int[]{};
        this.batchSqlVec = this.myConnection.getBatchVector(this);
        if (this.batchSqlVec != null) {
            int[] arrayOfInt2 = new int[]{};
            int i = 0;
            Enumeration localEnumeration = this.batchSqlVec.elements();
            arrayOfInt1 = new int[this.batchSqlVec.size()];
            for (int j = 0; j < arrayOfInt1.length; ++j) {
                if (!localEnumeration.hasMoreElements()) continue;
                String str = (String)localEnumeration.nextElement();
                try {
                    if (!this.execute(str)) {
                        arrayOfInt1[j] = this.getUpdateCount();
                        ++i;
                        continue;
                    }
                    arrayOfInt2 = new int[i];
                    for (int k = 0; k <= j - 1; ++k) {
                        arrayOfInt2[k] = arrayOfInt1[k];
                    }
                    this.clearBatch();
                    throw new JdbcOdbcBatchUpdateException("No row count was produced from executeBatch", arrayOfInt2);
                }
                catch (SQLException localSQLException) {
                    arrayOfInt2 = new int[i];
                    for (int m = 0; m <= j - 1; ++m) {
                        arrayOfInt2[m] = arrayOfInt1[m];
                    }
                    this.clearBatch();
                    throw new JdbcOdbcBatchUpdateException(localSQLException.getMessage(), localSQLException.getSQLState(), arrayOfInt2);
                }
            }
            this.clearBatch();
        }
        return arrayOfInt1;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.myConnection;
    }

    public String getSql() {
        return this.mySql;
    }

    public void setSql(String paramString) {
        this.mySql = paramString.toUpperCase();
    }

    public Object[] getObjects() {
        Object[] arrayOfObject = new Object[]{};
        return arrayOfObject;
    }

    public int[] getObjectTypes() {
        int[] arrayOfInt = new int[]{};
        return arrayOfInt;
    }

    public int getParamCount() {
        return 0;
    }

    public int getBlockCursorSize() {
        return this.rsBlockSize;
    }

    public void setBlockCursorSize(int paramInt) {
        this.rsBlockSize = paramInt;
    }

    protected int getStmtOption(short paramShort) throws SQLException {
        int i = 0;
        this.clearWarnings();
        try {
            i = (int)this.OdbcApi.SQLGetStmtOption(this.hStmt, paramShort);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            BigDecimal localBigDecimal = (BigDecimal)localJdbcOdbcSQLWarning.value;
            i = localBigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        return i;
    }

    protected int getColumnCount() throws SQLException {
        int i = 0;
        try {
            i = this.OdbcApi.SQLNumResultCols(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            BigDecimal localBigDecimal = (BigDecimal)localJdbcOdbcSQLWarning.value;
            i = localBigDecimal.intValue();
        }
        return i;
    }

    protected int getRowCount() throws SQLException {
        int i = 0;
        try {
            i = this.OdbcApi.SQLRowCount(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            BigDecimal localBigDecimal = (BigDecimal)localJdbcOdbcSQLWarning.value;
            i = localBigDecimal.intValue();
        }
        return i;
    }

    protected boolean lockIfNecessary(String paramString) throws SQLException {
        boolean bool = false;
        String str = paramString.toUpperCase();
        int i = str.indexOf(" FOR UPDATE");
        if (i > 0) {
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("Setting concurrency for update");
            }
            try {
                this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)7, 2);
            }
            catch (SQLWarning localSQLWarning) {
                this.setWarning(localSQLWarning);
            }
            bool = true;
        }
        return bool;
    }

    protected int getPrecision(int paramInt) {
        JdbcOdbcTypeInfo localJdbcOdbcTypeInfo;
        int i = -1;
        if (this.typeInfo != null && (localJdbcOdbcTypeInfo = (JdbcOdbcTypeInfo)this.typeInfo.get(new Integer(paramInt))) != null) {
            i = localJdbcOdbcTypeInfo.getPrec();
        }
        if (paramInt == -2 && i == -1) {
            i = this.getPrecision(-3);
        }
        return i;
    }

    protected synchronized void clearMyResultSet() throws SQLException {
        if (this.myResultSet != null) {
            if (this.hStmt != 0L) {
                this.myResultSet.close();
            }
            this.myResultSet = null;
        }
    }

    protected void checkCursorDowngrade() throws SQLException {
        int i = (int)this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)6);
        if (i != this.myConnection.getOdbcCursorType(this.rsType)) {
            this.rsType = i == 0 ? 1003 : 1004;
        }
        this.setWarning(new SQLWarning("Result set type has been changed."));
    }

    public static int getTypeFromObject(Object paramObject) {
        if (paramObject == null) {
            return 0;
        }
        if (paramObject instanceof String) {
            return 1;
        }
        if (paramObject instanceof BigDecimal) {
            return 2;
        }
        if (paramObject instanceof Boolean) {
            return -7;
        }
        if (paramObject instanceof Byte) {
            return -6;
        }
        if (paramObject instanceof Short) {
            return 5;
        }
        if (paramObject instanceof Integer) {
            return 4;
        }
        if (paramObject instanceof Long) {
            return -5;
        }
        if (paramObject instanceof Float) {
            return 6;
        }
        if (paramObject instanceof Double) {
            return 8;
        }
        if (paramObject instanceof byte[]) {
            return -3;
        }
        if (paramObject instanceof InputStream) {
            return -4;
        }
        if (paramObject instanceof Reader) {
            return -1;
        }
        if (paramObject instanceof Date) {
            return 91;
        }
        if (paramObject instanceof Time) {
            return 92;
        }
        if (paramObject instanceof Timestamp) {
            return 93;
        }
        return 1111;
    }

    @Override
    public boolean getMoreResults(int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String paramString, int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String paramString, int[] paramArrayOfInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String paramString, String[] paramArrayOfString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String paramString, int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String paramString, int[] paramArrayOfInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String paramString, String[] paramArrayOfString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean paramBoolean) throws SQLException {
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

