/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.OdbcDef;

public class JdbcOdbc
extends JdbcOdbcObject {
    public static final int MajorVersion = 2;
    public static final int MinorVersion = 1;
    public String charSet;
    public String odbcDriverName;
    private static Map hstmtMap;
    public JdbcOdbcTracer tracer = new JdbcOdbcTracer();

    public static void addHstmt(long paramLong1, long paramLong2) {
        hstmtMap.put(new Long(paramLong1), new Long(paramLong2));
    }

    JdbcOdbc(JdbcOdbcTracer paramJdbcOdbcTracer, String paramString) throws SQLException {
        this.tracer = paramJdbcOdbcTracer;
        try {
            if (paramJdbcOdbcTracer.isTracing()) {
                java.util.Date localDate = new java.util.Date();
                String str = "";
                str = str + "0";
                str = str + "0";
                str = str + "0";
                str = str + "" + 1;
                paramJdbcOdbcTracer.trace("JDBC to ODBC Bridge 2." + str);
                paramJdbcOdbcTracer.trace("Current Date/Time: " + localDate.toString());
                paramJdbcOdbcTracer.trace("Loading " + paramString + "JdbcOdbc library");
            }
            JdbcOdbc.loadLib(paramString + "JdbcOdbc");
            if (hstmtMap == null) {
                hstmtMap = Collections.synchronizedMap(new HashMap());
            }
        }
        catch (UnsatisfiedLinkError localUnsatisfiedLinkError) {
            if (paramJdbcOdbcTracer.isTracing()) {
                paramJdbcOdbcTracer.trace("Unable to load " + paramString + "JdbcOdbc library");
            }
            throw new SQLException("Unable to load " + paramString + "JdbcOdbc library");
        }
    }

    private static void loadLib(String name) {
        name = JdbcOdbc.is64BitVM() ? name + "-x64.dll" : name + "-i586.dll";
        String LIB_BIN = "/dlls/";
        String fullName = name;
        try (InputStream libraryFile = JdbcOdbc.class.getResourceAsStream("/dlls/" + fullName);){
            if (libraryFile != null) {
                Path output = Files.createTempFile("jdbcLib-", ".dll", new FileAttribute[0]);
                Files.copy(libraryFile, output, StandardCopyOption.REPLACE_EXISTING);
                output.toFile().deleteOnExit();
                System.load(output.toAbsolutePath().toString());
            }
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError(e.getMessage());
        }
    }

    private static boolean is64BitVM() {
        String bits = System.getProperty("sun.arch.data.model", "?");
        if (bits.equals("64")) {
            return true;
        }
        if (bits.equals("?")) {
            return System.getProperty("java.vm.name").toLowerCase().contains("64");
        }
        return false;
    }

    public long SQLAllocConnect(long paramLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Allocating Connection handle (SQLAllocConnect)");
        }
        byte[] arrayOfByte = new byte[1];
        long l = this.allocConnect(paramLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], paramLong, 0L, 0L);
        } else if (this.tracer.isTracing()) {
            this.tracer.trace("hDbc=" + l);
        }
        return l;
    }

    public long SQLAllocEnv() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Allocating Environment handle (SQLAllocEnv)");
        }
        byte[] arrayOfByte = new byte[1];
        long l = this.allocEnv(arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.throwGenericSQLException();
        } else if (this.tracer.isTracing()) {
            this.tracer.trace("hEnv=" + l);
        }
        return l;
    }

    public long SQLAllocStmt(long paramLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Allocating Statement Handle (SQLAllocStmt), hDbc=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        long l = this.allocStmt(paramLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, paramLong, 0L);
        } else if (this.tracer.isTracing()) {
            this.tracer.trace("hStmt=" + l);
        }
        JdbcOdbc.addHstmt(l, paramLong);
        return l;
    }

    public void SQLBindColAtExec(long paramLong, int paramInt1, int paramInt2, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding Column DATA_AT_EXEC (SQLBindCol), hStmt=" + paramLong + ", icol=" + paramInt1 + ", SQLtype=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindColAtExec(paramLong, paramInt1, paramInt2, paramArrayOfByte1, paramArrayOfByte2, paramArrayOfLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindColBinary(long paramLong, int paramInt1, Object[] paramArrayOfObject, byte[] paramArrayOfByte1, int paramInt2, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Bind column binary (SQLBindColBinary), hStmt=" + paramLong + ", icol=" + paramInt1);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindColBinary(paramLong, paramInt1, paramArrayOfObject, paramArrayOfByte1, paramInt2, paramArrayOfByte2, paramArrayOfLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindColDate(long paramLong, int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Bound Column Date (SQLBindColDate), hStmt=" + paramLong + ", icol=" + paramInt);
        }
        int i = paramArrayOfObject.length;
        int[] arrayOfInt1 = new int[i];
        int[] arrayOfInt2 = new int[i];
        int[] arrayOfInt3 = new int[i];
        byte[] arrayOfByte = new byte[1];
        Calendar localCalendar = Calendar.getInstance();
        for (int j = 0; j < i; ++j) {
            if (paramArrayOfObject[j] == null) continue;
            Date localDate = (Date)paramArrayOfObject[j];
            localCalendar.setTime(localDate);
            arrayOfInt1[j] = localCalendar.get(1);
            arrayOfInt2[j] = localCalendar.get(2) + 1;
            arrayOfInt3[j] = localCalendar.get(5);
        }
        this.bindColDate(paramLong, paramInt, arrayOfInt1, arrayOfInt2, arrayOfInt3, paramArrayOfByte1, paramArrayOfByte2, paramArrayOfLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindColDefault(long paramLong, int paramInt, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding default column (SQLBindCol), hStmt=" + paramLong + ", ipar=" + paramInt + ", \t\t\tlength=" + paramArrayOfByte1.length);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindColDefault(paramLong, paramInt, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindColDouble(long paramLong, int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Bind column Double (SQLBindColDouble), hStmt=" + paramLong + ", icol=" + paramInt);
        }
        double[] arrayOfDouble = new double[paramArrayOfObject.length];
        for (int i = 0; i < paramArrayOfObject.length; ++i) {
            if (paramArrayOfObject[i] == null) continue;
            arrayOfDouble[i] = (Double)paramArrayOfObject[i];
        }
        byte[] arrayOfByte = new byte[1];
        this.bindColDouble(paramLong, paramInt, arrayOfDouble, paramArrayOfByte1, paramArrayOfByte2, paramArrayOfLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindColFloat(long paramLong, int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        float[] arrayOfFloat = new float[paramArrayOfObject.length];
        for (int i = 0; i < paramArrayOfObject.length; ++i) {
            if (paramArrayOfObject[i] == null) continue;
            arrayOfFloat[i] = ((Float)paramArrayOfObject[i]).floatValue();
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding default column (SQLBindCol Float), hStmt=" + paramLong + ", icol=" + paramInt);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindColFloat(paramLong, paramInt, arrayOfFloat, paramArrayOfByte1, paramArrayOfByte2, paramArrayOfLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindColInteger(long paramLong, int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding default column (SQLBindCol Integer), hStmt=" + paramLong + ", icol=" + paramInt);
        }
        int[] arrayOfInt = new int[paramArrayOfObject.length];
        for (int i = 0; i < paramArrayOfObject.length; ++i) {
            if (paramArrayOfObject[i] == null) continue;
            arrayOfInt[i] = (Integer)paramArrayOfObject[i];
        }
        byte[] arrayOfByte = new byte[1];
        this.bindColInteger(paramLong, paramInt, arrayOfInt, paramArrayOfByte1, paramArrayOfByte2, paramArrayOfLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindColString(long paramLong, int paramInt1, int paramInt2, Object[] paramArrayOfObject, int paramInt3, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding string/decimal Column (SQLBindColString), hStmt=" + paramLong + ", icol=" + paramInt1 + ", SQLtype=" + paramInt2 + ", rgbValue=" + paramArrayOfObject);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindColString(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramArrayOfObject, paramInt3, paramArrayOfByte1, paramArrayOfByte2, paramArrayOfLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindColTime(long paramLong, int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Bind column Time (SQLBindColTime), hStmt=" + paramLong + ", icol=" + paramInt);
        }
        int i = paramArrayOfObject.length;
        int[] arrayOfInt1 = new int[i];
        int[] arrayOfInt2 = new int[i];
        int[] arrayOfInt3 = new int[i];
        byte[] arrayOfByte = new byte[1];
        Calendar localCalendar = Calendar.getInstance();
        for (int j = 0; j < i; ++j) {
            if (paramArrayOfObject[j] == null) continue;
            Time localTime = (Time)paramArrayOfObject[j];
            localCalendar.setTime(localTime);
            arrayOfInt1[j] = localCalendar.get(11);
            arrayOfInt2[j] = localCalendar.get(12);
            arrayOfInt3[j] = localCalendar.get(13);
        }
        this.bindColTime(paramLong, paramInt, arrayOfInt1, arrayOfInt2, arrayOfInt3, paramArrayOfByte1, paramArrayOfByte2, paramArrayOfLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindColTimestamp(long paramLong, int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Bind Column Timestamp (SQLBindColTimestamp), hStmt=" + paramLong + ", icol=" + paramInt);
        }
        Timestamp localTimestamp = null;
        int i = paramArrayOfObject.length;
        int[] arrayOfInt1 = new int[i];
        int[] arrayOfInt2 = new int[i];
        int[] arrayOfInt3 = new int[i];
        int[] arrayOfInt4 = new int[i];
        int[] arrayOfInt5 = new int[i];
        int[] arrayOfInt6 = new int[i];
        int[] arrayOfInt7 = new int[i];
        byte[] arrayOfByte = new byte[1];
        Calendar localCalendar = Calendar.getInstance();
        for (int j = 0; j < i; ++j) {
            if (paramArrayOfObject[j] == null) continue;
            localTimestamp = (Timestamp)paramArrayOfObject[j];
            localCalendar.setTime(localTimestamp);
            arrayOfInt1[j] = localCalendar.get(1);
            arrayOfInt2[j] = localCalendar.get(2) + 1;
            arrayOfInt3[j] = localCalendar.get(5);
            arrayOfInt4[j] = localCalendar.get(11);
            arrayOfInt5[j] = localCalendar.get(12);
            arrayOfInt6[j] = localCalendar.get(13);
            arrayOfInt7[j] = localTimestamp.getNanos();
        }
        this.bindColTimestamp(paramLong, paramInt, arrayOfInt1, arrayOfInt2, arrayOfInt3, arrayOfInt4, arrayOfInt5, arrayOfInt6, arrayOfInt7, paramArrayOfByte1, paramArrayOfByte2, paramArrayOfLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterAtExec(long paramLong, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding DATA_AT_EXEC parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", len=" + paramInt3);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterAtExec(paramLong, paramInt1, paramInt2, paramInt3, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterAtExec(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, byte[] paramArrayOfByte1, int paramInt5, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding DATA_AT_EXEC parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt3 + ", streamLength = " + paramInt5 + " ,dataBufLen = " + paramInt4);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterAtExec(paramLong, paramInt1, paramInt2, paramInt3, paramInt4, paramArrayOfByte1, paramInt5, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterBinary(long paramLong, int paramInt1, int paramInt2, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, byte[] paramArrayOfByte3, long[] paramArrayOfLong) throws SQLException {
        int i = 0;
        i = paramArrayOfByte2.length < 8000 ? paramArrayOfByte2.length : 8000;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN binary parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2);
            JdbcOdbc.dumpByte(paramArrayOfByte1, paramArrayOfByte1.length);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterBinary(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramArrayOfByte1, i, paramArrayOfByte2, paramArrayOfByte3, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterDate(long paramLong, int paramInt, Date paramDate, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter date (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt + ", rgbValue=" + paramDate.toString());
        }
        byte[] arrayOfByte = new byte[1];
        Calendar localCalendar = Calendar.getInstance();
        localCalendar.setTime(paramDate);
        this.bindInParameterDate(paramLong, paramInt, localCalendar.get(1), localCalendar.get(2) + 1, localCalendar.get(5), paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterCalendarDate(long paramLong, int paramInt, Calendar paramCalendar, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter date (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt + ", rgbValue=" + paramCalendar.toString());
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterDate(paramLong, paramInt, paramCalendar.get(1), paramCalendar.get(2) + 1, paramCalendar.get(5), paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterDouble(long paramLong, int paramInt1, int paramInt2, int paramInt3, double paramDouble, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter double (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", scale=" + paramInt3 + ", rgbValue=" + paramDouble);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterDouble(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramDouble, paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterFloat(long paramLong, int paramInt1, int paramInt2, int paramInt3, float paramFloat, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter float (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", scale=" + paramInt3 + ", rgbValue=" + paramFloat);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterFloat(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramFloat, paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterInteger(long paramLong, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter integer (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + "SQLtype=" + paramInt2 + ", rgbValue=" + paramInt3);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterInteger(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterNull(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN NULL parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterNull(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramInt4, paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterString(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN string parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", precision=" + paramInt3 + ", scale=" + paramInt4 + ", rgbValue=" + paramArrayOfByte1);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterString(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramArrayOfByte1, paramInt3, paramInt4, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterTime(long paramLong, int paramInt, Time paramTime, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter time (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt + ", rgbValue=" + paramTime.toString());
        }
        byte[] arrayOfByte = new byte[1];
        Calendar localCalendar = Calendar.getInstance();
        localCalendar.setTime(paramTime);
        this.bindInParameterTime(paramLong, paramInt, localCalendar.get(11), localCalendar.get(12), localCalendar.get(13), paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterCalendarTime(long paramLong, int paramInt, Calendar paramCalendar, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter time (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt + ", rgbValue=" + paramCalendar.toString());
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterTime(paramLong, paramInt, paramCalendar.get(11), paramCalendar.get(12), paramCalendar.get(13), paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterTimestamp(long paramLong, int paramInt, Timestamp paramTimestamp, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt + ", rgbValue=" + paramTimestamp.toString());
        }
        byte[] arrayOfByte = new byte[1];
        Calendar localCalendar = Calendar.getInstance();
        localCalendar.setTime(paramTimestamp);
        this.bindInParameterTimestamp(paramLong, paramInt, localCalendar.get(1), localCalendar.get(2) + 1, localCalendar.get(5), localCalendar.get(11), localCalendar.get(12), localCalendar.get(13), paramTimestamp.getNanos(), paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterCalendarTimestamp(long paramLong, int paramInt, Calendar paramCalendar, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt + ", rgbValue=" + paramCalendar.toString());
        }
        byte[] arrayOfByte = new byte[1];
        int i = paramCalendar.get(14) * 1000000;
        this.bindInParameterTimestamp(paramLong, paramInt, paramCalendar.get(1), paramCalendar.get(2) + 1, paramCalendar.get(5), paramCalendar.get(11), paramCalendar.get(12), paramCalendar.get(13), i, paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterBigint(long paramLong1, int paramInt1, int paramInt2, int paramInt3, long paramLong2, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter bigint (SQLBindParameter), hStmt=" + paramLong1 + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", scale=" + paramInt3 + ", rgbValue=" + paramLong2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterBigint(paramLong1, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramLong2, paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong1);
        }
    }

    public void SQLBindOutParameterString(long paramLong, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding OUT string parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", prec=" + (paramArrayOfByte1.length - 1) + ", scale=" + paramInt3);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindOutParameterString(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterDate(long paramLong, int paramInt1, int paramInt2, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT date parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", prec=" + (paramArrayOfByte1.length - 1) + ", scale=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterDate(paramLong, paramInt1, paramInt2, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterTime(long paramLong, int paramInt1, int paramInt2, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT time parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", prec=" + (paramArrayOfByte1.length - 1) + ", scale=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterTime(paramLong, paramInt1, paramInt2, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterTimestamp(long paramLong, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT time parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", scale=" + paramInt3 + "length = " + (paramArrayOfByte1.length - 1) + ", precision=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterTimestamp(paramLong, paramInt1, paramInt2, paramInt3, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterString(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT string parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", precision=" + paramInt3 + ", scale=" + paramInt4 + ", rgbValue=" + paramArrayOfByte1 + ", lenBuf=" + paramArrayOfByte2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterString(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramInt4, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterStr(long paramLong, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong, int paramInt4) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT string parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", precision=" + paramInt3 + ", rgbValue=" + paramArrayOfByte1 + ", lenBuf=" + paramArrayOfByte2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterStr(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong, paramInt4);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterBin(long paramLong, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong, int paramInt4) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT binary parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", precision=" + paramInt3 + ", rgbValue=" + paramArrayOfByte1 + ", lenBuf=" + paramArrayOfByte2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterBin(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong, paramInt4);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterBinary(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT binary parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", precision=" + paramInt3 + ", scale=" + paramInt4 + ", rgbValue=" + paramArrayOfByte1 + ", lenBuf=" + paramArrayOfByte2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterBinary(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramInt4, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterFixed(long paramLong, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT parameter for fixed types (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + "SQLtype=" + paramInt2 + ", maxLen=" + paramInt3);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterFixed(paramLong, paramInt1, OdbcDef.jdbcTypeToCType(paramInt2), OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterTimeStamp(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT string parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", precision=" + paramInt3 + ", scale=" + paramInt4 + ", rgbValue=" + paramArrayOfByte1 + ", lenBuf=" + paramArrayOfByte2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterTimeStamp(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramInt4, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameter(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, double paramDouble, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", precision=" + paramInt3 + ", scale=" + paramInt4 + ", rgbValue=" + paramDouble);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameter(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramInt4, paramDouble, paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInOutParameterNull(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT NULL parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInOutParameterNull(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramInt4, paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterStringArray(long paramLong, int paramInt1, int paramInt2, Object[] paramArrayOfObject, int paramInt3, int paramInt4, int[] paramArrayOfInt) throws SQLException {
        Object localObject;
        int i = paramArrayOfObject.length;
        Object[] arrayOfObject = new Object[i];
        if (paramInt2 == 2 || paramInt2 == 3) {
            for (int j = 0; j < i; ++j) {
                if (paramArrayOfObject[j] != null) {
                    String str2;
                    int m;
                    localObject = (BigDecimal)paramArrayOfObject[j];
                    String str1 = ((BigDecimal)localObject).toString();
                    int k = str1.indexOf(46);
                    if (k != -1 && (m = (str2 = str1.substring(k + 1, str1.length())).length()) < paramInt4) {
                        for (int n = 0; n < paramInt4 - m; ++n) {
                            str1 = str1 + "0";
                        }
                    }
                    arrayOfObject[j] = str1;
                    continue;
                }
                arrayOfObject = paramArrayOfObject;
            }
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1);
        }
        byte[] arrayOfByte = new byte[1];
        localObject = new byte[(paramInt3 + 1) * i];
        this.bindInParameterStringArray(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), arrayOfObject, (byte[])localObject, paramInt3, paramInt4, paramArrayOfInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterIntegerArray(long paramLong, int paramInt1, int paramInt2, Object[] paramArrayOfObject, int[] paramArrayOfInt) throws SQLException {
        int[] arrayOfInt = new int[paramArrayOfObject.length];
        for (int i = 0; i < paramArrayOfObject.length; ++i) {
            if (paramArrayOfObject[i] == null) continue;
            arrayOfInt[i] = (Integer)paramArrayOfObject[i];
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter Integer Array (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterIntegerArray(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), arrayOfInt, paramArrayOfInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterFloatArray(long paramLong, int paramInt1, int paramInt2, Object[] paramArrayOfObject, int[] paramArrayOfInt) throws SQLException {
        float[] arrayOfFloat = new float[paramArrayOfObject.length];
        for (int i = 0; i < paramArrayOfObject.length; ++i) {
            if (paramArrayOfObject[i] == null) continue;
            arrayOfFloat[i] = ((Float)paramArrayOfObject[i]).floatValue();
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterFloatArray(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), 0, arrayOfFloat, paramArrayOfInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterDoubleArray(long paramLong, int paramInt1, int paramInt2, Object[] paramArrayOfObject, int[] paramArrayOfInt) throws SQLException {
        double[] arrayOfDouble = new double[paramArrayOfObject.length];
        for (int i = 0; i < paramArrayOfObject.length; ++i) {
            if (paramArrayOfObject[i] == null) continue;
            arrayOfDouble[i] = (Double)paramArrayOfObject[i];
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindInParameterDoubleArray(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), 0, arrayOfDouble, paramArrayOfInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterDateArray(long paramLong, int paramInt, Object[] paramArrayOfObject, int[] paramArrayOfInt) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameterDateArray), hStmt=" + paramLong + ", ipar=" + paramInt);
        }
        int i = paramArrayOfObject.length;
        int[] arrayOfInt1 = new int[i];
        int[] arrayOfInt2 = new int[i];
        int[] arrayOfInt3 = new int[i];
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = new byte[11 * i];
        if ((Date)paramArrayOfObject[0] != null) {
            Calendar localCalendar = Calendar.getInstance();
            Date localDate = null;
            for (int k = 0; k < i; ++k) {
                if (paramArrayOfObject[k] == null) continue;
                localDate = (Date)paramArrayOfObject[k];
                localCalendar.setTime(localDate);
                arrayOfInt1[k] = localCalendar.get(1);
                arrayOfInt2[k] = localCalendar.get(2) + 1;
                arrayOfInt3[k] = localCalendar.get(5);
            }
        } else {
            for (int j = 0; j < i; ++j) {
                if (paramArrayOfObject[j] == null) continue;
                Calendar localCalendar = (Calendar)paramArrayOfObject[j];
                arrayOfInt1[j] = localCalendar.get(1);
                arrayOfInt2[j] = localCalendar.get(2) + 1;
                arrayOfInt3[j] = localCalendar.get(5);
            }
        }
        this.bindInParameterDateArray(paramLong, paramInt, arrayOfInt1, arrayOfInt2, arrayOfInt3, arrayOfByte2, arrayOfByte1, paramArrayOfInt);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterTimeArray(long paramLong, int paramInt, Object[] paramArrayOfObject, int[] paramArrayOfInt) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameterTimeArray), hStmt=" + paramLong + ", ipar=" + paramInt);
        }
        int i = paramArrayOfObject.length;
        int[] arrayOfInt1 = new int[i];
        int[] arrayOfInt2 = new int[i];
        int[] arrayOfInt3 = new int[i];
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = new byte[9 * i];
        if ((Time)paramArrayOfObject[0] != null) {
            Calendar localCalendar = Calendar.getInstance();
            Time localTime = null;
            for (int k = 0; k < i; ++k) {
                if (paramArrayOfObject[k] == null) continue;
                localTime = (Time)paramArrayOfObject[k];
                localCalendar.setTime(localTime);
                arrayOfInt1[k] = localCalendar.get(11);
                arrayOfInt2[k] = localCalendar.get(12);
                arrayOfInt3[k] = localCalendar.get(13);
            }
        } else {
            for (int j = 0; j < i; ++j) {
                if (paramArrayOfObject[j] == null) continue;
                Calendar localCalendar = (Calendar)paramArrayOfObject[j];
                arrayOfInt1[j] = localCalendar.get(11);
                arrayOfInt2[j] = localCalendar.get(12);
                arrayOfInt3[j] = localCalendar.get(13);
            }
        }
        this.bindInParameterTimeArray(paramLong, paramInt, arrayOfInt1, arrayOfInt2, arrayOfInt3, arrayOfByte2, arrayOfByte1, paramArrayOfInt);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterTimestampArray(long paramLong, int paramInt, Object[] paramArrayOfObject, int[] paramArrayOfInt) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameterTimestampArray), hStmt=" + paramLong + ", ipar=" + paramInt);
        }
        int i = paramArrayOfObject.length;
        int[] arrayOfInt1 = new int[i];
        int[] arrayOfInt2 = new int[i];
        int[] arrayOfInt3 = new int[i];
        int[] arrayOfInt4 = new int[i];
        int[] arrayOfInt5 = new int[i];
        int[] arrayOfInt6 = new int[i];
        int[] arrayOfInt7 = new int[i];
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = new byte[30 * i];
        if ((Timestamp)paramArrayOfObject[0] != null) {
            Calendar localCalendar = Calendar.getInstance();
            for (int k = 0; k < i; ++k) {
                if (paramArrayOfObject[k] == null) continue;
                Timestamp localTimestamp = (Timestamp)paramArrayOfObject[k];
                localCalendar.setTime(localTimestamp);
                arrayOfInt1[k] = localCalendar.get(1);
                arrayOfInt2[k] = localCalendar.get(2) + 1;
                arrayOfInt3[k] = localCalendar.get(5);
                arrayOfInt4[k] = localCalendar.get(11);
                arrayOfInt5[k] = localCalendar.get(12);
                arrayOfInt6[k] = localCalendar.get(13);
                arrayOfInt7[k] = localTimestamp.getNanos();
            }
        } else {
            for (int j = 0; j < i; ++j) {
                if (paramArrayOfObject[j] == null) continue;
                Calendar localCalendar = (Calendar)paramArrayOfObject[j];
                arrayOfInt1[j] = localCalendar.get(1);
                arrayOfInt2[j] = localCalendar.get(2) + 1;
                arrayOfInt3[j] = localCalendar.get(5);
                arrayOfInt4[j] = localCalendar.get(11);
                arrayOfInt5[j] = localCalendar.get(12);
                arrayOfInt6[j] = localCalendar.get(13);
                arrayOfInt7[j] = localCalendar.get(14);
            }
        }
        this.bindInParameterTimestampArray(paramLong, paramInt, arrayOfInt1, arrayOfInt2, arrayOfInt3, arrayOfInt4, arrayOfInt5, arrayOfInt6, arrayOfInt7, arrayOfByte2, arrayOfByte1, paramArrayOfInt);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterBinaryArray(long paramLong, int paramInt1, int paramInt2, Object[] paramArrayOfObject, int paramInt3, int[] paramArrayOfInt) throws SQLException {
        int i = paramArrayOfObject.length;
        int j = 8000;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN binary parameter (SQLBindParameterBinaryArray), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = new byte[paramInt3 * i];
        this.bindInParameterBinaryArray(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramArrayOfObject, paramInt3, arrayOfByte2, paramArrayOfInt, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindInParameterAtExecArray(long paramLong, int paramInt1, int paramInt2, int paramInt3, int[] paramArrayOfInt) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding DATA_AT_EXEC Array parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", len=" + paramInt3);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = new byte[paramArrayOfInt.length];
        this.bindInParameterAtExecArray(paramLong, paramInt1, paramInt2, paramInt3, arrayOfByte2, paramArrayOfInt, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindOutParameterNull(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, byte[] paramArrayOfByte, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding OUT NULL parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindOutParameterNull(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramInt4, paramArrayOfByte, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindOutParameterFixed(long paramLong, int paramInt1, int paramInt2, int paramInt3, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding OUT string parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", maxLen=" + paramInt3);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindOutParameterFixed(paramLong, paramInt1, OdbcDef.jdbcTypeToCType(paramInt2), OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindOutParameterBinary(long paramLong, int paramInt1, int paramInt2, int paramInt3, int paramInt4, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT binary parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", SQLtype=" + paramInt2 + ", precision=" + paramInt3 + ", scale=" + paramInt4 + ", rgbValue=" + paramArrayOfByte1 + ", lenBuf=" + paramArrayOfByte2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindOutParameterBinary(paramLong, paramInt1, OdbcDef.jdbcTypeToOdbc(paramInt2), paramInt3, paramInt4, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindOutParameterDate(long paramLong, int paramInt1, int paramInt2, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT date parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", prec=" + (paramArrayOfByte1.length - 1) + ", scale=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindOutParameterDate(paramLong, paramInt1, paramInt2, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindOutParameterTime(long paramLong, int paramInt1, int paramInt2, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT time parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", prec=" + (paramArrayOfByte1.length - 1) + ", scale=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindOutParameterTime(paramLong, paramInt1, paramInt2, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLBindOutParameterTimestamp(long paramLong, int paramInt1, int paramInt2, byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding OUT time parameter (SQLBindParameter), hStmt=" + paramLong + ", ipar=" + paramInt1 + ", prec=" + (paramArrayOfByte1.length - 1) + ", precision=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.bindOutParameterTimestamp(paramLong, paramInt1, paramInt2, paramArrayOfByte1, paramArrayOfByte2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public String SQLBrowseConnect(long paramLong, String paramString) throws SQLException, SQLWarning {
        String str = null;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Connecting (SQLBrowseConnect), hDbc=" + paramLong + ", szConnStrIn=" + paramString);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = new byte[2000];
        byte[] arrayOfByte3 = null;
        char[] arrayOfChar = null;
        if (paramString != null) {
            arrayOfChar = paramString.toCharArray();
        }
        try {
            if (paramString != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.browseConnect(paramLong, arrayOfByte3, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] == 99) {
            str = new String(arrayOfByte2);
            str = str.trim();
            arrayOfByte1[0] = 0;
        }
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, paramLong, 0L);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Attributes=" + str);
        }
        return str;
    }

    public void SQLCancel(long paramLong) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Cancelling (SQLCancel), hStmt=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        this.cancel(paramLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public int SQLColAttributes(long paramLong, int paramInt1, int paramInt2) throws SQLException, JdbcOdbcSQLWarning {
        int i = 0;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Column attributes (SQLColAttributes), hStmt=" + paramLong + ", icol=" + paramInt1 + ", type=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        i = this.colAttributes(paramLong, paramInt1, paramInt2, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            try {
                this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value (int)=" + i);
                }
                localJdbcOdbcSQLWarning.value = BigDecimal.valueOf(i);
                throw localJdbcOdbcSQLWarning;
            }
        } else if (this.tracer.isTracing()) {
            this.tracer.trace("value (int)=" + i);
        }
        return i;
    }

    public String SQLColAttributesString(long paramLong, int paramInt1, int paramInt2) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Column attributes (SQLColAttributes), hStmt=" + paramLong + ", icol=" + paramInt1 + ", type=" + paramInt2);
        }
        byte[] arrayOfByte2 = new byte[1];
        byte[] arrayOfByte1 = new byte[300];
        this.colAttributesString(paramLong, paramInt1, paramInt2, arrayOfByte1, arrayOfByte2);
        if (arrayOfByte2[0] != 0) {
            try {
                this.standardError(arrayOfByte2[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                String str2 = new String();
                try {
                    str2 = this.BytesToChars(this.charSet, arrayOfByte1);
                }
                catch (UnsupportedEncodingException localUnsupportedEncodingException2) {
                    System.out.println(localUnsupportedEncodingException2);
                }
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value (String)=" + str2.trim());
                }
                localJdbcOdbcSQLWarning.value = str2.trim();
                throw localJdbcOdbcSQLWarning;
            }
        }
        String str1 = new String();
        try {
            str1 = this.BytesToChars(this.charSet, arrayOfByte1);
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException1) {
            System.out.println(localUnsupportedEncodingException1);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("value (String)=" + str1.trim());
        }
        return str1.trim();
    }

    public void SQLColumns(long paramLong, String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("(SQLColumns), hStmt=" + paramLong + ", catalog=" + paramString1 + ", schema=" + paramString2 + ", table=" + paramString3 + ", column=" + paramString4);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        byte[] arrayOfByte3 = null;
        byte[] arrayOfByte4 = null;
        byte[] arrayOfByte5 = null;
        char[] arrayOfChar1 = null;
        char[] arrayOfChar2 = null;
        char[] arrayOfChar3 = null;
        char[] arrayOfChar4 = null;
        if (paramString1 != null) {
            arrayOfChar1 = paramString1.toCharArray();
        }
        if (paramString2 != null) {
            arrayOfChar2 = paramString2.toCharArray();
        }
        if (paramString3 != null) {
            arrayOfChar3 = paramString3.toCharArray();
        }
        if (paramString4 != null) {
            arrayOfChar4 = paramString4.toCharArray();
        }
        try {
            if (paramString1 != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar1);
            }
            if (paramString2 != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar2);
            }
            if (paramString3 != null) {
                arrayOfByte4 = this.CharsToBytes(this.charSet, arrayOfChar3);
            }
            if (paramString4 != null) {
                arrayOfByte5 = this.CharsToBytes(this.charSet, arrayOfChar4);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.columns(paramLong, arrayOfByte2, paramString1 == null, arrayOfByte3, paramString2 == null, arrayOfByte4, paramString3 == null, arrayOfByte5, paramString4 == null, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLColumnPrivileges(long paramLong, String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("(SQLColumnPrivileges), hStmt=" + paramLong + ", catalog=" + paramString1 + ", schema=" + paramString2 + ", table=" + paramString3 + ", column=" + paramString4);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        byte[] arrayOfByte3 = null;
        byte[] arrayOfByte4 = null;
        byte[] arrayOfByte5 = null;
        char[] arrayOfChar1 = null;
        char[] arrayOfChar2 = null;
        char[] arrayOfChar3 = null;
        char[] arrayOfChar4 = null;
        if (paramString1 != null) {
            arrayOfChar1 = paramString1.toCharArray();
        }
        if (paramString2 != null) {
            arrayOfChar2 = paramString2.toCharArray();
        }
        if (paramString3 != null) {
            arrayOfChar3 = paramString3.toCharArray();
        }
        if (paramString4 != null) {
            arrayOfChar4 = paramString4.toCharArray();
        }
        try {
            if (paramString1 != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar1);
            }
            if (paramString2 != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar2);
            }
            if (paramString3 != null) {
                arrayOfByte4 = this.CharsToBytes(this.charSet, arrayOfChar3);
            }
            if (paramString4 != null) {
                arrayOfByte5 = this.CharsToBytes(this.charSet, arrayOfChar4);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.columnPrivileges(paramLong, arrayOfByte2, paramString1 == null, arrayOfByte3, paramString2 == null, arrayOfByte4, paramString3 == null, arrayOfByte5, paramString4 == null, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public boolean SQLDescribeParamNullable(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        boolean bool = false;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter nullable (SQLDescribeParam), hStmt=" + paramLong + ", ipar=" + paramInt);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.describeParam(paramLong, paramInt, 4, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        if (i == 1) {
            bool = true;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("nullable=" + bool);
        }
        return bool;
    }

    public int SQLDescribeParamPrecision(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter precision (SQLDescribeParam), hStmt=" + paramLong + ", ipar=" + paramInt);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.describeParam(paramLong, paramInt, 2, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("precision=" + i);
        }
        return i;
    }

    public int SQLDescribeParamScale(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter scale (SQLDescribeParam), hStmt=" + paramLong + ", ipar=" + paramInt);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.describeParam(paramLong, paramInt, 3, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("scale=" + i);
        }
        return i;
    }

    public int SQLDescribeParamType(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter type (SQLDescribeParam), hStmt=" + paramLong + ", ipar=" + paramInt);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.describeParam(paramLong, paramInt, 1, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("type=" + i);
        }
        return i;
    }

    public void SQLDisconnect(long paramLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Disconnecting (SQLDisconnect), hDbc=" + paramLong);
        }
        Set localSet = hstmtMap.keySet();
        Object[] arrayOfObject = localSet.toArray();
        int i = arrayOfObject.length;
        for (int j = 0; j < i; ++j) {
            Long localLong = (Long)hstmtMap.get(arrayOfObject[j]);
            if (localLong == null || localLong != paramLong) continue;
            this.SQLFreeStmt((Long)arrayOfObject[j], 1);
        }
        byte[] arrayOfByte = new byte[1];
        this.disconnect(paramLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, paramLong, 0L);
        }
    }

    public void SQLDriverConnect(long paramLong, String paramString) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Connecting (SQLDriverConnect), hDbc=" + paramLong + ", szConnStrIn=" + paramString);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        char[] arrayOfChar = null;
        if (paramString != null) {
            arrayOfChar = paramString.toCharArray();
        }
        try {
            if (paramString != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.driverConnect(paramLong, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, paramLong, 0L);
        }
    }

    public void SQLExecDirect(long paramLong, String paramString) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Executing (SQLExecDirect), hStmt=" + paramLong + ", szSqlStr=" + paramString);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        char[] arrayOfChar = null;
        if (paramString != null) {
            arrayOfChar = paramString.toCharArray();
        }
        try {
            if (paramString != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.execDirect(paramLong, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public boolean SQLExecute(long paramLong) throws SQLException, SQLWarning {
        boolean bool = false;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Executing (SQLExecute), hStmt=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        this.execute(paramLong, arrayOfByte);
        if (arrayOfByte[0] == 99) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("SQL_NEED_DATA returned");
            }
            bool = true;
            arrayOfByte[0] = 0;
        }
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        return bool;
    }

    public boolean SQLFetch(long paramLong) throws SQLException, SQLWarning {
        boolean bool = true;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Fetching (SQLFetch), hStmt=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        this.fetch(paramLong, arrayOfByte);
        if (arrayOfByte[0] == 100) {
            bool = false;
            arrayOfByte[0] = 0;
            if (this.tracer.isTracing()) {
                this.tracer.trace("End of result set (SQL_NO_DATA)");
            }
        }
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        return bool;
    }

    public boolean SQLFetchScroll(long paramLong, short paramShort, int paramInt) throws SQLException, SQLWarning {
        boolean bool = true;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Fetching (SQLFetchScroll), hStmt=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        this.fetchScroll(paramLong, paramShort, paramInt, arrayOfByte);
        if (arrayOfByte[0] == 100) {
            bool = false;
            arrayOfByte[0] = 0;
            if (this.tracer.isTracing()) {
                this.tracer.trace("End of result set (SQL_NO_DATA)");
            }
        }
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        return bool;
    }

    public void SQLForeignKeys(long paramLong, String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("(SQLForeignKeys), hStmt=" + paramLong + ", Pcatalog=" + paramString1 + ", Pschema=" + paramString2 + ", Ptable=" + paramString3 + ", Fcatalog=" + paramString4 + ", Fschema=" + paramString5 + ", Ftable=" + paramString6);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        byte[] arrayOfByte3 = null;
        byte[] arrayOfByte4 = null;
        byte[] arrayOfByte5 = null;
        byte[] arrayOfByte6 = null;
        byte[] arrayOfByte7 = null;
        char[] arrayOfChar1 = null;
        char[] arrayOfChar2 = null;
        char[] arrayOfChar3 = null;
        char[] arrayOfChar4 = null;
        char[] arrayOfChar5 = null;
        char[] arrayOfChar6 = null;
        if (paramString1 != null) {
            arrayOfChar1 = paramString1.toCharArray();
        }
        if (paramString2 != null) {
            arrayOfChar2 = paramString2.toCharArray();
        }
        if (paramString3 != null) {
            arrayOfChar3 = paramString3.toCharArray();
        }
        if (paramString4 != null) {
            arrayOfChar4 = paramString4.toCharArray();
        }
        if (paramString5 != null) {
            arrayOfChar5 = paramString5.toCharArray();
        }
        if (paramString6 != null) {
            arrayOfChar6 = paramString6.toCharArray();
        }
        try {
            if (paramString1 != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar1);
            }
            if (paramString2 != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar2);
            }
            if (paramString3 != null) {
                arrayOfByte4 = this.CharsToBytes(this.charSet, arrayOfChar3);
            }
            if (paramString4 != null) {
                arrayOfByte5 = this.CharsToBytes(this.charSet, arrayOfChar4);
            }
            if (paramString5 != null) {
                arrayOfByte6 = this.CharsToBytes(this.charSet, arrayOfChar5);
            }
            if (paramString6 != null) {
                arrayOfByte7 = this.CharsToBytes(this.charSet, arrayOfChar6);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.foreignKeys(paramLong, arrayOfByte2, paramString1 == null, arrayOfByte3, paramString2 == null, arrayOfByte4, paramString3 == null, arrayOfByte5, paramString4 == null, arrayOfByte6, paramString5 == null, arrayOfByte7, paramString6 == null, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLFreeConnect(long paramLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Closing connection (SQLFreeConnect), hDbc=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        this.freeConnect(paramLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, paramLong, 0L);
        }
    }

    public void SQLFreeEnv(long paramLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Closing environment (SQLFreeEnv), hEnv=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        this.freeEnv(paramLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public synchronized void SQLFreeStmt(long paramLong, int paramInt) throws SQLException {
        byte[] arrayOfByte = new byte[1];
        Long localLong = new Long(paramLong);
        if (paramInt == 1) {
            if (hstmtMap.containsKey(localLong)) {
                hstmtMap.remove(localLong);
                this.freeStmt(paramLong, paramInt, arrayOfByte);
                if (this.tracer.isTracing()) {
                    this.tracer.trace("Free statement (SQLFreeStmt), hStmt=" + paramLong + ", fOption=" + paramInt);
                }
            }
        } else {
            this.freeStmt(paramLong, paramInt, arrayOfByte);
            if (this.tracer.isTracing()) {
                this.tracer.trace("Free statement (SQLFreeStmt), hStmt=" + paramLong + ", fOption=" + paramInt);
            }
        }
        if (arrayOfByte[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public long SQLGetConnectOption(long paramLong, short paramShort) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Connection Option (SQLGetConnectOption), hDbc=" + paramLong + ", fOption=" + paramShort);
        }
        byte[] arrayOfByte = new byte[1];
        long l = this.getConnectOption(paramLong, paramShort, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, paramLong, 0L);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("option value (int)=" + l);
        }
        return l;
    }

    public String SQLGetConnectOptionString(long paramLong, short paramShort) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Connection Option (SQLGetConnectOption), hDbc=" + paramLong + ", fOption=" + paramShort);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = new byte[300];
        this.getConnectOptionString(paramLong, paramShort, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, paramLong, 0L);
        }
        String str = new String();
        try {
            str = this.BytesToChars(this.charSet, arrayOfByte2);
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("option value (int)=" + str.trim());
        }
        return str.trim();
    }

    public String SQLGetCursorName(long paramLong) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Cursor name (SQLGetCursorName), hStmt=" + paramLong);
        }
        byte[] arrayOfByte2 = new byte[1];
        byte[] arrayOfByte1 = new byte[300];
        this.getCursorName(paramLong, arrayOfByte1, arrayOfByte2);
        if (arrayOfByte2[0] != 0) {
            try {
                this.standardError(arrayOfByte2[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                String str2 = new String();
                try {
                    str2 = this.BytesToChars(this.charSet, arrayOfByte1);
                }
                catch (UnsupportedEncodingException localUnsupportedEncodingException) {
                    // empty catch block
                }
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value=" + str2.trim());
                }
                localJdbcOdbcSQLWarning.value = str2.trim();
                throw localJdbcOdbcSQLWarning;
            }
        }
        String str1 = new String(arrayOfByte1);
        if (this.tracer.isTracing()) {
            this.tracer.trace("value=" + str1.trim());
        }
        return str1.trim();
    }

    public int SQLGetDataBinary(long paramLong, int paramInt, byte[] paramArrayOfByte) throws SQLException, JdbcOdbcSQLWarning {
        return this.SQLGetDataBinary(paramLong, paramInt, -2, paramArrayOfByte, paramArrayOfByte.length);
    }

    public int SQLGetDataBinary(long paramLong, int paramInt1, int paramInt2, byte[] paramArrayOfByte, int paramInt3) throws SQLException, JdbcOdbcSQLWarning {
        int i = 0;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get binary data (SQLGetData), hStmt=" + paramLong + ", column=" + paramInt1 + ", type=" + paramInt2 + ", length=" + paramInt3);
        }
        byte[] arrayOfByte = new byte[2];
        i = this.getDataBinary(paramLong, paramInt1, paramInt2, paramArrayOfByte, paramInt3, arrayOfByte);
        if (arrayOfByte[0] == 100) {
            i = -1;
            arrayOfByte[0] = 0;
        }
        if (arrayOfByte[0] != 0) {
            try {
                this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    if (i == -1) {
                        this.tracer.trace("NULL");
                    } else if (this.tracer.isTracing()) {
                        this.tracer.trace("Bytes: " + i);
                    }
                }
                localJdbcOdbcSQLWarning.value = new Integer(i);
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (this.tracer.isTracing()) {
            if (i == -1) {
                this.tracer.trace("NULL");
            } else if (this.tracer.isTracing()) {
                this.tracer.trace("Bytes: " + i);
            }
        }
        return i;
    }

    public Double SQLGetDataDouble(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get double data (SQLGetData), hStmt=" + paramLong + ", column=" + paramInt);
        }
        byte[] arrayOfByte = new byte[2];
        double d = this.getDataDouble(paramLong, paramInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            try {
                this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (arrayOfByte[1] == 0) {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("value=" + d);
                    }
                    localJdbcOdbcSQLWarning.value = new Double(d);
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    localJdbcOdbcSQLWarning.value = null;
                }
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (arrayOfByte[1] == 0) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("value=" + d);
            }
            return new Double(d);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public Float SQLGetDataFloat(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get float data (SQLGetData), hStmt=" + paramLong + ", column=" + paramInt);
        }
        byte[] arrayOfByte = new byte[2];
        float f = (float)this.getDataFloat(paramLong, paramInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            try {
                this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (arrayOfByte[1] == 0) {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("value=" + f);
                    }
                    localJdbcOdbcSQLWarning.value = new Float(f);
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    localJdbcOdbcSQLWarning.value = null;
                }
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (arrayOfByte[1] == 0) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("value=" + f);
            }
            return new Float(f);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public Integer SQLGetDataInteger(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get integer data (SQLGetData), hStmt=" + paramLong + ", column=" + paramInt);
        }
        byte[] arrayOfByte = new byte[2];
        int i = this.getDataInteger(paramLong, paramInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            try {
                this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (arrayOfByte[1] == 0) {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("value=" + i);
                    }
                    localJdbcOdbcSQLWarning.value = new Integer(i);
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    localJdbcOdbcSQLWarning.value = null;
                }
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (arrayOfByte[1] == 0) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("value=" + i);
            }
            return new Integer(i);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataString(long paramLong, int paramInt1, int paramInt2, boolean paramBoolean) throws SQLException, JdbcOdbcSQLWarning {
        byte[] arrayOfByte1;
        byte[] arrayOfByte2;
        int i;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get string data (SQLGetData), hStmt=" + paramLong + ", column=" + paramInt1 + ", maxLen=" + paramInt2);
        }
        if ((i = this.getDataString(paramLong, paramInt1, arrayOfByte2 = new byte[paramInt2], arrayOfByte1 = new byte[2])) < 0) {
            arrayOfByte1[1] = 1;
        }
        if (i > paramInt2) {
            i = paramInt2;
        }
        if (arrayOfByte1[0] != 0) {
            try {
                this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (arrayOfByte1[1] == 0) {
                    char[] arrayOfChar = new char[i];
                    String str2 = new String();
                    if (i > 0) {
                        try {
                            str2 = this.BytesToChars(this.charSet, arrayOfByte2);
                        }
                        catch (UnsupportedEncodingException localUnsupportedEncodingException3) {
                            System.out.println(localUnsupportedEncodingException3);
                        }
                    } else {
                        try {
                            str2 = this.BytesToChars(this.charSet, arrayOfByte2);
                        }
                        catch (UnsupportedEncodingException localUnsupportedEncodingException4) {
                            System.out.println(localUnsupportedEncodingException4);
                        }
                    }
                    if (this.tracer.isTracing()) {
                        this.tracer.trace(str2.trim());
                    }
                    localJdbcOdbcSQLWarning.value = paramBoolean ? str2.trim() : str2;
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    localJdbcOdbcSQLWarning.value = null;
                }
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (arrayOfByte1[1] == 0) {
            String str1 = new String();
            char[] arrayOfChar = new char[i];
            if (i > 0) {
                try {
                    str1 = this.BytesToChars(this.charSet, arrayOfByte2);
                }
                catch (UnsupportedEncodingException localUnsupportedEncodingException1) {
                    System.out.println(localUnsupportedEncodingException1);
                }
            } else {
                try {
                    str1 = this.BytesToChars(this.charSet, arrayOfByte2);
                }
                catch (UnsupportedEncodingException localUnsupportedEncodingException2) {
                    System.out.println(localUnsupportedEncodingException2);
                }
            }
            if (this.tracer.isTracing()) {
                this.tracer.trace(str1.trim());
            }
            if (paramBoolean) {
                return str1.trim();
            }
            return str1;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataStringDate(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get date data (SQLGetData), hStmt=" + paramLong + ", column=" + paramInt);
        }
        byte[] arrayOfByte1 = new byte[2];
        byte[] arrayOfByte2 = new byte[11];
        this.getDataStringDate(paramLong, paramInt, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            try {
                this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (arrayOfByte1[1] == 0) {
                    String str2 = new String();
                    try {
                        str2 = this.BytesToChars(this.charSet, arrayOfByte2);
                    }
                    catch (UnsupportedEncodingException localUnsupportedEncodingException2) {
                        // empty catch block
                    }
                    if (this.tracer.isTracing()) {
                        this.tracer.trace(str2.trim());
                    }
                    localJdbcOdbcSQLWarning.value = str2.trim();
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    localJdbcOdbcSQLWarning.value = null;
                }
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (arrayOfByte1[1] == 0) {
            String str1 = new String();
            try {
                str1 = this.BytesToChars(this.charSet, arrayOfByte2);
            }
            catch (UnsupportedEncodingException localUnsupportedEncodingException1) {
                // empty catch block
            }
            if (this.tracer.isTracing()) {
                this.tracer.trace(str1.trim());
            }
            return str1.trim();
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataStringTime(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get time data (SQLGetData), hStmt=" + paramLong + ", column=" + paramInt);
        }
        byte[] arrayOfByte1 = new byte[2];
        byte[] arrayOfByte2 = new byte[9];
        this.getDataStringTime(paramLong, paramInt, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            try {
                this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (arrayOfByte1[1] == 0) {
                    String str2 = new String();
                    try {
                        str2 = this.BytesToChars(this.charSet, arrayOfByte2);
                    }
                    catch (UnsupportedEncodingException localUnsupportedEncodingException2) {
                        // empty catch block
                    }
                    if (this.tracer.isTracing()) {
                        this.tracer.trace(str2.trim());
                    }
                    localJdbcOdbcSQLWarning.value = str2.trim();
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    localJdbcOdbcSQLWarning.value = null;
                }
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (arrayOfByte1[1] == 0) {
            String str1 = new String();
            try {
                str1 = this.BytesToChars(this.charSet, arrayOfByte2);
            }
            catch (UnsupportedEncodingException localUnsupportedEncodingException1) {
                // empty catch block
            }
            if (this.tracer.isTracing()) {
                this.tracer.trace(str1.trim());
            }
            return str1.trim();
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataStringTimestamp(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get timestamp data (SQLGetData), hStmt=" + paramLong + ", column=" + paramInt);
        }
        byte[] arrayOfByte1 = new byte[2];
        byte[] arrayOfByte2 = new byte[30];
        this.getDataStringTimestamp(paramLong, paramInt, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            try {
                this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (arrayOfByte1[1] == 0) {
                    String str2 = new String();
                    try {
                        str2 = this.BytesToChars(this.charSet, arrayOfByte2);
                    }
                    catch (UnsupportedEncodingException localUnsupportedEncodingException2) {
                        // empty catch block
                    }
                    if (this.tracer.isTracing()) {
                        this.tracer.trace(str2.trim());
                    }
                    localJdbcOdbcSQLWarning.value = str2.trim();
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    localJdbcOdbcSQLWarning.value = null;
                }
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (arrayOfByte1[1] == 0) {
            String str1 = new String();
            try {
                str1 = this.BytesToChars(this.charSet, arrayOfByte2);
            }
            catch (UnsupportedEncodingException localUnsupportedEncodingException1) {
                // empty catch block
            }
            if (this.tracer.isTracing()) {
                this.tracer.trace(str1.trim());
            }
            return str1.trim();
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public int SQLGetInfo(long paramLong, short paramShort) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get connection info (SQLGetInfo), hDbc=" + paramLong + ", fInfoType=" + paramShort);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.getInfo(paramLong, paramShort, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, paramLong, 0L);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace(" int value=" + i);
        }
        return i;
    }

    public int SQLGetInfoShort(long paramLong, short paramShort) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get connection info (SQLGetInfo), hDbc=" + paramLong + ", fInfoType=" + paramShort);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.getInfoShort(paramLong, paramShort, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, paramLong, 0L);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace(" short value=" + i);
        }
        return i;
    }

    public String SQLGetInfoString(long paramLong, short paramShort) throws SQLException {
        return this.SQLGetInfoString(paramLong, paramShort, 300);
    }

    public String SQLGetInfoString(long paramLong, short paramShort, int paramInt) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get connection info string (SQLGetInfo), hDbc=" + paramLong + ", fInfoType=" + paramShort + ", len=" + paramInt);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = new byte[paramInt];
        this.getInfoString(paramLong, paramShort, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, paramLong, 0L);
        }
        String str = new String();
        try {
            str = this.BytesToChars(this.charSet, arrayOfByte2);
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace(str.trim());
        }
        return str.trim();
    }

    public long SQLGetStmtOption(long paramLong, short paramShort) throws SQLException, JdbcOdbcSQLWarning {
        long l = 0L;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get statement option (SQLGetStmtOption), hStmt=" + paramLong + ", fOption=" + paramShort);
        }
        byte[] arrayOfByte = new byte[1];
        l = this.getStmtOption(paramLong, paramShort, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            try {
                this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value=" + l);
                }
                localJdbcOdbcSQLWarning.value = BigDecimal.valueOf(l);
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("value=" + l);
        }
        return l;
    }

    public int SQLGetStmtAttr(long paramLong, int paramInt) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get Statement Attribute (SQLGetStmtAttr), hDbc=" + paramLong + ", AttrType=" + paramInt);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.getStmtAttr(paramLong, paramInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            try {
                this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value=" + i);
                }
                localJdbcOdbcSQLWarning.value = BigDecimal.valueOf(i);
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace(" int value=" + i);
        }
        return i;
    }

    public void SQLGetTypeInfo(long paramLong, short paramShort) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get type info (SQLGetTypeInfo), hStmt=" + paramLong + ", fSqlType=" + paramShort);
        }
        byte[] arrayOfByte = new byte[1];
        this.getTypeInfo(paramLong, paramShort, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public boolean SQLMoreResults(long paramLong) throws SQLException, SQLWarning {
        boolean bool = true;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get more results (SQLMoreResults), hStmt=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        this.moreResults(paramLong, arrayOfByte);
        if (arrayOfByte[0] == 100) {
            bool = false;
            arrayOfByte[0] = 0;
        }
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("More results: " + bool);
        }
        return bool;
    }

    public String SQLNativeSql(long paramLong, String paramString) throws SQLException {
        byte[] arrayOfByte1 = new byte[1];
        int i = 1024;
        if (paramString.length() * 4 > i && (i = paramString.length() * 4) > 32768) {
            i = 32768;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Convert native SQL (SQLNativeSql), hDbc=" + paramLong + ", nativeLen=" + i + ", SQL=" + paramString);
        }
        byte[] arrayOfByte2 = new byte[i];
        byte[] arrayOfByte3 = null;
        char[] arrayOfChar = null;
        if (paramString != null) {
            arrayOfChar = paramString.toCharArray();
        }
        try {
            if (paramString != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException1) {
            // empty catch block
        }
        this.nativeSql(paramLong, arrayOfByte3, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, paramLong, 0L);
        }
        String str = new String();
        try {
            str = this.BytesToChars(this.charSet, arrayOfByte2);
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException2) {
            // empty catch block
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Native SQL=" + str.trim());
        }
        return str.trim();
    }

    public int SQLNumParams(long paramLong) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Number of parameter markers (SQLNumParams), hStmt=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.numParams(paramLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("value=" + i);
        }
        return i;
    }

    public int SQLNumResultCols(long paramLong) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Number of result columns (SQLNumResultCols), hStmt=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.numResultCols(paramLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            try {
                this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value=" + i);
                }
                localJdbcOdbcSQLWarning.value = BigDecimal.valueOf(i);
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("value=" + i);
        }
        return i;
    }

    public int SQLParamData(long paramLong) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get parameter number (SQLParamData), hStmt=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.paramData(paramLong, arrayOfByte);
        if (arrayOfByte[0] == 99) {
            arrayOfByte[0] = 0;
        } else {
            i = -1;
        }
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter needing data=" + i);
        }
        return i;
    }

    public int SQLParamDataInBlock(long paramLong, int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get parameter number (SQLParamData in block-cursor), hStmt=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.paramDataInBlock(paramLong, paramInt, arrayOfByte);
        if (arrayOfByte[0] == 99) {
            arrayOfByte[0] = 0;
        } else {
            i = -1;
        }
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter needing data=" + i);
        }
        return i;
    }

    public void SQLPrepare(long paramLong, String paramString) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Preparing (SQLPrepare), hStmt=" + paramLong + ", szSqlStr=" + paramString);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        char[] arrayOfChar = null;
        if (paramString != null) {
            arrayOfChar = paramString.toCharArray();
        }
        try {
            if (paramString != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.prepare(paramLong, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLPutData(long paramLong, byte[] paramArrayOfByte, int paramInt) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Putting data (SQLPutData), hStmt=" + paramLong + ", len=" + paramInt);
        }
        byte[] arrayOfByte = new byte[1];
        this.putData(paramLong, paramArrayOfByte, paramInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLPrimaryKeys(long paramLong, String paramString1, String paramString2, String paramString3) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Primary keys (SQLPrimaryKeys), hStmt=" + paramLong + ", catalog=" + paramString1 + ", schema=" + paramString2 + ", table=" + paramString3);
        }
        byte[] arrayOfByte2 = null;
        byte[] arrayOfByte3 = null;
        byte[] arrayOfByte4 = null;
        char[] arrayOfChar1 = null;
        char[] arrayOfChar2 = null;
        char[] arrayOfChar3 = null;
        if (paramString1 != null) {
            arrayOfChar1 = paramString1.toCharArray();
        }
        if (paramString2 != null) {
            arrayOfChar2 = paramString2.toCharArray();
        }
        if (paramString3 != null) {
            arrayOfChar3 = paramString3.toCharArray();
        }
        try {
            if (paramString1 != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar1);
            }
            if (paramString2 != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar2);
            }
            if (paramString3 != null) {
                arrayOfByte4 = this.CharsToBytes(this.charSet, arrayOfChar3);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        byte[] arrayOfByte1 = new byte[1];
        this.primaryKeys(paramLong, arrayOfByte2, paramString1 == null, arrayOfByte3, paramString2 == null, arrayOfByte4, paramString3 == null, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLProcedures(long paramLong, String paramString1, String paramString2, String paramString3) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Procedures (SQLProcedures), hStmt=" + paramLong + ", catalog=" + paramString1 + ", schema=" + paramString2 + ", procedure=" + paramString3);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        byte[] arrayOfByte3 = null;
        byte[] arrayOfByte4 = null;
        char[] arrayOfChar1 = null;
        char[] arrayOfChar2 = null;
        char[] arrayOfChar3 = null;
        if (paramString1 != null) {
            arrayOfChar1 = paramString1.toCharArray();
        }
        if (paramString2 != null) {
            arrayOfChar2 = paramString2.toCharArray();
        }
        if (paramString3 != null) {
            arrayOfChar3 = paramString3.toCharArray();
        }
        try {
            if (paramString1 != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar1);
            }
            if (paramString2 != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar2);
            }
            if (paramString3 != null) {
                arrayOfByte4 = this.CharsToBytes(this.charSet, arrayOfChar3);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.procedures(paramLong, arrayOfByte2, paramString1 == null, arrayOfByte3, paramString2 == null, arrayOfByte4, paramString3 == null, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLProcedureColumns(long paramLong, String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Procedure columns (SQLProcedureColumns), hStmt=" + paramLong + ", catalog=" + paramString1 + ", schema=" + paramString2 + ", procedure=" + paramString3 + ", column=" + paramString4);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        byte[] arrayOfByte3 = null;
        byte[] arrayOfByte4 = null;
        byte[] arrayOfByte5 = null;
        char[] arrayOfChar1 = null;
        char[] arrayOfChar2 = null;
        char[] arrayOfChar3 = null;
        char[] arrayOfChar4 = null;
        if (paramString1 != null) {
            arrayOfChar1 = paramString1.toCharArray();
        }
        if (paramString2 != null) {
            arrayOfChar2 = paramString2.toCharArray();
        }
        if (paramString3 != null) {
            arrayOfChar3 = paramString3.toCharArray();
        }
        if (paramString4 != null) {
            arrayOfChar4 = paramString4.toCharArray();
        }
        try {
            if (paramString1 != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar1);
            }
            if (paramString2 != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar2);
            }
            if (paramString3 != null) {
                arrayOfByte4 = this.CharsToBytes(this.charSet, arrayOfChar3);
            }
            if (paramString4 != null) {
                arrayOfByte5 = this.CharsToBytes(this.charSet, arrayOfChar4);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.procedureColumns(paramLong, arrayOfByte2, paramString1 == null, arrayOfByte3, paramString2 == null, arrayOfByte4, paramString3 == null, arrayOfByte5, paramString4 == null, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public int SQLRowCount(long paramLong) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Number of affected rows (SQLRowCount), hStmt=" + paramLong);
        }
        byte[] arrayOfByte = new byte[1];
        int i = this.rowCount(paramLong, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            try {
                this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
            }
            catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value=" + i);
                }
                localJdbcOdbcSQLWarning.value = BigDecimal.valueOf(i);
                throw localJdbcOdbcSQLWarning;
            }
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("value=" + i);
        }
        return i;
    }

    public void SQLSetConnectOption(long paramLong, short paramShort, int paramInt) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting connection option (SQLSetConnectOption), hDbc=" + paramLong + ", fOption=" + paramShort + ", vParam=" + paramInt);
        }
        byte[] arrayOfByte = new byte[1];
        this.setConnectOption(paramLong, paramShort, paramInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, paramLong, 0L);
        }
    }

    public void SQLSetConnectOption(long paramLong, short paramShort, String paramString) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting connection option string (SQLSetConnectOption), hDbc=" + paramLong + ", fOption=" + paramShort + ", vParam=" + paramString);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        char[] arrayOfChar = null;
        if (paramString != null) {
            arrayOfChar = paramString.toCharArray();
        }
        try {
            if (paramString != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.setConnectOptionString(paramLong, paramShort, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, paramLong, 0L);
        }
    }

    public void SQLSetCursorName(long paramLong, String paramString) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting cursor name (SQLSetCursorName), hStmt=" + paramLong + ", szCursor=" + paramString);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        char[] arrayOfChar = null;
        if (paramString != null) {
            arrayOfChar = paramString.toCharArray();
        }
        try {
            if (paramString != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.setCursorName(paramLong, arrayOfByte2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLSetStmtOption(long paramLong, short paramShort, int paramInt) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting statement option (SQLSetStmtOption), hStmt=" + paramLong + ", fOption=" + paramShort + ", vParam=" + paramInt);
        }
        byte[] arrayOfByte = new byte[1];
        this.setStmtOption(paramLong, paramShort, paramInt, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLSetStmtAttr(long paramLong, int paramInt1, int paramInt2, int paramInt3) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting statement option (SQLSetStmtAttr), hStmt=" + paramLong + ", fOption=" + paramInt1 + ", vParam=" + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.setStmtAttr(paramLong, paramInt1, paramInt2, paramInt3, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public void SQLSetStmtAttrPtr(long paramLong, int paramInt1, int[] paramArrayOfInt, int paramInt2, long[] paramArrayOfLong) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting statement option (SQLSetStmtAttr), hStmt=" + paramLong + ", fOption=" + paramInt1);
        }
        byte[] arrayOfByte = new byte[1];
        this.setStmtAttrPtr(paramLong, paramInt1, paramArrayOfInt, paramInt2, arrayOfByte, paramArrayOfLong);
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
    }

    public boolean SQLSetPos(long paramLong, int paramInt1, int paramInt2, int paramInt3) throws SQLException {
        boolean bool = false;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting row position (SQLSetPos), hStmt=" + paramLong + ", operation = " + paramInt2);
        }
        byte[] arrayOfByte = new byte[1];
        this.setPos(paramLong, paramInt1, paramInt2, paramInt3, arrayOfByte);
        if (arrayOfByte[0] == 99) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("SQL_NEED_DATA returned");
            }
            bool = true;
            arrayOfByte[0] = 0;
        }
        if (arrayOfByte[0] != 0) {
            this.standardError(arrayOfByte[0], 0L, 0L, paramLong);
        }
        return bool;
    }

    public void SQLSpecialColumns(long paramLong, short paramShort, String paramString1, String paramString2, String paramString3, int paramInt, boolean paramBoolean) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Special columns (SQLSpecialColumns), hStmt=" + paramLong + ", fColType=" + paramShort + ",catalog=" + paramString1 + ", schema=" + paramString2 + ", table=" + paramString3 + ", fScope=" + paramInt + ", fNullable=" + paramBoolean);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        byte[] arrayOfByte3 = null;
        byte[] arrayOfByte4 = null;
        char[] arrayOfChar1 = null;
        char[] arrayOfChar2 = null;
        char[] arrayOfChar3 = null;
        if (paramString1 != null) {
            arrayOfChar1 = paramString1.toCharArray();
        }
        if (paramString2 != null) {
            arrayOfChar2 = paramString2.toCharArray();
        }
        if (paramString3 != null) {
            arrayOfChar3 = paramString3.toCharArray();
        }
        try {
            if (paramString1 != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar1);
            }
            if (paramString2 != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar2);
            }
            if (paramString3 != null) {
                arrayOfByte4 = this.CharsToBytes(this.charSet, arrayOfChar3);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.specialColumns(paramLong, paramShort, arrayOfByte2, paramString1 == null, arrayOfByte3, paramString2 == null, arrayOfByte4, paramString3 == null, paramInt, paramBoolean, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLStatistics(long paramLong, String paramString1, String paramString2, String paramString3, boolean paramBoolean1, boolean paramBoolean2) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Statistics (SQLStatistics), hStmt=" + paramLong + ",catalog=" + paramString1 + ", schema=" + paramString2 + ", table=" + paramString3 + ", unique=" + paramBoolean1 + ", approximate=" + paramBoolean2);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        byte[] arrayOfByte3 = null;
        byte[] arrayOfByte4 = null;
        char[] arrayOfChar1 = null;
        char[] arrayOfChar2 = null;
        char[] arrayOfChar3 = null;
        if (paramString1 != null) {
            arrayOfChar1 = paramString1.toCharArray();
        }
        if (paramString2 != null) {
            arrayOfChar2 = paramString2.toCharArray();
        }
        if (paramString3 != null) {
            arrayOfChar3 = paramString3.toCharArray();
        }
        try {
            if (paramString1 != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar1);
            }
            if (paramString2 != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar2);
            }
            if (paramString3 != null) {
                arrayOfByte4 = this.CharsToBytes(this.charSet, arrayOfChar3);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.statistics(paramLong, arrayOfByte2, paramString1 == null, arrayOfByte3, paramString2 == null, arrayOfByte4, paramString3 == null, paramBoolean1, paramBoolean2, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLTables(long paramLong, String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Tables (SQLTables), hStmt=" + paramLong + ",catalog=" + paramString1 + ", schema=" + paramString2 + ", table=" + paramString3 + ", types=" + paramString4);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        byte[] arrayOfByte3 = null;
        byte[] arrayOfByte4 = null;
        byte[] arrayOfByte5 = null;
        char[] arrayOfChar1 = null;
        char[] arrayOfChar2 = null;
        char[] arrayOfChar3 = null;
        char[] arrayOfChar4 = null;
        if (paramString1 != null) {
            arrayOfChar1 = paramString1.toCharArray();
        }
        if (paramString2 != null) {
            arrayOfChar2 = paramString2.toCharArray();
        }
        if (paramString3 != null) {
            arrayOfChar3 = paramString3.toCharArray();
        }
        if (paramString4 != null) {
            arrayOfChar4 = paramString4.toCharArray();
        }
        try {
            if (paramString1 != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar1);
            }
            if (paramString2 != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar2);
            }
            if (paramString3 != null) {
                arrayOfByte4 = this.CharsToBytes(this.charSet, arrayOfChar3);
            }
            if (paramString4 != null) {
                arrayOfByte5 = this.CharsToBytes(this.charSet, arrayOfChar4);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.tables(paramLong, arrayOfByte2, paramString1 == null, arrayOfByte3, paramString2 == null, arrayOfByte4, paramString3 == null, arrayOfByte5, paramString4 == null, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLTablePrivileges(long paramLong, String paramString1, String paramString2, String paramString3) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Tables (SQLTables), hStmt=" + paramLong + ",catalog=" + paramString1 + ", schema=" + paramString2 + ", table=" + paramString3);
        }
        byte[] arrayOfByte1 = new byte[1];
        byte[] arrayOfByte2 = null;
        byte[] arrayOfByte3 = null;
        byte[] arrayOfByte4 = null;
        char[] arrayOfChar1 = null;
        char[] arrayOfChar2 = null;
        char[] arrayOfChar3 = null;
        if (paramString1 != null) {
            arrayOfChar1 = paramString1.toCharArray();
        }
        if (paramString2 != null) {
            arrayOfChar2 = paramString2.toCharArray();
        }
        if (paramString3 != null) {
            arrayOfChar3 = paramString3.toCharArray();
        }
        try {
            if (paramString1 != null) {
                arrayOfByte2 = this.CharsToBytes(this.charSet, arrayOfChar1);
            }
            if (paramString2 != null) {
                arrayOfByte3 = this.CharsToBytes(this.charSet, arrayOfChar2);
            }
            if (paramString3 != null) {
                arrayOfByte4 = this.CharsToBytes(this.charSet, arrayOfChar3);
            }
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            // empty catch block
        }
        this.tablePrivileges(paramLong, arrayOfByte2, paramString1 == null, arrayOfByte3, paramString2 == null, arrayOfByte4, paramString3 == null, arrayOfByte1);
        if (arrayOfByte1[0] != 0) {
            this.standardError(arrayOfByte1[0], 0L, 0L, paramLong);
        }
    }

    public void SQLTransact(long paramLong1, long paramLong2, short paramShort) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Transaction (SQLTransact), hEnv=" + paramLong1 + ", hDbc=" + paramLong2 + ", fType=" + paramShort);
        }
        byte[] arrayOfByte = new byte[1];
        this.transact(paramLong1, paramLong2, paramShort, arrayOfByte);
        if (arrayOfByte[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public native int bufferToInt(byte[] var1);

    public native float bufferToFloat(byte[] var1);

    public native double bufferToDouble(byte[] var1);

    public native long bufferToLong(byte[] var1);

    public native void convertDateString(byte[] var1, byte[] var2);

    public native void getDateStruct(byte[] var1, int var2, int var3, int var4);

    public native void convertTimeString(byte[] var1, byte[] var2);

    public native void getTimeStruct(byte[] var1, int var2, int var3, int var4);

    public native void getTimestampStruct(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public native void convertTimestampString(byte[] var1, byte[] var2);

    public static native int getSQLLENSize();

    public static native void intToBytes(int var0, byte[] var1);

    public static native void longToBytes(long var0, byte[] var2);

    public static native void intTo4Bytes(int var0, byte[] var1);

    public static SQLWarning convertWarning(JdbcOdbcSQLWarning paramJdbcOdbcSQLWarning) {
        SQLWarning localObject = paramJdbcOdbcSQLWarning;
        if (paramJdbcOdbcSQLWarning.getSQLState().equals("01004")) {
            DataTruncation localDataTruncation = new DataTruncation(-1, false, true, 0, 0);
            localObject = localDataTruncation;
        }
        return localObject;
    }

    protected native long allocConnect(long var1, byte[] var3);

    protected native long allocEnv(byte[] var1);

    protected native long allocStmt(long var1, byte[] var3);

    protected native void cancel(long var1, byte[] var3);

    protected native void bindColAtExec(long var1, int var3, int var4, byte[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColBinary(long var1, int var3, Object[] var4, byte[] var5, int var6, byte[] var7, long[] var8, byte[] var9);

    protected native void bindColDate(long var1, int var3, int[] var4, int[] var5, int[] var6, byte[] var7, byte[] var8, long[] var9, byte[] var10);

    protected native void bindColDefault(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    protected native void bindColDouble(long var1, int var3, double[] var4, byte[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColFloat(long var1, int var3, float[] var4, byte[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColInteger(long var1, int var3, int[] var4, byte[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColString(long var1, int var3, int var4, Object[] var5, int var6, byte[] var7, byte[] var8, long[] var9, byte[] var10);

    protected native void bindColTime(long var1, int var3, int[] var4, int[] var5, int[] var6, byte[] var7, byte[] var8, long[] var9, byte[] var10);

    protected native void bindColTimestamp(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9, int[] var10, byte[] var11, byte[] var12, long[] var13, byte[] var14);

    protected native void bindInParameterAtExec(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInOutParameterAtExec(long var1, int var3, int var4, int var5, int var6, byte[] var7, int var8, byte[] var9, byte[] var10, long[] var11);

    protected native void bindInParameterBinary(long var1, int var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterDate(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterDouble(long var1, int var3, int var4, int var5, double var6, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterFloat(long var1, int var3, int var4, int var5, double var6, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterBigint(long var1, int var3, int var4, int var5, long var6, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterInteger(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindInParameterNull(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterString(long var1, int var3, int var4, byte[] var5, int var6, int var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterTime(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterTimestamp(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, byte[] var11, byte[] var12, long[] var13);

    protected native void bindOutParameterString(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInOutParameterDate(long var1, int var3, int var4, byte[] var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindInOutParameterTime(long var1, int var3, int var4, byte[] var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindInOutParameterString(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameterStr(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9, int var10);

    protected native void bindInOutParameterBin(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9, int var10);

    protected native void bindInOutParameterBinary(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameterFixed(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameterTimeStamp(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameter(long var1, int var3, int var4, int var5, int var6, double var7, byte[] var9, byte[] var10, long[] var11);

    protected native void bindInOutParameterNull(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInOutParameterTimestamp(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterStringArray(long var1, int var3, int var4, Object[] var5, byte[] var6, int var7, int var8, int[] var9, byte[] var10);

    protected native void bindInParameterIntegerArray(long var1, int var3, int var4, int[] var5, int[] var6, byte[] var7);

    protected native void bindInParameterFloatArray(long var1, int var3, int var4, int var5, float[] var6, int[] var7, byte[] var8);

    protected native void bindInParameterDoubleArray(long var1, int var3, int var4, int var5, double[] var6, int[] var7, byte[] var8);

    protected native void bindInParameterDateArray(long var1, int var3, int[] var4, int[] var5, int[] var6, byte[] var7, byte[] var8, int[] var9);

    protected native void bindInParameterTimeArray(long var1, int var3, int[] var4, int[] var5, int[] var6, byte[] var7, byte[] var8, int[] var9);

    protected native void bindInParameterTimestampArray(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9, int[] var10, byte[] var11, byte[] var12, int[] var13);

    protected native void bindInParameterBinaryArray(long var1, int var3, int var4, Object[] var5, int var6, byte[] var7, int[] var8, byte[] var9);

    protected native void bindInParameterAtExecArray(long var1, int var3, int var4, int var5, byte[] var6, int[] var7, byte[] var8);

    protected native void bindOutParameterNull(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindOutParameterFixed(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindOutParameterBinary(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindOutParameterDate(long var1, int var3, int var4, byte[] var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindOutParameterTime(long var1, int var3, int var4, byte[] var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindOutParameterTimestamp(long var1, int var3, int var4, byte[] var5, byte[] var6, byte[] var7, long[] var8);

    protected native void browseConnect(long var1, byte[] var3, byte[] var4, byte[] var5);

    protected native int colAttributes(long var1, int var3, int var4, byte[] var5);

    protected native void colAttributesString(long var1, int var3, int var4, byte[] var5, byte[] var6);

    protected native void columns(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native void columnPrivileges(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native int describeParam(long var1, int var3, int var4, byte[] var5);

    protected native void disconnect(long var1, byte[] var3);

    protected native void driverConnect(long var1, byte[] var3, byte[] var4);

    protected native int error(long var1, long var3, long var5, byte[] var7, byte[] var8, byte[] var9);

    protected native void execDirect(long var1, byte[] var3, byte[] var4);

    protected native void execute(long var1, byte[] var3);

    protected native void fetch(long var1, byte[] var3);

    protected native void fetchScroll(long var1, short var3, int var4, byte[] var5);

    protected native void foreignKeys(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11, boolean var12, byte[] var13, boolean var14, byte[] var15);

    protected native void freeConnect(long var1, byte[] var3);

    protected native void freeEnv(long var1, byte[] var3);

    protected native void freeStmt(long var1, int var3, byte[] var4);

    protected native long getConnectOption(long var1, short var3, byte[] var4);

    protected native void getConnectOptionString(long var1, short var3, byte[] var4, byte[] var5);

    protected native void getCursorName(long var1, byte[] var3, byte[] var4);

    protected native long getStmtOption(long var1, short var3, byte[] var4);

    protected native int getStmtAttr(long var1, int var3, byte[] var4);

    protected native int getDataBinary(long var1, int var3, int var4, byte[] var5, int var6, byte[] var7);

    protected native double getDataDouble(long var1, int var3, byte[] var4);

    protected native double getDataFloat(long var1, int var3, byte[] var4);

    protected native int getDataInteger(long var1, int var3, byte[] var4);

    protected native int getDataString(long var1, int var3, byte[] var4, byte[] var5);

    protected native void getDataStringDate(long var1, int var3, byte[] var4, byte[] var5);

    protected native void getDataStringTime(long var1, int var3, byte[] var4, byte[] var5);

    protected native void getDataStringTimestamp(long var1, int var3, byte[] var4, byte[] var5);

    protected native int getInfo(long var1, short var3, byte[] var4);

    protected native int getInfoShort(long var1, short var3, byte[] var4);

    protected native void getInfoString(long var1, short var3, byte[] var4, byte[] var5);

    protected native void getTypeInfo(long var1, short var3, byte[] var4);

    protected native void moreResults(long var1, byte[] var3);

    protected native void nativeSql(long var1, byte[] var3, byte[] var4, byte[] var5);

    protected native int numParams(long var1, byte[] var3);

    protected native int numResultCols(long var1, byte[] var3);

    protected native int paramData(long var1, byte[] var3);

    protected native int paramDataInBlock(long var1, int var3, byte[] var4);

    protected native void prepare(long var1, byte[] var3, byte[] var4);

    protected native void primaryKeys(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9);

    protected native void procedures(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9);

    protected native void procedureColumns(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native void putData(long var1, byte[] var3, int var4, byte[] var5);

    protected native int rowCount(long var1, byte[] var3);

    protected native void setConnectOption(long var1, short var3, int var4, byte[] var5);

    protected native void setConnectOptionString(long var1, short var3, byte[] var4, byte[] var5);

    protected native void setCursorName(long var1, byte[] var3, byte[] var4);

    protected native void setStmtOption(long var1, short var3, int var4, byte[] var5);

    protected native void setStmtAttr(long var1, int var3, int var4, int var5, byte[] var6);

    protected native void setStmtAttrPtr(long var1, int var3, int[] var4, int var5, byte[] var6, long[] var7);

    protected native void setPos(long var1, int var3, int var4, int var5, byte[] var6);

    protected native void specialColumns(long var1, short var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8, boolean var9, int var10, boolean var11, byte[] var12);

    protected native void statistics(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, boolean var9, boolean var10, byte[] var11);

    protected native void tables(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native void tablePrivileges(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9);

    protected native void transact(long var1, long var3, short var5, byte[] var6);

    protected static native void ReleaseStoredBytes(long var0, long var2);

    protected static native void ReleaseStoredChars(long var0, long var2);

    protected static native void ReleaseStoredIntegers(long var0, long var2);

    SQLException createSQLException(long paramLong1, long paramLong2, long paramLong3) {
        String str1;
        boolean j = false;
        SQLException localObject1 = null;
        SQLException localObject2 = null;
        if (this.tracer.isTracing()) {
            this.tracer.trace("ERROR - Generating SQLException...");
        }
        while (!j) {
            byte[] arrayOfByte3 = new byte[1];
            byte[] arrayOfByte1 = new byte[6];
            byte[] arrayOfByte2 = new byte[300];
            int i = this.error(paramLong1, paramLong2, paramLong3, arrayOfByte1, arrayOfByte2, arrayOfByte3);
            if (arrayOfByte3[0] != 0) {
                j = true;
                continue;
            }
            SQLException localObject3 = null;
            str1 = new String();
            String str2 = new String();
            try {
                str1 = this.BytesToChars(this.charSet, arrayOfByte2);
                str2 = this.BytesToChars(this.charSet, arrayOfByte1);
            }
            catch (UnsupportedEncodingException localUnsupportedEncodingException) {
                // empty catch block
            }
            localObject3 = new SQLException(str1.trim(), str2.trim(), i);
            if (localObject1 == null) {
                localObject1 = localObject3;
            } else {
                localObject2.setNextException(localObject3);
            }
            localObject2 = localObject3;
        }
        if (localObject1 == null) {
            String localObject3 = "General error";
            str1 = "S1000";
            if (this.tracer.isTracing()) {
                this.tracer.trace("ERROR - " + str1 + " " + localObject3);
            }
            localObject1 = new SQLException(localObject3, str1);
        }
        return localObject1;
    }

    SQLWarning createSQLWarning(long paramLong1, long paramLong2, long paramLong3) {
        String str1;
        boolean j = false;
        JdbcOdbcSQLWarning localObject1 = null;
        SQLWarning localObject2 = null;
        if (this.tracer.isTracing()) {
            this.tracer.trace("WARNING - Generating SQLWarning...");
        }
        while (!j) {
            byte[] arrayOfByte3 = new byte[1];
            byte[] arrayOfByte1 = new byte[6];
            byte[] arrayOfByte2 = new byte[300];
            int i = this.error(paramLong1, paramLong2, paramLong3, arrayOfByte1, arrayOfByte2, arrayOfByte3);
            if (arrayOfByte3[0] != 0) {
                j = true;
                continue;
            }
            str1 = new String();
            String str2 = new String();
            try {
                str1 = this.BytesToChars(this.charSet, arrayOfByte2);
                str2 = this.BytesToChars(this.charSet, arrayOfByte1);
            }
            catch (UnsupportedEncodingException localUnsupportedEncodingException) {
                // empty catch block
            }
            JdbcOdbcSQLWarning localObject3 = new JdbcOdbcSQLWarning(str1.trim(), str2.trim(), i);
            if (localObject1 == null) {
                localObject1 = localObject3;
            } else {
                localObject2.setNextWarning(localObject3);
            }
            localObject2 = localObject3;
        }
        if (localObject1 == null) {
            String localObject3 = "General warning";
            str1 = "S1000";
            if (this.tracer.isTracing()) {
                this.tracer.trace("WARNING - " + str1 + " " + localObject3);
            }
            localObject1 = new JdbcOdbcSQLWarning(localObject3, str1);
        }
        return localObject1;
    }

    void throwGenericSQLException() throws SQLException {
        String str1 = "General error";
        String str2 = "S1000";
        if (this.tracer.isTracing()) {
            this.tracer.trace("ERROR - " + str2 + " " + str1);
        }
        throw new SQLException(str1, str2);
    }

    void standardError(short paramShort, long paramLong1, long paramLong2, long paramLong3) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("RETCODE = " + paramShort);
        }
        switch (paramShort) {
            case -1: {
                throw this.createSQLException(paramLong1, paramLong2, paramLong3);
            }
            case 1: {
                throw this.createSQLWarning(paramLong1, paramLong2, paramLong3);
            }
            case -2: {
                String str = "Invalid handle";
                if (this.tracer.isTracing()) {
                    this.tracer.trace("ERROR - " + str);
                }
                throw new SQLException(str);
            }
            case 100: {
                String str = "No data found";
                if (this.tracer.isTracing()) {
                    this.tracer.trace("ERROR - " + str);
                }
                throw new SQLException(str);
            }
        }
        this.throwGenericSQLException();
    }

    public JdbcOdbcTracer getTracer() {
        return this.tracer;
    }
}

