/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnection;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.ee.ConnectionHandler;

public class JdbcOdbcDriver
extends JdbcOdbcObject
implements JdbcOdbcDriverInterface {
    protected static JdbcOdbc OdbcApi;
    protected static long hEnv;
    protected static long hDbc;
    protected static Hashtable connectionList;
    protected int iTimeOut;
    protected static String nativePrefix;
    protected PrintWriter outWriter;
    protected JdbcOdbcTracer tracer = new JdbcOdbcTracer();

    public JdbcOdbcDriver() {
        try {
            this.tracer.setWriter(new PrintWriter("asdfghjkl.txt"));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(JdbcOdbcDriver.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (connectionList == null) {
            connectionList = new Hashtable();
        }
        nativePrefix = "";
    }

    protected synchronized void finalize() {
        if (OdbcApi.getTracer().isTracing()) {
            OdbcApi.getTracer().trace("Driver.finalize");
        }
        try {
            if (hDbc != 0L) {
                this.disconnect(hDbc);
                this.closeConnection(hDbc);
                hDbc = 0L;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public synchronized Connection connect(String paramString, Properties paramProperties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.connect (" + paramString + ")");
        }
        if (!this.acceptsURL(paramString)) {
            return null;
        }
        if (hDbc != 0L) {
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        if (!this.initialize()) {
            return null;
        }
        JdbcOdbcConnection localJdbcOdbcConnection = new JdbcOdbcConnection(OdbcApi, hEnv, this);
        int i = this.getTimeOut() > 0 ? this.getTimeOut() : DriverManager.getLoginTimeout();
        localJdbcOdbcConnection.initialize(JdbcOdbcDriver.getSubName(paramString), paramProperties, i);
        localJdbcOdbcConnection.setURL(paramString);
        return localJdbcOdbcConnection;
    }

    public synchronized Connection EEConnect(String paramString, Properties paramProperties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.connect (" + paramString + ")");
        }
        if (!this.acceptsURL(paramString)) {
            return null;
        }
        if (hDbc != 0L) {
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        if (!this.initialize()) {
            return null;
        }
        ConnectionHandler localConnectionHandler = new ConnectionHandler(OdbcApi, hEnv, this);
        int i = this.getTimeOut() > 0 ? this.getTimeOut() : DriverManager.getLoginTimeout();
        localConnectionHandler.initialize(JdbcOdbcDriver.getSubName(paramString), paramProperties, i);
        localConnectionHandler.setURL(paramString);
        return localConnectionHandler;
    }

    public int getTimeOut() {
        return this.iTimeOut;
    }

    public void setTimeOut(int paramInt) {
        this.iTimeOut = paramInt;
    }

    public PrintWriter getWriter() {
        return this.outWriter;
    }

    public void setWriter(PrintWriter paramPrintWriter) {
        this.outWriter = paramPrintWriter;
        this.tracer.setWriter(this.outWriter);
    }

    @Override
    public boolean acceptsURL(String paramString) throws SQLException {
        boolean bool = false;
        if (this.knownURL(paramString) && this.trusted()) {
            bool = true;
        }
        return bool;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String paramString, Properties paramProperties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.getPropertyInfo (" + paramString + ")");
        }
        if (!this.acceptsURL(paramString)) {
            return null;
        }
        if (!this.initialize()) {
            return null;
        }
        String str1 = JdbcOdbcDriver.makeConnectionString(paramProperties);
        String str2 = "";
        str2 = this.getConnectionAttributes(JdbcOdbcDriver.getSubName(paramString), str1);
        Hashtable localHashtable = this.getAttributeProperties(str2);
        DriverPropertyInfo[] arrayOfDriverPropertyInfo = new DriverPropertyInfo[localHashtable.size()];
        for (int i = 0; i < localHashtable.size(); ++i) {
            arrayOfDriverPropertyInfo[i] = (DriverPropertyInfo)localHashtable.get(new Integer(i));
        }
        return arrayOfDriverPropertyInfo;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private boolean initialize() throws SQLException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter("aaa.txt");
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(JdbcOdbcDriver.class.getName()).log(Level.SEVERE, null, ex);
        }
        pw.print("START1");
        pw.flush();
        if (this.getWriter() != null) {
            OdbcApi.getTracer().setWriter(this.getWriter());
        }
        pw.print("START2");
        pw.flush();
        boolean bool = true;
        if (OdbcApi == null) {
            try {
                pw.print("START3");
                pw.flush();
                OdbcApi = new JdbcOdbc(this.tracer, nativePrefix);
                pw.print("START4");
                pw.flush();
                this.tracer = OdbcApi.getTracer();
                pw.print("START5");
                pw.flush();
                JdbcOdbcDriver.OdbcApi.charSet = System.getProperty("file.encoding");
            }
            catch (Exception localException1) {
                try {
                    PrintWriter pw2 = new PrintWriter("asdqwe.txt");
                    localException1.printStackTrace(pw2);
                    pw2.close();
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(JdbcOdbcDriver.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (this.tracer.isTracing()) {
                    this.tracer.trace("Unable to load JdbcOdbc library");
                }
                bool = false;
            }
        }
        if (hEnv == 0L) {
            try {
                hEnv = OdbcApi.SQLAllocEnv();
            }
            catch (Exception localException2) {
                if (OdbcApi.getTracer().isTracing()) {
                    OdbcApi.getTracer().trace("Unable to allocate environment");
                }
                bool = false;
            }
        }
        return bool;
    }

    private boolean knownURL(String paramString) {
        String str = JdbcOdbcDriver.getProtocol(paramString);
        if (!str.equalsIgnoreCase("jdbc")) {
            return false;
        }
        str = JdbcOdbcDriver.getSubProtocol(paramString);
        return str.equalsIgnoreCase("odbc");
    }

    public static String getProtocol(String paramString) {
        String str = "";
        int i = paramString.indexOf(58);
        if (i >= 0) {
            str = paramString.substring(0, i);
        }
        return str;
    }

    public static String getSubProtocol(String paramString) {
        int j;
        String str = "";
        int i = paramString.indexOf(58);
        if (i >= 0 && (j = paramString.indexOf(58, i + 1)) >= 0) {
            str = paramString.substring(i + 1, j);
        }
        return str;
    }

    public static String getSubName(String paramString) {
        int j;
        String str = "";
        int i = paramString.indexOf(58);
        if (i >= 0 && (j = paramString.indexOf(58, i + 1)) >= 0) {
            str = paramString.substring(j + 1);
        }
        return str;
    }

    private boolean trusted() {
        SecurityManager localSecurityManager;
        boolean bool = false;
        if (this.tracer.isTracing()) {
            this.tracer.trace("JDBC to ODBC Bridge: Checking security");
        }
        if ((localSecurityManager = System.getSecurityManager()) != null) {
            try {
                String str = System.getProperty("browser");
                if (str != null && str.equalsIgnoreCase("Netscape Navigator")) {
                    nativePrefix = "Netscape_";
                    return true;
                }
            }
            catch (Exception localException) {
                // empty catch block
            }
            try {
                localSecurityManager.checkWrite("JdbcOdbcSecurityCheck");
                bool = true;
            }
            catch (SecurityException localSecurityException) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("Security check failed: " + localSecurityException.getMessage());
                }
                bool = false;
            }
        } else {
            if (this.tracer.isTracing()) {
                this.tracer.trace("No SecurityManager present, assuming trusted application/applet");
            }
            bool = true;
        }
        bool = true;
        return bool;
    }

    public String getConnectionAttributes(String paramString1, String paramString2) throws SQLException {
        String str2;
        String str1 = "DSN=" + paramString1 + paramString2;
        if (hDbc == 0L) {
            hDbc = this.allocConnection(hEnv);
        }
        if ((str2 = OdbcApi.SQLBrowseConnect(hDbc, str1)) == null) {
            str2 = "";
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        return str2;
    }

    public Hashtable getAttributeProperties(String paramString) {
        int i = 0;
        int j = 0;
        int i1 = 0;
        Hashtable<Integer, DriverPropertyInfo> localHashtable = new Hashtable<Integer, DriverPropertyInfo>();
        int i2 = paramString.length();
        while (i < i2) {
            boolean bool = true;
            String str2 = null;
            String str3 = null;
            String[] arrayOfString = null;
            String str4 = null;
            j = paramString.indexOf(";", i);
            if (j < 0) {
                j = i2;
            }
            String str1 = paramString.substring(i, j);
            int k = 0;
            int m = str1.indexOf(":", 0);
            int n = str1.indexOf("=", 0);
            if (str1.startsWith("*")) {
                bool = false;
                ++k;
            }
            if (m > 0) {
                str2 = str1.substring(k, m);
            }
            if (m > 0 && n > 0) {
                str3 = str1.substring(m + 1, n);
            }
            if (n > 0 && (str4 = str1.substring(n + 1)).equals("?")) {
                str4 = null;
            }
            if (str4 != null && str4.startsWith("{")) {
                arrayOfString = JdbcOdbcDriver.listToArray(str4);
                str4 = null;
            }
            DriverPropertyInfo localDriverPropertyInfo = new DriverPropertyInfo(str2, str4);
            localDriverPropertyInfo.description = str3;
            localDriverPropertyInfo.required = bool;
            localDriverPropertyInfo.choices = arrayOfString;
            localHashtable.put(new Integer(i1), localDriverPropertyInfo);
            ++i1;
            i = j + 1;
        }
        return localHashtable;
    }

    protected static String makeConnectionString(Properties paramProperties) {
        String str1 = "";
        Enumeration<?> localEnumeration = paramProperties.propertyNames();
        JdbcOdbcDriver.OdbcApi.charSet = paramProperties.getProperty("charSet", System.getProperty("file.encoding"));
        while (localEnumeration.hasMoreElements()) {
            String str2 = (String)localEnumeration.nextElement();
            String str3 = paramProperties.getProperty(str2);
            if (str2.equalsIgnoreCase("user")) {
                str2 = "UID";
            }
            if (str2.equalsIgnoreCase("password")) {
                str2 = "PWD";
            }
            if (str3 == null) continue;
            str1 = str1 + ";" + str2 + "=" + str3;
        }
        return str1;
    }

    protected static String[] listToArray(String paramString) {
        String str;
        String[] arrayOfString = null;
        Hashtable<Integer, String> localHashtable = new Hashtable<Integer, String>();
        int i = 0;
        int j = 1;
        int k = 1;
        int m = paramString.length();
        if (!paramString.startsWith("{")) {
            return null;
        }
        if (!paramString.endsWith("}")) {
            return null;
        }
        while (j < m) {
            k = paramString.indexOf(",", j);
            if (k < 0) {
                k = m - 1;
            }
            str = paramString.substring(j, k);
            localHashtable.put(new Integer(i), str);
            ++i;
            j = k + 1;
        }
        arrayOfString = new String[i];
        for (j = 0; j < i; ++j) {
            arrayOfString[j] = str = (String)localHashtable.get(new Integer(j));
        }
        return arrayOfString;
    }

    @Override
    public long allocConnection(long paramLong) throws SQLException {
        long l = 0L;
        l = OdbcApi.SQLAllocConnect(paramLong);
        connectionList.put(new Long(l), new Long(paramLong));
        return l;
    }

    @Override
    public void closeConnection(long paramLong) throws SQLException {
        OdbcApi.SQLFreeConnect(paramLong);
        Long localLong = (Long)connectionList.remove(new Long(paramLong));
        if (connectionList.size() == 0 && hEnv != 0L) {
            OdbcApi.SQLFreeEnv(hEnv);
            hEnv = 0L;
        }
    }

    @Override
    public void disconnect(long paramLong) throws SQLException {
        OdbcApi.SQLDisconnect(paramLong);
    }

    static {
        block3: {
            JdbcOdbcTracer localJdbcOdbcTracer = new JdbcOdbcTracer();
            if (localJdbcOdbcTracer.isTracing()) {
                localJdbcOdbcTracer.trace("JdbcOdbcDriver class loaded");
            }
            JdbcOdbcDriver localJdbcOdbcDriver = new JdbcOdbcDriver();
            try {
                DriverManager.registerDriver(localJdbcOdbcDriver);
            }
            catch (SQLException localSQLException) {
                if (!localJdbcOdbcTracer.isTracing()) break block3;
                localJdbcOdbcTracer.trace("Unable to register driver");
            }
        }
    }
}

