/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcBoundCol;
import sun.jdbc.odbc.JdbcOdbcInputStream;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSetInterface;
import sun.jdbc.odbc.JdbcOdbcResultSetMetaData;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcStatement;
import sun.jdbc.odbc.JdbcOdbcUtils;
import sun.jdbc.odbc.OdbcDef;

public class JdbcOdbcResultSet
extends JdbcOdbcObject
implements JdbcOdbcResultSetInterface {
    protected JdbcOdbc OdbcApi = null;
    protected long hDbc = 0L;
    protected long hStmt = 0L;
    protected SQLWarning lastWarning = null;
    protected boolean keepHSTMT = false;
    protected JdbcOdbcBoundCol[] boundCols;
    protected int numberOfCols;
    protected int numResultCols = -1;
    protected int firstPseudoCol;
    protected int lastPseudoCol;
    protected JdbcOdbcPseudoCol[] pseudoCols;
    protected int[] colMappings;
    protected ResultSetMetaData rsmd;
    private Hashtable colNameToNum;
    private Hashtable colNumToName;
    private boolean lastColumnNull = false;
    private boolean closed;
    private int sqlTypeColumn;
    private boolean freed;
    private JdbcOdbcUtils utils = new JdbcOdbcUtils();
    private boolean ownInsertsAreVisible;
    private boolean ownDeletesAreVisible;
    protected JdbcOdbcStatement ownerStatement;
    protected int numberOfRows;
    protected int rowPosition;
    protected int lastRowPosition;
    protected int[] rowStatusArray;
    protected boolean atInsertRow;
    protected int lastForwardRecord;
    protected int lastColumnData;
    protected int rowSet;
    protected boolean blockCursor;
    protected int fetchCount;
    protected int currentBlockCell;
    protected int lastBlockPosition;
    protected boolean moveUpBlock;
    protected boolean moveDownBlock;
    protected short odbcCursorType;
    protected boolean rowUpdated;
    protected long[] pA;

    protected void finalize() {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("ResultSet.finalize " + this);
        }
        try {
            if (!this.closed) {
                this.hStmt = 0L;
                this.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void initialize(JdbcOdbc paramJdbcOdbc, long paramLong1, long paramLong2, boolean paramBoolean, JdbcOdbcStatement paramJdbcOdbcStatement) throws SQLException {
        int i;
        this.OdbcApi = paramJdbcOdbc;
        this.hDbc = paramLong1;
        this.hStmt = paramLong2;
        this.keepHSTMT = paramBoolean;
        this.numberOfCols = this.getColumnCount();
        this.boundCols = new JdbcOdbcBoundCol[this.numberOfCols];
        for (i = 0; i < this.numberOfCols; ++i) {
            this.boundCols[i] = new JdbcOdbcBoundCol();
        }
        this.ownerStatement = paramJdbcOdbcStatement;
        this.rowPosition = 0;
        this.lastForwardRecord = 0;
        this.lastRowPosition = 0;
        this.lastColumnData = 0;
        this.currentBlockCell = 0;
        this.blockCursor = false;
        this.rowSet = 1;
        if (this.getType() != 1003) {
            if (this.ownerStatement != null) {
                this.rowSet = this.ownerStatement.getBlockCursorSize();
            }
            this.setRowStatusPtr();
            this.setResultSetVisibilityIndicators();
            this.calculateRowCount();
            if (this.numberOfRows >= 0) {
                i = 0;
                boolean bool = this.setRowArraySize();
                if (!bool) {
                    this.rowSet = 1;
                }
                if (this.pA != null && this.pA[0] != 0L) {
                    JdbcOdbc.ReleaseStoredIntegers(this.pA[0], this.pA[1]);
                    this.pA[0] = 0L;
                    this.pA[1] = 0L;
                }
                this.setRowStatusPtr();
                if (this.rowSet > 1) {
                    this.blockCursor = true;
                    this.setCursorType();
                }
                for (int j = 0; j < this.numberOfCols; ++j) {
                    this.boundCols[j].initStagingArea(this.rowSet);
                }
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastColumnNull;
    }

    public void setAliasColumnName(String paramString, int paramInt) {
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            this.boundCols[paramInt - 1].setAliasName(paramString);
        }
    }

    @Override
    public String mapColumnName(String paramString, int paramInt) {
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            return this.boundCols[paramInt - 1].mapAliasName(paramString);
        }
        return paramString;
    }

    @Override
    public String getString(int paramInt) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int i = this.getMaxCharLen(paramInt);
        int j = this.getColumnLength(paramInt);
        String str1 = null;
        if (j > Short.MAX_VALUE) {
            JdbcOdbcInputStream localJdbcOdbcInputStream = (JdbcOdbcInputStream)this.getAsciiStream(paramInt);
            try {
                byte[] arrayOfByte = localJdbcOdbcInputStream.readAllData();
                if (arrayOfByte != null) {
                    if (arrayOfByte.length > 2 && arrayOfByte[1] == 0) {
                        str1 = this.BytesToChars("UnicodeLittleUnmarked", arrayOfByte);
                    }
                    if (arrayOfByte.length >= 2 && arrayOfByte[0] == 0) {
                        str1 = this.BytesToChars("UnicodeBigUnmarked", arrayOfByte);
                    }
                    str1 = this.BytesToChars(this.OdbcApi.charSet, arrayOfByte);
                }
                this.lastColumnNull = true;
            }
            catch (Exception localException) {
                SQLException localSQLException = new SQLException(localException.getMessage());
                localSQLException.fillInStackTrace();
                throw localSQLException;
            }
        } else {
            if (i == -1) {
                this.lastColumnNull = true;
                return null;
            }
            boolean bool = true;
            int k = this.getColumnType(paramInt);
            switch (k) {
                case -1: 
                case 1: 
                case 12: {
                    bool = false;
                }
            }
            str1 = this.getDataString(paramInt, ++i, bool);
            if (str1 == null) {
                this.lastColumnNull = true;
                return str1;
            }
            int m = str1.length();
            if (m == i - 1 && !bool) {
                str1 = str1.substring(0, i - 1);
            }
            if ((k == -1 || k == -4) && m == i - 1) {
                String str2 = str1;
                while (str2.length() == Short.MAX_VALUE && (str2 = this.getDataString(paramInt, i, bool)) != null) {
                    if (this.OdbcApi.getTracer().isTracing()) {
                        this.OdbcApi.getTracer().trace("" + str2.length() + " byte(s) read");
                    }
                    if (str2.length() == i) {
                        str2 = str2.substring(0, i - 1);
                    }
                    str1 = str1 + str2;
                    if (!this.OdbcApi.getTracer().isTracing()) continue;
                    this.OdbcApi.getTracer().trace("" + str1.length() + " bytes total");
                }
            }
        }
        return str1;
    }

    @Override
    public String getString(String paramString) throws SQLException {
        return this.getString(this.findColumn(paramString));
    }

    @Override
    public boolean getBoolean(int paramInt) throws SQLException {
        this.checkOpen();
        boolean bool = false;
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) == null) {
            bool = this.getInt(paramInt) != 0;
        } else {
            this.lastColumnNull = true;
        }
        return bool;
    }

    @Override
    public boolean getBoolean(String paramString) throws SQLException {
        return this.getBoolean(this.findColumn(paramString));
    }

    @Override
    public byte getByte(int paramInt) throws SQLException {
        this.checkOpen();
        byte b = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) == null) {
            b = (byte)this.getInt(paramInt);
        } else {
            this.lastColumnNull = true;
        }
        return b;
    }

    @Override
    public byte getByte(String paramString) throws SQLException {
        return this.getByte(this.findColumn(paramString));
    }

    @Override
    public short getShort(int paramInt) throws SQLException {
        this.checkOpen();
        short s = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) == null) {
            s = (short)this.getInt(paramInt);
        } else {
            this.lastColumnNull = true;
        }
        return s;
    }

    @Override
    public short getShort(String paramString) throws SQLException {
        return this.getShort(this.findColumn(paramString));
    }

    @Override
    public int getInt(int paramInt) throws SQLException {
        this.checkOpen();
        int i = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) == null) {
            Integer localInteger = this.getDataInteger(paramInt);
            if (localInteger != null) {
                i = localInteger;
            }
        } else {
            this.lastColumnNull = true;
        }
        return i;
    }

    @Override
    public int getInt(String paramString) throws SQLException {
        return this.getInt(this.findColumn(paramString));
    }

    @Override
    public long getLong(int paramInt) throws SQLException {
        this.checkOpen();
        long l = 0L;
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) == null) {
            Double localDouble = this.getDataDouble(paramInt);
            if (localDouble != null) {
                l = localDouble.longValue();
            }
        } else {
            this.lastColumnNull = true;
        }
        return l;
    }

    @Override
    public long getLong(String paramString) throws SQLException {
        return this.getLong(this.findColumn(paramString));
    }

    @Override
    public float getFloat(int paramInt) throws SQLException {
        return (float)this.getDouble(paramInt);
    }

    @Override
    public float getFloat(String paramString) throws SQLException {
        return this.getFloat(this.findColumn(paramString));
    }

    @Override
    public double getDouble(int paramInt) throws SQLException {
        this.checkOpen();
        double d = 0.0;
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) == null) {
            Double localDouble = this.getDataDouble(paramInt);
            if (localDouble != null) {
                d = localDouble;
            }
        } else {
            this.lastColumnNull = true;
        }
        return d;
    }

    @Override
    public double getDouble(String paramString) throws SQLException {
        return this.getDouble(this.findColumn(paramString));
    }

    @Override
    public BigDecimal getBigDecimal(int paramInt1, int paramInt2) throws SQLException {
        this.checkOpen();
        BigDecimal localBigDecimal = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt1 = this.mapColumn(paramInt1);
        this.consecutiveFetch(paramInt1);
        if (this.getPseudoCol(paramInt1) == null) {
            String str = this.getDataString(paramInt1, 300, true);
            if (str != null) {
                localBigDecimal = new BigDecimal(str);
                localBigDecimal = localBigDecimal.setScale(paramInt2, 6);
            }
        } else {
            this.lastColumnNull = true;
        }
        return localBigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String paramString, int paramInt) throws SQLException {
        return this.getBigDecimal(this.findColumn(paramString), paramInt);
    }

    @Override
    public synchronized byte[] getBytes(int paramInt) throws SQLException {
        int m;
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int i = this.getMaxBinaryLen(paramInt);
        if (i == -1) {
            this.lastColumnNull = true;
            return null;
        }
        int j = this.getColumnLength(paramInt);
        if (j > Short.MAX_VALUE) {
            JdbcOdbcInputStream localJdbcOdbcInputStream = (JdbcOdbcInputStream)this.getBinaryStream(paramInt);
            try {
                return localJdbcOdbcInputStream.readAllData();
            }
            catch (Exception localException) {
                throw new SQLException(localException.getMessage());
            }
        }
        int k = this.getColumnType(paramInt);
        byte[] arrayOfByte1 = new byte[i];
        try {
            m = this.OdbcApi.SQLGetDataBinary(this.hStmt, paramInt, arrayOfByte1);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            Integer localInteger = (Integer)localJdbcOdbcSQLWarning.value;
            m = localInteger;
        }
        if (m == -1) {
            this.lastColumnNull = true;
            arrayOfByte1 = null;
        }
        if (k != -2 && m != i && arrayOfByte1 != null) {
            byte[] arrayOfByte2 = new byte[m];
            System.arraycopy(arrayOfByte1, 0, arrayOfByte2, 0, m);
            return arrayOfByte2;
        }
        return arrayOfByte1;
    }

    @Override
    public byte[] getBytes(String paramString) throws SQLException {
        return this.getBytes(this.findColumn(paramString));
    }

    @Override
    public Date getDate(int paramInt) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String str = this.getDataStringDate(paramInt);
        if (str == null) {
            return null;
        }
        return Date.valueOf(str);
    }

    @Override
    public Date getDate(String paramString) throws SQLException {
        return this.getDate(this.findColumn(paramString));
    }

    @Override
    public Time getTime(int paramInt) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String str = this.getDataStringTime(paramInt);
        if (str == null) {
            return null;
        }
        return Time.valueOf(str);
    }

    @Override
    public Time getTime(String paramString) throws SQLException {
        return this.getTime(this.findColumn(paramString));
    }

    @Override
    public Timestamp getTimestamp(int paramInt) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) != null) {
            this.lastColumnNull = true;
            return null;
        }
        String str = this.getDataStringTimestamp(paramInt);
        if (str == null) {
            return null;
        }
        if (str.length() == 10) {
            str = str + " 00:00:00";
        }
        return Timestamp.valueOf(str);
    }

    @Override
    public Timestamp getTimestamp(String paramString) throws SQLException {
        return this.getTimestamp(this.findColumn(paramString));
    }

    @Override
    public InputStream getAsciiStream(int paramInt) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        int i = this.getColumnType(paramInt);
        int j = -2;
        switch (i) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                j = 1;
            }
        }
        JdbcOdbcInputStream localJdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, paramInt, 1, j, this.ownerStatement);
        this.setInputStream(paramInt, localJdbcOdbcInputStream);
        return localJdbcOdbcInputStream;
    }

    @Override
    public InputStream getAsciiStream(String paramString) throws SQLException {
        return this.getAsciiStream(this.findColumn(paramString));
    }

    @Override
    public InputStream getUnicodeStream(int paramInt) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        int i = this.getColumnType(paramInt);
        int j = -2;
        switch (i) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                j = 1;
            }
        }
        JdbcOdbcInputStream localJdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, paramInt, 2, j, this.ownerStatement);
        this.setInputStream(paramInt, localJdbcOdbcInputStream);
        return localJdbcOdbcInputStream;
    }

    @Override
    public InputStream getUnicodeStream(String paramString) throws SQLException {
        return this.getUnicodeStream(this.findColumn(paramString));
    }

    @Override
    public InputStream getBinaryStream(int paramInt) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        int i = this.getColumnType(paramInt);
        int j = -2;
        switch (i) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                j = 1;
            }
        }
        JdbcOdbcInputStream localJdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, paramInt, 3, j, this.ownerStatement);
        this.setInputStream(paramInt, localJdbcOdbcInputStream);
        return localJdbcOdbcInputStream;
    }

    @Override
    public InputStream getBinaryStream(String paramString) throws SQLException {
        return this.getBinaryStream(this.findColumn(paramString));
    }

    @Override
    public boolean next() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            boolean bool = false;
            boolean i = false;
            if (this.getFetchDirection() == 1000) {
                if (this.rowPosition == this.numberOfRows) {
                    this.afterLast();
                    return false;
                }
                if (this.blockCursor) {
                    bool = this.relative(1, false);
                } else {
                    ++this.rowPosition;
                    bool = this.fetchScrollOption(this.rowPosition, (short)5);
                }
            } else {
                if (this.rowPosition == 1) {
                    this.beforeFirst();
                    return false;
                }
                if (this.blockCursor) {
                    bool = this.relative(-1, false);
                } else {
                    --this.rowPosition;
                    bool = this.fetchScrollOption(this.rowPosition, (short)5);
                }
            }
            return bool;
        }
        boolean bool = true;
        this.lastColumnNull = false;
        this.closeInputStreams();
        this.clearWarnings();
        try {
            bool = this.OdbcApi.SQLFetch(this.hStmt);
        }
        catch (SQLWarning localSQLWarning) {
            this.setWarning(localSQLWarning);
        }
        if (bool) {
            ++this.rowPosition;
        } else if (!bool) {
            if (this.lastForwardRecord == 0) {
                this.lastForwardRecord = this.rowPosition;
                this.rowPosition = 0;
            } else {
                this.rowPosition = 0;
            }
        }
        return bool;
    }

    public int getRowNumber() throws SQLException {
        this.checkOpen();
        int i = 0;
        this.clearWarnings();
        try {
            i = (int)this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)14);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            BigDecimal localBigDecimal = (BigDecimal)localJdbcOdbcSQLWarning.value;
            i = localBigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        return i;
    }

    @Override
    public int getColumnCount() throws SQLException {
        this.checkOpen();
        int i = 0;
        this.clearWarnings();
        if (this.lastPseudoCol > 0) {
            return this.lastPseudoCol;
        }
        if (this.colMappings != null) {
            return this.colMappings.length;
        }
        try {
            i = this.numResultCols = this.OdbcApi.SQLNumResultCols(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            BigDecimal localBigDecimal = (BigDecimal)localJdbcOdbcSQLWarning.value;
            i = localBigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        return i;
    }

    public int getRowCount() throws SQLException {
        this.checkOpen();
        return this.numberOfRows;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSet.close");
        }
        this.closeInputStreams();
        this.clearWarnings();
        this.lastColumnNull = false;
        if (this.OdbcApi != null && this.hStmt != 0L) {
            if (!this.keepHSTMT) {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                this.hStmt = 0L;
            }
            this.closed = true;
            this.FreeCols();
            if (this.pA != null && this.pA[0] != 0L) {
                JdbcOdbc.ReleaseStoredIntegers(this.pA[0], this.pA[1]);
                this.pA[0] = 0L;
                this.pA[1] = 0L;
            }
            if (this.ownerStatement != null) {
                this.ownerStatement.myResultSet = null;
            }
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("*ResultSet has been closed");
            }
        }
    }

    public synchronized void FreeCols() throws NullPointerException {
        try {
            for (int i = 0; i < this.boundCols.length; ++i) {
                if (this.boundCols[i].pA1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundCols[i].pA1, this.boundCols[i].pA2);
                    this.boundCols[i].pA1 = 0L;
                    this.boundCols[i].pA2 = 0L;
                }
                if (this.boundCols[i].pB1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundCols[i].pB1, this.boundCols[i].pB2);
                    this.boundCols[i].pB1 = 0L;
                    this.boundCols[i].pB2 = 0L;
                }
                if (this.boundCols[i].pC1 != 0L) {
                    JdbcOdbc.ReleaseStoredBytes(this.boundCols[i].pC1, this.boundCols[i].pC2);
                    this.boundCols[i].pC1 = 0L;
                    this.boundCols[i].pC2 = 0L;
                }
                if (this.boundCols[i].pS1 == 0L) continue;
                JdbcOdbc.ReleaseStoredChars(this.boundCols[i].pS1, this.boundCols[i].pS2);
                this.boundCols[i].pS1 = 0L;
                this.boundCols[i].pS2 = 0L;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkOpen();
        String str = "";
        this.clearWarnings();
        try {
            str = this.OdbcApi.SQLGetCursorName(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            str = (String)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        return str.trim();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSet.getMetaData");
        }
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
        return new JdbcOdbcResultSetMetaData(this.OdbcApi, this);
    }

    @Override
    public Object getObject(int paramInt) throws SQLException {
        this.checkOpen();
        Object localObject = null;
        int i = this.getColumnType(paramInt);
        int j = paramInt;
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) != null) {
            this.lastColumnNull = true;
            return null;
        }
        switch (i) {
            case -1: 
            case 1: 
            case 12: {
                localObject = this.getString(paramInt);
                break;
            }
            case 2: 
            case 3: {
                localObject = this.getBigDecimal(paramInt, this.getScale(j));
                break;
            }
            case -7: {
                localObject = new Boolean(this.getBoolean(paramInt));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                localObject = new Integer(this.getInt(paramInt));
                break;
            }
            case -5: {
                localObject = new Long(this.getLong(paramInt));
                break;
            }
            case 7: {
                localObject = new Float(this.getFloat(paramInt));
                break;
            }
            case 6: 
            case 8: {
                localObject = new Double(this.getDouble(paramInt));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                localObject = this.getBytes(paramInt);
                break;
            }
            case 91: {
                localObject = this.getDate(paramInt);
                break;
            }
            case 92: {
                localObject = this.getTime(paramInt);
                break;
            }
            case 93: {
                localObject = this.getTimestamp(paramInt);
            }
        }
        if (this.wasNull()) {
            localObject = null;
        }
        return localObject;
    }

    @Override
    public Object getObject(String paramString) throws SQLException {
        return this.getObject(this.findColumn(paramString));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.lastWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.lastWarning = null;
    }

    @Override
    public void setWarning(SQLWarning paramSQLWarning) throws SQLException {
        this.checkOpen();
        this.lastWarning = paramSQLWarning;
    }

    @Override
    public long getHSTMT() {
        return this.hStmt;
    }

    @Override
    public synchronized int findColumn(String paramString) throws SQLException {
        Integer localInteger;
        if (this.rsmd == null) {
            this.rsmd = this.getMetaData();
            this.colNameToNum = new Hashtable();
            this.colNumToName = new Hashtable();
        }
        if ((localInteger = (Integer)this.colNameToNum.get(paramString)) == null) {
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                String str = (String)this.colNumToName.get(new Integer(i));
                if (str == null) {
                    str = this.rsmd.getColumnName(i);
                    this.colNameToNum.put(str, new Integer(i));
                    this.colNumToName.put(new Integer(i), str);
                }
                if (!str.equalsIgnoreCase(paramString)) continue;
                return i;
            }
            throw new SQLException("Column not found", "S0022");
        }
        return localInteger;
    }

    @Override
    public Reader getCharacterStream(int paramInt) throws SQLException {
        this.checkOpen();
        InputStreamReader localInputStreamReader = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        int i = this.getColumnType(paramInt);
        int j = -2;
        switch (i) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                j = 1;
            }
        }
        String str = this.OdbcApi.charSet;
        JdbcOdbcInputStream localJdbcOdbcInputStream = new JdbcOdbcInputStream(this.OdbcApi, this.hStmt, paramInt, 5, j, this.ownerStatement);
        this.setInputStream(paramInt, localJdbcOdbcInputStream);
        try {
            localInputStreamReader = new InputStreamReader((InputStream)localJdbcOdbcInputStream, str);
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            throw new SQLException("getCharacterStream() with Encoding ('encoding') :" + localUnsupportedEncodingException.getMessage());
        }
        return localInputStreamReader;
    }

    @Override
    public Reader getCharacterStream(String paramString) throws SQLException {
        int i = this.findColumn(paramString);
        return this.getCharacterStream(i);
    }

    @Override
    public BigDecimal getBigDecimal(int paramInt) throws SQLException {
        this.checkOpen();
        BigDecimal localBigDecimal = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        paramInt = this.mapColumn(paramInt);
        this.consecutiveFetch(paramInt);
        if (this.getPseudoCol(paramInt) == null) {
            String str = this.getDataString(paramInt, 300, true);
            if (str != null) {
                localBigDecimal = new BigDecimal(str);
            }
        } else {
            this.lastColumnNull = true;
        }
        return localBigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String paramString) throws SQLException {
        int i = this.findColumn(paramString);
        return this.getBigDecimal(i);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition == 0;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition > this.numberOfRows;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition == 1;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                return this.rowPosition == this.numberOfRows;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            boolean bool = false;
            bool = this.fetchScrollOption(0, (short)5);
            this.rowPosition = 0;
            this.currentBlockCell = 0;
            if (this.atInsertRow) {
                this.lastRowPosition = 0;
                this.lastBlockPosition = 0;
                this.atInsertRow = false;
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkOpen();
        boolean bool = false;
        if (this.getType() != 1003) {
            bool = this.fetchScrollOption(this.numberOfRows + 1, (short)5);
            this.rowPosition = this.numberOfRows + 1;
            this.currentBlockCell = this.rowSet + 1;
            if (this.atInsertRow) {
                this.lastRowPosition = 0;
                this.lastBlockPosition = 0;
                this.atInsertRow = false;
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                boolean bool1 = false;
                boolean bool2 = false;
                if (this.blockCursor && !(bool1 = this.blockFetch(1, (short)2))) {
                    bool2 = true;
                }
                if (!this.blockCursor || bool1) {
                    this.resetInsertRow();
                    this.lastColumnNull = false;
                    this.closeInputStreams();
                    this.clearWarnings();
                    bool2 = this.fetchScrollOption(this.rowPosition, (short)2);
                }
                if (bool2) {
                    this.currentBlockCell = this.rowPosition = 1;
                }
                return bool2;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public boolean last() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                this.moveToCurrentRow();
                boolean bool1 = false;
                boolean bool2 = false;
                if (this.blockCursor) {
                    bool1 = this.blockFetch(this.numberOfRows, (short)3);
                    if (!bool1) {
                        this.setPos(this.currentBlockCell, 0);
                        bool2 = true;
                    } else {
                        bool2 = true;
                    }
                }
                if (!this.blockCursor || bool1) {
                    this.resetInsertRow();
                    this.lastColumnNull = false;
                    this.closeInputStreams();
                    this.clearWarnings();
                    bool2 = bool1 ? this.fetchScrollOption(this.numberOfRows, (short)5) : this.fetchScrollOption(this.numberOfRows, (short)3);
                    if (bool2) {
                        this.rowPosition = this.numberOfRows;
                    }
                    this.currentBlockCell = 1;
                }
                return bool2;
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        if (this.getType() == 1003) {
            if (this.lastForwardRecord == 0) {
                return this.rowPosition;
            }
            return 0;
        }
        if (this.numberOfRows > 0) {
            if (this.rowPosition <= 0 || this.rowPosition > this.numberOfRows) {
                return 0;
            }
            return this.rowPosition;
        }
        return 0;
    }

    @Override
    public boolean absolute(int paramInt) throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.numberOfRows > 0) {
                boolean bool1 = false;
                boolean bool2 = false;
                if (paramInt != 0) {
                    if (this.blockCursor) {
                        if (this.atInsertRow) {
                            this.rowPosition = this.lastRowPosition;
                            this.currentBlockCell = this.lastBlockPosition;
                            this.atInsertRow = false;
                        }
                        if (bool2 = this.blockFetch(paramInt, (short)5)) {
                            this.currentBlockCell = 1;
                        } else {
                            this.setPos(this.currentBlockCell, 0);
                            bool1 = true;
                        }
                    }
                    if (!this.blockCursor || bool2) {
                        this.rowPosition = paramInt >= 0 ? paramInt : this.numberOfRows + 1 + paramInt;
                        if (this.rowPosition > this.numberOfRows) {
                            this.afterLast();
                            return false;
                        }
                        if (this.rowPosition < 1) {
                            this.beforeFirst();
                            return false;
                        }
                        this.lastColumnNull = false;
                        this.closeInputStreams();
                        this.clearWarnings();
                        bool1 = this.fetchScrollOption(paramInt, (short)5);
                    }
                    return bool1;
                }
                throw new SQLException("Cursor position (" + paramInt + ") is invalid");
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    protected boolean fetchScrollOption(int paramInt, short paramShort) throws SQLException {
        if (this.numberOfRows > 0) {
            try {
                this.OdbcApi.SQLFetchScroll(this.hStmt, paramShort, paramInt);
            }
            catch (SQLWarning localSQLWarning) {
                this.setWarning(localSQLWarning);
                return true;
            }
            catch (SQLException localSQLException) {
                return false;
            }
            return true;
        }
        return false;
    }

    protected void consecutiveFetch(int paramInt) throws SQLException {
        boolean i = false;
        if (this.blockCursor && this.rowUpdated) {
            i = true;
        }
        if (this.rowSet != 1) {
            if (this.lastColumnData == paramInt || i) {
                try {
                    this.OdbcApi.SQLFetchScroll(this.hStmt, (short)5, this.getRow());
                    this.lastColumnData = 0;
                    if (this.blockCursor) {
                        this.currentBlockCell = 1;
                    }
                }
                catch (SQLWarning localSQLWarning) {
                    this.setWarning(localSQLWarning);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.rowUpdated = false;
            } else {
                this.lastColumnData = paramInt;
            }
        }
    }

    @Override
    public boolean relative(int paramInt) throws SQLException {
        this.checkOpen();
        return this.relative(paramInt, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean relative(int paramInt, boolean paramBoolean) throws SQLException {
        int i;
        boolean bool2;
        boolean bool1;
        block13: {
            block12: {
                this.checkOpen();
                if (this.getType() == 1003) throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
                if (this.numberOfRows <= 0) throw new SQLException("Call to relative(" + paramInt + ") when there is no current row.");
                this.moveToCurrentRow();
                bool1 = false;
                bool2 = false;
                i = -1;
                if (paramBoolean) {
                    if (this.rowPosition == 0) {
                        throw new SQLException("Cursor is positioned before the ResultSet");
                    }
                    if (this.rowPosition > this.numberOfRows) {
                        throw new SQLException("Cursor is positioned after the ResultSet");
                    }
                }
                if (!this.blockCursor) break block12;
                bool2 = this.blockFetch(this.rowPosition + paramInt, (short)5);
                if (bool2) {
                    i = this.rowPosition;
                    i += paramInt;
                    break block13;
                } else if (paramInt == 0) {
                    i = paramInt;
                    bool2 = true;
                }
                break block13;
            }
            i = this.rowPosition;
            i += paramInt;
        }
        if (i <= 1 && paramInt < 0) {
            this.beforeFirst();
            if (paramBoolean) {
                return false;
            }
            if (i != 1) return false;
            return true;
        }
        if (i >= this.numberOfRows && paramInt > 0) {
            this.afterLast();
            if (paramBoolean) {
                return false;
            }
            if (i != this.numberOfRows) return false;
            return true;
        }
        this.lastColumnNull = false;
        this.closeInputStreams();
        this.clearWarnings();
        if (!this.blockCursor) {
            bool1 = this.fetchScrollOption(paramInt, (short)6);
            if (!bool1) return bool1;
            this.rowPosition = i;
            return bool1;
        }
        if (bool2) {
            bool1 = this.fetchScrollOption(i, (short)5);
            if (!bool1) return bool1;
            this.rowPosition = i;
            this.currentBlockCell = 1;
            return bool1;
        }
        this.setPos(this.currentBlockCell, 0);
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            int i = 0;
            if (this.numberOfRows > 0) {
                if (this.atInsertRow) {
                    i = this.lastRowPosition;
                }
                this.moveToCurrentRow();
                if (this.getFetchDirection() == 1000) {
                    if (i > 0) {
                        return this.absolute(i - 1);
                    }
                    if (this.rowPosition > 1) {
                        return this.absolute(this.rowPosition - 1);
                    }
                    if (this.rowPosition == 1) {
                        this.beforeFirst();
                        return false;
                    }
                    return !this.isBeforeFirst();
                }
                if (i > 0) {
                    return this.absolute(i + 1);
                }
                if (this.rowPosition < this.numberOfRows) {
                    return this.absolute(this.rowPosition + 1);
                }
                if (this.rowPosition == this.numberOfRows) {
                    this.afterLast();
                    return false;
                }
                return !this.isAfterLast();
            }
            return false;
        }
        throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
    }

    protected boolean blockFetch(int paramInt, short paramShort) throws SQLException {
        boolean bool = false;
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return true;
        }
        switch (paramShort) {
            case 2: {
                if (this.rowPosition == 1) break;
                if (!this.isRowWithinTheBlock(1)) {
                    bool = true;
                    break;
                }
                this.currentBlockCell = this.rowPosition = 1;
                break;
            }
            case 3: {
                if (this.rowPosition < this.numberOfRows) {
                    if (!this.isRowWithinTheBlock(this.numberOfRows)) {
                        bool = true;
                        break;
                    }
                    while (this.rowPosition != this.numberOfRows) {
                        ++this.rowPosition;
                        ++this.currentBlockCell;
                    }
                    bool = false;
                    break;
                }
                if (this.rowPosition != this.numberOfRows) break;
                bool = false;
                break;
            }
            case 5: {
                if (this.rowPosition == paramInt) break;
                if (paramInt < 0 || paramInt > this.numberOfRows) {
                    bool = true;
                    break;
                }
                if (!this.isRowWithinTheBlock(paramInt)) {
                    bool = true;
                    break;
                }
                while (this.rowPosition != paramInt) {
                    if (this.moveUpBlock) {
                        --this.rowPosition;
                        --this.currentBlockCell;
                        continue;
                    }
                    if (!this.moveDownBlock) continue;
                    ++this.rowPosition;
                    ++this.currentBlockCell;
                }
                bool = false;
                break;
            }
        }
        return bool;
    }

    protected boolean isRowWithinTheBlock(int paramInt) {
        boolean bool = false;
        if (this.rowPosition != 0) {
            int i = this.rowPosition - (this.currentBlockCell - 1);
            int j = this.rowPosition + (this.rowSet - this.currentBlockCell);
            if (j < paramInt || i > paramInt) {
                bool = false;
            } else if (paramInt > this.rowPosition) {
                bool = true;
                this.moveUpBlock = false;
                this.moveDownBlock = true;
            } else if (paramInt < this.rowPosition) {
                bool = true;
                this.moveUpBlock = true;
                this.moveDownBlock = false;
            }
        }
        return bool;
    }

    protected int getRowIndex() {
        int i = 0;
        if (this.blockCursor) {
            i = this.currentBlockCell - 1;
        } else if (this.atInsertRow) {
            i = this.rowSet;
        }
        return i;
    }

    @Override
    public void setFetchDirection(int paramInt) throws SQLException {
        this.checkOpen();
        this.ownerStatement.setFetchDirection(paramInt);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.ownerStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int paramInt) throws SQLException {
        this.checkOpen();
        this.ownerStatement.setFetchSize(paramInt);
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.ownerStatement.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        if (this.ownerStatement != null) {
            return this.ownerStatement.getResultSetType();
        }
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return this.ownerStatement.getResultSetConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkOpen();
        if (this.numberOfRows > 0) {
            int i = this.getRowIndex();
            if (this.blockCursor) {
                return this.rowStatusArray[i] == 2;
            }
            return this.rowStatusArray[this.rowSet - 1] == 2;
        }
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkOpen();
        if (this.numberOfRows > 0) {
            int i = this.getRowIndex();
            if (this.blockCursor) {
                return this.rowStatusArray[i] == 4;
            }
            return this.rowStatusArray[this.rowSet - 1] == 4;
        }
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkOpen();
        if (this.numberOfRows > 0) {
            int i = this.getRowIndex();
            if (this.blockCursor) {
                return this.rowStatusArray[i] == 1;
            }
            return this.rowStatusArray[this.rowSet - 1] == 1;
        }
        return false;
    }

    @Override
    public void updateNull(int paramInt) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            int j = this.getColumnType(paramInt);
            if (j != 9999) {
                this.boundCols[paramInt - 1].setRowValues(i, null, -1);
            } else {
                throw new SQLException("Unknown Data Type for column [#" + paramInt + "]");
            }
        }
    }

    @Override
    public void updateBoolean(int paramInt, boolean paramBoolean) throws SQLException {
        this.checkOpen();
        int i = 0;
        if (paramBoolean) {
            i = 1;
        }
        this.updateInt(paramInt, i);
    }

    @Override
    public void updateByte(int paramInt, byte paramByte) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            int j = this.getColumnType(paramInt);
            if (j != -6) {
                this.boundCols[paramInt - 1].setType(-6);
            }
            this.boundCols[paramInt - 1].setRowValues(i, new Integer(paramByte), 4);
        }
    }

    @Override
    public void updateShort(int paramInt, short paramShort) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            int j = this.getColumnType(paramInt);
            if (j != 5) {
                this.boundCols[paramInt - 1].setType(5);
            }
            this.boundCols[paramInt - 1].setRowValues(i, new Integer(paramShort), 4);
        }
    }

    @Override
    public void updateInt(int paramInt1, int paramInt2) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt1 > 0 && paramInt1 <= this.numberOfCols) {
            int j = this.getColumnType(paramInt1);
            if (j != 4) {
                this.boundCols[paramInt1 - 1].setType(4);
            }
            this.boundCols[paramInt1 - 1].setRowValues(i, new Integer(paramInt2), 4);
        }
    }

    @Override
    public void updateLong(int paramInt, long paramLong) throws SQLException {
        this.checkOpen();
        this.updateFloat(paramInt, (float)paramLong);
    }

    @Override
    public void updateFloat(int paramInt, float paramFloat) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            int j = this.getColumnType(paramInt);
            if (j != 6) {
                this.boundCols[paramInt - 1].setType(6);
            }
            this.boundCols[paramInt - 1].setRowValues(i, new Float(paramFloat), 4);
        }
    }

    @Override
    public void updateDouble(int paramInt, double paramDouble) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            int j = this.getColumnType(paramInt);
            if (j != 8) {
                this.boundCols[paramInt - 1].setType(8);
            }
            this.boundCols[paramInt - 1].setRowValues(i, new Double(paramDouble), 8);
        }
    }

    @Override
    public void updateBigDecimal(int paramInt, BigDecimal paramBigDecimal) throws SQLException {
        this.checkOpen();
        int i = this.getColumnType(paramInt);
        if (i == 3 || i == 2) {
            if (paramBigDecimal == null) {
                this.updateChar(paramInt, i, null);
            } else {
                this.updateChar(paramInt, i, paramBigDecimal.toString());
            }
        } else if (paramBigDecimal == null) {
            this.updateChar(paramInt, 2, null);
        } else {
            this.updateChar(paramInt, 2, paramBigDecimal.toString());
        }
    }

    @Override
    public void updateString(int paramInt, String paramString) throws SQLException {
        byte[] arrayOfByte;
        this.checkOpen();
        try {
            arrayOfByte = paramString == null ? null : paramString.getBytes(this.OdbcApi.charSet);
        }
        catch (UnsupportedEncodingException localUnsupportedEncodingException) {
            throw new SQLException(localUnsupportedEncodingException.getMessage());
        }
        this.updateBytes(paramInt, arrayOfByte);
    }

    @Override
    public void updateBytes(int paramInt, byte[] paramArrayOfByte) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramArrayOfByte != null && paramArrayOfByte.length > 8000) {
            this.updateBinaryStream(paramInt, (InputStream)new ByteArrayInputStream(paramArrayOfByte), paramArrayOfByte.length);
        }
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            int j = this.getColumnType(paramInt);
            if (j != -2 && j != -3) {
                this.boundCols[paramInt - 1].setType(-2);
                if (paramArrayOfByte != null) {
                    this.boundCols[paramInt - 1].setLength(paramArrayOfByte.length);
                }
            }
            if (paramArrayOfByte == null) {
                this.updateNull(paramInt);
                return;
            }
            if (paramArrayOfByte.length > this.boundCols[paramInt - 1].getLength()) {
                this.boundCols[paramInt - 1].setLength(paramArrayOfByte.length);
            }
            this.boundCols[paramInt - 1].setRowValues(i, paramArrayOfByte, paramArrayOfByte.length);
        }
    }

    @Override
    public void updateDate(int paramInt, Date paramDate) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            if (this.getColumnType(paramInt) != 91) {
                this.boundCols[paramInt - 1].setType(91);
            }
            if (paramDate == null) {
                this.updateNull(paramInt);
                return;
            }
            this.boundCols[paramInt - 1].setRowValues(i, paramDate, 6);
        }
    }

    @Override
    public void updateTime(int paramInt, Time paramTime) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            if (this.getColumnType(paramInt) != 92) {
                this.boundCols[paramInt - 1].setType(92);
            }
            if (paramTime == null) {
                this.updateNull(paramInt);
                return;
            }
            this.boundCols[paramInt - 1].setRowValues(i, paramTime, 6);
        }
    }

    @Override
    public void updateTimestamp(int paramInt, Timestamp paramTimestamp) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            if (this.getColumnType(paramInt) != 93) {
                this.boundCols[paramInt - 1].setType(93);
            }
            if (paramTimestamp == null) {
                this.updateNull(paramInt);
                return;
            }
            this.boundCols[paramInt - 1].setRowValues(i, paramTimestamp, 16);
        }
    }

    @Override
    public void updateAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt1 > 0 && paramInt1 <= this.numberOfCols) {
            if (this.getColumnType(paramInt1) != -1) {
                this.boundCols[paramInt1 - 1].setType(-1);
            }
            if (paramInputStream == null) {
                this.updateNull(paramInt1);
                return;
            }
            if (paramInt2 != this.boundCols[paramInt1 - 1].getLength()) {
                this.boundCols[paramInt1 - 1].setLength(paramInt2);
            }
            this.boundCols[paramInt1 - 1].setRowValues(i, paramInputStream, paramInt2);
            this.boundCols[paramInt1 - 1].setStreamType(1);
        }
    }

    @Override
    public void updateBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt1 > 0 && paramInt1 <= this.numberOfCols) {
            if (this.getColumnType(paramInt1) != -4) {
                this.boundCols[paramInt1 - 1].setType(-4);
            }
            if (paramInputStream == null) {
                this.updateNull(paramInt1);
                return;
            }
            if (paramInt2 != this.boundCols[paramInt1 - 1].getLength()) {
                this.boundCols[paramInt1 - 1].setLength(paramInt2);
            }
            this.boundCols[paramInt1 - 1].setRowValues(i, paramInputStream, paramInt2);
            this.boundCols[paramInt1 - 1].setStreamType(3);
        }
    }

    @Override
    public void updateCharacterStream(int paramInt1, Reader paramReader, int paramInt2) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        BufferedReader localBufferedReader = null;
        BufferedOutputStream localBufferedOutputStream = null;
        ByteArrayOutputStream localByteArrayOutputStream = null;
        ByteArrayInputStream localByteArrayInputStream = null;
        String str = this.OdbcApi.charSet;
        int j = 300;
        if (paramInt2 < j) {
            j = paramInt2;
        }
        int k = 0;
        int m = 0;
        try {
            m = (int)Charset.forName(str).newEncoder().maxBytesPerChar();
        }
        catch (UnsupportedCharsetException localUnsupportedCharsetException) {
        }
        catch (IllegalCharsetNameException localIllegalCharsetNameException) {
            // empty catch block
        }
        if (m == 0) {
            m = 1;
        }
        try {
            if (paramReader != null) {
                boolean n = false;
                int i1 = 0;
                localBufferedReader = new BufferedReader(paramReader);
                localByteArrayOutputStream = new ByteArrayOutputStream();
                localBufferedOutputStream = new BufferedOutputStream(localByteArrayOutputStream);
                char[] arrayOfChar1 = new char[j];
                while (i1 != -1) {
                    byte[] arrayOfByte = new byte[]{};
                    i1 = localBufferedReader.read(arrayOfChar1);
                    if (i1 == -1) continue;
                    char[] arrayOfChar2 = new char[i1];
                    for (int i2 = 0; i2 < i1; ++i2) {
                        arrayOfChar2[i2] = arrayOfChar1[i2];
                    }
                    arrayOfByte = this.CharsToBytes(str, arrayOfChar2);
                    int i3 = arrayOfByte.length - 1;
                    localBufferedOutputStream.write(arrayOfByte, 0, i3);
                    localBufferedOutputStream.flush();
                }
                k = localByteArrayOutputStream.size();
                localByteArrayInputStream = new ByteArrayInputStream(localByteArrayOutputStream.toByteArray());
            }
        }
        catch (IOException localIOException) {
            throw new SQLException("CharsToBytes Reader Conversion: " + localIOException.getMessage());
        }
        if (paramInt1 > 0 && paramInt1 <= this.numberOfCols) {
            if (this.getColumnType(paramInt1) != -1 || this.getColumnType(paramInt1) != 12) {
                this.boundCols[paramInt1 - 1].setType(-1);
            }
            if (paramReader == null) {
                this.updateNull(paramInt1);
                return;
            }
            if (k != this.boundCols[paramInt1 - 1].getLength()) {
                this.boundCols[paramInt1 - 1].setLength(k);
            }
            this.boundCols[paramInt1 - 1].setRowValues(i, localByteArrayInputStream, k);
            this.boundCols[paramInt1 - 1].setStreamType(3);
        }
    }

    @Override
    public void updateObject(int paramInt1, Object paramObject, int paramInt2) throws SQLException {
        this.updateObject(paramInt1, paramObject, paramInt2, this.boundCols[paramInt1 - 1].getType());
    }

    @Override
    public void updateObject(int paramInt, Object paramObject) throws SQLException {
        this.updateObject(paramInt, paramObject, 0, this.boundCols[paramInt - 1].getType());
    }

    protected void updateObject(int paramInt1, Object paramObject, int paramInt2, int paramInt3) throws SQLException {
        this.checkOpen();
        if (paramInt3 == 9999 && paramObject != null) {
            paramInt3 = JdbcOdbcStatement.getTypeFromObject(paramObject);
        } else if (paramObject == null) {
            paramInt3 = 0;
        }
        if (paramInt1 > 0 && paramInt1 <= this.numberOfCols) {
            switch (paramInt3) {
                case 1: 
                case 12: {
                    this.updateString(paramInt1, (String)paramObject);
                    break;
                }
                case -1: {
                    if (paramObject instanceof byte[] && (byte[])paramObject != null) {
                        byte[] arrayOfByte1 = (byte[])paramObject;
                        this.updateAsciiStream(paramInt1, (InputStream)new ByteArrayInputStream(arrayOfByte1), arrayOfByte1.length);
                        break;
                    }
                    if (paramObject instanceof Reader && (Reader)paramObject != null) {
                        throw new SQLException("Unknown length for Reader Object, try updateCharacterStream.");
                    }
                    if (!(paramObject instanceof String) || (String)paramObject == null) break;
                    this.updateString(paramInt1, (String)paramObject);
                    break;
                }
                case 2: 
                case 3: {
                    this.updateBigDecimal(paramInt1, (BigDecimal)paramObject);
                    break;
                }
                case -7: {
                    this.updateBoolean(paramInt1, (boolean)((Boolean)paramObject));
                    break;
                }
                case -6: {
                    this.updateByte(paramInt1, (byte)((Integer)paramObject).intValue());
                    break;
                }
                case 5: {
                    this.updateShort(paramInt1, (short)((Integer)paramObject).intValue());
                    break;
                }
                case 4: {
                    this.updateInt(paramInt1, (int)((Integer)paramObject));
                    break;
                }
                case -5: {
                    this.updateLong(paramInt1, ((Integer)paramObject).longValue());
                    break;
                }
                case 6: 
                case 7: {
                    this.updateFloat(paramInt1, ((Float)paramObject).floatValue());
                    break;
                }
                case 8: {
                    this.updateDouble(paramInt1, (double)((Double)paramObject));
                    break;
                }
                case -2: {
                    if (paramObject instanceof String) {
                        try {
                            this.updateBytes(paramInt1, ((String)paramObject).getBytes(this.OdbcApi.charSet));
                            break;
                        }
                        catch (UnsupportedEncodingException localUnsupportedEncodingException1) {
                            throw new SQLException(localUnsupportedEncodingException1.getMessage());
                        }
                    }
                    this.updateBytes(paramInt1, (byte[])paramObject);
                    break;
                }
                case -4: 
                case -3: {
                    byte[] arrayOfByte2 = null;
                    if (paramObject instanceof String) {
                        try {
                            arrayOfByte2 = ((String)paramObject).getBytes(this.OdbcApi.charSet);
                        }
                        catch (UnsupportedEncodingException localUnsupportedEncodingException2) {
                            throw new SQLException(localUnsupportedEncodingException2.getMessage());
                        }
                    } else {
                        arrayOfByte2 = (byte[])paramObject;
                    }
                    if (arrayOfByte2.length > 8000) {
                        this.updateBinaryStream(paramInt1, (InputStream)new ByteArrayInputStream(arrayOfByte2), arrayOfByte2.length);
                        break;
                    }
                    this.updateBytes(paramInt1, arrayOfByte2);
                    break;
                }
                case 91: {
                    this.updateDate(paramInt1, (Date)paramObject);
                    break;
                }
                case 92: {
                    this.updateTime(paramInt1, (Time)paramObject);
                    break;
                }
                case 93: {
                    this.updateTimestamp(paramInt1, (Timestamp)paramObject);
                    break;
                }
                case 0: {
                    this.updateNull(paramInt1);
                    break;
                }
                default: {
                    throw new SQLException("Unknown SQL Type for ResultSet.updateObject SQL Type = " + paramInt3);
                }
            }
        }
    }

    protected void updateChar(int paramInt1, int paramInt2, String paramString) throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (paramInt1 > 0 && paramInt1 <= this.numberOfCols) {
            int j = this.getColumnType(paramInt1);
            if (j != paramInt2) {
                this.boundCols[paramInt1 - 1].setType(paramInt2);
            }
            if (paramString == null) {
                this.updateNull(paramInt1);
            } else {
                this.boundCols[paramInt1 - 1].setRowValues(i, paramString, -3);
            }
        }
    }

    @Override
    public void updateNull(String paramString) throws SQLException {
        this.updateNull(this.findColumn(paramString));
    }

    @Override
    public void updateBoolean(String paramString, boolean paramBoolean) throws SQLException {
        this.updateBoolean(this.findColumn(paramString), paramBoolean);
    }

    @Override
    public void updateByte(String paramString, byte paramByte) throws SQLException {
        this.updateInt(this.findColumn(paramString), (int)paramByte);
    }

    @Override
    public void updateShort(String paramString, short paramShort) throws SQLException {
        this.updateInt(this.findColumn(paramString), (int)paramShort);
    }

    @Override
    public void updateInt(String paramString, int paramInt) throws SQLException {
        this.updateInt(this.findColumn(paramString), paramInt);
    }

    @Override
    public void updateLong(String paramString, long paramLong) throws SQLException {
        this.updateFloat(this.findColumn(paramString), (float)paramLong);
    }

    @Override
    public void updateFloat(String paramString, float paramFloat) throws SQLException {
        this.updateFloat(this.findColumn(paramString), paramFloat);
    }

    @Override
    public void updateDouble(String paramString, double paramDouble) throws SQLException {
        this.updateDouble(this.findColumn(paramString), paramDouble);
    }

    @Override
    public void updateBigDecimal(String paramString, BigDecimal paramBigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(paramString), paramBigDecimal);
    }

    @Override
    public void updateString(String paramString1, String paramString2) throws SQLException {
        this.updateString(this.findColumn(paramString1), paramString2);
    }

    @Override
    public void updateBytes(String paramString, byte[] paramArrayOfByte) throws SQLException {
        this.updateBytes(this.findColumn(paramString), paramArrayOfByte);
    }

    @Override
    public void updateDate(String paramString, Date paramDate) throws SQLException {
        this.updateDate(this.findColumn(paramString), paramDate);
    }

    @Override
    public void updateTime(String paramString, Time paramTime) throws SQLException {
        this.updateTime(this.findColumn(paramString), paramTime);
    }

    @Override
    public void updateTimestamp(String paramString, Timestamp paramTimestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(paramString), paramTimestamp);
    }

    @Override
    public void updateAsciiStream(String paramString, InputStream paramInputStream, int paramInt) throws SQLException {
        this.updateAsciiStream(this.findColumn(paramString), paramInputStream, paramInt);
    }

    @Override
    public void updateBinaryStream(String paramString, InputStream paramInputStream, int paramInt) throws SQLException {
        this.updateBinaryStream(this.findColumn(paramString), paramInputStream, paramInt);
    }

    @Override
    public void updateCharacterStream(String paramString, Reader paramReader, int paramInt) throws SQLException {
        this.updateCharacterStream(this.findColumn(paramString), paramReader, paramInt);
    }

    @Override
    public void updateObject(String paramString, Object paramObject, int paramInt) throws SQLException {
        this.updateObject(this.findColumn(paramString), paramObject, paramInt);
    }

    @Override
    public void updateObject(String paramString, Object paramObject) throws SQLException {
        this.updateObject(this.findColumn(paramString), paramObject);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkOpen();
        for (int i = 0; i < this.numberOfCols; ++i) {
            int j = this.boundCols[i].getType();
            this.bindCol(i + 1, j);
        }
        if (this.getType() != 1003) {
            if (this.blockCursor) {
                this.setPos(this.currentBlockCell, 4);
            } else {
                this.setPos(this.rowSet, 4);
            }
            this.FreeCols();
            if (this.ownInsertsAreVisible) {
                ++this.numberOfRows;
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
        this.resetColumnState();
        this.resetInsertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkOpen();
        for (int i = 0; i < this.numberOfCols; ++i) {
            int j = this.boundCols[i].getType();
            this.bindCol(i + 1, j);
        }
        if (this.getType() != 1003) {
            if (this.blockCursor) {
                this.setPos(this.currentBlockCell, 2);
            } else {
                this.setPos(this.rowSet, 2);
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
        this.FreeCols();
        this.resetColumnState();
        this.rowUpdated = true;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkOpen();
        if (this.blockCursor) {
            this.setPos(this.currentBlockCell, 3);
        } else {
            this.setPos(this.rowSet, 3);
        }
        if (this.ownDeletesAreVisible) {
            --this.numberOfRows;
        }
    }

    private void setResultSetVisibilityIndicators() throws SQLException {
        int i = this.OdbcApi.SQLGetStmtAttr(this.hStmt, 6);
        short s = 0;
        switch (i) {
            case 1: {
                s = 151;
                break;
            }
            case 2: {
                s = 145;
                break;
            }
            case 3: {
                s = 168;
            }
        }
        if (s > 0) {
            try {
                int j = this.OdbcApi.SQLGetInfo(this.hDbc, s);
                if ((j & 0x20) > 0) {
                    this.ownDeletesAreVisible = true;
                }
                if ((j & 0x10) > 0) {
                    this.ownInsertsAreVisible = true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkOpen();
        if (this.getType() != 1003) {
            if (this.atInsertRow || this.getRow() <= 0) {
                throw new SQLException("Cursor position is invalid");
            }
        } else {
            throw new SQLException("Result set type is TYPE_FORWARD_ONLY");
        }
        this.fetchScrollOption(0, (short)6);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkOpen();
        if (this.atInsertRow) {
            throw new SQLException("Cursor position on insert row");
        }
        this.resetColumnState();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("Invalid Cursor Type: " + this.getType());
        }
        this.checkOpen();
        this.atInsertRow = true;
        this.lastRowPosition = this.rowPosition;
        this.lastBlockPosition = this.currentBlockCell;
        if (this.blockCursor) {
            this.currentBlockCell = this.rowSet + 1;
        }
        this.resetInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkOpen();
        boolean bool = false;
        if (this.atInsertRow) {
            this.resetInsertRow();
            this.rowPosition = this.lastRowPosition;
            this.currentBlockCell = this.lastBlockPosition;
            bool = this.absolute(this.rowPosition);
            if (bool) {
                this.lastRowPosition = 0;
                this.lastBlockPosition = 0;
            }
            this.atInsertRow = false;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkOpen();
        if (this.ownerStatement != null) {
            return this.ownerStatement;
        }
        return null;
    }

    @Override
    public Object getObject(int paramInt, Map<String, Class<?>> paramMap) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String paramString, Map<String, Class<?>> paramMap) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String paramString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String paramString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(String paramString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String paramString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String paramString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int paramInt, Ref paramRef) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String paramString, Ref paramRef) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int paramInt, Blob paramBlob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String paramString, Blob paramBlob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int paramInt, Clob paramClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String paramString, Clob paramClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int paramInt, Array paramArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String paramString, Array paramArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int paramInt, Calendar paramCalendar) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        long l = 0L;
        paramInt = this.mapColumn(paramInt);
        if (this.getPseudoCol(paramInt) != null) {
            this.lastColumnNull = true;
            return null;
        }
        l = this.getDataLongDate(paramInt, paramCalendar);
        if (l == 0L) {
            return null;
        }
        return new Date(l);
    }

    @Override
    public Date getDate(String paramString, Calendar paramCalendar) throws SQLException {
        return this.getDate(this.findColumn(paramString), paramCalendar);
    }

    @Override
    public Time getTime(int paramInt, Calendar paramCalendar) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        long l = 0L;
        paramInt = this.mapColumn(paramInt);
        if (this.getPseudoCol(paramInt) != null) {
            this.lastColumnNull = true;
            return null;
        }
        l = this.getDataLongTime(paramInt, paramCalendar);
        if (l == 0L) {
            return null;
        }
        return new Time(l);
    }

    @Override
    public Time getTime(String paramString, Calendar paramCalendar) throws SQLException {
        return this.getTime(this.findColumn(paramString), paramCalendar);
    }

    @Override
    public Timestamp getTimestamp(int paramInt, Calendar paramCalendar) throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.lastColumnNull = false;
        long l = 0L;
        paramInt = this.mapColumn(paramInt);
        if (this.getPseudoCol(paramInt) != null) {
            this.lastColumnNull = true;
            return null;
        }
        l = this.getDataLongTimestamp(paramInt, paramCalendar);
        if (l == 0L) {
            return null;
        }
        return new Timestamp(l);
    }

    @Override
    public Timestamp getTimestamp(String paramString, Calendar paramCalendar) throws SQLException {
        return this.getTimestamp(this.findColumn(paramString), paramCalendar);
    }

    protected void setRowStatusPtr() throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        this.rowStatusArray = new int[this.rowSet + 1];
        this.pA = new long[2];
        this.pA[0] = 0L;
        this.pA[1] = 0L;
        this.OdbcApi.SQLSetStmtAttrPtr(this.hStmt, 25, this.rowStatusArray, 0, this.pA);
    }

    protected boolean setRowArraySize() {
        int i = 0;
        try {
            this.clearWarnings();
            if (this.rowSet > 1) {
                if (this.numberOfRows < this.rowSet) {
                    this.rowSet = this.numberOfRows;
                }
                this.OdbcApi.SQLSetStmtAttr(this.hStmt, 5, 0, 0);
                this.OdbcApi.SQLSetStmtAttr(this.hStmt, 27, this.rowSet, 0);
                i = this.OdbcApi.SQLGetStmtAttr(this.hStmt, 27);
                if (i > 1 && i < this.rowSet) {
                    this.rowSet = i;
                    return true;
                }
            }
        }
        catch (SQLException localSQLException) {
            return false;
        }
        return i == this.rowSet;
    }

    protected void resetInsertRow() throws SQLException {
        this.checkOpen();
        int i = this.getRowIndex();
        if (this.atInsertRow) {
            for (int j = 0; j < this.numberOfCols; ++j) {
                this.boundCols[j].resetColumnToIgnoreData();
            }
        }
    }

    protected void resetColumnState() throws SQLException {
        this.checkOpen();
        if (this.hStmt != 0L) {
            this.OdbcApi.SQLFreeStmt(this.hStmt, 2);
        }
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.boundCols[i].resetColumnToIgnoreData();
        }
    }

    protected void bindCol(int paramInt1, int paramInt2) throws SQLException {
        boolean i = false;
        int j = 0;
        Object localObject1 = null;
        Object[] arrayOfObject = this.boundCols[paramInt1 - 1].getRowValues();
        byte[] arrayOfByte = this.boundCols[paramInt1 - 1].getRowLengths();
        if (!this.blockCursor && this.atInsertRow) {
            j = 0;
        }
        if (this.blockCursor) {
            j = this.currentBlockCell - 1;
        }
        Object localObject2 = this.boundCols[paramInt1 - 1].getRowValue(j);
        int k = this.boundCols[paramInt1 - 1].getLength();
        if (k < 0) {
            k = this.getColumnLength(paramInt1);
        }
        try {
            switch (paramInt2) {
                case 1: 
                case 2: 
                case 3: 
                case 12: {
                    if ((paramInt2 == 2 || paramInt2 == 3) && localObject2 != null) {
                        Object localObject3 = localObject2;
                        String str = localObject3.toString();
                        k = str.length();
                        BigDecimal localBigDecimal = new BigDecimal(str);
                        int n = localBigDecimal.scale();
                        if (n <= 0) {
                            ++k;
                        }
                    }
                    this.bindStringCol(paramInt1, paramInt2, arrayOfObject, arrayOfByte, k);
                    break;
                }
                case -1: {
                    int m = JdbcOdbcStatement.getTypeFromObject(localObject2);
                    if (m == -4 || m == 0) {
                        this.bindAtExecCol(paramInt1, paramInt2, arrayOfByte);
                        break;
                    }
                    if (m != -2) break;
                    this.bindBinaryCol(paramInt1, arrayOfObject, arrayOfByte, k);
                    break;
                }
                case -7: 
                case -6: 
                case 4: 
                case 5: {
                    this.bindIntegerCol(paramInt1, arrayOfObject, arrayOfByte);
                    break;
                }
                case 8: {
                    this.bindDoubleCol(paramInt1, arrayOfObject, arrayOfByte);
                    break;
                }
                case -5: 
                case 6: 
                case 7: {
                    this.bindFloatCol(paramInt1, arrayOfObject, arrayOfByte);
                    break;
                }
                case 91: {
                    this.bindDateCol(paramInt1, arrayOfObject, arrayOfByte);
                    break;
                }
                case 92: {
                    this.bindTimeCol(paramInt1, arrayOfObject, arrayOfByte);
                    break;
                }
                case 93: {
                    this.bindTimestampCol(paramInt1, arrayOfObject, arrayOfByte);
                    break;
                }
                case -3: 
                case -2: {
                    this.bindBinaryCol(paramInt1, arrayOfObject, arrayOfByte, k);
                    break;
                }
                case -4: {
                    this.bindAtExecCol(paramInt1, paramInt2, arrayOfByte);
                }
            }
        }
        catch (SQLException localSQLException) {
            throw new SQLException("SQLBinCol (" + paramInt1 + ") SQLType = " + paramInt2 + ". " + localSQLException.getMessage());
        }
    }

    protected void bindStringCol(int paramInt1, int paramInt2, Object[] paramArrayOfObject, byte[] paramArrayOfByte, int paramInt3) throws SQLException {
        byte[] arrayOfByte = this.boundCols[paramInt1 - 1].allocBindDataBuffer((paramInt3 + 1) * paramArrayOfObject.length);
        long[] arrayOfLong = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColString(this.hStmt, paramInt1, paramInt2, paramArrayOfObject, paramInt3, paramArrayOfByte, arrayOfByte, arrayOfLong);
        this.boundCols[paramInt1 - 1].pA1 = arrayOfLong[0];
        this.boundCols[paramInt1 - 1].pA2 = arrayOfLong[1];
        this.boundCols[paramInt1 - 1].pC1 = arrayOfLong[2];
        this.boundCols[paramInt1 - 1].pC2 = arrayOfLong[3];
    }

    protected void bindIntegerCol(int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte) throws SQLException {
        byte[] arrayOfByte = this.boundCols[paramInt - 1].allocBindDataBuffer(4 * paramArrayOfObject.length);
        long[] arrayOfLong = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColInteger(this.hStmt, paramInt, paramArrayOfObject, paramArrayOfByte, arrayOfByte, arrayOfLong);
        this.boundCols[paramInt - 1].pA1 = arrayOfLong[0];
        this.boundCols[paramInt - 1].pA2 = arrayOfLong[1];
        this.boundCols[paramInt - 1].pC1 = arrayOfLong[2];
        this.boundCols[paramInt - 1].pC2 = arrayOfLong[3];
    }

    protected void bindFloatCol(int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte) throws SQLException {
        byte[] arrayOfByte = this.boundCols[paramInt - 1].allocBindDataBuffer(8 * paramArrayOfObject.length);
        long[] arrayOfLong = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColFloat(this.hStmt, paramInt, paramArrayOfObject, paramArrayOfByte, arrayOfByte, arrayOfLong);
        this.boundCols[paramInt - 1].pA1 = arrayOfLong[0];
        this.boundCols[paramInt - 1].pA2 = arrayOfLong[1];
        this.boundCols[paramInt - 1].pC1 = arrayOfLong[2];
        this.boundCols[paramInt - 1].pC2 = arrayOfLong[3];
    }

    protected void bindDoubleCol(int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte) throws SQLException {
        byte[] arrayOfByte = this.boundCols[paramInt - 1].allocBindDataBuffer(8 * paramArrayOfObject.length);
        long[] arrayOfLong = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColDouble(this.hStmt, paramInt, paramArrayOfObject, paramArrayOfByte, arrayOfByte, arrayOfLong);
        this.boundCols[paramInt - 1].pA1 = arrayOfLong[0];
        this.boundCols[paramInt - 1].pA2 = arrayOfLong[1];
        this.boundCols[paramInt - 1].pC1 = arrayOfLong[2];
        this.boundCols[paramInt - 1].pC2 = arrayOfLong[3];
    }

    protected void bindDateCol(int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte) throws SQLException {
        byte[] arrayOfByte = this.boundCols[paramInt - 1].allocBindDataBuffer(10 * paramArrayOfObject.length);
        long[] arrayOfLong = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColDate(this.hStmt, paramInt, paramArrayOfObject, paramArrayOfByte, arrayOfByte, arrayOfLong);
        this.boundCols[paramInt - 1].pA1 = arrayOfLong[0];
        this.boundCols[paramInt - 1].pA2 = arrayOfLong[1];
        this.boundCols[paramInt - 1].pC1 = arrayOfLong[2];
        this.boundCols[paramInt - 1].pC2 = arrayOfLong[3];
    }

    protected void bindTimeCol(int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte) throws SQLException {
        byte[] arrayOfByte = this.boundCols[paramInt - 1].allocBindDataBuffer(9 * paramArrayOfObject.length);
        long[] arrayOfLong = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColTime(this.hStmt, paramInt, paramArrayOfObject, paramArrayOfByte, arrayOfByte, arrayOfLong);
        this.boundCols[paramInt - 1].pA1 = arrayOfLong[0];
        this.boundCols[paramInt - 1].pA2 = arrayOfLong[1];
        this.boundCols[paramInt - 1].pC1 = arrayOfLong[2];
        this.boundCols[paramInt - 1].pC2 = arrayOfLong[3];
    }

    protected void bindTimestampCol(int paramInt, Object[] paramArrayOfObject, byte[] paramArrayOfByte) throws SQLException {
        byte[] arrayOfByte = this.boundCols[paramInt - 1].allocBindDataBuffer(30 * paramArrayOfObject.length);
        long[] arrayOfLong = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColTimestamp(this.hStmt, paramInt, paramArrayOfObject, paramArrayOfByte, arrayOfByte, arrayOfLong);
        this.boundCols[paramInt - 1].pA1 = arrayOfLong[0];
        this.boundCols[paramInt - 1].pA2 = arrayOfLong[1];
        this.boundCols[paramInt - 1].pC1 = arrayOfLong[2];
        this.boundCols[paramInt - 1].pC2 = arrayOfLong[3];
    }

    protected void bindBinaryCol(int paramInt1, Object[] paramArrayOfObject, byte[] paramArrayOfByte, int paramInt2) throws SQLException {
        byte[] arrayOfByte = this.boundCols[paramInt1 - 1].allocBindDataBuffer((paramInt2 + 1) * paramArrayOfObject.length);
        long[] arrayOfLong = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColBinary(this.hStmt, paramInt1, paramArrayOfObject, paramArrayOfByte, paramInt2, arrayOfByte, arrayOfLong);
        this.boundCols[paramInt1 - 1].pA1 = arrayOfLong[0];
        this.boundCols[paramInt1 - 1].pA2 = arrayOfLong[1];
        this.boundCols[paramInt1 - 1].pC1 = arrayOfLong[2];
        this.boundCols[paramInt1 - 1].pC2 = arrayOfLong[3];
    }

    protected void bindAtExecCol(int paramInt1, int paramInt2, byte[] paramArrayOfByte) throws SQLException {
        byte[] arrayOfByte = this.boundCols[paramInt1 - 1].allocBindDataBuffer(4);
        long[] arrayOfLong = new long[]{0L, 0L, 0L, 0L};
        this.OdbcApi.SQLBindColAtExec(this.hStmt, paramInt1, paramInt2, paramArrayOfByte, arrayOfByte, arrayOfLong);
        this.boundCols[paramInt1 - 1].pA1 = arrayOfLong[0];
        this.boundCols[paramInt1 - 1].pA2 = arrayOfLong[1];
        this.boundCols[paramInt1 - 1].pC1 = arrayOfLong[2];
        this.boundCols[paramInt1 - 1].pC2 = arrayOfLong[3];
    }

    protected void setPos(int paramInt1, int paramInt2) throws SQLException {
        SQLWarning localObject = null;
        boolean bool = false;
        try {
            this.clearWarnings();
            bool = this.OdbcApi.SQLSetPos(this.hStmt, paramInt1, paramInt2, 0);
            int i = 0;
            while (bool) {
                int j = this.getRowIndex();
                String str = this.OdbcApi.odbcDriverName;
                i = this.blockCursor && str.indexOf("(IV") == -1 ? this.OdbcApi.SQLParamDataInBlock(this.hStmt, j) : this.OdbcApi.SQLParamData(this.hStmt);
                if (i == -1) {
                    bool = false;
                    continue;
                }
                this.putColumnData(i);
            }
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            throw new SQLException(localSQLException.getMessage());
        }
    }

    protected void putColumnData(int paramInt) throws SQLException, JdbcOdbcSQLWarning {
        int i = 2000;
        byte[] arrayOfByte = new byte[i];
        boolean m = false;
        if (paramInt < 1 || paramInt > this.numberOfCols) {
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("Invalid index for putColumnData()");
            }
            return;
        }
        InputStream localInputStream = null;
        int n = this.getRowIndex();
        try {
            localInputStream = (InputStream)this.boundCols[paramInt - 1].getRowValue(n);
        }
        catch (Exception localException) {
            throw new SQLException("Invalid data for columnIndex(" + paramInt + "): " + localException.getMessage());
        }
        int i1 = this.boundCols[paramInt - 1].getLength();
        int i2 = this.boundCols[paramInt - 1].getStreamType();
        while (!m) {
            int j;
            try {
                if (this.OdbcApi.getTracer().isTracing()) {
                    this.OdbcApi.getTracer().trace("Reading from input stream");
                }
                j = localInputStream.read(arrayOfByte);
                if (this.OdbcApi.getTracer().isTracing()) {
                    this.OdbcApi.getTracer().trace("Bytes read: " + j);
                }
            }
            catch (IOException localIOException) {
                throw new SQLException(localIOException.getMessage());
            }
            if (j == -1) {
                if (i1 != 0) {
                    throw new SQLException("End of InputStream reached before satisfying length specified when InputStream was set");
                }
                m = true;
                break;
            }
            if (j > i1) {
                j = i1;
                m = true;
            }
            int k = j;
            try {
                this.OdbcApi.SQLPutData(this.hStmt, arrayOfByte, k);
            }
            catch (SQLWarning localSQLWarning) {
                this.setWarning(localSQLWarning);
            }
            catch (SQLException localSQLException) {
                // empty catch block
            }
            i1 -= j;
            if (this.OdbcApi.getTracer().isTracing()) {
                this.OdbcApi.getTracer().trace("" + i1 + " bytes remaining");
            }
            if (i1 != 0) continue;
            m = true;
        }
    }

    @Override
    public int getColAttribute(int paramInt1, int paramInt2) throws SQLException {
        int i = 0;
        this.clearWarnings();
        try {
            i = this.OdbcApi.SQLColAttributes(this.hStmt, paramInt1, paramInt2);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            BigDecimal localBigDecimal = (BigDecimal)localJdbcOdbcSQLWarning.value;
            i = localBigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        return i;
    }

    protected int getMaxCharLen(int paramInt) throws SQLException {
        int i = this.getColumnType(paramInt);
        int j = this.getColumnLength(paramInt);
        if (j != -1) {
            switch (i) {
                case -4: 
                case -3: 
                case -2: {
                    j *= 2;
                    break;
                }
                case 91: {
                    j = 10;
                    break;
                }
                case 92: {
                    j = 8;
                    break;
                }
                case 93: {
                    j = 29;
                    break;
                }
                case 2: 
                case 3: {
                    j += 2;
                    break;
                }
                case -7: {
                    j = 1;
                    break;
                }
                case -6: {
                    j = 4;
                    break;
                }
                case 5: {
                    j = 6;
                    break;
                }
                case 4: {
                    j = 11;
                    break;
                }
                case -5: {
                    j = 20;
                    break;
                }
                case 7: {
                    j = 13;
                    break;
                }
                case 6: 
                case 8: {
                    j = 22;
                }
            }
            if (j <= 0 || j > Short.MAX_VALUE) {
                j = Short.MAX_VALUE;
            }
        }
        return j;
    }

    protected int getMaxBinaryLen(int paramInt) throws SQLException {
        int i = this.getColumnLength(paramInt);
        if (i != -1 && (i <= 0 || i > Short.MAX_VALUE)) {
            i = Short.MAX_VALUE;
        }
        return i;
    }

    public Double getDataDouble(int paramInt) throws SQLException {
        Double localDouble;
        this.lastColumnNull = false;
        try {
            localDouble = this.OdbcApi.SQLGetDataDouble(this.hStmt, paramInt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            localDouble = (Double)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        if (localDouble == null) {
            this.lastColumnNull = true;
        }
        return localDouble;
    }

    public Float getDataFloat(int paramInt) throws SQLException {
        Float localFloat;
        this.lastColumnNull = false;
        try {
            localFloat = this.OdbcApi.SQLGetDataFloat(this.hStmt, paramInt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            localFloat = (Float)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        if (localFloat == null) {
            this.lastColumnNull = true;
        }
        return localFloat;
    }

    public Integer getDataInteger(int paramInt) throws SQLException {
        Integer localInteger;
        this.lastColumnNull = false;
        try {
            localInteger = this.OdbcApi.SQLGetDataInteger(this.hStmt, paramInt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            localInteger = (Integer)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        if (localInteger == null) {
            this.lastColumnNull = true;
        } else if (paramInt == this.sqlTypeColumn) {
            localInteger = new Integer(OdbcDef.odbcTypeToJdbc(localInteger));
        }
        return localInteger;
    }

    public Long getDataLong(int paramInt) throws SQLException {
        Long localLong = null;
        Double localDouble = this.getDataDouble(paramInt);
        if (localDouble != null) {
            localLong = new Long(localDouble.longValue());
        }
        return localLong;
    }

    public String getDataString(int paramInt1, int paramInt2, boolean paramBoolean) throws SQLException {
        String str;
        this.lastColumnNull = false;
        try {
            str = this.OdbcApi.SQLGetDataString(this.hStmt, paramInt1, paramInt2, paramBoolean);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            str = (String)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        if (str == null) {
            this.lastColumnNull = true;
        } else if (paramInt1 == this.sqlTypeColumn) {
            try {
                int i = OdbcDef.odbcTypeToJdbc(Integer.valueOf(str));
                str = "" + i;
            }
            catch (Exception localException) {
                // empty catch block
            }
        }
        return str;
    }

    public String getDataStringDate(int paramInt) throws SQLException {
        String str;
        this.lastColumnNull = false;
        try {
            str = this.OdbcApi.SQLGetDataStringDate(this.hStmt, paramInt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            str = (String)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        if (str == null) {
            this.lastColumnNull = true;
        }
        return str;
    }

    public String getDataStringTime(int paramInt) throws SQLException {
        String str;
        this.lastColumnNull = false;
        try {
            str = this.OdbcApi.SQLGetDataStringTime(this.hStmt, paramInt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            str = (String)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        if (str == null) {
            this.lastColumnNull = true;
        }
        return str;
    }

    public String getDataStringTimestamp(int paramInt) throws SQLException {
        String str;
        this.lastColumnNull = false;
        try {
            str = this.OdbcApi.SQLGetDataStringTimestamp(this.hStmt, paramInt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            str = (String)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        if (str == null) {
            this.lastColumnNull = true;
        }
        return str;
    }

    public long getDataLongDate(int paramInt, Calendar paramCalendar) throws SQLException {
        String str;
        this.lastColumnNull = false;
        Date localDate = null;
        long l = 0L;
        try {
            str = this.OdbcApi.SQLGetDataStringDate(this.hStmt, paramInt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            str = (String)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        if (str != null) {
            localDate = Date.valueOf(str);
            l = this.utils.convertFromGMT(localDate, paramCalendar);
        } else if (str == null) {
            this.lastColumnNull = true;
        }
        return l;
    }

    public long getDataLongTime(int paramInt, Calendar paramCalendar) throws SQLException {
        String str;
        this.lastColumnNull = false;
        Time localTime = null;
        long l = 0L;
        try {
            str = this.OdbcApi.SQLGetDataStringTime(this.hStmt, paramInt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            str = (String)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        if (str != null) {
            localTime = Time.valueOf(str);
            l = this.utils.convertFromGMT(localTime, paramCalendar);
        } else if (str == null) {
            this.lastColumnNull = true;
        }
        return l;
    }

    public long getDataLongTimestamp(int paramInt, Calendar paramCalendar) throws SQLException {
        String str;
        this.lastColumnNull = false;
        Timestamp localTimestamp = null;
        long l = 0L;
        try {
            str = this.OdbcApi.SQLGetDataStringTimestamp(this.hStmt, paramInt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            str = (String)localJdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        if (str != null) {
            localTimestamp = Timestamp.valueOf(str);
            l = this.utils.convertFromGMT(localTimestamp, paramCalendar);
        } else if (str == null) {
            this.lastColumnNull = true;
        }
        return l;
    }

    public int getColumnLength(int paramInt) throws SQLException {
        int i = -1;
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            i = this.boundCols[paramInt - 1].getLength();
        }
        if (i == -1) {
            i = this.getColAttribute(paramInt, 3);
            if (paramInt > 0 && paramInt <= this.numberOfCols) {
                this.boundCols[paramInt - 1].setLength(i);
            }
        }
        return i;
    }

    @Override
    public int getScale(int paramInt) throws SQLException {
        int i;
        if (this.getPseudoCol(paramInt) != null) {
            this.lastColumnNull = true;
            i = 0;
        } else {
            i = this.getColAttribute(paramInt, 5);
        }
        return i;
    }

    @Override
    public int getColumnType(int paramInt) throws SQLException {
        int i = 9999;
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            i = this.boundCols[paramInt - 1].getType();
        }
        if (i == 9999) {
            i = this.getColAttribute(paramInt, 2);
            i = OdbcDef.odbcTypeToJdbc(i);
            if (paramInt > 0 && paramInt <= this.numberOfCols) {
                this.boundCols[paramInt - 1].setType(i);
            }
        }
        return i;
    }

    public void setPseudoCols(int paramInt1, int paramInt2, JdbcOdbcPseudoCol[] paramArrayOfJdbcOdbcPseudoCol) {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("Setting pseudo columns, first=" + paramInt1 + ", last=" + paramInt2);
        }
        this.firstPseudoCol = paramInt1;
        this.lastPseudoCol = paramInt2;
        this.pseudoCols = paramArrayOfJdbcOdbcPseudoCol;
    }

    @Override
    public JdbcOdbcPseudoCol getPseudoCol(int paramInt) {
        JdbcOdbcPseudoCol localJdbcOdbcPseudoCol = null;
        if (paramInt > 0 && paramInt >= this.firstPseudoCol && paramInt <= this.lastPseudoCol) {
            localJdbcOdbcPseudoCol = this.pseudoCols[paramInt - this.firstPseudoCol];
        }
        return localJdbcOdbcPseudoCol;
    }

    public void setSQLTypeColumn(int paramInt) {
        this.sqlTypeColumn = paramInt;
    }

    protected void setInputStream(int paramInt, JdbcOdbcInputStream paramJdbcOdbcInputStream) {
        if (paramInt > 0 && paramInt <= this.numberOfCols) {
            this.boundCols[paramInt - 1].setInputStream(paramJdbcOdbcInputStream);
        }
    }

    protected void closeInputStreams() {
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.boundCols[i].closeInputStream();
        }
    }

    public void setColumnMappings(int[] paramArrayOfInt) {
        this.colMappings = paramArrayOfInt;
    }

    @Override
    public int mapColumn(int paramInt) {
        int i = paramInt;
        if (this.colMappings != null) {
            i = paramInt > 0 && paramInt <= this.colMappings.length ? this.colMappings[paramInt - 1] : -1;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateRowCount() throws SQLException {
        Object localObject1;
        try {
            this.numberOfRows = this.OdbcApi.SQLRowCount(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            localObject1 = (BigDecimal)localJdbcOdbcSQLWarning.value;
            this.numberOfRows = ((BigDecimal)localObject1).intValue();
        }
        if (this.numberOfRows > 0) {
            return;
        }
        try {
            this.OdbcApi.SQLFetchScroll(this.hStmt, (short)3, 0);
            this.numberOfRows = (int)this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)14);
        }
        catch (SQLException localSQLException) {
        }
        finally {
            this.OdbcApi.SQLFetchScroll(this.hStmt, (short)5, 0);
        }
        if (this.numberOfRows > 0) {
            this.OdbcApi.SQLFetchScroll(this.hStmt, (short)5, 0);
            return;
        }
        if (this.ownerStatement != null) {
            Connection localConnection = this.ownerStatement.getConnection();
            localObject1 = this.ownerStatement.getSql();
            String str1 = null;
            String str2 = this.ownerStatement.getClass().getName();
            int i = 0;
            i = this.ownerStatement.getParamCount();
            if (i > 0) {
                if (str2.indexOf("CallableStatement") > 0) {
                    throw new SQLException("Unable to obtain result set row count. From " + (String)localObject1);
                }
                if (str2.indexOf("PreparedStatement") > 0) {
                    if (((String)localObject1).toLowerCase().indexOf("select") == -1) {
                        throw new SQLException("Cannot obtain result set row count for " + (String)localObject1);
                    }
                    str1 = this.reWordAsCountQuery((String)localObject1);
                    if (str1.indexOf("?") > 0) {
                        this.numberOfRows = this.parameterQuery(localConnection.prepareStatement(str1));
                    } else {
                        i = 0;
                    }
                }
            }
            if (str2.indexOf("Statement") > 0 && i == 0) {
                Statement localStatement = localConnection.createStatement();
                if (localObject1 != null && ((String)localObject1).startsWith("SELECT")) {
                    if (str1 == null) {
                        str1 = this.reWordAsCountQuery((String)localObject1);
                    }
                    ResultSet localResultSet = localStatement.executeQuery(str1);
                    localResultSet.next();
                    this.numberOfRows = localResultSet.getInt(1);
                    if (str1.indexOf("COUNT(*)") < 0 && this.numberOfRows > 0) {
                        this.numberOfRows = 1;
                        this.setWarning(new SQLWarning("ResultSet is not updatable."));
                    }
                }
                if (localStatement != null) {
                    localStatement.close();
                }
            }
        }
        if (this.numberOfRows > 0) {
            return;
        }
        this.setWarning(new SQLWarning("Can not determine result set row count."));
    }

    protected int parameterQuery(PreparedStatement paramPreparedStatement) throws SQLException {
        int i = 0;
        Object[] arrayOfObject = null;
        int[] arrayOfInt = null;
        if (paramPreparedStatement != null) {
            try {
                arrayOfObject = this.ownerStatement.getObjects();
                arrayOfInt = this.ownerStatement.getObjectTypes();
                for (int j = 0; j < arrayOfObject.length; ++j) {
                    paramPreparedStatement.setObject(j + 1, arrayOfObject[j], arrayOfInt[j]);
                }
            }
            catch (Exception localException) {
                throw new SQLException("while calculating row count: " + localException.getMessage());
            }
            ResultSet localResultSet = paramPreparedStatement.executeQuery();
            localResultSet.next();
            i = localResultSet.getInt(1);
            paramPreparedStatement.close();
        }
        return i;
    }

    protected String reWordAsCountQuery(String paramString) {
        int i = paramString.indexOf(" COUNT(*) ");
        int j = -1;
        int k = paramString.indexOf(" FROM ");
        int m = paramString.indexOf("'");
        int n = -1;
        if (m > 0) {
            n = paramString.indexOf("'", m + 2);
        }
        if (k > m && n > k) {
            k = paramString.indexOf(" FROM ", n);
        }
        if (i > m && n > i) {
            i = -1;
        }
        int i1 = -1;
        int i2 = -1;
        int i3 = -1;
        int i4 = -1;
        int i5 = -1;
        int i6 = paramString.indexOf("WHERE");
        int i7 = -1;
        if (i6 < k) {
            i6 = paramString.indexOf("WHERE", i6 + 2);
        }
        String str1 = "";
        if (i5 < 0) {
            i1 = paramString.lastIndexOf("ORDER BY");
            if (i1 > i6) {
                i5 = i1;
            }
            str1 = "ORDER BY";
        }
        if (i5 < 0) {
            i2 = paramString.lastIndexOf("GROUP BY");
            if (i2 > i6 && i2 > i1) {
                i5 = i2;
            }
            str1 = "GROUP BY";
        }
        if (i5 < 0) {
            i3 = paramString.lastIndexOf("FOR UPDATE");
            if (i3 > i6 && i3 > i2) {
                i5 = i3;
            }
            str1 = "FOR UPDATE";
        }
        if (i5 < 0) {
            i4 = paramString.lastIndexOf("UNION");
            if (i4 > i6 && i4 > i3) {
                i5 = i4;
            }
            str1 = "UNION";
        }
        if (i5 > 0 && i5 > k) {
            if (i6 > 0 && i6 > k) {
                int i8 = paramString.indexOf("'", i6);
                int i9 = -1;
                if (i8 > 0) {
                    i9 = paramString.indexOf("'", i8 + 2);
                }
                if (i5 > i8 && n > i5) {
                    i5 = paramString.indexOf(str1, i9);
                }
                if (i5 > i9) {
                    paramString = paramString.substring(0, i5);
                }
            } else {
                paramString = paramString.substring(0, i5);
            }
        }
        String str2 = paramString.substring(0, k);
        StringBuffer localStringBuffer = new StringBuffer(paramString);
        if (i < 0 && j < 0 && (j = str2.lastIndexOf(")")) > 0) {
            int i10 = paramString.indexOf(" (");
            if (i10 > 0) {
                if (i10 < m && i10 < n) {
                    j = -1;
                }
            } else if (i10 < 0) {
                j = -1;
                i = i10;
            }
        }
        if (j > 0) {
            localStringBuffer.insert(6, " COUNT(*), ");
        } else if (i < 0 && k > 0) {
            localStringBuffer.replace(6, k, " COUNT(*) ");
        }
        return localStringBuffer.toString();
    }

    protected void setCursorType() throws SQLException {
        this.clearWarnings();
        try {
            long l = this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)6);
            this.odbcCursorType = (short)l;
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            BigDecimal localBigDecimal = (BigDecimal)localJdbcOdbcSQLWarning.value;
            this.odbcCursorType = localBigDecimal.shortValue();
            this.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
    }

    @Override
    public SQLXML getSQLXML(int paramInt) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public SQLXML getSQLXML(String paramString) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public RowId getRowId(int paramInt) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public RowId getRowId(String paramString) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateRowId(int paramInt, RowId paramRowId) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateRowId(String paramString, RowId paramRowId) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNString(int paramInt, String paramString) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNString(String paramString1, String paramString2) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNClob(int paramInt, NClob paramNClob) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNClob(String paramString, NClob paramNClob) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public NClob getNClob(int paramInt) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public NClob getNClob(String paramString) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return false;
    }

    @Override
    public Reader getNCharacterStream(int paramInt) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public Reader getNCharacterStream(String paramString) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateSQLXML(int paramInt, SQLXML paramSQLXML) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateSQLXML(String paramString, SQLXML paramSQLXML) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public String getNString(int paramInt) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public String getNString(String paramString) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    public void updateNCharacterStream(int paramInt1, Reader paramReader, int paramInt2) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    public void updateNCharacterStream(String paramString, Reader paramReader, int paramInt) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public void updateNClob(String paramString, Reader paramReader, long paramLong) throws SQLException {
    }

    @Override
    public void updateNClob(int paramInt, Reader paramReader, long paramLong) throws SQLException {
    }

    @Override
    public void updateClob(String paramString, Reader paramReader, long paramLong) throws SQLException {
    }

    @Override
    public void updateClob(int paramInt, Reader paramReader, long paramLong) throws SQLException {
    }

    @Override
    public void updateBlob(String paramString, InputStream paramInputStream, long paramLong) throws SQLException {
    }

    @Override
    public void updateBlob(int paramInt, InputStream paramInputStream, long paramLong) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String paramString, Reader paramReader, long paramLong) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String paramString, InputStream paramInputStream, long paramLong) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String paramString, InputStream paramInputStream, long paramLong) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int paramInt, Reader paramReader, long paramLong) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int paramInt, InputStream paramInputStream, long paramLong) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int paramInt, InputStream paramInputStream, long paramLong) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String paramString, Reader paramReader, long paramLong) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int paramInt, Reader paramReader, long paramLong) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int paramInt, Reader paramReader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String paramString, Reader paramReader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int paramInt, InputStream paramInputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int paramInt, InputStream paramInputStream) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int paramInt, Reader paramReader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String paramString, InputStream paramInputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String paramString, InputStream paramInputStream) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String paramString, Reader paramReader) throws SQLException {
    }

    @Override
    public void updateBlob(int paramInt, InputStream paramInputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String paramString, InputStream paramInputStream) throws SQLException {
    }

    @Override
    public void updateClob(int paramInt, Reader paramReader) throws SQLException {
    }

    @Override
    public void updateClob(String paramString, Reader paramReader) throws SQLException {
    }

    @Override
    public void updateNClob(int paramInt, Reader paramReader) throws SQLException {
    }

    @Override
    public void updateNClob(String paramString, Reader paramReader) throws SQLException {
    }

    @Override
    public <T> T getObject(int paramInt, Class<T> paramClass) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String paramString, Class<T> paramClass) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

