/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSet;

public class JdbcOdbcDatabaseMetaData
extends JdbcOdbcObject
implements DatabaseMetaData {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcConnectionInterface Con;
    protected long hDbc;

    public JdbcOdbcDatabaseMetaData(JdbcOdbc paramJdbcOdbc, JdbcOdbcConnectionInterface paramJdbcOdbcConnectionInterface) {
        this.OdbcApi = paramJdbcOdbc;
        this.Con = paramJdbcOdbcConnectionInterface;
        this.hDbc = this.Con.getHDBC();
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.allProceduresAreCallable");
        }
        return this.getInfoBooleanString((short)20);
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.allTablesAreSelectable");
        }
        return this.getInfoBooleanString((short)19);
    }

    @Override
    public String getURL() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getURL");
        }
        return this.Con.getURL();
    }

    @Override
    public String getUserName() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getUserName");
        }
        return this.getInfoString((short)47);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.isReadOnly");
        }
        return this.getInfoBooleanString((short)25);
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.nullsAreSortedHigh");
        }
        return (i = this.getInfoShort((short)85)) == 0;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.nullsAreSortedLow");
        }
        return (i = this.getInfo((short)85)) == 1;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.nullsAreSortedAtStart");
        }
        return (i = this.getInfo((short)85)) == 2;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.nullsAreSortedAtEnd");
        }
        return (i = this.getInfo((short)85)) == 4;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getDatabaseProductName");
        }
        return this.getInfoString((short)17);
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getDatabaseProductVersion");
        }
        return this.getInfoString((short)18);
    }

    @Override
    public String getDriverName() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getDriverName");
        }
        return "JDBC-ODBC Bridge (" + this.getInfoString((short)6) + ")";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getDriverVersion");
        }
        int i = this.getDriverMinorVersion();
        String str = "";
        if (i < 1000) {
            str = str + "0";
        }
        if (i < 100) {
            str = str + "0";
        }
        if (i < 10) {
            str = str + "0";
        }
        str = str + "" + i;
        return "" + this.getDriverMajorVersion() + "." + str + " (" + this.getInfoString((short)7) + ")";
    }

    @Override
    public int getDriverMajorVersion() {
        return 2;
    }

    @Override
    public int getDriverMinorVersion() {
        return 1;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.usesLocalFiles");
        }
        return (i = this.getInfoShort((short)84)) == 2;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.usesLocalFilePerTable");
        }
        return (i = this.getInfoShort((short)84)) == 1;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsMixedCaseIdentifiers");
        }
        return (i = this.getInfoShort((short)28)) == 3;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.storesUpperCaseIdentifiers");
        }
        return (i = this.getInfoShort((short)28)) == 1;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.storesLowerCaseIdentifiers");
        }
        return (i = this.getInfoShort((short)28)) == 2;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.storesMixedCaseIdentifiers");
        }
        return (i = this.getInfoShort((short)28)) == 4;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsMixedCaseQuotedIdentifiers");
        }
        return (i = this.getInfoShort((short)93)) == 3;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.storesUpperCaseQuotedIdentifiers");
        }
        return (i = this.getInfoShort((short)93)) == 1;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.storesLowerCaseQuotedIdentifiers");
        }
        return (i = this.getInfoShort((short)93)) == 2;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.storesMixedCaseQuotedIdentifiers");
        }
        return (i = this.getInfoShort((short)93)) == 4;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getIdentifierQuoteString");
        }
        return this.getInfoString((short)29);
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getSQLKeywords");
        }
        return this.getInfoString((short)89, 16383);
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getNumericFunctions");
        }
        String str = "";
        int i = this.getInfo((short)49);
        if ((i & 1) != 0) {
            str = str + "ABS,";
        }
        if ((i & 2) != 0) {
            str = str + "ACOS,";
        }
        if ((i & 4) != 0) {
            str = str + "ASIN,";
        }
        if ((i & 8) != 0) {
            str = str + "ATAN,";
        }
        if ((i & 0x10) != 0) {
            str = str + "ATAN2,";
        }
        if ((i & 0x20) != 0) {
            str = str + "CEILING,";
        }
        if ((i & 0x40) != 0) {
            str = str + "COS,";
        }
        if ((i & 0x80) != 0) {
            str = str + "COT,";
        }
        if ((i & 0x40000) != 0) {
            str = str + "DEGREES,";
        }
        if ((i & 0x100) != 0) {
            str = str + "EXP,";
        }
        if ((i & 0x200) != 0) {
            str = str + "FLOOR,";
        }
        if ((i & 0x400) != 0) {
            str = str + "LOG,";
        }
        if ((i & 0x80000) != 0) {
            str = str + "LOG10,";
        }
        if ((i & 0x800) != 0) {
            str = str + "MOD,";
        }
        if ((i & 0x10000) != 0) {
            str = str + "PI,";
        }
        if ((i & 0x100000) != 0) {
            str = str + "POWER,";
        }
        if ((i & 0x200000) != 0) {
            str = str + "RADIANS,";
        }
        if ((i & 0x20000) != 0) {
            str = str + "RAND,";
        }
        if ((i & 0x400000) != 0) {
            str = str + "ROUND,";
        }
        if ((i & 0x1000) != 0) {
            str = str + "SIGN,";
        }
        if ((i & 0x2000) != 0) {
            str = str + "SIN,";
        }
        if ((i & 0x4000) != 0) {
            str = str + "SQRT,";
        }
        if ((i & 0x8000) != 0) {
            str = str + "TAN,";
        }
        if ((i & 0x800000) != 0) {
            str = str + "TRUNCATE,";
        }
        if (str.length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getStringFunctions");
        }
        String str = "";
        int i = this.getInfo((short)50);
        if ((i & 0x2000) != 0) {
            str = str + "ASCII,";
        }
        if ((i & 0x4000) != 0) {
            str = str + "CHAR,";
        }
        if ((i & 1) != 0) {
            str = str + "CONCAT,";
        }
        if ((i & 0x8000) != 0) {
            str = str + "DIFFERENCE,";
        }
        if ((i & 2) != 0) {
            str = str + "INSERT,";
        }
        if ((i & 0x40) != 0) {
            str = str + "LCASE,";
        }
        if ((i & 4) != 0) {
            str = str + "LEFT,";
        }
        if ((i & 0x10) != 0) {
            str = str + "LENGTH,";
        }
        if ((i & 0x20) != 0) {
            str = str + "LOCATE,";
        }
        if ((i & 0x10000) != 0) {
            str = str + "LOCATE_2,";
        }
        if ((i & 8) != 0) {
            str = str + "LTRIM,";
        }
        if ((i & 0x80) != 0) {
            str = str + "REPEAT,";
        }
        if ((i & 0x100) != 0) {
            str = str + "REPLACE,";
        }
        if ((i & 0x200) != 0) {
            str = str + "RIGHT,";
        }
        if ((i & 0x400) != 0) {
            str = str + "RTRIM,";
        }
        if ((i & 0x20000) != 0) {
            str = str + "SOUNDEX,";
        }
        if ((i & 0x40000) != 0) {
            str = str + "SPACE,";
        }
        if ((i & 0x800) != 0) {
            str = str + "SUBSTRING,";
        }
        if ((i & 0x1000) != 0) {
            str = str + "UCASE,";
        }
        if (str.length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getSystemFunctions");
        }
        String str = "";
        int i = this.getInfo((short)51);
        if ((i & 2) != 0) {
            str = str + "DBNAME,";
        }
        if ((i & 4) != 0) {
            str = str + "IFNULL,";
        }
        if ((i & 1) != 0) {
            str = str + "USERNAME,";
        }
        if (str.length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getTimeDateFunctions");
        }
        String str = "";
        int i = this.getInfo((short)52);
        if ((i & 2) != 0) {
            str = str + "CURDATE,";
        }
        if ((i & 0x200) != 0) {
            str = str + "CURTIME,";
        }
        if ((i & 0x8000) != 0) {
            str = str + "DAYNAME,";
        }
        if ((i & 4) != 0) {
            str = str + "DAYOFMONTH,";
        }
        if ((i & 8) != 0) {
            str = str + "DAYOFWEEK,";
        }
        if ((i & 0x10) != 0) {
            str = str + "DAYOFYEAR,";
        }
        if ((i & 0x400) != 0) {
            str = str + "HOUR,";
        }
        if ((i & 0x800) != 0) {
            str = str + "MINUTE,";
        }
        if ((i & 0x20) != 0) {
            str = str + "MONTH,";
        }
        if ((i & 0x10000) != 0) {
            str = str + "MONTHNAME,";
        }
        if ((i & 1) != 0) {
            str = str + "NOW,";
        }
        if ((i & 0x40) != 0) {
            str = str + "QUARTER,";
        }
        if ((i & 0x1000) != 0) {
            str = str + "SECOND,";
        }
        if ((i & 0x2000) != 0) {
            str = str + "TIMESTAMPADD,";
        }
        if ((i & 0x4000) != 0) {
            str = str + "TIMESTAMPDIFF,";
        }
        if ((i & 0x80) != 0) {
            str = str + "WEEK,";
        }
        if ((i & 0x100) != 0) {
            str = str + "YEAR,";
        }
        if (str.length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getSearchStringEscape");
        }
        return this.getInfoString((short)14);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getExtraNameCharacters");
        }
        return this.getInfoString((short)94);
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsAlterTableWithAddColumn");
        }
        return ((i = this.getInfo((short)86)) & 1) > 0;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsAlterTableWithDropColumn");
        }
        return ((i = this.getInfo((short)86)) & 2) > 0;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsColumnAliasing");
        }
        return this.getInfoBooleanString((short)87);
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.nullPlusNullIsNull");
        }
        return (i = this.getInfoShort((short)22)) == 0;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsConvert");
        }
        return (i = this.getInfo((short)48)) == 1;
    }

    @Override
    public boolean supportsConvert(int paramInt1, int paramInt2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsConvert (" + paramInt1 + "," + paramInt2 + ")");
        }
        short s = 0;
        boolean i = false;
        int j = 0;
        switch (paramInt1) {
            case -7: {
                s = 55;
                break;
            }
            case -6: {
                s = 68;
                break;
            }
            case 5: {
                s = 65;
                break;
            }
            case 4: {
                s = 61;
                break;
            }
            case -5: {
                s = 53;
                break;
            }
            case 6: {
                s = 60;
                break;
            }
            case 7: {
                s = 64;
                break;
            }
            case 8: {
                s = 59;
                break;
            }
            case 2: {
                s = 63;
                break;
            }
            case 3: {
                s = 58;
                break;
            }
            case 1: {
                s = 56;
                break;
            }
            case 12: {
                s = 70;
                break;
            }
            case -1: {
                s = 62;
                break;
            }
            case 91: {
                s = 57;
                break;
            }
            case 92: {
                s = 66;
                break;
            }
            case 93: {
                s = 67;
                break;
            }
            case -2: {
                s = 54;
                break;
            }
            case -3: {
                s = 69;
                break;
            }
            case -4: {
                s = 71;
            }
        }
        int k = this.getInfo(s);
        switch (paramInt2) {
            case -7: {
                j = 4096;
                break;
            }
            case -6: {
                j = 8192;
                break;
            }
            case 5: {
                j = 16;
                break;
            }
            case 4: {
                j = 8;
                break;
            }
            case -5: {
                j = 16384;
                break;
            }
            case 6: {
                j = 32;
                break;
            }
            case 7: {
                j = 64;
                break;
            }
            case 8: {
                j = 128;
                break;
            }
            case 2: {
                j = 2;
                break;
            }
            case 3: {
                j = 4;
                break;
            }
            case 1: {
                j = 1;
                break;
            }
            case 12: {
                j = 256;
                break;
            }
            case -1: {
                j = 512;
                break;
            }
            case 91: {
                j = 32768;
                break;
            }
            case 92: {
                j = 65536;
                break;
            }
            case 93: {
                j = 131072;
                break;
            }
            case -2: {
                j = 1024;
                break;
            }
            case -3: {
                j = 2048;
                break;
            }
            case -4: {
                j = 262144;
            }
        }
        return (k & j) > 0;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsTableCorrelationNames");
        }
        return (i = this.getInfoShort((short)74)) == 1 || i == 2;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsDifferentTableCorrelationNames");
        }
        return (i = this.getInfoShort((short)74)) == 1;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsExpressionsInOrderBy");
        }
        return this.getInfoBooleanString((short)27);
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsOrderByUnrelated");
        }
        return this.getInfoBooleanString((short)90);
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsGroupBy");
        }
        return (i = this.getInfoShort((short)88)) != 0;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsGroupByUnrelated");
        }
        return (i = this.getInfoShort((short)88)) == 3;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsGroupByBeyondSelect");
        }
        return (i = this.getInfoShort((short)88)) == 2;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsLikeEscapeClause");
        }
        return this.getInfoBooleanString((short)113);
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsMultipleResultSets");
        }
        return this.getInfoBooleanString((short)36);
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsMultipleTransactions");
        }
        return this.getInfoBooleanString((short)37);
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsNonNullableColumns");
        }
        return (i = this.getInfoShort((short)75)) == 1;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsMinimumSQLGrammar");
        }
        return (i = this.getInfoShort((short)15)) == 0 || i == 1 || i == 2;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsCoreSQLGrammar");
        }
        return (i = this.getInfoShort((short)15)) == 1 || i == 2;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsExtendedSQLGrammar");
        }
        return (i = this.getInfoShort((short)15)) == 2;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsIntegrityEnhancementFacility");
        }
        return this.getInfoBooleanString((short)73);
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        String str;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsOuterJoins");
        }
        return !(str = this.getInfoString((short)38)).equalsIgnoreCase("N");
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsFullOuterJoins");
        }
        String str = this.getInfoString((short)38);
        return str.equalsIgnoreCase("F");
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsLimitedOuterJoins");
        }
        String str = this.getInfoString((short)38);
        return str.equalsIgnoreCase("P");
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getSchemaTerm");
        }
        return this.getInfoString((short)39);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getProcedureTerm");
        }
        return this.getInfoString((short)40);
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getCatalogTerm");
        }
        return this.getInfoString((short)42);
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.isCatalogAtStart");
        }
        return (i = this.getInfoShort((short)114)) == 1;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getCatalogSeparator");
        }
        return this.getInfoString((short)41);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsSchemasInDataManipulation");
        }
        return ((i = this.getInfo((short)91)) & 1) > 0;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsSchemasInProcedureCalls");
        }
        return ((i = this.getInfo((short)91)) & 2) > 0;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsSchemasInTableDefinitions");
        }
        return ((i = this.getInfo((short)91)) & 4) > 0;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsSchemasInIndexDefintions");
        }
        return ((i = this.getInfo((short)91)) & 8) > 0;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsSchemasInPrivilegeDefintions");
        }
        return ((i = this.getInfo((short)91)) & 0x10) > 0;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsCatalogsInDataManipulation");
        }
        return ((i = this.getInfo((short)92)) & 1) > 0;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsCatalogsInProcedureCalls");
        }
        return ((i = this.getInfo((short)92)) & 2) > 0;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsCatalogsInTableDefinitions");
        }
        return ((i = this.getInfo((short)92)) & 4) > 0;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsCatalogsInIndexDefinitions");
        }
        return ((i = this.getInfo((short)92)) & 8) > 0;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsCatalogsInPrivilegeDefintions");
        }
        return ((i = this.getInfo((short)92)) & 0x10) > 0;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsPositionedDelete");
        }
        return ((i = this.getInfo((short)80)) & 1) > 0;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsPositionedUpdate");
        }
        return ((i = this.getInfo((short)80)) & 2) > 0;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsSelectForUpdate");
        }
        return ((i = this.getInfo((short)80)) & 4) > 0;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsStoredProcedures");
        }
        return this.getInfoBooleanString((short)21);
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsSubqueriesInComparisions");
        }
        return ((i = this.getInfo((short)95)) & 1) > 0;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsSubqueriesInExists");
        }
        return ((i = this.getInfo((short)95)) & 2) > 0;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsSubqueriesInIns");
        }
        return ((i = this.getInfo((short)95)) & 4) > 0;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsSubqueriesInQuantifieds");
        }
        return ((i = this.getInfo((short)95)) & 8) > 0;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsCorrelatedSubqueries");
        }
        return ((i = this.getInfo((short)95)) & 0x10) > 0;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsUnion");
        }
        return ((i = this.getInfo((short)96)) & 1) > 0;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsUnionAll");
        }
        return ((i = this.getInfo((short)96)) & 2) > 0;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsOpenCursorsAcrossCommit");
        }
        return (i = this.getInfoShort((short)23)) == 2;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsOpenCursorsAcrossRollback");
        }
        return (i = this.getInfoShort((short)24)) == 2;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsOpenStatementsAcrossCommit");
        }
        return (i = this.getInfoShort((short)23)) == 2 || i == 1;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsOpenStatementsAcrossRollback");
        }
        return (i = this.getInfoShort((short)24)) == 2 || i == 1;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxBinaryLiteralLength");
        }
        return this.getInfo((short)112);
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxCharLiteralLength");
        }
        return this.getInfo((short)108);
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxColumnNameLength");
        }
        return this.getInfoShort((short)30);
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxColumnsInGroupBy");
        }
        return this.getInfoShort((short)97);
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxColumnsInIndex");
        }
        return this.getInfoShort((short)98);
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxColumnsInOrderBy");
        }
        return this.getInfoShort((short)99);
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxColumnsInSeleted");
        }
        return this.getInfoShort((short)100);
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxColumnsInTable");
        }
        return this.getInfoShort((short)101);
    }

    @Override
    public int getMaxConnections() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxConnections");
        }
        return this.getInfoShort((short)0);
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxCursorNameLength");
        }
        return this.getInfo((short)31);
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxIndexLength");
        }
        return this.getInfo((short)102);
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxSchemaNameLength");
        }
        return this.getInfoShort((short)32);
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxProcedureNameLength");
        }
        return this.getInfoShort((short)33);
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxCatalogNameLength");
        }
        return this.getInfoShort((short)34);
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxRowSize");
        }
        return this.getInfo((short)104);
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.doesMaxRowSizeIncludeBlobs");
        }
        return this.getInfoBooleanString((short)103);
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxStatementLength");
        }
        return this.getInfo((short)105);
    }

    @Override
    public int getMaxStatements() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxStatements");
        }
        return this.getInfoShort((short)1);
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxTableNameLength");
        }
        return this.getInfoShort((short)35);
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxTablesInSelect");
        }
        return this.getInfoShort((short)106);
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getMaxUserNameLength");
        }
        return this.getInfoShort((short)107);
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getDefaultTransactionIsolation");
        }
        int i = this.getInfo((short)26);
        int j = 0;
        switch (i) {
            case 1: {
                j = 1;
                break;
            }
            case 2: {
                j = 2;
                break;
            }
            case 4: {
                j = 4;
                break;
            }
            case 8: {
                j = 8;
            }
        }
        return j;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsTransactions");
        }
        return (i = this.getInfoShort((short)46)) != 0;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsTransactionIsolationLevel (" + paramInt + ")");
        }
        if (paramInt == 0) {
            return !this.supportsTransactions();
        }
        int i = this.getInfo((short)72);
        boolean bool = false;
        switch (paramInt) {
            case 1: {
                bool = (i & 1) > 0;
                break;
            }
            case 2: {
                bool = (i & 2) > 0;
                break;
            }
            case 4: {
                bool = (i & 4) > 0;
                break;
            }
            case 8: {
                bool = (i & 8) > 0;
            }
        }
        return bool;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions");
        }
        return ((i = this.getInfoShort((short)46)) & 2) > 0;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsDataManipulationTransactionsOnly");
        }
        return ((i = this.getInfoShort((short)46)) & 1) > 0;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.dataDefintionCausesTransactionCommit");
        }
        return ((i = this.getInfoShort((short)46)) & 3) > 0;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.dataDefintionIgnoredInTransactions");
        }
        return ((i = this.getInfoShort((short)46)) & 4) > 0;
    }

    @Override
    public ResultSet getProcedures(String paramString1, String paramString2, String paramString3) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getProcedures (" + paramString1 + "," + paramString2 + "," + paramString3 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLProcedures(l, paramString1, paramString2, paramString3);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getProcedureColumns(String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getProcedureColumns (" + paramString1 + "," + paramString2 + "," + paramString3 + "," + paramString4 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLProcedureColumns(l, paramString1, paramString2, paramString3, paramString4);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        if (this.Con.getODBCVer() >= 2) {
            localJdbcOdbcResultSet.setSQLTypeColumn(6);
            localJdbcOdbcResultSet.setAliasColumnName("PRECISION", 8);
            localJdbcOdbcResultSet.setAliasColumnName("LENGTH", 9);
            localJdbcOdbcResultSet.setAliasColumnName("SCALE", 10);
            localJdbcOdbcResultSet.setAliasColumnName("RADIX", 11);
        }
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getTables(String paramString1, String paramString2, String paramString3, String[] paramArrayOfString) throws SQLException {
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        String str1 = null;
        SQLWarning localObject = null;
        if (paramArrayOfString != null) {
            str1 = "";
            int i = 0;
            for (i = 0; i < paramArrayOfString.length; i = (int)((short)(i + 1))) {
                String str2 = paramArrayOfString[i];
                if (i > 0) {
                    str1 = str1 + ",";
                }
                str1 = str1 + str2;
            }
        }
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getTables (" + paramString1 + "," + paramString2 + "," + paramString3 + "," + str1 + ")");
        }
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLTables(l, paramString1, paramString2, paramString3, str1);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getSchemas");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = (JdbcOdbcResultSet)this.getTables("", "%", "", null);
        int[] arrayOfInt = new int[]{2};
        localJdbcOdbcResultSet.setColumnMappings(arrayOfInt);
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getCatalogs");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = (JdbcOdbcResultSet)this.getTables("%", "", "", null);
        int[] arrayOfInt = new int[]{1};
        localJdbcOdbcResultSet.setColumnMappings(arrayOfInt);
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getTableTypes");
        }
        String[] arrayOfString = new String[]{"%"};
        JdbcOdbcResultSet localJdbcOdbcResultSet = (JdbcOdbcResultSet)this.getTables(null, null, "%", null);
        int[] arrayOfInt = new int[]{4};
        localJdbcOdbcResultSet.setColumnMappings(arrayOfInt);
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getColumns(String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getColumns (" + paramString1 + "," + paramString2 + "," + paramString3 + "," + paramString4 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLColumns(l, paramString1, paramString2, paramString3, paramString4);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        if (this.Con.getODBCVer() == 2) {
            JdbcOdbcPseudoCol[] arrayOfJdbcOdbcPseudoCol = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("COLUMN_DEF", 12, 254), new JdbcOdbcPseudoCol("SQL_DATA_TYPE", 5, 0), new JdbcOdbcPseudoCol("SQL_DATETIME_SUB", 5, 0), new JdbcOdbcPseudoCol("CHAR_OCTET_LENGTH", 4, 0), new JdbcOdbcPseudoCol("ORDINAL_POSITION", 4, 0), new JdbcOdbcPseudoCol("IS_NULLABLE", 12, 254)};
            localJdbcOdbcResultSet.setPseudoCols(13, 18, arrayOfJdbcOdbcPseudoCol);
            localJdbcOdbcResultSet.setSQLTypeColumn(5);
        } else if (this.Con.getODBCVer() >= 3) {
            localJdbcOdbcResultSet.setSQLTypeColumn(5);
            localJdbcOdbcResultSet.setAliasColumnName("SQL_DATETIME_SUB", 15);
        }
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getColumnPrivileges(String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getColumnPrivileges (" + paramString1 + "," + paramString2 + "," + paramString3 + "," + paramString4 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLColumnPrivileges(l, paramString1, paramString2, paramString3, paramString4);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getTablePrivileges(String paramString1, String paramString2, String paramString3) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getTablePrivileges (" + paramString1 + "," + paramString2 + "," + paramString3 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLTablePrivileges(l, paramString1, paramString2, paramString3);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getBestRowIdentifier(String paramString1, String paramString2, String paramString3, int paramInt, boolean paramBoolean) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getBestRowIdentifier (" + paramString1 + "," + paramString2 + "," + paramString3 + "," + paramInt + "," + paramBoolean + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLSpecialColumns(l, (short)1, paramString1, paramString2, paramString3, paramInt, paramBoolean);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        if (this.Con.getODBCVer() >= 2) {
            localJdbcOdbcResultSet.setSQLTypeColumn(3);
        }
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getVersionColumns(String paramString1, String paramString2, String paramString3) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getVersionColumns (" + paramString1 + "," + paramString2 + "," + paramString3 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLSpecialColumns(l, (short)2, paramString1, paramString2, paramString3, 0, false);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        if (this.Con.getODBCVer() >= 2) {
            localJdbcOdbcResultSet.setSQLTypeColumn(3);
        }
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getPrimaryKeys(String paramString1, String paramString2, String paramString3) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getPrimaryKeys (" + paramString1 + "," + paramString2 + "," + paramString3 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLPrimaryKeys(l, paramString1, paramString2, paramString3);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getImportedKeys(String paramString1, String paramString2, String paramString3) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getImportedKeys (" + paramString1 + "," + paramString2 + "," + paramString3 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLForeignKeys(l, null, null, null, paramString1, paramString2, paramString3);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        if (this.Con.getODBCVer() >= 2) {
            JdbcOdbcPseudoCol[] arrayOfJdbcOdbcPseudoCol = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("DEFERRABILITY", 5, 0)};
            localJdbcOdbcResultSet.setPseudoCols(14, 14, arrayOfJdbcOdbcPseudoCol);
        }
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getExportedKeys(String paramString1, String paramString2, String paramString3) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getExportedKeys (" + paramString1 + "," + paramString2 + "," + paramString3 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLForeignKeys(l, paramString1, paramString2, paramString3, null, null, null);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        if (this.Con.getODBCVer() >= 2) {
            JdbcOdbcPseudoCol[] arrayOfJdbcOdbcPseudoCol = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("DEFERRABILITY", 5, 0)};
            localJdbcOdbcResultSet.setPseudoCols(14, 14, arrayOfJdbcOdbcPseudoCol);
        }
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getCrossReference(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getCrossReference (" + paramString1 + "," + paramString2 + "," + paramString3 + "," + paramString4 + "," + paramString5 + "," + paramString6 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLForeignKeys(l, paramString1, paramString2, paramString3, paramString4, paramString5, paramString6);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        if (this.Con.getODBCVer() >= 2) {
            JdbcOdbcPseudoCol[] arrayOfJdbcOdbcPseudoCol = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("DEFERRABILITY", 5, 0)};
            localJdbcOdbcResultSet.setPseudoCols(14, 14, arrayOfJdbcOdbcPseudoCol);
        }
        return localJdbcOdbcResultSet;
    }

    @Override
    public boolean supportsResultSetType(int paramInt) throws SQLException {
        short s = this.getConnectionSupportType(paramInt);
        switch (paramInt) {
            case 1003: {
                return s == 0;
            }
            case 1004: {
                return s == 3 || s == 1;
            }
            case 1005: {
                if (s == 1) {
                    int i = this.Con.getOdbcCursorAttr2(s);
                    return (i & 0x40) != 0;
                }
                return s == 2;
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int paramInt1, int paramInt2) throws SQLException {
        if (this.supportsResultSetType(paramInt1)) {
            short i = this.Con.getOdbcConcurrency(paramInt2);
            switch (paramInt2) {
                case 1007: {
                    return i == 1;
                }
                case 1008: {
                    if (paramInt1 != 1003) {
                        return i == 2;
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int paramInt) throws SQLException {
        if (paramInt != 1003) {
            return this.updatesAreDetected(paramInt);
        }
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int paramInt) throws SQLException {
        if (paramInt != 1003) {
            return this.deletesAreDetected(paramInt);
        }
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int paramInt) throws SQLException {
        if (paramInt != 1003) {
            return this.insertsAreDetected(paramInt);
        }
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int paramInt) throws SQLException {
        if (paramInt == 1005) {
            return this.updatesAreDetected(paramInt);
        }
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int paramInt) throws SQLException {
        if (paramInt == 1005) {
            return this.deletesAreDetected(paramInt);
        }
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int paramInt) throws SQLException {
        if (paramInt == 1005) {
            return this.insertsAreDetected(paramInt);
        }
        return false;
    }

    @Override
    public boolean updatesAreDetected(int paramInt) throws SQLException {
        short s = this.getCursorAttribute(paramInt);
        if (s > 0) {
            try {
                int i = this.OdbcApi.SQLGetInfo(this.hDbc, s);
                return (i & 0x40) > 0;
            }
            catch (SQLException localSQLException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean deletesAreDetected(int paramInt) throws SQLException {
        short s = this.getCursorAttribute(paramInt);
        if (s > 0) {
            try {
                int i = this.OdbcApi.SQLGetInfo(this.hDbc, s);
                return (i & 0x20) > 0;
            }
            catch (SQLException localSQLException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean insertsAreDetected(int paramInt) throws SQLException {
        short s = this.getCursorAttribute(paramInt);
        if (s > 0) {
            try {
                int i = this.OdbcApi.SQLGetInfo(this.hDbc, s);
                return (i & 0x10) > 0;
            }
            catch (SQLException localSQLException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.supportsBatchUpdates");
        }
        int i = 0;
        boolean j = false;
        boolean k = false;
        boolean m = false;
        try {
            i = this.OdbcApi.SQLGetInfo(this.hDbc, (short)121);
            if ((i & 2) > 0) {
                j = true;
            }
            if (((i = this.OdbcApi.SQLGetInfo(this.hDbc, (short)153)) & 1) > 0) {
                m = true;
            }
        }
        catch (SQLException localSQLException) {
            j = false;
            m = false;
        }
        return j && m;
    }

    @Override
    public ResultSet getUDTs(String paramString1, String paramString2, String paramString3, int[] paramArrayOfInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.Con != null && this.hDbc > 0L) {
            return this.Con;
        }
        return null;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getTypeInfo");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLGetTypeInfo(l, (short)0);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        if (this.Con.getODBCVer() == 2) {
            JdbcOdbcPseudoCol[] arrayOfJdbcOdbcPseudoCol = new JdbcOdbcPseudoCol[5];
            arrayOfJdbcOdbcPseudoCol[0] = new JdbcOdbcPseudoCol("SQL_DATA_TYPE", 5, 0);
            arrayOfJdbcOdbcPseudoCol[1] = new JdbcOdbcPseudoCol("SQL_DATETIME_SUB", 5, 0);
            arrayOfJdbcOdbcPseudoCol[2] = new JdbcOdbcPseudoCol("NUM_PREC_RADIX", 5, 0);
            localJdbcOdbcResultSet.setPseudoCols(16, 18, arrayOfJdbcOdbcPseudoCol);
            localJdbcOdbcResultSet.setSQLTypeColumn(2);
        } else if (this.Con.getODBCVer() >= 3) {
            localJdbcOdbcResultSet.setSQLTypeColumn(2);
        }
        if (this.Con.getODBCVer() >= 2) {
            localJdbcOdbcResultSet.setAliasColumnName("PRECISION", 3);
            localJdbcOdbcResultSet.setAliasColumnName("AUTO_INCREMENT", 12);
        }
        return localJdbcOdbcResultSet;
    }

    @Override
    public ResultSet getIndexInfo(String paramString1, String paramString2, String paramString3, boolean paramBoolean1, boolean paramBoolean2) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*DatabaseMetaData.getIndexInfo (" + paramString1 + "," + paramString2 + "," + paramString3 + paramBoolean1 + "," + paramBoolean2 + ")");
        }
        JdbcOdbcResultSet localJdbcOdbcResultSet = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLStatistics(l, paramString1, paramString2, paramString3, paramBoolean1, paramBoolean2);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.OdbcApi.SQLFreeStmt(l, 1);
            throw localSQLException;
        }
        localJdbcOdbcResultSet = new JdbcOdbcResultSet();
        localJdbcOdbcResultSet.initialize(this.OdbcApi, this.hDbc, l, false, null);
        localJdbcOdbcResultSet.setWarning(localObject);
        return localJdbcOdbcResultSet;
    }

    protected void validateConnection() throws SQLException {
        this.Con.validateConnection();
    }

    protected int getInfo(short paramShort) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfo(this.hDbc, paramShort);
    }

    protected int getInfoShort(short paramShort) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoShort(this.hDbc, paramShort);
    }

    protected boolean getInfoBooleanString(short paramShort) throws SQLException {
        this.validateConnection();
        String str = this.OdbcApi.SQLGetInfoString(this.hDbc, paramShort);
        return str.equalsIgnoreCase("Y");
    }

    protected String getInfoString(short paramShort) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, paramShort);
    }

    protected String getInfoString(short paramShort, int paramInt) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, paramShort, paramInt);
    }

    protected short getConnectionSupportType(int paramInt) throws SQLException {
        short s = this.Con.getOdbcCursorType(paramInt);
        if (s == -1) {
            s = this.Con.getBestOdbcCursorType();
        }
        return s;
    }

    protected short getCursorAttribute(int paramInt) throws SQLException {
        short s = 0;
        if (this.supportsResultSetType(paramInt)) {
            short i = this.getConnectionSupportType(paramInt);
            switch (i) {
                case 1: {
                    s = 151;
                    break;
                }
                case 2: {
                    s = 145;
                    break;
                }
                case 3: {
                    s = 168;
                }
            }
            return s;
        }
        return s;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String paramString1, String paramString2, String paramString3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getSuperTables(String paramString1, String paramString2, String paramString3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getAttributes(String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsResultSetHoldability(int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 1;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 2;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getSchemas(String paramString1, String paramString2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getFunctions(String paramString1, String paramString2, String paramString3) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    public ResultSet getFunctionParameters(String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public ResultSet getFunctionColumns(String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException {
        throw new UnsupportedOperationException("Operation not yet supported");
    }

    @Override
    public ResultSet getPseudoColumns(String paramString1, String paramString2, String paramString3, String paramString4) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }
}

