/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.InputStream;
import sun.jdbc.odbc.JdbcOdbcInputStream;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPlatform;

public class JdbcOdbcBoundCol
extends JdbcOdbcObject {
    protected int type = 9999;
    protected int len = -1;
    protected JdbcOdbcInputStream inputStream;
    protected boolean isRenamed = false;
    protected String aliasName = null;
    protected int rowSetSize;
    protected Object colObj;
    protected Object[] columnWiseData;
    protected byte[] columnWiseLength;
    protected byte[] binaryData;
    protected int streamType;
    public static final short ASCII = 1;
    public static final short UNICODE = 2;
    public static final short BINARY = 3;
    protected long pA1 = 0L;
    protected long pA2 = 0L;
    protected long pB1 = 0L;
    protected long pB2 = 0L;
    protected long pC1 = 0L;
    protected long pC2 = 0L;
    protected long pS1 = 0L;
    protected long pS2 = 0L;

    public void setInputStream(JdbcOdbcInputStream paramJdbcOdbcInputStream) {
        this.inputStream = paramJdbcOdbcInputStream;
    }

    public void closeInputStream() {
        if (this.inputStream != null) {
            this.inputStream.invalidate();
            this.inputStream = null;
        }
    }

    public void setType(int paramInt) {
        this.type = paramInt;
    }

    public int getType() {
        return this.type;
    }

    public void setLength(int paramInt) {
        this.len = paramInt;
    }

    public int getLength() {
        return this.len;
    }

    public void setAliasName(String paramString) {
        this.aliasName = paramString;
        this.isRenamed = true;
    }

    public String mapAliasName(String paramString) {
        if (this.isRenamed) {
            return this.aliasName;
        }
        return paramString;
    }

    public void setColumnValue(Object paramObject, int paramInt) {
        try {
            if (this.type == -1 || this.type == -4) {
                if ((InputStream)paramObject != null) {
                    this.setInputStream((JdbcOdbcInputStream)paramObject);
                } else {
                    this.colObj = paramObject;
                }
            } else {
                this.colObj = paramObject;
            }
            this.setLength(paramInt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getColumnValue() {
        if (this.type == -1 || this.type == -4) {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            return this.colObj;
        }
        return this.colObj;
    }

    public JdbcOdbcInputStream getInputStream() {
        return this.inputStream;
    }

    public void initStagingArea(int paramInt) {
        this.rowSetSize = paramInt;
        this.columnWiseData = new Object[this.rowSetSize + 1];
        this.columnWiseLength = new byte[(this.rowSetSize + 1) * JdbcOdbcPlatform.getLengthBufferSize()];
        byte[] arrayOfByte = JdbcOdbcPlatform.convertIntToByteArray(-6);
        for (int i = 0; i < (this.rowSetSize + 1) * arrayOfByte.length; i += arrayOfByte.length) {
            for (int j = 0; j < arrayOfByte.length; ++j) {
                this.columnWiseLength[i + j] = arrayOfByte[j];
            }
        }
    }

    public void resetColumnToIgnoreData() {
        byte[] arrayOfByte = JdbcOdbcPlatform.convertIntToByteArray(-6);
        for (int i = 0; i < (this.rowSetSize + 1) * arrayOfByte.length; i += arrayOfByte.length) {
            for (int j = 0; j < arrayOfByte.length; ++j) {
                this.columnWiseLength[i + j] = arrayOfByte[j];
            }
        }
    }

    public void setRowValues(int paramInt1, Object paramObject, int paramInt2) {
        int i;
        this.columnWiseData[paramInt1] = paramObject;
        byte[] arrayOfByte = JdbcOdbcPlatform.convertIntToByteArray(paramInt2);
        for (int j = i = paramInt1 * arrayOfByte.length; j < i + arrayOfByte.length; ++j) {
            this.columnWiseLength[j] = arrayOfByte[j - i];
        }
    }

    public Object getRowValue(int paramInt) {
        return this.columnWiseData[paramInt];
    }

    public int getRowLenInd(int paramInt) {
        return this.columnWiseLength[paramInt];
    }

    public Object[] getRowValues() {
        return this.columnWiseData;
    }

    public byte[] getRowLengths() {
        return this.columnWiseLength;
    }

    public byte[] allocBindDataBuffer(int paramInt) {
        this.binaryData = new byte[paramInt];
        return this.binaryData;
    }

    public void setStreamType(int paramInt) {
        this.streamType = paramInt;
    }

    public int getStreamType() {
        return this.streamType;
    }
}

