/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPseudoCol;
import sun.jdbc.odbc.JdbcOdbcResultSetInterface;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcOdbcResultSetMetaData
extends JdbcOdbcObject
implements ResultSetMetaData {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcResultSetInterface resultSet;
    protected long hStmt;

    public JdbcOdbcResultSetMetaData(JdbcOdbc paramJdbcOdbc, JdbcOdbcResultSetInterface paramJdbcOdbcResultSetInterface) {
        this.OdbcApi = paramJdbcOdbc;
        this.resultSet = paramJdbcOdbcResultSetInterface;
        this.hStmt = paramJdbcOdbcResultSetInterface.getHSTMT();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.resultSet.getColumnCount();
    }

    @Override
    public boolean isAutoIncrement(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isAutoIncrement (" + paramInt + ")");
        }
        boolean bool = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null ? false : this.getColAttributeBoolean(paramInt, 11);
        return bool;
    }

    @Override
    public boolean isCaseSensitive(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isCaseSensitive (" + paramInt + ")");
        }
        boolean bool = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null ? false : this.getColAttributeBoolean(paramInt, 12);
        return bool;
    }

    @Override
    public boolean isSearchable(int paramInt) throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isSearchable (" + paramInt + ")");
        }
        boolean bool = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null ? false : (i = this.getColAttribute(paramInt, 13)) != 0;
        return bool;
    }

    @Override
    public boolean isCurrency(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isCurrency (" + paramInt + ")");
        }
        boolean bool = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null ? false : this.getColAttributeBoolean(paramInt, 9);
        return bool;
    }

    @Override
    public int isNullable(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isNullable (" + paramInt + ")");
        }
        int i = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null ? 0 : this.getColAttribute(paramInt, 7);
        return i;
    }

    @Override
    public boolean isSigned(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isSigned (" + paramInt + ")");
        }
        boolean bool = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null ? false : !this.getColAttributeBoolean(paramInt, 8);
        return bool;
    }

    @Override
    public int getColumnDisplaySize(int paramInt) throws SQLException {
        JdbcOdbcPseudoCol localJdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnDisplaySize (" + paramInt + ")");
        }
        int i = (localJdbcOdbcPseudoCol = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt))) != null ? localJdbcOdbcPseudoCol.getColumnDisplaySize() : this.getColAttribute(paramInt, 6);
        return i;
    }

    @Override
    public String getColumnLabel(int paramInt) throws SQLException {
        JdbcOdbcPseudoCol localJdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnLabel (" + paramInt + ")");
        }
        String str = (localJdbcOdbcPseudoCol = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt))) != null ? localJdbcOdbcPseudoCol.getColumnLabel() : this.getColAttributeString(paramInt, 18);
        str = this.resultSet.mapColumnName(str, paramInt);
        return str;
    }

    @Override
    public String getColumnName(int paramInt) throws SQLException {
        JdbcOdbcPseudoCol localJdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnName (" + paramInt + ")");
        }
        String str = (localJdbcOdbcPseudoCol = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt))) != null ? localJdbcOdbcPseudoCol.getColumnLabel() : this.getColAttributeString(paramInt, 1);
        str = this.resultSet.mapColumnName(str, paramInt);
        return str;
    }

    @Override
    public String getSchemaName(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getSchemaName (" + paramInt + ")");
        }
        if (this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null) {
            paramInt = 1;
        }
        return this.getColAttributeString(paramInt, 16);
    }

    @Override
    public int getPrecision(int paramInt) throws SQLException {
        JdbcOdbcPseudoCol localJdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getPrecision (" + paramInt + ")");
        }
        int i = (localJdbcOdbcPseudoCol = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt))) != null ? localJdbcOdbcPseudoCol.getColumnDisplaySize() - 1 : this.getColAttribute(paramInt, 4);
        return i;
    }

    @Override
    public int getScale(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getScale (" + paramInt + ")");
        }
        return this.resultSet.getScale(paramInt);
    }

    @Override
    public String getTableName(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getTableName (" + paramInt + ")");
        }
        if (this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null) {
            paramInt = 1;
        }
        return this.getColAttributeString(paramInt, 15);
    }

    @Override
    public String getCatalogName(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getCatalogName (" + paramInt + ")");
        }
        if (this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null) {
            paramInt = 1;
        }
        return this.getColAttributeString(paramInt, 17);
    }

    @Override
    public int getColumnType(int paramInt) throws SQLException {
        JdbcOdbcPseudoCol localJdbcOdbcPseudoCol;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnType (" + paramInt + ")");
        }
        int i = (localJdbcOdbcPseudoCol = this.resultSet.getPseudoCol(paramInt)) != null ? localJdbcOdbcPseudoCol.getColumnType() - 1 : this.resultSet.getColumnType(paramInt);
        return i;
    }

    @Override
    public String getColumnTypeName(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnTypeName (" + paramInt + ")");
        }
        String str = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null ? "" : this.getColAttributeString(paramInt, 14);
        return str;
    }

    @Override
    public boolean isReadOnly(int paramInt) throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isReadOnly (" + paramInt + ")");
        }
        boolean bool = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null ? true : (i = this.getColAttribute(paramInt, 10)) == 0;
        return bool;
    }

    @Override
    public boolean isWritable(int paramInt) throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isWritable (" + paramInt + ")");
        }
        boolean bool = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null ? false : (i = this.getColAttribute(paramInt, 10)) == 2;
        return bool;
    }

    @Override
    public boolean isDefinitelyWritable(int paramInt) throws SQLException {
        int i;
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.isDefinitelyWritable (" + paramInt + ")");
        }
        boolean bool = this.resultSet.getPseudoCol(paramInt = this.resultSet.mapColumn(paramInt)) != null ? false : (i = this.getColAttribute(paramInt, 10)) == 1;
        return bool;
    }

    @Override
    public String getColumnClassName(int paramInt) throws SQLException {
        if (this.OdbcApi.getTracer().isTracing()) {
            this.OdbcApi.getTracer().trace("*ResultSetMetaData.getColumnClassName (" + paramInt + ")");
        }
        String str = new String().getClass().getName();
        int i = this.getColumnType(paramInt);
        switch (i) {
            case 2: 
            case 3: {
                str = new BigDecimal(0).getClass().getName();
                break;
            }
            case -7: {
                str = new Boolean(false).getClass().getName();
                break;
            }
            case -6: {
                str = new Byte("0").getClass().getName();
                break;
            }
            case 5: {
                str = new Short("0").getClass().getName();
                break;
            }
            case 4: {
                str = new Integer(0).getClass().getName();
                break;
            }
            case -5: {
                str = new Long(0L).getClass().getName();
                break;
            }
            case 7: {
                str = new Float(0.0f).getClass().getName();
                break;
            }
            case 6: 
            case 8: {
                str = new Double(0.0).getClass().getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] arrayOfByte = new byte[]{};
                str = arrayOfByte.getClass().getName();
                break;
            }
            case 91: {
                str = new Date(123456L).getClass().getName();
                break;
            }
            case 92: {
                str = new Time(123456L).getClass().getName();
                break;
            }
            case 93: {
                str = new Timestamp(123456L).getClass().getName();
            }
        }
        return str;
    }

    protected int getColAttribute(int paramInt1, int paramInt2) throws SQLException {
        return this.resultSet.getColAttribute(paramInt1, paramInt2);
    }

    protected boolean getColAttributeBoolean(int paramInt1, int paramInt2) throws SQLException {
        int i = this.getColAttribute(paramInt1, paramInt2);
        boolean bool = false;
        if (i == 1) {
            bool = true;
        }
        return bool;
    }

    protected String getColAttributeString(int paramInt1, int paramInt2) throws SQLException {
        String str = "";
        this.resultSet.clearWarnings();
        try {
            str = this.OdbcApi.SQLColAttributesString(this.hStmt, paramInt1, paramInt2);
        }
        catch (JdbcOdbcSQLWarning localJdbcOdbcSQLWarning) {
            str = (String)localJdbcOdbcSQLWarning.value;
            this.resultSet.setWarning(JdbcOdbc.convertWarning(localJdbcOdbcSQLWarning));
        }
        return str.trim();
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return false;
    }
}

