/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcCallableStatement;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcDatabaseMetaData;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPreparedStatement;
import sun.jdbc.odbc.JdbcOdbcStatement;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.JdbcOdbcTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcOdbcConnection
extends JdbcOdbcObject
implements JdbcOdbcConnectionInterface {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcDriverInterface myDriver;
    protected long hEnv;
    protected long hDbc;
    protected SQLWarning lastWarning;
    protected boolean closed;
    protected String URL;
    protected int odbcVer;
    protected Hashtable typeInfo;
    public WeakHashMap statements;
    protected Hashtable batchStatements;
    protected short rsTypeFO;
    protected short rsTypeSI;
    protected short rsTypeSS;
    protected short rsTypeBest;
    protected int rsBlockSize;
    protected int batchInStatements;
    protected int batchInProcedures;
    protected int batchInPrepares;
    private boolean freeStmtsFromConnectionOnly;
    protected JdbcOdbcTracer tracer = new JdbcOdbcTracer();

    public JdbcOdbcConnection(JdbcOdbc paramJdbcOdbc, long paramLong, JdbcOdbcDriverInterface paramJdbcOdbcDriverInterface) {
        this.OdbcApi = paramJdbcOdbc;
        this.tracer = this.OdbcApi.getTracer();
        this.myDriver = paramJdbcOdbcDriverInterface;
        this.hEnv = paramLong;
        this.hDbc = 0L;
        this.URL = null;
        this.lastWarning = null;
        this.closed = true;
        this.freeStmtsFromConnectionOnly = false;
    }

    protected void finalize() {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Connection.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void initialize(String paramString, Properties paramProperties, int paramInt) throws SQLException {
        String str3;
        String localObject1 = "";
        String localObject2 = "";
        String localObject3 = null;
        String localObject4 = null;
        String localObject5 = null;
        String localObject6 = "";
        if (this.closed) {
            this.hDbc = this.myDriver.allocConnection(this.hEnv);
        }
        if (paramInt > 0) {
            this.setLoginTimeout(paramInt);
        }
        if ((str3 = paramProperties.getProperty("odbcRowSetSize")) != null) {
            this.setResultSetBlockSize(str3);
        }
        this.OdbcApi.charSet = paramProperties.getProperty("charSet", System.getProperty("file.encoding"));
        String str4 = paramProperties.getProperty("licfile", "");
        String str5 = paramProperties.getProperty("licpwd", "");
        String str1 = paramProperties.getProperty("user", "");
        String str2 = paramProperties.getProperty("password", "");
        String str6 = null;
        str6 = paramString.indexOf("DRIVER") != -1 || paramString.indexOf("Driver") != -1 || paramString.indexOf("driver") != -1 ? paramString : "DSN=" + paramString;
        StringTokenizer localStringTokenizer = new StringTokenizer(str6, ";", false);
        if (localStringTokenizer.countTokens() > 1) {
            int i = 0;
            while (localStringTokenizer.hasMoreTokens()) {
                ++i;
                String str10 = localStringTokenizer.nextToken();
                if (str10.startsWith("user")) {
                    localObject3 = str10;
                    continue;
                }
                if (str10.startsWith("password")) {
                    localObject4 = str10;
                    continue;
                }
                if (str10.startsWith("odbcRowSetSize")) {
                    localObject5 = str10;
                    continue;
                }
                if (i > 1) {
                    localObject2 = localObject2 + ";" + str10;
                    continue;
                }
                localObject2 = localObject2 + str10;
            }
        } else {
            localObject2 = str6;
        }
        localObject1 = localObject2;
        try {
            StringBuffer localStringBuffer3;
            int m;
            if (str1.equals("") && localObject3 != null) {
                localObject6 = localObject3;
                String str7 = localObject3.substring(4);
                if (!str7.equals("")) {
                    if (localObject1.indexOf("UID=") == -1) {
                        localObject1 = localObject1 + ";UID" + str7;
                    } else {
                        m = localObject1.indexOf("UID=");
                        int n = localObject1.indexOf(";", m);
                        localStringBuffer3 = new StringBuffer(localObject1);
                        localStringBuffer3.replace(m, n, "UID=" + str7);
                        localObject1 = localStringBuffer3.toString();
                    }
                }
            } else if (!str1.equals("")) {
                if (localObject1.indexOf("UID=") == -1) {
                    localObject1 = localObject1 + ";UID=" + str1;
                } else {
                    int j = localObject1.indexOf("UID=");
                    m = localObject1.indexOf(";", j);
                    StringBuffer localStringBuffer1 = new StringBuffer(localObject1);
                    localStringBuffer1.replace(j, m, "UID=" + str1);
                    localObject1 = localStringBuffer1.toString();
                }
            }
            if (str2.equals("") && localObject4 != null) {
                localObject6 = localObject4;
                String str8 = localObject4.substring(8);
                if (localObject1.indexOf("UID=") != -1) {
                    if (localObject1.indexOf("PWD=") == -1) {
                        localObject1 = localObject1 + ";PWD" + str8;
                    } else {
                        m = localObject1.indexOf("PWD=");
                        int i1 = localObject1.indexOf(";", m);
                        localStringBuffer3 = new StringBuffer(localObject1);
                        localStringBuffer3.replace(m, i1, "PWD=" + str8);
                        localObject1 = localStringBuffer3.toString();
                    }
                }
            } else if (!str2.equals("") && localObject1.indexOf("UID=") != -1) {
                if (localObject1.indexOf("PWD=") == -1) {
                    localObject1 = localObject1 + ";PWD=" + str2;
                } else {
                    int k = localObject1.indexOf("PWD=");
                    m = localObject1.indexOf(";", k);
                    StringBuffer localStringBuffer2 = new StringBuffer(localObject1);
                    localStringBuffer2.replace(k, m, "PWD=" + str2);
                    localObject1 = localStringBuffer2.toString();
                }
            }
            if (str3 == null && localObject5 != null) {
                localObject6 = localObject5;
                String str9 = localObject5.substring(15);
                this.setResultSetBlockSize(str9);
            }
        }
        catch (StringIndexOutOfBoundsException localStringIndexOutOfBoundsException) {
            throw new SQLException("invalid property values [" + localObject6 + "]");
        }
        try {
            this.OdbcApi.SQLDriverConnect(this.hDbc, localObject1);
        }
        catch (SQLWarning localSQLWarning) {
            this.lastWarning = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            this.myDriver.closeConnection(this.hDbc);
            throw localSQLException;
        }
        this.closed = false;
        if (str4 == null || str5 != null) {
            // empty if block
        }
        this.statements = new WeakHashMap();
        this.batchStatements = new Hashtable();
        DatabaseMetaData localDatabaseMetaData = this.getMetaData();
        this.OdbcApi.odbcDriverName = localDatabaseMetaData.getDriverName() + " " + localDatabaseMetaData.getDriverVersion();
        if (this.tracer.isTracing()) {
            this.tracer.trace("Driver name:    " + localDatabaseMetaData.getDriverName());
            this.tracer.trace("Driver version: " + localDatabaseMetaData.getDriverVersion());
        } else {
            localDatabaseMetaData = null;
        }
        this.buildTypeInfo();
        this.checkScrollCursorSupport();
        this.checkBatchUpdateSupport();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public Statement createStatement(int paramInt1, int paramInt2) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.createStatement");
        }
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        JdbcOdbcStatement localJdbcOdbcStatement = new JdbcOdbcStatement(this);
        localJdbcOdbcStatement.initialize(this.OdbcApi, this.hDbc, l, null, paramInt1, paramInt2);
        localJdbcOdbcStatement.setBlockCursorSize(this.rsBlockSize);
        this.registerStatement(localJdbcOdbcStatement);
        return localJdbcOdbcStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String paramString) throws SQLException {
        return this.prepareStatement(paramString, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.prepareStatement (" + paramString + ")");
        }
        JdbcOdbcPreparedStatement localJdbcOdbcPreparedStatement = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        localJdbcOdbcPreparedStatement = new JdbcOdbcPreparedStatement(this);
        localJdbcOdbcPreparedStatement.initialize(this.OdbcApi, this.hDbc, l, this.typeInfo, paramInt1, paramInt2);
        try {
            this.OdbcApi.SQLPrepare(l, paramString);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            localJdbcOdbcPreparedStatement.close();
            throw localSQLException;
        }
        localJdbcOdbcPreparedStatement.initBoundParam();
        localJdbcOdbcPreparedStatement.setWarning(localObject);
        localJdbcOdbcPreparedStatement.setBlockCursorSize(this.rsBlockSize);
        localJdbcOdbcPreparedStatement.setSql(paramString);
        this.registerStatement(localJdbcOdbcPreparedStatement);
        return localJdbcOdbcPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String paramString) throws SQLException {
        return this.prepareCall(paramString, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.prepareCall (" + paramString + ")");
        }
        JdbcOdbcCallableStatement localJdbcOdbcCallableStatement = null;
        SQLWarning localObject = null;
        long l = this.OdbcApi.SQLAllocStmt(this.hDbc);
        localJdbcOdbcCallableStatement = new JdbcOdbcCallableStatement(this);
        localJdbcOdbcCallableStatement.initialize(this.OdbcApi, this.hDbc, l, this.typeInfo, paramInt1, paramInt2);
        try {
            this.OdbcApi.SQLPrepare(l, paramString);
        }
        catch (SQLWarning localSQLWarning) {
            localObject = localSQLWarning;
        }
        catch (SQLException localSQLException) {
            localJdbcOdbcCallableStatement.close();
            throw localSQLException;
        }
        localJdbcOdbcCallableStatement.initBoundParam();
        localJdbcOdbcCallableStatement.setWarning(localObject);
        localJdbcOdbcCallableStatement.setBlockCursorSize(this.rsBlockSize);
        localJdbcOdbcCallableStatement.setSql(paramString);
        this.registerStatement(localJdbcOdbcCallableStatement);
        return localJdbcOdbcCallableStatement;
    }

    @Override
    public String nativeSQL(String paramString) throws SQLException {
        String str;
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.nativeSQL (" + paramString + ")");
        }
        try {
            str = this.OdbcApi.SQLNativeSql(this.hDbc, paramString);
        }
        catch (SQLException localSQLException) {
            str = paramString;
        }
        return str;
    }

    @Override
    public void setAutoCommit(boolean paramBoolean) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.setAutoCommit (" + paramBoolean + ")");
        }
        int i = 1;
        this.validateConnection();
        if (!paramBoolean) {
            i = 0;
        }
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)102, i);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.getAutoCommit");
        }
        boolean bool = false;
        this.validateConnection();
        int i = (int)this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)102);
        if (i == 1) {
            bool = true;
        }
        return bool;
    }

    @Override
    public void commit() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.commit");
        }
        this.validateConnection();
        this.OdbcApi.SQLTransact(this.hEnv, this.hDbc, (short)0);
    }

    @Override
    public void rollback() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.rollback");
        }
        this.validateConnection();
        this.OdbcApi.SQLTransact(this.hEnv, this.hDbc, (short)1);
    }

    @Override
    public void close() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.close");
        }
        this.setFreeStmtsFromConnectionOnly();
        this.closeAllStatements();
        if (!this.closed) {
            this.myDriver.disconnect(this.hDbc);
            this.myDriver.closeConnection(this.hDbc);
        }
        this.closed = true;
        this.URL = null;
    }

    @Override
    public boolean isFreeStmtsFromConnectionOnly() {
        return this.freeStmtsFromConnectionOnly;
    }

    public void setFreeStmtsFromConnectionOnly() {
        this.freeStmtsFromConnectionOnly = true;
    }

    public void setFreeStmtsFromAnyWhere() {
        this.freeStmtsFromConnectionOnly = false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.getMetaData");
        }
        this.validateConnection();
        JdbcOdbcDatabaseMetaData localJdbcOdbcDatabaseMetaData = new JdbcOdbcDatabaseMetaData(this.OdbcApi, this);
        return localJdbcOdbcDatabaseMetaData;
    }

    @Override
    public void setReadOnly(boolean paramBoolean) throws SQLException {
        block4: {
            if (this.tracer.isTracing()) {
                this.tracer.trace("*Connection.setReadOnly (" + paramBoolean + ")");
            }
            int i = 0;
            this.validateConnection();
            if (paramBoolean) {
                i = 1;
            }
            try {
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)101, i);
            }
            catch (SQLException localSQLException) {
                if (!this.tracer.isTracing()) break block4;
                this.tracer.trace("setReadOnly exception ignored");
            }
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.isReadOnly");
        }
        boolean bool = false;
        this.validateConnection();
        int i = (int)this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)101);
        if (i == 1) {
            bool = true;
        }
        return bool;
    }

    @Override
    public void setCatalog(String paramString) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.setCatalog (" + paramString + ")");
        }
        this.validateConnection();
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)109, paramString);
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.getCatalog");
        }
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, (short)16);
    }

    @Override
    public void setTransactionIsolation(int paramInt) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.setTransactionIsolation (" + paramInt + ")");
        }
        this.validateConnection();
        switch (paramInt) {
            case 0: {
                this.setAutoCommit(true);
                break;
            }
            case 1: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 1);
                break;
            }
            case 2: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 2);
                break;
            }
            case 4: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 4);
                break;
            }
            case 8: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 8);
                break;
            }
            default: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, paramInt);
            }
        }
    }

    public void setLicenseFile(String paramString) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.setLicenseFile (" + paramString + ")");
        }
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)1041, paramString);
    }

    public void setLicensePassword(String paramString) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.setPassword (" + paramString + ")");
        }
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)1042, paramString);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.getTransactionIsolation");
        }
        int i = 0;
        this.validateConnection();
        int j = (int)this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)108);
        switch (j) {
            case 1: {
                i = 1;
                break;
            }
            case 2: {
                i = 2;
                break;
            }
            case 4: {
                i = 4;
                break;
            }
            case 8: {
                i = 8;
                break;
            }
            default: {
                i = j;
            }
        }
        return i;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Connection.getWarnings");
        }
        return this.lastWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    @Override
    public void validateConnection() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed");
        }
    }

    @Override
    public long getHDBC() {
        return this.hDbc;
    }

    public void setURL(String paramString) {
        this.URL = paramString;
    }

    @Override
    public String getURL() {
        return this.URL;
    }

    protected void setLoginTimeout(int paramInt) throws SQLException {
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)103, paramInt);
    }

    @Override
    public int getODBCVer() {
        if (this.odbcVer == 0) {
            String str;
            try {
                str = this.OdbcApi.SQLGetInfoString(this.hDbc, (short)10);
            }
            catch (SQLException localSQLException) {
                str = "-1";
            }
            Integer localInteger = new Integer(str.substring(0, 2));
            this.odbcVer = localInteger;
        }
        return this.odbcVer;
    }

    protected void checkBatchUpdateSupport() {
        this.batchInStatements = -1;
        this.batchInProcedures = -1;
        this.batchInPrepares = -1;
        int i = -1;
        int j = -1;
        boolean k = false;
        boolean m = false;
        boolean n = false;
        try {
            i = this.OdbcApi.SQLGetInfo(this.hDbc, (short)121);
            if ((i & 2) > 0) {
                k = true;
            }
            if ((i & 8) > 0) {
                m = true;
            }
            if (((j = this.OdbcApi.SQLGetInfo(this.hDbc, (short)120)) & 4) > 0) {
                this.batchInStatements = 4;
                this.batchInProcedures = 4;
            } else {
                if (k && (j & 2) > 0) {
                    this.batchInStatements = 2;
                }
                if (m && (j & 1) > 0) {
                    this.batchInProcedures = 1;
                }
            }
            i = this.OdbcApi.SQLGetInfo(this.hDbc, (short)153);
            if ((i & 1) > 0) {
                n = true;
                this.batchInPrepares = 1;
            }
        }
        catch (SQLException localSQLException) {
            this.batchInStatements = -1;
            this.batchInProcedures = -1;
            this.batchInPrepares = -1;
        }
    }

    @Override
    public int getBatchRowCountFlag(int paramInt) {
        switch (paramInt) {
            case 1: {
                return this.batchInStatements;
            }
            case 2: {
                return this.batchInPrepares;
            }
            case 3: {
                return this.batchInProcedures;
            }
        }
        return -1;
    }

    public void checkScrollCursorSupport() throws SQLException {
        short s = -1;
        int i = 0;
        int j = this.OdbcApi.SQLGetInfo(this.hDbc, (short)44);
        this.rsTypeFO = (short)-1;
        this.rsTypeSI = (short)-1;
        this.rsTypeSS = (short)-1;
        if ((j & 1) != 0) {
            this.rsTypeFO = 0;
        }
        if ((j & 0x10) != 0) {
            this.rsTypeSI = (short)3;
        }
        if ((j & 0x10) != 0 && ((i = this.getOdbcCursorAttr2(s = 3)) & 0x40) != 0) {
            this.rsTypeSS = s;
        }
        if ((j & 2) != 0 || (j & 8) != 0) {
            s = 1;
            i = this.getOdbcCursorAttr2(s);
            if ((i & 0x40) != 0) {
                this.rsTypeSS = s;
            } else {
                this.rsTypeSI = s;
            }
        }
        if ((j & 4) != 0 && ((i = this.getOdbcCursorAttr2(s = 2)) & 0x40) != 0) {
            this.rsTypeSS = s;
        }
        this.rsTypeBest = s;
        if (this.rsTypeBest == -1) {
            this.rsTypeBest = this.rsTypeSS;
        }
        if (this.rsTypeBest == -1) {
            this.rsTypeBest = this.rsTypeSI;
        }
        if (this.rsTypeBest == -1) {
            this.rsTypeBest = this.rsTypeFO;
        }
    }

    @Override
    public short getBestOdbcCursorType() {
        return this.rsTypeBest;
    }

    @Override
    public short getOdbcCursorType(int paramInt) {
        short s = -1;
        switch (paramInt) {
            case 1003: {
                s = this.rsTypeFO;
                break;
            }
            case 1004: {
                s = this.rsTypeSI;
                break;
            }
            case 1005: {
                s = this.rsTypeSS;
            }
        }
        return s;
    }

    @Override
    public short getOdbcConcurrency(int paramInt) {
        switch (paramInt) {
            case 1007: {
                return 1;
            }
            case 1008: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public int getOdbcCursorAttr2(short paramShort) throws SQLException {
        short s = 0;
        switch (paramShort) {
            case 0: {
                s = 147;
                break;
            }
            case 3: {
                s = 168;
                break;
            }
            case 1: {
                s = 151;
                break;
            }
            case 2: {
                s = 145;
            }
        }
        try {
            return this.OdbcApi.SQLGetInfo(this.hDbc, s);
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> paramMap) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected void buildTypeInfo() throws SQLException {
        this.typeInfo = new Hashtable();
        if (this.tracer.isTracing()) {
            this.tracer.trace("Caching SQL type information");
        }
        ResultSet localResultSet = this.getMetaData().getTypeInfo();
        boolean bool = localResultSet.next();
        while (bool) {
            String str = localResultSet.getString(1);
            int i = localResultSet.getInt(2);
            if (this.typeInfo.get(new Integer(i)) == null) {
                JdbcOdbcTypeInfo localJdbcOdbcTypeInfo = new JdbcOdbcTypeInfo();
                localJdbcOdbcTypeInfo.setName(str);
                localJdbcOdbcTypeInfo.setPrec(localResultSet.getInt(3));
                this.typeInfo.put(new Integer(i), localJdbcOdbcTypeInfo);
            }
            bool = localResultSet.next();
        }
        localResultSet.close();
    }

    protected void registerStatement(Statement paramStatement) {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Registering Statement " + paramStatement);
        }
        this.statements.put(paramStatement, "");
    }

    @Override
    public void deregisterStatement(Statement paramStatement) {
        if (this.statements.get(paramStatement) != null) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("deregistering Statement " + paramStatement);
            }
            this.statements.remove(paramStatement);
        }
    }

    public synchronized void closeAllStatements() throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("" + this.statements.size() + " Statement(s) to close");
        }
        if (this.statements.size() == 0) {
            return;
        }
        Set localSet = this.statements.keySet();
        Iterator localIterator = localSet.iterator();
        while (localIterator.hasNext()) {
            try {
                Statement localStatement = (Statement)localIterator.next();
                localStatement.close();
            }
            catch (Exception localException) {
                localSet = this.statements.keySet();
                localIterator = localSet.iterator();
            }
        }
        this.batchStatements = null;
    }

    @Override
    public synchronized void setBatchVector(Vector paramVector, Statement paramStatement) {
        int i = -1;
        if (this.tracer.isTracing()) {
            this.tracer.trace("setBatchVector " + paramStatement);
        }
        this.batchStatements.put(paramStatement, paramVector);
    }

    @Override
    public Vector getBatchVector(Statement paramStatement) {
        if (this.tracer.isTracing()) {
            this.tracer.trace("getBatchVector " + paramStatement);
        }
        return (Vector)this.batchStatements.get(paramStatement);
    }

    @Override
    public synchronized void removeBatchVector(Statement paramStatement) {
        if (this.tracer.isTracing()) {
            this.tracer.trace("removeBatchVector " + paramStatement);
        }
        this.batchStatements.remove(paramStatement);
    }

    protected void setResultSetBlockSize(String paramString) throws SQLException {
        this.rsBlockSize = 10;
        if (paramString != null) {
            paramString.trim();
            if (!paramString.equals("")) {
                try {
                    int i = new Integer(paramString);
                    if (i > 0) {
                        this.rsBlockSize = i;
                    }
                }
                catch (NumberFormatException localNumberFormatException) {
                    throw new SQLException("invalid property value: [odbcRowSetSize=" + paramString + "]");
                }
            }
        }
    }

    @Override
    public void setHoldability(int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint(String paramString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback(Savepoint paramSavepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createStatement(int paramInt1, int paramInt2, int paramInt3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2, int paramInt3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseSavepoint(Savepoint paramSavepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2, int paramInt3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String paramString, int paramInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String paramString, int[] paramArrayOfInt) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String paramString, String[] paramArrayOfString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(int paramInt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String paramString1, String paramString2) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(Properties paramProperties) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String paramString) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> paramClass) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> paramClass) throws SQLException {
        return false;
    }

    @Override
    public Struct createStruct(String paramString, Object[] paramArrayOfObject) throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String paramString, Object[] paramArrayOfObject) throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String paramString) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor paramExecutor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor paramExecutor, int paramInt) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

