/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.rzo.yajsw.log.PatternFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyFileHandler
extends StreamHandler {
    private MeteredStream meter;
    private boolean append;
    private int limit;
    private int count;
    private String pattern;
    private String lockFileName;
    private FileOutputStream lockStream;
    private File[] files;
    private static final int MAX_LOCKS = 100;
    private static HashMap locks = new HashMap();
    private FileChangeListner _listener = null;

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)fname.length();
        }
        if (!fname.getParentFile().exists()) {
            fname.getParentFile().mkdirs();
        }
        FileOutputStream fout = new FileOutputStream(fname.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, len);
        this.setOutputStream(this.meter);
    }

    private void configure() {
    }

    public MyFileHandler() throws IOException, SecurityException {
        this.configure();
        this.openFiles();
    }

    public MyFileHandler(String pattern) throws IOException, SecurityException {
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = 0;
        this.count = 1;
        this.openFiles();
    }

    public MyFileHandler(String pattern, boolean append) throws IOException, SecurityException {
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = 0;
        this.count = 1;
        this.append = append;
        this.openFiles();
    }

    public MyFileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.openFiles();
    }

    public MyFileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.openFiles();
    }

    public MyFileHandler(String pattern, int limit, int count, boolean append, PatternFormatter fileFormatter, Level logLevel, String encoding) throws SecurityException, IOException {
        this(pattern, limit, count, append);
        if (encoding != null) {
            this.setEncoding(encoding);
        }
        this.setFormatter(fileFormatter);
        this.setLevel(logLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openFiles() throws IOException {
        LogManager manager = LogManager.getLogManager();
        manager.checkAccess();
        if (this.count < 1) {
            throw new IllegalArgumentException("file count = " + this.count);
        }
        if (this.limit < 0) {
            this.limit = 0;
        }
        InitializationErrorManager em = new InitializationErrorManager();
        this.setErrorManager(em);
        int unique = -1;
        while (true) {
            if (++unique > 100) {
                throw new IOException("Couldn't get lock for " + this.pattern);
            }
            this.lockFileName = MyFileHandler.generate(this.pattern, 0, unique, this.count).toString() + ".lck";
            HashMap hashMap = locks;
            synchronized (hashMap) {
                FileChannel fc;
                if (locks.get(this.lockFileName) != null) {
                    continue;
                }
                try {
                    this.lockStream = new FileOutputStream(this.lockFileName);
                    fc = this.lockStream.getChannel();
                }
                catch (IOException ix) {
                    continue;
                }
                try {
                    FileLock fl = fc.tryLock();
                    if (fl != null) break;
                }
                catch (IOException ix) {
                    // empty catch block
                    break;
                }
            }
        }
        {
            locks.put(this.lockFileName, this.lockFileName);
        }
        this.files = new File[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.files[i] = MyFileHandler.generate(this.pattern, i, unique, this.count);
        }
        if (this.append) {
            this.open(this.files[0], true);
        } else {
            this.rotate();
        }
        Exception ex = em.lastException;
        if (ex == null) {
            this.setErrorManager(new ErrorManager());
            return;
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof SecurityException) {
            throw (SecurityException)ex;
        }
        throw new IOException("Exception: " + ex);
    }

    static File generate(String pattern, int generation, int unique, int count) throws IOException {
        File file = null;
        String word = "";
        int ix = 0;
        boolean sawg = false;
        boolean sawu = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File(word) : new File(file, word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = System.getProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    if (MyFileHandler.isSetUID()) {
                        throw new IOException("can't use %h in set UID program");
                    }
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'g') {
                    word = word + generation;
                    sawg = true;
                    ++ix;
                    continue;
                }
                if (ch2 == 'u') {
                    word = word + unique;
                    sawu = true;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = word + "%";
                    ++ix;
                    continue;
                }
            }
            word = word + ch;
        }
        if (count > 1 && !sawg && generation != 0) {
            word = word + "." + generation;
        }
        if (unique > 0 && !sawu && unique != 0) {
            word = word + "." + unique;
        }
        if (word.length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    private synchronized void rotate() {
        Level oldLevel = this.getLevel();
        this.setLevel(Level.OFF);
        super.close();
        for (int i = this.count - 2; i >= 0; --i) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (!f1.exists()) continue;
            if (f2.exists()) {
                f2.delete();
            } else if (this._listener != null) {
                this._listener.fileChange(f2, true);
            }
            f1.renameTo(f2);
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException ix) {
            this.reportError(null, ix, 4);
        }
        this.setLevel(oldLevel);
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        if (this.limit > 0 && this.meter.written >= this.limit) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    MyFileHandler.this.rotate();
                    return null;
                }
            });
        }
    }

    public File currentFile() {
        return this.files[0];
    }

    public LinkedList<File> getCurrentFiles() {
        LinkedList<File> result = new LinkedList<File>();
        for (File f : this.files) {
            if (!f.exists()) break;
            result.addLast(f);
        }
        return result;
    }

    public void setNewFileListner(FileChangeListner listener) {
        this._listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SecurityException {
        super.close();
        if (this.lockFileName == null) {
            return;
        }
        try {
            this.lockStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap hashMap = locks;
        synchronized (hashMap) {
            locks.remove(this.lockFileName);
        }
        new File(this.lockFileName).delete();
        this.lockFileName = null;
        this.lockStream = null;
    }

    private static native boolean isSetUID();

    private static class InitializationErrorManager
    extends ErrorManager {
        Exception lastException;

        private InitializationErrorManager() {
        }

        public void error(String msg, Exception ex, int code) {
            this.lastException = ex;
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += buff.length;
        }

        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += len;
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    static interface FileChangeListner {
        public void fileChange(File var1, boolean var2);
    }
}

