/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.app;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.wrapper.StateChangeListener;
import org.rzo.yajsw.wrapper.WrappedRuntimeProcess;

public class RuntimeJavaMain {
    static boolean _stop = false;
    static boolean _debug = false;

    public static void main(String[] args) {
        _debug = "true".equals(System.getProperty("wrapper.debug", "false"));
        final WrappedRuntimeProcess p = new WrappedRuntimeProcess();
        Configuration conf = p.getConfiguration();
        RuntimeJavaMain.clearKeys(conf, "wrapper.filter");
        RuntimeJavaMain.clearKeys(conf, "wrapper.tray");
        RuntimeJavaMain.clearKeys(conf, "wrapper.image.javawrapper");
        RuntimeJavaMain.clearKeys(conf, "wrapper.logfile");
        RuntimeJavaMain.clearKeys(conf, "wrapper.script");
        RuntimeJavaMain.clearKeys(conf, "wrapper.console.pipestreams");
        conf.setProperty("wrapper.control", (Object)"APPLICATION");
        conf.setProperty("wrapper.console.loglevel", (Object)"INFO");
        conf.setProperty("wrapper.logfile.loglevel", (Object)"NONE");
        if ("true".equals(System.getProperty("wrapper.runtime.java.default.shutdown", "false"))) {
            conf.setProperty("wrapper.on_exit.default", (Object)"SHUTDOWN");
        }
        conf.setProperty("wrapper.console.pipestreams", (Object)true);
        RuntimeJavaMain.stopIfRunning(conf);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                if (_debug) {
                    System.err.println("runtime process wrapper is shutting down, stopping runtime process");
                }
                p.stop();
            }
        }));
        p.addStateChangeListener(0, new StateChangeListener(){

            public void stateChange(int newState, int oldState) {
                if (_debug) {
                    System.err.println("wrapped runtime process stopped with exit code " + p.getExitCode());
                }
                p.shutdown();
                System.exit(p.getExitCode());
            }
        });
        p.start();
    }

    private static void stopIfRunning(Configuration conf) {
        int pid = -1;
        String file = conf.getString("wrapper.runtime.pidfile");
        if (file != null) {
            File f = new File(file);
            BufferedReader b = null;
            if (f.exists()) {
                try {
                    b = new BufferedReader(new FileReader(f));
                    pid = Integer.parseInt(b.readLine());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (b != null) {
                try {
                    b.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (pid != -1) {
                int shutdownWaitTime = conf.getInt("wrapper.shutdown.timeout", 30) * 1000;
                RuntimeJavaMain.stopProcess(shutdownWaitTime, pid);
            }
        }
    }

    private static void stopProcess(int timeout, int pid) {
        try {
            Process p = OperatingSystem.instance().processManagerInstance().getProcess(pid);
            if (p != null) {
                if (_debug) {
                    System.out.println("stopping process with pid/timeout " + pid + " " + timeout);
                }
                p.stop(timeout, 999);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void clearKeys(Configuration conf, String key) {
        if (conf.containsKey(key)) {
            conf.clearProperty(key);
        }
        Iterator keys = conf.getKeys(key);
        while (keys.hasNext()) {
            conf.clearProperty((String)keys.next());
        }
    }
}

