/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.wrapper;

import com.sun.jna.Platform;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.EnvironmentConfiguration;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class FileUtils {
    static Logger log = Logger.getLogger(FileUtils.class.getName());

    /*
     * WARNING - void declaration
     */
    public static Collection getFiles(String workingDir, String pattern) {
        ArrayList<File> result = new ArrayList<File>();
        File res = new File(pattern);
        if (res.exists() && res.isAbsolute()) {
            result.add(res);
            return result;
        }
        File workingDirectory = new File(workingDir);
        res = new File(workingDirectory.getAbsolutePath(), pattern);
        if (res.exists()) {
            result.add(res);
            return result;
        }
        String[] s = pattern.split("[\\\\|/]");
        String[] sh = s.length == 1 ? new String[]{".", s[0]} : s;
        if (!Platform.isWindows() && pattern.startsWith("/")) {
            if (sh[0].equals(".")) {
                sh[1] = "/" + sh[1];
            } else {
                sh[0] = "/" + sh[0];
            }
        }
        HashSet<String> paths = new HashSet<String>();
        paths.add(sh[0]);
        for (int i = 1; i < sh.length; ++i) {
            String file = sh[i];
            if (file.trim().length() == 0) continue;
            HashSet<String> newPaths = new HashSet<String>();
            for (String string : paths) {
                void var12_12;
                File path;
                if (string.endsWith(":")) {
                    String string2 = string + "/";
                }
                if (!((path = new File((String)var12_12)).isDirectory() && path.exists() && path.isAbsolute())) {
                    path = new File(workingDir, (String)var12_12);
                }
                Collection files = FileUtils.getWildcardFiles(path.getAbsolutePath(), file);
                for (File f : files) {
                    if (f.isDirectory()) {
                        newPaths.add(f.getPath());
                        continue;
                    }
                    if (!f.isFile()) continue;
                    result.add(f);
                }
            }
            paths = newPaths;
        }
        if (result.size() == 0) {
            log.warning("No files found for " + pattern);
        }
        return result;
    }

    private static Collection getWildcardFiles(String path, String file) {
        ArrayList<File> result = new ArrayList<File>();
        if ((file = file.trim()).equals(".") || file.equals("..")) {
            result.add(new File(path + "/" + file));
            return result;
        }
        File fPath = new File(path);
        try {
            if (!fPath.isDirectory()) {
                log.warning("classpath directory " + fPath.getCanonicalPath() + " not found");
                return result;
            }
        }
        catch (Exception ex) {
            log.warning("classpath directory " + path + " error" + ex.getMessage());
            return result;
        }
        WildcardFileFilter fileFilter = new WildcardFileFilter(file);
        File[] thisFiles = fPath.listFiles((FileFilter)fileFilter);
        for (int i = 0; i < thisFiles.length; ++i) {
            File f = thisFiles[i];
            if (f.exists()) {
                result.add(f);
                continue;
            }
            log.warning("classpath file " + f.getName() + "not found");
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(FileUtils.getFiles(".", "z:\\dev\\yajsw\\..\\yajsw\\*.jar").size());
        try {
            CompositeConfiguration compConfig = new CompositeConfiguration();
            BaseConfiguration configuraton = new BaseConfiguration();
            compConfig.addConfiguration((Configuration)new EnvironmentConfiguration());
            configuraton.setProperty("wrapper.java.classpath.1", (Object)"${VERSANT_ROOT}/lib/jvi.*jar");
            configuraton.setProperty("wrapper.java.classpath.2", (Object)"${GROOVY_HOME}/lib/*.jar");
            compConfig.addConfiguration((Configuration)configuraton);
            System.out.println("Configuration: " + ConfigurationConverter.getProperties((Configuration)compConfig));
            System.out.println("subset: " + ConfigurationConverter.getProperties((Configuration)compConfig.subset("wrapper.java")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

