/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.updater;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.JavaHome;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.updater.InstallerBooter;
import org.rzo.yajsw.updater.UpdateAction;
import org.rzo.yajsw.util.Utils;

public class InstallAction {
    static YajswConfigurationImpl _currentConfig;
    static String _newConfig;
    static String _wrapperHome;
    static Process _p;

    public static void setWrapperHome(String wrapperHome) {
        _wrapperHome = wrapperHome;
    }

    public static void setCurrentConfig(YajswConfigurationImpl config) {
        _currentConfig = config;
    }

    public static void setNewConfig(String newConfig) {
        _newConfig = newConfig;
    }

    public static void run() {
        try {
            if (_p != null) {
                return;
            }
            if (_currentConfig == null || _newConfig == null || _wrapperHome == null) {
                return;
            }
            _p = OperatingSystem.instance().processManagerInstance().createProcess();
            _p.setCommand(InstallAction.getInstallerCommand());
            _p.setPipeStreams(false, false);
            _p.setVisible(false);
            _p.setDebug(true);
            _p.setWorkingDir(WrapperLoader.getWrapperHome());
            _p.start();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    private static String[] getInstallerCommand() {
        ArrayList<Object> result = new ArrayList<Object>();
        JavaHome javaHome = OperatingSystem.instance().getJavaHome((Configuration)_currentConfig);
        String java = javaHome.findJava(_currentConfig.getString("wrapper.java.command"), _currentConfig.getString("wrapper.java.customProcName"));
        result.add(java);
        result.add("-classpath");
        result.add(InstallAction.getWrapperJar() + File.pathSeparator + InstallAction.getWrapperAppJar());
        for (Object obj : System.getProperties().keySet()) {
            String key = (String)obj;
            result.add(Utils.getDOption(key, System.getProperty(key)));
        }
        result.add(InstallerBooter.class.getName());
        result.add(new File(_currentConfig.getCachedPath(false)).getAbsolutePath());
        result.add(_newConfig);
        String[] arrResult = new String[result.size()];
        for (int i = 0; i < arrResult.length; ++i) {
            arrResult[i] = (String)result.get(i);
        }
        return arrResult;
    }

    private static String getWrapperJar() {
        return _wrapperHome + File.separator + "wrapper.jar";
    }

    private static String getWrapperAppJar() {
        return _wrapperHome + File.separator + "wrapperApp.jar";
    }

    public static void main(String[] args) {
        UpdateAction.setUpdateConfig("z:/dev/yajsw/update.conf");
        System.setProperty("wrapper.config", "z:/dev/yajsw/conf/wrapper.helloworld.conf");
        YajswConfigurationImpl conf = new YajswConfigurationImpl();
        UpdateAction.setCurrentConfig(conf);
        System.out.println("service " + conf.getString("wrapper.ntservice.name", "?"));
        UpdateAction.run();
    }
}

