/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.script;

import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.rzo.yajsw.script.AbstractScript;
import org.rzo.yajsw.util.DaemonThreadFactory;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class ShellScript
extends AbstractScript {
    String[] _cmd;
    AtomicReference<Process> p = new AtomicReference();
    protected static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("yajsw.shellscript"));

    public ShellScript(String script, String id, WrappedProcess process, String[] args, int timeout, int maxConcInvocations) {
        super(script, id, process, args, timeout, maxConcInvocations);
        if (script.endsWith(".sh")) {
            this._cmd = new String[]{"/bin/sh"};
        }
        if (script.endsWith("bat")) {
            this._cmd = new String[]{"cmd", "/c"};
        }
    }

    @Override
    public Object execute(String line) {
        String id = this._id;
        String state = this._process != null ? this._process.getStringState() : "?";
        String count = this._process != null ? "" + this._process.getRestartCount() : "?";
        String pid = this._process != null ? "" + this._process.getAppPid() : "?";
        String exitCode = this._process != null ? "" + this._process.getExitCode() : "?";
        String[] cmd = this._cmd == null ? new String[7] : new String[this._cmd.length + 7];
        int i = 0;
        if (this._cmd != null) {
            for (i = 0; i < this._cmd.length; ++i) {
                cmd[i] = this._cmd[i];
            }
        }
        cmd[i] = this.getScript();
        cmd[i + 1] = id;
        cmd[i + 2] = state;
        cmd[i + 3] = count;
        cmd[i + 4] = pid;
        cmd[i + 5] = exitCode;
        cmd[i + 6] = line == null ? "?" : line;
        Object ccmd = "";
        for (String x : cmd) {
            ccmd = (String)ccmd + x + " ";
        }
        try {
            String result = this.osCommand(cmd, this._timeout);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void interrupt() {
        if (this.p.get() != null) {
            this.p.get().destroy();
        }
        this.p.set(null);
        if (this._future != null) {
            this._future.cancel(true);
        }
    }

    @Override
    void log(String msg) {
        if (this._process != null && this._process.getInternalWrapperLogger() != null) {
            this._process.getInternalWrapperLogger().info(msg);
        } else {
            System.out.println(msg);
        }
    }

    void log(Exception e) {
        if (this._process != null && this._process.getInternalWrapperLogger() != null) {
            this._process.getInternalWrapperLogger().warn(e);
        } else {
            e.printStackTrace();
        }
    }

    public String osCommand(String[] cmd, long timeout) {
        try {
            this.p.set(Runtime.getRuntime().exec(cmd));
            FutureTask future = new FutureTask(new Callable(){

                public String call() throws Exception {
                    int y;
                    int x;
                    StringBuffer result = new StringBuffer();
                    InputStream in = ShellScript.this.p.get().getInputStream();
                    InputStream err = ShellScript.this.p.get().getErrorStream();
                    while ((x = in.read()) != -1) {
                        result.append((char)x);
                    }
                    while ((y = err.read()) != -1) {
                        result.append((char)y);
                    }
                    return result.toString();
                }
            });
            executor.execute(future);
            String result = (String)future.get(timeout, TimeUnit.MILLISECONDS);
            return result;
        }
        catch (Exception e) {
            this.log("Error executing \"" + this.getScript() + "\": " + e);
            this.log(e);
            this.interrupt();
            return null;
        }
    }
}

