/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix.bsd.macosx;

import com.sun.jna.Native;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.rzo.yajsw.io.CyclicBufferFileInputStream;
import org.rzo.yajsw.io.CyclicBufferFilePrintStream;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.os.posix.PosixProcess;

public class MacOsXProcess
extends PosixProcess {
    @Override
    public String getStdInName() {
        return "__stdinp";
    }

    @Override
    public String getStdOutName() {
        return "__stdoutp";
    }

    @Override
    public String getStdErrName() {
        return "__stderrp";
    }

    @Override
    public int getCurrentCpu() {
        return -1;
    }

    @Override
    public int getCurrentThreads() {
        return -1;
    }

    @Override
    public long getCurrentPhysicalMemory() {
        return -1L;
    }

    @Override
    public long getCurrentVirtualMemory() {
        return -1L;
    }

    @Override
    public int getCurrentPageFaults() {
        return -1;
    }

    @Override
    public boolean start() {
        if (this._arrCmd == null && this._cmd == null) {
            return false;
        }
        if (this._arrCmd == null) {
            this._arrCmd = this._cmd.split(" ");
            if (this._debug) {
                this.log("exec: " + this._cmd);
            }
        } else {
            Object cmd = "";
            for (String c : this._arrCmd) {
                cmd = (String)cmd + c + " ";
            }
            if (this._debug) {
                this.log("exec:" + (String)cmd);
            }
        }
        this.log("starting ");
        int pid = 0;
        this._exitCode = -2;
        String title = this._title == null ? "yajsw" : this._title;
        this._terminated = false;
        if (this._visible) {
            this.setCommand(String.format("xterm -hold -sb -T %1$s -e %2$s", title, this.getCommand()));
        }
        if (this._visible) {
            this._pipeStreams = false;
        }
        if ((pid = PosixProcess.CLibrary.INSTANCE.fork()) == 0) {
            int stdout = this.getStdOutNo();
            int stderr = this.getStdErrNo();
            int stdin = this.getStdInNo();
            PosixProcess.CLibrary.INSTANCE.close(this._inPipe[1]);
            this.moveDescriptor(this._inPipe[0], stdin);
            PosixProcess.CLibrary.INSTANCE.close(this._outPipe[0]);
            this.moveDescriptor(this._outPipe[1], stdout);
            PosixProcess.CLibrary.INSTANCE.close(this._errPipe[0]);
            this.moveDescriptor(this._errPipe[1], stderr);
            PosixProcess.CLibrary.INSTANCE.umask(0);
            if (PosixProcess.CLibrary.INSTANCE.setsid() < 0) {
                PosixProcess.CLibrary.INSTANCE.exit(-1);
            }
            if (this.getWorkingDir() != null && PosixProcess.CLibrary.INSTANCE.chdir(this.getWorkingDir()) != 0) {
                this.log("could not set working dir");
            }
            if (this._priority == -1) {
                if (PosixProcess.CLibrary.INSTANCE.nice(1) == -1) {
                    this.log("could not set priority ");
                }
            } else if (this._priority == -2) {
                if (PosixProcess.CLibrary.INSTANCE.nice(2) == -1) {
                    this.log("could not set priority ");
                }
            } else if (this._priority == 1) {
                if (PosixProcess.CLibrary.INSTANCE.nice(-1) == -1) {
                    this.log("could not set priority ");
                }
            } else if (this._priority == 2 && PosixProcess.CLibrary.INSTANCE.nice(-2) == -1) {
                this.log("could not set priority ");
            }
            if (this.getUser() != null) {
                this.switchUser(this.getUser(), this.getPassword());
            }
            try {
                int res = PosixProcess.CLibrary.INSTANCE.execvp(this._arrCmd[0], this._arrCmd);
                int err = Native.getLastError();
                this.log("errno " + err + " " + PosixProcess.CLibrary.INSTANCE.strerror(err));
                this.log("exec res " + res);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.lock = false;
        } else {
            if (pid > 0) {
                this._pid = pid;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException stdout) {
                    // empty catch block
                }
                if (this._teeName != null && this._tmpPath != null) {
                    File f = new File(this._tmpPath);
                    try {
                        if (!f.exists()) {
                            f.mkdir();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Thread.currentThread().interrupt();
                    }
                    try {
                        this._inputStream = new CyclicBufferFileInputStream(this.createRWfile(this._tmpPath, "out_" + this._teeName));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this._errorStream = new CyclicBufferFileInputStream(this.createRWfile(this._tmpPath, "err_" + this._teeName));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this._outputStream = new CyclicBufferFilePrintStream(this.createRWfile(this._tmpPath, "in_" + this._teeName));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this._pipeStreams && this._teeName == null && this._tmpPath == null) {
                    this.writefd(this.in_fd, this._inPipe[1]);
                    this.writefd(this.out_fd, this._outPipe[0]);
                    this.writefd(this.err_fd, this._errPipe[0]);
                    this._outputStream = new BufferedOutputStream(new FileOutputStream(this.in_fd));
                    this._inputStream = new BufferedInputStream(new FileInputStream(this.out_fd));
                    this._errorStream = new BufferedInputStream(new FileInputStream(this.err_fd));
                    PosixProcess.CLibrary.INSTANCE.close(this._inPipe[0]);
                    PosixProcess.CLibrary.INSTANCE.close(this._outPipe[1]);
                    PosixProcess.CLibrary.INSTANCE.close(this._errPipe[1]);
                }
                this.handleAffinity();
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        int r = PosixProcess.CLibrary.INSTANCE.waitpid(MacOsXProcess.this._pid, MacOsXProcess.this.status, 0);
                        if (r == MacOsXProcess.this._pid) {
                            MacOsXProcess.this._exitCode = MacOsXProcess.this.status.getValue();
                        }
                        MacOsXProcess.this.log("exit code linux process " + MacOsXProcess.this._exitCode);
                        MacOsXProcess.this._terminated = true;
                    }
                });
                return true;
            }
            if (pid < 0) {
                this.log("failed to fork: " + pid);
                return false;
            }
        }
        return false;
    }

    private String getCurrentJava() {
        int myPid = OperatingSystem.instance().processManagerInstance().currentProcessId();
        Process myProcess = OperatingSystem.instance().processManagerInstance().getProcess(myPid);
        String cmd = myProcess.getCommand();
        String jvm = null;
        jvm = cmd.startsWith("\"") ? cmd.substring(0, cmd.indexOf("\" ") + 1) : cmd.substring(0, cmd.indexOf(" "));
        return jvm;
    }

    public String getCommandInternal() {
        if (this._pid < 0) {
            return null;
        }
        String cmd = String.format("ps -p %1$s -o command", this._pid);
        String res = this._utils.osCommand(cmd, 5000L);
        if (res == null) {
            return null;
        }
        String[] resx = res.split(System.getProperty("line.separator"));
        return resx[1];
    }

    @Override
    public String getUserInternal() {
        if (this._pid < 0) {
            return null;
        }
        String cmd = String.format("ps -p %1$s -o user", this._pid);
        String res = this._utils.osCommand(cmd, 5000L);
        if (res == null) {
            return null;
        }
        String[] resx = res.split(System.getProperty("line.separator"));
        return resx[1];
    }

    @Override
    public String getWorkingDirInternal() {
        if (this._pid < 0) {
            return null;
        }
        return null;
    }

    public static Process getProcess(int pid) {
        MacOsXProcess result = null;
        result = new MacOsXProcess();
        result.setPid(pid);
        result.setUser(result.getUserInternal());
        result.setCommand(result.getCommandInternal());
        result.setWorkingDir(result.getWorkingDirInternal());
        if (result.getCommand() == null) {
            return null;
        }
        return result;
    }

    @Override
    public void waitFor(long timeout) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            if (!this.isRunning()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (this._logger != null) {
                    this._logger.throwing(PosixProcess.class.getName(), "waitFor", e);
                }
                Thread.currentThread().interrupt();
            }
        }
    }
}

