/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.rzo.yajsw.util.DaemonThreadFactory;

public class PosixUtils {
    protected static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("util.osCommand"));
    protected Logger _logger;

    public void setLog(Logger logger) {
        this._logger = logger;
    }

    public String readFile(String file) {
        Object result = "";
        File f = new File(file);
        if (f.exists()) {
            try {
                FileInputStream in = new FileInputStream(f);
                byte[] buffer = new byte[10240];
                int size = 0;
                String rest = "";
                while ((size = ((InputStream)in).read(buffer)) > 0) {
                    for (int i = 0; i < size; ++i) {
                        if (buffer[i] != 0) continue;
                        buffer[i] = 32;
                    }
                    result = (String)result + new String(buffer, 0, size);
                }
                ((InputStream)in).close();
            }
            catch (Exception e) {
                if (this._logger != null) {
                    this._logger.throwing(PosixUtils.class.getName(), "readFile", e);
                }
            }
        } else if (this._logger != null) {
            this._logger.info("could not find file " + f.getAbsolutePath());
        }
        return result;
    }

    public String readFileQuoted(String file) {
        ArrayList<String> result = new ArrayList<String>();
        File f = new File(file);
        if (f.exists()) {
            try {
                FileInputStream in = new FileInputStream(f);
                byte[] buffer = new byte[10240];
                int size = 0;
                String rest = "";
                while ((size = ((InputStream)in).read(buffer)) > 0) {
                    int k = 0;
                    for (int i = 0; i < size; ++i) {
                        if (buffer[i] != 0) continue;
                        result.add(rest + new String(buffer, k, i - k));
                        rest = "";
                        k = i + 1;
                    }
                    rest = new String(buffer, k, size);
                }
                if (rest.length() > 0) {
                    result.add(rest);
                }
                ((InputStream)in).close();
            }
            catch (Exception e) {
                if (this._logger != null) {
                    this._logger.throwing(PosixUtils.class.getName(), "readFile", e);
                }
            }
        } else if (this._logger != null) {
            this._logger.info("could not find file " + f.getAbsolutePath());
        }
        return this.toQuotedString(result);
    }

    private String toQuotedString(List<String> strings) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strings.size(); ++i) {
            String x = strings.get(i);
            if (x.contains(" ") && !x.contains("\"") && !x.contains("'")) {
                sb.append("\"");
                sb.append(x);
                sb.append("\"");
            } else {
                sb.append(x);
            }
            if (i == strings.size()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String osCommand(String cmd) {
        StringBuffer result;
        block3: {
            result = new StringBuffer();
            try {
                int x;
                Process p = Runtime.getRuntime().exec(cmd);
                InputStream in = p.getInputStream();
                while ((x = in.read()) != -1) {
                    result.append((char)x);
                }
            }
            catch (Exception ex) {
                if (this._logger == null) break block3;
                this._logger.warning("Error executing \"" + cmd + "\": " + ex);
            }
        }
        return result.toString();
    }

    public String osCommand(String cmd, long timeout) {
        Process p = null;
        try {
            final Process fp = p = Runtime.getRuntime().exec(cmd);
            FutureTask future = new FutureTask(new Callable(){

                public String call() throws Exception {
                    int x;
                    StringBuffer result = new StringBuffer();
                    InputStream in = fp.getInputStream();
                    while ((x = in.read()) != -1) {
                        result.append((char)x);
                    }
                    return result.toString();
                }
            });
            executor.execute(future);
            String result = (String)future.get(timeout, TimeUnit.MILLISECONDS);
            return result;
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.warning("Error executing \"" + cmd + "\": " + e);
            }
            if (p != null) {
                p.destroy();
            }
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println(new PosixUtils().osCommand("cmd /C dir", 500L));
    }
}

