/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnacontrib.jna.Advapi32;
import jnacontrib.win32.Win32Service;
import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.os.AbstractService;
import org.rzo.yajsw.os.Service;
import org.rzo.yajsw.os.ServiceInfo;

public class WindowsXPService
extends AbstractService {
    MyWin32Service _service;

    @Override
    public boolean install() {
        Object command = "";
        for (int i = 0; i < this._command.length; ++i) {
            command = this._command[i].startsWith("\"") || !this._command[i].contains(" ") ? (String)command + this._command[i] + " " : (String)command + "\"" + this._command[i] + "\" ";
        }
        return this._service.install(this._displayName, this._description, this._dependencies, this._account, this._password, (String)command, this._startType, this._interactive, this._failureActions);
    }

    @Override
    public boolean start() {
        return this._service.start();
    }

    @Override
    public boolean stop() {
        try {
            return this._service.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static Service getService(String name) {
        WindowsXPService result = new WindowsXPService();
        result.setName(name);
        result.init();
        return result;
    }

    @Override
    public void init() {
        if (this._service == null) {
            this._service = new MyWin32Service(this._name);
        }
        if (this._config != null && this._config.getBoolean("wrapper.ntservice.interactive", false)) {
            this._interactive = true;
        }
    }

    @Override
    public boolean uninstall() {
        return this._service.uninstall();
    }

    @Override
    public int state() {
        if (this._service == null) {
            return 128;
        }
        return this._service.state();
    }

    public static Map<String, ServiceInfo> getServiceList() {
        HashMap<String, ServiceInfo> result = new HashMap<String, ServiceInfo>();
        Map<String, Advapi32.ENUM_SERVICE_STATUS_PROCESS> services = Win32Service.enumerateServices(null);
        for (String name : services.keySet()) {
            result.put(name, WindowsXPService.getServiceInfo(name));
        }
        return result;
    }

    public static ServiceInfo getServiceInfo(String name) {
        return Win32Service.serviceInfo(name);
    }

    public boolean requestElevation() {
        if (this._service != null) {
            return this._service.requestElevation();
        }
        return false;
    }

    public static Object getServiceFailureActions(Configuration config) {
        String cmd = config.getString("wrapper.ntservice.failure_actions.command", null);
        List actions = config.getList("wrapper.ntservice.failure_actions.actions", null);
        List actionsDelay = config.getList("wrapper.ntservice.failure_actions.actions_delay", new ArrayList());
        if (actions == null) {
            return null;
        }
        Advapi32.SC_ACTION[] scActions = (Advapi32.SC_ACTION[])new Advapi32.SC_ACTION().toArray(actions.size());
        int i = 0;
        int lastDelay = 0;
        for (Object action : actions) {
            if ("NONE".equals(action)) {
                scActions[i].Type = 0;
            } else if ("REBOOT".equals(action)) {
                scActions[i].Type = 2;
            } else if ("RESTART".equals(action)) {
                scActions[i].Type = 1;
            } else if ("COMMAND".equals(action)) {
                scActions[i].Type = 3;
            } else {
                System.out.println("ERROR: unknown failure action : " + action);
                System.out.println("Aborting setting failure actions");
                return null;
            }
            if (actionsDelay.size() > i) {
                try {
                    Object d = actionsDelay.get(i);
                    lastDelay = Integer.parseInt((String)d);
                }
                catch (Exception ex) {
                    System.out.println("Error: failure actions delay is not a number.");
                }
            }
            scActions[i].Delay = lastDelay;
            ++i;
        }
        Advapi32.SERVICE_FAILURE_ACTIONS result = new Advapi32.SERVICE_FAILURE_ACTIONS();
        result.dwResetPeriod = config.getInt("wrapper.ntservice.failure_actions.reset_period", 0);
        result.lpCommand = config.getString("wrapper.ntservice.failure_actions.command", "");
        result.lpRebootMsg = config.getString("wrapper.ntservice.failure_actions.reboot_msg", null);
        result.cActions = scActions.length;
        scActions[0].autoWrite();
        result.lpsaActions = scActions[0].getPointer();
        result.write();
        return result;
    }

    class MyWin32Service
    extends Win32Service {
        public MyWin32Service(String name) {
            super(name);
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onStop() {
        }

        @Override
        public void log(String txt, int level) {
            if (this._debug > level) {
                System.out.println(txt);
            }
        }
    }
}

