/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import com.sun.jna.Platform;
import io.netty.util.internal.logging.InternalLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import jnacontrib.win32.Registry;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.os.JavaHome;

public class WindowsJavaHome
implements JavaHome {
    Configuration _config;
    InternalLogger _logger;
    int _debug = 3;

    @Override
    public void setLogger(InternalLogger logger, int debug) {
        this._logger = logger;
        this._debug = debug;
    }

    WindowsJavaHome(Configuration config) {
        this._config = config;
    }

    @Override
    public String findJava(String wrapperJava, String customProcName) {
        Object java = null;
        if (wrapperJava != null && !((String)wrapperJava).endsWith(".exe") && !((String)wrapperJava).endsWith("}")) {
            wrapperJava = (String)wrapperJava + ".exe";
        }
        try {
            if (wrapperJava != null) {
                File f = new File((String)wrapperJava);
                if (!f.isAbsolute()) {
                    File f2 = new File(WrapperLoader.getWrapperHome(), (String)wrapperJava);
                    if (f2.exists()) {
                        try {
                            wrapperJava = f2.getCanonicalPath();
                        }
                        catch (IOException e) {
                            this._logger.warn("Exception in findJava()", e);
                        }
                    }
                } else if (!new File((String)(wrapperJava = new File((String)wrapperJava).getCanonicalPath())).exists()) {
                    this._logger.error("java file does not exist: " + (String)wrapperJava);
                    return null;
                }
            }
        }
        catch (Exception e) {
            this._logger.warn("Error in JavaHome.findJava(): ", e);
        }
        java = wrapperJava;
        boolean useJavaw = this._config.getBoolean("wrapper.java.command.javaw", wrapperJava != null && ((String)wrapperJava).endsWith("javaw.exe"));
        if (java == null) {
            String registryBase;
            String minVersion = this._config.getString("wrapper.java.command.minVersion");
            String maxVersion = this._config.getString("wrapper.java.command.maxVersion");
            boolean b64bit = this._config.getBoolean("wrapper.java.command.64bit", false);
            boolean jreOnly = this._config.getBoolean("wrapper.java.command.jreOnly", false);
            boolean preferJdk = this._config.getBoolean("wrapper.java.command.preferJdk", false);
            boolean preferJre = this._config.getBoolean("wrapper.java.command.preferJre", !preferJdk);
            boolean jdkOnly = this._config.getBoolean("wrapper.java.command.jdkOnly", false);
            String string = registryBase = Platform.is64Bit() && !b64bit ? "SOFTWARE\\Wow6432Node" : "SOFTWARE";
            if (!jdkOnly && (jreOnly || preferJre)) {
                java = this.findJavaInRegistry(new String[]{registryBase + "\\JavaSoft\\Java Runtime Environment", registryBase + "\\IBM\\Java2 Runtime Environment"}, minVersion, maxVersion, b64bit);
            }
            if (java == null && !jreOnly) {
                java = this.findJavaInRegistry(new String[]{registryBase + "\\JavaSoft\\Java Development Kit", registryBase + "\\IBM\\Java Development Kit"}, minVersion, maxVersion, b64bit);
            }
        } else if (customProcName != null) {
            Object h = java;
            File f = new File((String)h);
            java = f.exists() ? f.getParentFile().getParentFile().getAbsolutePath() : this.findJavaFromPath((String)java);
        } else {
            return java;
        }
        if (java == null) {
            return null;
        }
        File javaFile = new File((String)java);
        if (!javaFile.exists()) {
            return null;
        }
        java = javaFile.getAbsolutePath() + "/bin";
        java = !useJavaw ? (String)java + "/java.exe" : (String)java + "/javaw.exe";
        if (customProcName != null) {
            java = this.copyTotmp((String)java, customProcName);
        }
        if (this._logger == null) {
            System.out.println("using java: " + (String)java);
        } else if (this._debug > 1) {
            this._logger.info("using java: " + (String)java);
        }
        return java;
    }

    private String findJavaFromPath(String java) {
        String[] paths;
        File javaFile;
        if (java != null && (javaFile = new File(java)).exists()) {
            return java;
        }
        for (String path : paths = System.getenv("path").split(";")) {
            File javaFile2;
            if (!path.contains("jdk") && !path.contains("jre") || !(javaFile2 = new File(path)).exists()) continue;
            return path.substring(0, path.length() - 4);
        }
        return null;
    }

    private String copyTotmp(String java, String customProcName) {
        try {
            boolean isTmp = true;
            File javaFile = new File(java);
            File tmpJavaFile = null;
            try {
                File fc = new File(customProcName);
                if (fc.isAbsolute() && fc.getParentFile().exists()) {
                    tmpJavaFile = fc;
                    isTmp = false;
                }
            }
            catch (Exception fc) {
                // empty catch block
            }
            customProcName = customProcName.endsWith(".exe") ? customProcName.substring(0, customProcName.length() - 4) : customProcName;
            String exeName = "java_" + customProcName + "_";
            if (tmpJavaFile == null) {
                try {
                    tmpJavaFile = File.createTempFile(exeName, ".exe");
                    this.copyFile(javaFile, tmpJavaFile);
                }
                catch (Exception ex) {
                    this._logger.error("error creating tmp file: " + exeName, ex);
                }
            }
            if (!tmpJavaFile.exists()) {
                this.copyFile(javaFile, tmpJavaFile);
            }
            if (isTmp) {
                tmpJavaFile.deleteOnExit();
            }
            return tmpJavaFile.getAbsolutePath();
        }
        catch (Throwable e) {
            this._logger.error("error copying java: " + java + " -> " + customProcName, e);
            return null;
        }
    }

    void copyFile(File in, File out) throws IOException {
        this._logger.info("copying java: " + in.getAbsolutePath() + " -> " + out.getAbsolutePath());
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    private String findJavaFromJavaHomeEnv() {
        return System.getenv("JAVA_HOME");
    }

    private String findJavaInRegistry(String[] keys, String minVersion, String maxVersion, boolean b64bit) {
        String[] values = null;
        String result = null;
        String resultKey = null;
        String resultDir = null;
        minVersion = minVersion == null ? "1.1.0" : minVersion;
        maxVersion = maxVersion == null ? "99.99.99" : maxVersion;
        for (String key : keys) {
            try {
                for (String value : values = Registry.getSubKeys(Registry.REGISTRY_ROOT_KEY.LOCAL_MACHINE, key)) {
                    String dir = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.LOCAL_MACHINE, key + "\\" + value, "JavaHome");
                    boolean exists = false;
                    try {
                        exists = dir != null && new File(dir).exists();
                    }
                    catch (Exception ex) {
                        System.out.println("wrong registry key value: " + dir);
                    }
                    if (!exists || value.compareTo(maxVersion) > 0 || value.compareTo(minVersion) < 0) continue;
                    if (result == null) {
                        result = value;
                        resultKey = key;
                        resultDir = dir;
                        continue;
                    }
                    if (value.compareTo(result) < 0) continue;
                    result = value;
                    resultKey = key;
                    resultDir = dir;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultDir;
    }

    public static void main(String[] args) {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("wrapper.java.command", (Object)"java");
        WindowsJavaHome javaHome = new WindowsJavaHome((Configuration)conf);
        System.out.println(javaHome.findJava(conf.getString("wrapper.java.command"), conf.getString("wrapper.java.command")));
        conf.setProperty("wrapper.java.customProcName", (Object)"test");
        javaHome = new WindowsJavaHome((Configuration)conf);
        System.out.println(javaHome.findJava(conf.getString("wrapper.java.command"), conf.getString("wrapper.java.command")));
        conf.setProperty("wrapper.java.command", (Object)"javaw");
        javaHome = new WindowsJavaHome((Configuration)conf);
        System.out.println(javaHome.findJava(conf.getString("wrapper.java.command"), conf.getString("wrapper.java.command")));
        conf.clear();
        conf.setProperty("wrapper.java.minversion", (Object)"1.5.0");
        conf.setProperty("wrapper.java.maxversion", (Object)"1.5.99");
        conf.setProperty("wrapper.java.customProcName", (Object)"test");
        javaHome = new WindowsJavaHome((Configuration)conf);
        System.out.println(javaHome.findJava(conf.getString("wrapper.java.command"), conf.getString("wrapper.java.command")));
        conf.clear();
        conf.setProperty("wrapper.java.minversion", (Object)"1.6.0");
        conf.setProperty("wrapper.java.customProcName", (Object)"test");
        conf.setProperty("wrapper.java.preferJdk", (Object)true);
        javaHome = new WindowsJavaHome((Configuration)conf);
        System.out.println(javaHome.findJava(conf.getString("wrapper.java.command"), conf.getString("wrapper.java.command")));
    }
}

