/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.action;

import io.netty.channel.Channel;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import org.rzo.yajsw.action.Action;
import org.rzo.yajsw.controller.Message;

public class ThreadDumpImpl6
implements Action {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Message msg, Channel session, PrintStream out, Object data) throws IOException {
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        long[] ids = (long[])(data == null ? (Object)thbean.getAllThreadIds() : data);
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        HashMap<Long, Thread> threadIds = new HashMap<Long, Thread>();
        for (Thread t : threads.keySet()) {
            threadIds.put(t.getId(), t);
        }
        long[] lArray = ids;
        synchronized (ids) {
            ThreadInfo[] infos = !thbean.isObjectMonitorUsageSupported() || !thbean.isSynchronizerUsageSupported() ? thbean.getThreadInfo(ids) : thbean.getThreadInfo(ids, true, true);
            for (ThreadInfo info : infos) {
                Object locked = info.getLockOwnerName();
                String daemon = ((Thread)threadIds.get(info.getThreadId())).isDaemon() ? "DAEMON" : "";
                locked = locked == null ? "" : "locked by " + (String)locked;
                out.println(String.format("%1$s %2$s %5$s - %3$s %4$s", new Object[]{info.getThreadId(), info.getThreadName(), info.getThreadState(), locked, daemon}));
                MonitorInfo[] monitorInfos = info.getLockedMonitors();
                StackTraceElement[] stackTraceElements = info.getStackTrace();
                int k = 0;
                int i = 0;
                for (StackTraceElement trace : stackTraceElements) {
                    out.println(String.format("    %1$s", trace));
                    if (monitorInfos.length > k && monitorInfos[k].getLockedStackDepth() == i) {
                        out.println(String.format("        - lock  %2$s@%1$s", monitorInfos[k].getClassName(), Integer.toHexString(monitorInfos[k].getIdentityHashCode())));
                        ++k;
                    }
                    ++i;
                }
            }
            out.flush();
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) throws IOException {
        ThreadDumpImpl6 a = new ThreadDumpImpl6();
        a.execute(null, null, System.out, null);
    }
}

