/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.server;

import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.server.Continuation;
import org.rzo.netty.ahessian.rpc.server.DefaultContinuation;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.rpc.server.HessianSkeleton;
import org.rzo.netty.ahessian.session.ServerSessionFilter;

public class ContinuationService
extends HessianSkeleton {
    private LinkedBlockingQueue<HessianRPCCallMessage> _pendingCalls = new LinkedBlockingQueue();
    private Executor _executor;
    private boolean _stop = false;
    private Map<String, Method> _methodMap = new HashMap<String, Method>();
    private volatile ChannelHandlerContext _ctx = null;

    public ContinuationService(Object service, Class apiClass, HessianRPCServiceHandler factory, Executor executor) {
        super(service, apiClass, factory);
        Method[] methodList = service.getClass().getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            String mangeledName;
            Method method = methodList[i];
            if (method.getParameterTypes().length <= 0 || !method.getParameterTypes()[0].equals(Continuation.class) || super.getMethod(mangeledName = method.getName() + "__" + (method.getParameterTypes().length - 1)) == null) continue;
            this._methodMap.put(mangeledName, method);
        }
        this._executor = executor;
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                while (!ContinuationService.this._stop) {
                    HessianRPCCallMessage message = null;
                    try {
                        message = ContinuationService.this._pendingCalls.take();
                    }
                    catch (InterruptedException e1) {
                        Constants.ahessianLogger.warn("", (Throwable)e1);
                    }
                    if (message == null) continue;
                    ContinuationService.this.invoke(ContinuationService.this._ctx, message);
                }
            }
        });
    }

    @Override
    public void messageReceived(HessianRPCCallMessage message) {
        this._pendingCalls.add(message);
    }

    private void invoke(ChannelHandlerContext ctx, final HessianRPCCallMessage message) {
        this._executor.execute(new Runnable(){

            @Override
            public void run() {
                DefaultContinuation continuation = new DefaultContinuation(message, ContinuationService.this, ServerSessionFilter.getSession(ContinuationService.this._ctx));
                try {
                    Method method = ContinuationService.this.getMethod(message);
                    int l = message.getArgs() == null ? 1 : message.getArgs().length + 1;
                    Object[] args = new Object[l];
                    if (args.length > 1) {
                        System.arraycopy(message.getArgs(), 0, args, 1, message.getArgs().length);
                    }
                    args[0] = continuation;
                    method.invoke(ContinuationService.this._service, args);
                }
                catch (Throwable ex) {
                    Constants.ahessianLogger.warn("", ex);
                    continuation.fault(ex);
                }
            }
        });
    }

    @Override
    public Method getMethod(HessianRPCCallMessage message) {
        String mangeledName = message.getMethod() + "__" + message.getArgs().length;
        return this._methodMap.get(mangeledName);
    }
}

