/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.wrapper;

import org.apache.commons.configuration.Configuration;
import org.rzo.yajsw.controller.AbstractController;
import org.rzo.yajsw.controller.runtime.RuntimeController;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.wrapper.AbstractWrappedProcess;

public class WrappedRuntimeProcess
extends AbstractWrappedProcess {
    private final AbstractController.ControllerListener listenerStopped = new AbstractController.ControllerListener(){

        public void fire() {
            WrappedRuntimeProcess.this.getWrapperLogger().info("listener stopped");
            if (WrappedRuntimeProcess.this._osProcess.isRunning()) {
                WrappedRuntimeProcess.this.stop();
            }
            if (WrappedRuntimeProcess.this.allowRestart() && WrappedRuntimeProcess.this.exitCodeRestart() && !WrappedRuntimeProcess.this.exitCodeShutdown()) {
                WrappedRuntimeProcess.this.restartInternal();
            } else {
                WrappedRuntimeProcess.this.setState(0);
                if (WrappedRuntimeProcess.this._debug) {
                    WrappedRuntimeProcess.this.getWrapperLogger().info("giving up after " + WrappedRuntimeProcess.this._restartCount + " retries");
                }
            }
        }
    };

    void configProcess() {
        super.configProcess();
        this._osProcess.setCommand(this._config.getString("wrapper.image"));
        boolean pipeStreams = this._config.getBoolean("wrapper.console.pipestreams", true);
        this._osProcess.setPipeStreams(pipeStreams, pipeStreams);
    }

    void postStart() {
    }

    void stopController(int timeout, String reason) {
        this._controller.stop(4, reason);
        this._osProcess.stop(timeout, 999);
    }

    public boolean reconnect(int pid) {
        try {
            this._osProcess = OperatingSystem.instance().processManagerInstance().getProcess(pid);
            if (!this._osProcess.stop(10, 0)) {
                this.getWrapperLogger().severe("native processes must be restarted to consume the out and err streams. stopping of process failed");
            }
        }
        catch (Throwable ex) {
            this.getWrapperLogger().severe("native processes must be restarted to consume the out and err streams. stopping of process failed: " + ex.getMessage());
            ex.printStackTrace();
        }
        return true;
    }

    public void init() {
        super.init();
        if (this._controller == null) {
            this._controller = new RuntimeController(this);
            this.configController();
        }
    }

    void configController() {
        this._controller.setLogger(this.getWrapperLogger());
        this._controller.addListener(2, this.listenerStopped);
    }

    public String getType() {
        return "Native-" + super.getType();
    }

    public static void main(String[] args) {
        WrappedRuntimeProcess p = new WrappedRuntimeProcess();
        Configuration c = p.getLocalConfiguration();
        c.setProperty("wrapper.image", (Object)"notepad");
        c.setProperty("wrapper.working.dir", (Object)"c:/");
        p.init();
        p.start();
        p.waitFor(10000L);
        System.out.println("stopping");
        p.stop();
        System.out.println("stopped " + p.getExitCode());
    }
}

