/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.wrapper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.rzo.yajsw.app.WrapperMainServiceWin;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.controller.AbstractController;
import org.rzo.yajsw.controller.jvm.JVMController;
import org.rzo.yajsw.os.JavaHome;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.wrapper.AbstractWrappedProcess;
import org.rzo.yajsw.wrapper.AlphanumComparator;
import org.rzo.yajsw.wrapper.FileUtils;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class WrappedJavaProcess
extends AbstractWrappedProcess {
    String _key;
    String _teeName;
    File _javaPidFile;
    boolean _initController = false;
    Runnable _serviceStartupListener = null;

    public void init() {
        super.init();
        this._key = "" + new Random(System.currentTimeMillis()).nextLong();
        this._localConfiguration.setProperty("wrapper.key", (Object)this._key);
        if (this._controller == null) {
            this._controller = new JVMController(this);
            this.configController();
        }
    }

    protected void setState(int state) {
        super.setState(state);
        if (state == 0) {
            this.removeJavaPidFile();
        }
    }

    void configProcess() {
        if (this.pipeStreams()) {
            File t;
            this._teeName = this._key + "$" + System.currentTimeMillis();
            this._localConfiguration.setProperty("wrapper.teeName", (Object)this._teeName);
            this._osProcess.setTeeName(this._teeName);
            this._tmpPath = this._config.getString("wrapper.tmp.path");
            if (this._tmpPath == null) {
                this._tmpPath = System.getProperty("java.io.tmpdir");
            }
            if (this._tmpPath == null) {
                this._tmpPath = "/tmp";
            }
            if (!(t = new File(this._tmpPath)).exists()) {
                t.mkdirs();
            }
            this._tmpPath = t.getAbsolutePath();
            this._osProcess.setTmpPath(this._tmpPath);
        }
        JavaHome javaHome = OperatingSystem.instance().getJavaHome((Configuration)this._config);
        javaHome.setLogger(this.getInternalWrapperLogger());
        String java = javaHome.findJava(this._config.getString("wrapper.java.command"), this._config.getString("wrapper.java.customProcName"));
        if (java == null) {
            this.getWrapperLogger().log(Level.SEVERE, "ERROR: could not get java command");
        }
        List jvmOptions = this.jvmOptions();
        List wrapperOptions = this.wrapperOptions();
        String mainClass = this.getMainClass();
        ArrayList<String> command = new ArrayList<String>();
        command.add(java);
        command.addAll(wrapperOptions);
        command.addAll(jvmOptions);
        command.add(mainClass);
        String[] arrCmd = new String[command.size()];
        for (int i = 0; i < arrCmd.length; ++i) {
            arrCmd[i] = (String)command.get(i);
        }
        this._osProcess.setCommand(arrCmd);
        this._osProcess.setPipeStreams(false, false);
        super.configProcess();
    }

    protected String getMainClass() {
        return this._config.getString("wrapper.java.mainclass", "org.rzo.yajsw.app.WrapperJVMMain");
    }

    private List wrapperOptions() {
        String preScript;
        ArrayList<String> result = new ArrayList<String>();
        JVMController controller = (JVMController)this._controller;
        Iterator it = this._config.getSystemConfiguration().getKeys("wrapper");
        while (it.hasNext()) {
            String key = (String)it.next();
            if (("wrapper.service".equals(key) || "wrapper.console.visible".equals(key)) && this._config.getBoolean("wrapper.service", false)) continue;
            if ("wrapper.config".equals(key)) {
                result.add(this.checkValue("-D" + key + "=" + this._config.getCachedPath()));
                continue;
            }
            result.add(this.checkValue("-D" + key + "=" + this._config.getProperty(key).toString()));
        }
        result.add("-Dwrapper.port=" + controller.getPort());
        result.add("-Dwrapper.key=" + controller.getKey());
        result.add("-Dwrapper.teeName=" + this._teeName);
        result.add("-Dwrapper.tmpPath=" + this._tmpPath);
        String gcPattern = this._config.getString("wrapper.java.monitor.gc", null);
        if (gcPattern != null && gcPattern.length() > 0) {
            gcPattern = gcPattern.replaceAll(",", "\\\\,");
            result.add("-Dwrapper.java.monitor.gc=" + gcPattern);
        }
        if ((preScript = this._config.getString("wrapper.app.pre.script", null)) != null & !"".equals(preScript)) {
            try {
                File f = new File(preScript);
                if (!f.exists()) {
                    this.getWrapperLogger().warning("app.pre.script not found: " + preScript);
                } else {
                    preScript = this.checkValue(f.getCanonicalPath());
                    result.add("-Dwrapper.app.pre.script=" + preScript);
                }
            }
            catch (Exception ex) {
                this.getWrapperLogger().log(Level.SEVERE, "WrappedJavaProcess wrapperOptions", ex);
            }
        }
        return result;
    }

    private List jvmOptions() {
        String preMainScript;
        int port;
        String key;
        ArrayList<String> result = new ArrayList<String>();
        result.add("-classpath");
        StringBuffer sb = new StringBuffer();
        sb.append(WrapperLoader.getWrapperAppJar().trim());
        StringBuilder appCp = this.getAppClassPath(this._config.getString("wrapper.working.dir", "."), this._config.getKeys("wrapper.java.classpath"));
        if (appCp != null && appCp.length() > 0) {
            sb.append(PATHSEP);
            sb.append((CharSequence)appCp);
        }
        result.add(this.checkValue(sb.toString()));
        boolean hasXrs = false;
        boolean hasXmx = false;
        boolean hasXms = false;
        Iterator it = this._config.getKeys("wrapper.java.additional");
        while (it.hasNext()) {
            key = (String)it.next();
            String value = this._config.getString(key);
            result.add(this.checkValue(value));
            hasXrs |= value.contains("-Xrs");
            hasXmx |= value.contains("-Xmx");
            hasXms |= value.contains("-Xms");
        }
        sb = new StringBuffer();
        if (this._config.getKeys("wrapper.java.library.path").hasNext()) {
            sb.append("-Djava.library.path=");
            it = this._config.getKeys("wrapper.java.library.path");
            while (it.hasNext()) {
                key = (String)it.next();
                sb.append(this._config.getString(key));
                if (!it.hasNext()) continue;
                sb.append(PATHSEP);
            }
            result.add(this.checkValue(sb.toString()));
        }
        if (this._config.getBoolean("wrapper.service", false) && !hasXrs) {
            result.add("-Xrs");
        }
        if (this._config.getBoolean("wrapper.service", false)) {
            result.add("-Dwrapper.service=true");
            result.add("-Dwrapper.console.visible=false");
        } else if (this._config.getBoolean("wrapper.console.visible", false)) {
            result.add("-Dwrapper.console.visible=true");
        }
        if (this._config.containsKey("wrapper.java.initmemory") || this._config.containsKey("wrapper.java.initmemory.relative") || this._config.containsKey("wrapper.java.maxmemory") || this._config.containsKey("wrapper.java.maxmemory.relative")) {
            long xmx = 0L;
            long xmxr = 0L;
            long xms = 0L;
            long xmsr = 0L;
            OperatingSystem.instance().systemInformation().setLogger(this.getWrapperLogger());
            long totalRAM = OperatingSystem.instance().systemInformation().totalRAM();
            if (!hasXms) {
                try {
                    xms = this._config.getLong("wrapper.java.initmemory", 0L);
                    xmsr = this._config.getLong("wrapper.java.initmemory.relative", 0L);
                }
                catch (Exception ex) {
                    this.getWrapperLogger().info("error in wrapper.java.initmemory " + ex.getMessage());
                }
                if (xmsr > 0L && totalRAM > 0L) {
                    xms = totalRAM * xmsr / 100L / 0x100000L;
                }
                if (xms > 0L) {
                    result.add("-Xms" + xms + "m");
                }
            }
            if (!hasXmx) {
                try {
                    xmx = this._config.getLong("wrapper.java.maxmemory", 0L);
                    xmxr = this._config.getLong("wrapper.java.maxmemory.relative", 0L);
                }
                catch (Exception ex) {
                    this.getWrapperLogger().info("error in wrapper.java.maxmemory " + ex.getMessage());
                }
                if (xmxr > 0L && totalRAM > 0L) {
                    xmx = totalRAM * xmxr / 100L / 0x100000L;
                }
                if (xmx > 0L) {
                    if (xmx < xms) {
                        xmx = xms;
                    }
                    if (xmx < 3L) {
                        xmx = 3L;
                    }
                    result.add("-Xmx" + xmx + "m");
                }
            }
        }
        if ((port = this._config.getInt("wrapper.java.debug.port", -1)) != -1) {
            result.add("-Xdebug");
            result.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + port);
        }
        if ((preMainScript = this._config.getString("wrapper.app.pre_main.script", null)) != null && preMainScript.length() > 0) {
            result.add("-Dwrapper.app.pre_main.script=" + preMainScript);
        }
        if (this._config.getBoolean("wrapper.service", false)) {
            for (Map.Entry<String, String> e : this._config.getEnvLookupSet().entrySet()) {
                result.add("\"-D" + e.getKey() + "=" + e.getValue() + "\"");
            }
        }
        return result;
    }

    private String checkValue(String value) {
        if ((value = value.trim()).endsWith("\\") && !value.endsWith("\\\\")) {
            value = value + "\\";
        }
        return value;
    }

    private StringBuilder getAppClassPath(String workingDir, Iterator keys) {
        ArrayList configList = new ArrayList();
        Iterator it = keys;
        while (it.hasNext()) {
            configList.add(it.next());
        }
        Collections.sort(configList, new AlphanumComparator());
        ArrayList files = new ArrayList();
        String jar = this._config.getString("wrapper.java.app.jar", null);
        if (jar != null) {
            files.addAll(FileUtils.getFiles(workingDir, jar));
        }
        ListIterator it2 = configList.listIterator();
        while (it2.hasNext()) {
            String file = this._config.getString((String)it2.next());
            files.addAll(FileUtils.getFiles(workingDir, file));
        }
        StringBuilder sb = new StringBuilder();
        Iterator it3 = files.iterator();
        while (it3.hasNext()) {
            try {
                sb.append(((File)it3.next()).getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!it3.hasNext()) continue;
            sb.append(PATHSEP);
        }
        return sb;
    }

    void configController() {
        JVMController controller = (JVMController)this._controller;
        controller.setLogger(this.getWrapperLogger());
        controller.setKey(this._config.getString("wrapper.key"));
        if (this._config.containsKey("wrapper.port")) {
            controller.setMinPort(this._config.getInt("wrapper.port"));
            controller.setMaxPort(this._config.getInt("wrapper.port"));
        } else {
            controller.setMinPort(this._config.getInt("wrapper.port.min", 15003));
            controller.setMaxPort(this._config.getInt("wrapper.port.max", 65535));
        }
        controller.setStartupTimeout(this._config.getInt("wrapper.startup.timeout", 30) * 1000);
        controller.setPingTimeout(this._config.getInt("wrapper.ping.timeout", 30) * 1000);
        if (!this._initController) {
            AbstractController.ControllerListener restartHandler = new AbstractController.ControllerListener(){

                public void fire() {
                    if (WrappedJavaProcess.this._state == 6 || WrappedJavaProcess.this._state == 2 || WrappedJavaProcess.this._state == 5 || WrappedJavaProcess.this._state == 7) {
                        return;
                    }
                    if (WrappedJavaProcess.this.allowRestart() && WrappedJavaProcess.this.exitCodeRestart() && !WrappedJavaProcess.this.exitCodeShutdown()) {
                        WrappedJavaProcess.this.restartInternal();
                    } else {
                        if (WrappedJavaProcess.this._debug) {
                            WrappedJavaProcess.this.getWrapperLogger().info("giving up after " + WrappedJavaProcess.this._restartCount + " retries");
                        }
                        if (WrappedJavaProcess.this._state != 8) {
                            WrappedJavaProcess.this.setState(9);
                        }
                        if (!WrappedJavaProcess.this._exiting) {
                            WrappedJavaProcess.this.stop();
                        }
                        WrappedJavaProcess.this.setState(0);
                    }
                }
            };
            AbstractController.ControllerListener killedRestartHandler = new AbstractController.ControllerListener(){

                public void fire() {
                    if (WrappedJavaProcess.this._state == 6 || WrappedJavaProcess.this._state == 2 || WrappedJavaProcess.this._state == 7) {
                        return;
                    }
                    if (WrappedJavaProcess.this.allowRestart() && WrappedJavaProcess.this.exitCodeRestart() && !WrappedJavaProcess.this.exitCodeShutdown()) {
                        WrappedJavaProcess.this.restartInternal();
                    } else {
                        if (WrappedJavaProcess.this._debug) {
                            WrappedJavaProcess.this.getWrapperLogger().info("giving up after " + WrappedJavaProcess.this._restartCount + " retries");
                        }
                        if (WrappedJavaProcess.this._state != 8) {
                            WrappedJavaProcess.this.setState(9);
                        }
                        if (!WrappedJavaProcess.this._exiting) {
                            WrappedJavaProcess.this.stop();
                        }
                        WrappedJavaProcess.this.setState(0);
                    }
                }
            };
            controller.addListener(4, restartHandler);
            controller.addListener(7, restartHandler);
            controller.addListener(8, killedRestartHandler);
            if (!this._config.getBoolean("wrapper.ntservice.autoreport.startup", true) && this.getService() instanceof WrapperMainServiceWin) {
                this.setServiceStartupListener(new Runnable(){

                    public void run() {
                        ((WrapperMainServiceWin)WrappedJavaProcess.this.getService()).notifyStartup();
                    }
                });
            }
            controller.setServiceStartupListener(this._serviceStartupListener);
            controller.init();
            this._initController = true;
        }
    }

    void postStart() {
        this.saveJavaPidFile();
    }

    public static void main(String[] args) {
        WrappedProcess[] w = new WrappedProcess[20];
        for (int i = 0; i < w.length; ++i) {
            w[i] = new WrappedJavaProcess();
            w[i].getLocalConfiguration().setProperty("wrapper.config", (Object)"conf/wrapper.helloworld.conf");
            w[i].getLocalConfiguration().setProperty("wrapper.debug", (Object)"true");
            w[i].setUseSystemProperties(false);
            w[i].init();
        }
        boolean done = false;
        while (!done) {
            for (int i = 0; i < w.length; ++i) {
                System.out.println("starting " + i);
                w[i].start();
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            for (int i = 0; i < w.length; ++i) {
                System.out.println("stopping " + i);
                w[i].stop();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    void saveJavaPidFile() {
        String file = this._config.getString("wrapper.java.pidfile");
        if (file != null) {
            try {
                this._javaPidFile = new File(file);
                if (!this._javaPidFile.exists()) {
                    this._javaPidFile.createNewFile();
                }
                FileWriter out = new FileWriter(this._javaPidFile, false);
                out.write("" + this.getAppPid());
                out.flush();
                out.close();
                if (this._debug) {
                    this.getWrapperLogger().info("created jva.pid file " + this._javaPidFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void removeJavaPidFile() {
        if (this._javaPidFile != null) {
            try {
                this._javaPidFile.delete();
                if (this._debug) {
                    this.getWrapperLogger().info("removed java.pid file " + this._javaPidFile.getAbsolutePath());
                }
                this._javaPidFile = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean reconnect(int pid) {
        if (this._state != 0) {
            return false;
        }
        this._osProcess = OperatingSystem.instance().processManagerInstance().getProcess(pid);
        if (this._osProcess == null) {
            return false;
        }
        String cmd = this._osProcess.getCommand();
        if (cmd == null) {
            return false;
        }
        String key = this.getPropertyFromCommandLine("wrapper.key=[^ \"]*", cmd);
        if (key == null) {
            return false;
        }
        String port = this.getPropertyFromCommandLine("wrapper.port=[^ \"]*", cmd);
        if (port == null) {
            return false;
        }
        String configFile = this.getPropertyFromCommandLine("wrapper.config=[^ \"]*", cmd);
        String teeName = this.getPropertyFromCommandLine("wrapper.teeName=[^ \"]*", cmd);
        String tmpPath = this.getPropertyFromCommandLine("wrapper.tmpPath=[^ \"]*", cmd);
        this._localConfiguration.setProperty("wrapper.key", (Object)key);
        this._localConfiguration.setProperty("wrapper.port", (Object)port);
        this._localConfiguration.setProperty("wrapper.teeName", (Object)teeName);
        this._localConfiguration.setProperty("wrapper.tmpPath", (Object)tmpPath);
        if (configFile != null) {
            this._localConfiguration.setProperty("wrapper.config", (Object)configFile);
        }
        this.setReconnecting(true);
        super.init();
        this._osProcess.setTeeName(teeName);
        this._osProcess.setTmpPath(tmpPath);
        this._osProcess.reconnectStreams();
        if (this._controller == null) {
            this._controller = new JVMController(this);
        }
        JVMController controller = (JVMController)this._controller;
        this.configController();
        this._firstRestartTime = System.currentTimeMillis();
        controller.start();
        controller.processStarted();
        this.setState(4);
        boolean result = controller.waitFor(this._config.getInt("wrapper.ping.timeout", 30) * 1000);
        if (result) {
            for (int i = 0; i < 5 && this._osProcess.getInputStream() == null; ++i) {
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
            Map triggerActions = this.getTriggerActions();
            Map regexTriggerActions = this.getRegexTriggerActions();
            Map missingTriggerActions = this.getMissingTriggerActions();
            Map missingRegexTriggerActions = this.getMissingRegexTriggerActions();
            this._gobler_in = new AbstractWrappedProcess.Gobler(this._osProcess.getInputStream(), this.getAppLogger(), triggerActions, regexTriggerActions, missingTriggerActions, missingRegexTriggerActions, "OUTPUT " + this._osProcess.getPid(), this._osProcess.getPid());
            this._gobler_err = new AbstractWrappedProcess.Gobler(this._osProcess.getErrorStream(), this.getAppLogger(), triggerActions, regexTriggerActions, missingTriggerActions, missingRegexTriggerActions, "ERROR " + this._osProcess.getPid(), this._osProcess.getPid());
            executor.execute(this._gobler_err);
            executor.execute(this._gobler_in);
            this.setState(4);
            this.saveJavaPidFile();
            this.saveLockFile();
        }
        return result;
    }

    private String getPropertyFromCommandLine(String pattern, String cmd) {
        String result = null;
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(cmd);
        if (m.find()) {
            result = m.group();
        }
        if (result != null && result.length() > 0) {
            return result.substring(result.indexOf("=") + 1).replaceAll("'", "");
        }
        return null;
    }

    public String getTeeName() {
        return this._teeName;
    }

    public void requestThreadDump() {
        if (this._controller != null) {
            JVMController controller = (JVMController)this._controller;
            controller.requestThreadDump();
        }
    }

    public void requestGc() {
        if (this._controller != null) {
            JVMController controller = (JVMController)this._controller;
            controller.requestGc();
        }
    }

    public void requestDumpHeap(String fileName) {
        if (this._controller != null) {
            JVMController controller = (JVMController)this._controller;
            controller.requestDumpHeap(fileName);
        }
    }

    void stopController(int timeout, String reason) {
        JVMController controller = (JVMController)this._controller;
        controller.stop(6, reason);
    }

    public String getType() {
        return "Java-" + super.getType();
    }

    public void setServiceStartupListener(Runnable serviceStartupListener) {
        this._serviceStartupListener = serviceStartupListener;
    }

    protected void reloadConfiguration() {
        super.reloadConfiguration();
    }
}

