/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray.ahessian.server;

import com.caucho.hessian4.io.AbstractSerializerFactory;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.handler.ipfilter.IpFilteringHandler;
import org.rzo.netty.ahessian.application.jmx.remote.service.JmxSerializerFactory;
import org.rzo.netty.ahessian.io.InputStreamConsumer;
import org.rzo.netty.ahessian.io.InputStreamDecoder;
import org.rzo.netty.ahessian.io.OutputStreamEncoder;
import org.rzo.netty.ahessian.io.PullInputStreamConsumer;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallDecoder;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyEncoder;
import org.rzo.netty.ahessian.rpc.message.OutputProducer;
import org.rzo.netty.ahessian.rpc.server.ExecutorInvokeService;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.rpc.server.HessianSkeleton;
import org.rzo.netty.ahessian.stopable.StopHandler;
import org.rzo.netty.ahessian.stopable.StopablePipeline;
import org.rzo.yajsw.tray.ahessian.server.AhessianLogging;

public class AHessianServerPipelineFactory
implements ChannelPipelineFactory {
    Executor _executor;
    IpFilteringHandler _ipFilter;
    MBeanServer _mbeanServer;
    HessianRPCServiceHandler _factory;
    Logger _log;

    AHessianServerPipelineFactory(Executor executor, IpFilteringHandler ipFilter, MBeanServer mbeanServer, Logger log) {
        AhessianLogging.setAhessianLogger(log);
        this._executor = executor;
        this._ipFilter = ipFilter;
        this._mbeanServer = mbeanServer;
        this._log = log;
        this._factory = new HessianRPCServiceHandler(this._executor);
        this._factory.addService("default", (HessianSkeleton)new ExecutorInvokeService((Object)this._mbeanServer, MBeanServerConnection.class, this._factory, this._executor));
    }

    public ChannelPipeline getPipeline() throws Exception {
        StopablePipeline pipeline = StopablePipeline.pipeline();
        pipeline.addLast("ipfilter", (ChannelHandler)this._ipFilter);
        pipeline.addLast("inputStream", (ChannelHandler)new InputStreamDecoder());
        pipeline.addLast("outputStream", (ChannelHandler)new OutputStreamEncoder());
        pipeline.addLast("callDecoder", (ChannelHandler)new PullInputStreamConsumer((InputStreamConsumer)new HessianRPCCallDecoder((AbstractSerializerFactory)new JmxSerializerFactory()), this._executor));
        pipeline.addLast("replyEncoder", (ChannelHandler)new HessianRPCReplyEncoder((AbstractSerializerFactory)new JmxSerializerFactory()));
        pipeline.addLast("outputProducer", (ChannelHandler)new OutputProducer(this._executor));
        pipeline.addLast("hessianRPCServer", (ChannelHandler)this._factory);
        pipeline.addLast("stopHandler", (ChannelHandler)new StopHandler());
        return pipeline;
    }
}

