/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray.ahessian.client;

import com.caucho.hessian4.io.AbstractSerializerFactory;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.util.Timer;
import org.rzo.netty.ahessian.application.jmx.remote.service.JmxSerializerFactory;
import org.rzo.netty.ahessian.io.InputStreamConsumer;
import org.rzo.netty.ahessian.io.InputStreamDecoder;
import org.rzo.netty.ahessian.io.OutputStreamEncoder;
import org.rzo.netty.ahessian.io.PullInputStreamConsumer;
import org.rzo.netty.ahessian.rpc.client.BootstrapProvider;
import org.rzo.netty.ahessian.rpc.client.HessianProxyFactory;
import org.rzo.netty.ahessian.rpc.client.ReconnectHandler;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallEncoder;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyDecoder;
import org.rzo.netty.ahessian.rpc.message.OutputProducer;
import org.rzo.netty.ahessian.stopable.StopHandler;
import org.rzo.netty.ahessian.stopable.StopablePipeline;

public class AHessianClientPipelineFactory
implements ChannelPipelineFactory {
    Executor _executor;
    HessianProxyFactory _factory;
    BootstrapProvider _bootstrapProvider;
    Timer _timer;

    AHessianClientPipelineFactory(Executor executor, HessianProxyFactory factory, BootstrapProvider bootstrapProvider, Timer timer) {
        this._executor = executor;
        this._factory = factory;
        this._bootstrapProvider = bootstrapProvider;
        this._timer = timer;
    }

    AHessianClientPipelineFactory(Executor executor, HessianProxyFactory factory, Timer timer) {
        this(executor, factory, null, timer);
    }

    public ChannelPipeline getPipeline() throws Exception {
        StopablePipeline pipeline = StopablePipeline.pipeline();
        if (this._bootstrapProvider != null) {
            pipeline.addLast("reconnect", (ChannelHandler)new ReconnectHandler(this._bootstrapProvider, 1000L, this._timer));
        }
        pipeline.addLast("inputStream", (ChannelHandler)new InputStreamDecoder());
        pipeline.addLast("outputStream", (ChannelHandler)new OutputStreamEncoder());
        pipeline.addLast("hessianReplyDecoder", (ChannelHandler)new PullInputStreamConsumer((InputStreamConsumer)new HessianRPCReplyDecoder(this._factory, (AbstractSerializerFactory)new JmxSerializerFactory()), this._executor));
        pipeline.addLast("hessianCallEncoder", (ChannelHandler)new HessianRPCCallEncoder((AbstractSerializerFactory)new JmxSerializerFactory()));
        pipeline.addLast("outputProducer", (ChannelHandler)new OutputProducer(this._executor));
        pipeline.addLast("hessianHandler", (ChannelHandler)this._factory);
        pipeline.addLast("stopHandler", (ChannelHandler)new StopHandler());
        return pipeline;
    }
}

