/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray;

import java.util.ArrayList;
import java.util.Map;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.tray.TrayIconMainBooter;
import org.rzo.yajsw.tray.WrapperTrayIcon;
import org.rzo.yajsw.tray.WrapperTrayIconDummy;
import org.rzo.yajsw.tray.WrapperTrayIconImpl;

public class WrapperTrayIconFactory {
    public static WrapperTrayIcon createTrayIcon(String name, String icon, YajswConfigurationImpl config) {
        WrapperTrayIcon result = null;
        if (config == null) {
            config = new YajswConfigurationImpl();
        }
        try {
            result = new WrapperTrayIconImpl(name, icon, config);
        }
        catch (Throwable ex) {
            System.out.println("java version does not support SystemTray: " + ex.getMessage());
            ex.printStackTrace();
        }
        if (result == null || !result.isInit()) {
            result = new WrapperTrayIconDummy();
        }
        return result;
    }

    public static Process startTrayIconProcess(YajswConfigurationImpl config) {
        if (config == null) {
            return null;
        }
        String wrapperConfFileName = config.getCachedPath(false);
        final Process _osProcess = OperatingSystem.instance().processManagerInstance().createProcess();
        try {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(WrapperTrayIconFactory.getJava());
            cmd.add("-cp");
            cmd.add(WrapperLoader.getWrapperHome() + "/wrapper.jar");
            for (Map.Entry<String, String> e : config.getEnvLookupSet().entrySet()) {
                cmd.add("\"-D" + e.getKey() + "=" + e.getValue() + "\"");
            }
            cmd.add(TrayIconMainBooter.class.getName());
            cmd.add(wrapperConfFileName);
            String[] arrCmd = new String[cmd.size()];
            for (int i = 0; i < arrCmd.length; ++i) {
                arrCmd[i] = (String)cmd.get(i);
            }
            _osProcess.setCommand(arrCmd);
            _osProcess.setPipeStreams(false, false);
            _osProcess.setVisible(false);
            _osProcess.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (_osProcess != null) {
                        _osProcess.kill(0);
                    }
                }
            });
            return _osProcess;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getJava() {
        String result = System.getenv("java_exe");
        if (result == null) {
            result = System.getProperty("sun.boot.library.path");
            result = result != null ? result + "/javaw" : "java";
        }
        return result;
    }
}

