/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.rzo.yajsw.tray.ByteFormat;
import org.rzo.yajsw.tray.ConsoleForm;
import org.rzo.yajsw.tray.WrapperTrayIconImpl;
import org.rzo.yajsw.util.DaemonThreadFactory;

public class Console
extends JFrame {
    WrapperTrayIconImpl _trayIcon;
    boolean stop;
    protected static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("console"));
    int maxLines = 1500;
    ConsoleForm _consoleForm = new ConsoleForm();
    SimpleDateFormat _dateTimeFormat = new SimpleDateFormat();
    ByteFormat _byteFormat = new ByteFormat();
    Icon _okIcon;
    JMenuItem _startOutputItem = new JMenuItem();
    JMenuItem _pauseOutputItem = new JMenuItem();
    JMenuItem _clearOutputItem = new JMenuItem();
    volatile boolean _outputPaused = false;
    volatile String _outputFilter = null;
    volatile LinkedList<String> _outputLines = new LinkedList();
    ReentrantLock _outputLock = new ReentrantLock();

    public Console(WrapperTrayIconImpl trayIcon) {
        this._trayIcon = trayIcon;
        this.setTitle(this._trayIcon.toolTipPrefix + "Console");
        this.addWindowListener(new WindowEventHandler());
        this.setDefaultCloseOperation(0);
        this._okIcon = WrapperTrayIconImpl.createImageIcon("/resources/tick.png");
        this._clearOutputItem.setAction(new AbstractAction(null, WrapperTrayIconImpl.createImageIcon("/resources/edit-clear.png")){

            public void actionPerformed(ActionEvent e) {
                Console.this.clearOutput();
            }
        });
        this._pauseOutputItem.setAction(new AbstractAction(null, WrapperTrayIconImpl.createImageIcon("/resources/pause.png")){

            public void actionPerformed(ActionEvent e) {
                Console.this._outputPaused = true;
                Console.this._consoleForm._START_OUTPUT_BUTTON.setEnabled(true);
                Console.this._consoleForm._PAUSE_OUTPUT_BUTTON.setEnabled(false);
            }
        });
        this._startOutputItem.setAction(new AbstractAction(null, WrapperTrayIconImpl.createImageIcon("/resources/start.png")){

            public void actionPerformed(ActionEvent e) {
                Console.this._outputPaused = false;
                Console.this._consoleForm._START_OUTPUT_BUTTON.setEnabled(false);
                Console.this._consoleForm._PAUSE_OUTPUT_BUTTON.setEnabled(true);
            }
        });
        this._consoleForm.__OUTPUT_FILTER.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String txt = Console.this._consoleForm.__OUTPUT_FILTER.getText();
                Console.this._outputFilter = "".equals(txt) ? null : txt;
                Console.this.filterOutput();
            }
        });
        this.initOutput();
        this.initInput();
        this.initPerformance();
        this.initButtons();
        this._consoleForm._START_OUTPUT_BUTTON.setEnabled(false);
        this.getContentPane().add(this._consoleForm);
        this.pack();
        this.setVisible(true);
        this.stop = false;
    }

    private void initButtons() {
        this.initButton(this._consoleForm._EXIT_TRAY_ICON_BUTTON, this._trayIcon._exitItem);
        this.initButton(this._consoleForm._EXIT_WRAPPER_BUTTON, this._trayIcon._exitWrapperItem);
        this.initButton(this._consoleForm._THREAD_DUMP_WRAPPER_BUTTON, this._trayIcon._threadDumpWrapperItem);
        this.initButton(this._consoleForm._RESTART_BUTTON, this._trayIcon._restartItem);
        this.initButton(this._consoleForm._START_BUTTON, this._trayIcon._startItem);
        this.initButton(this._consoleForm._STOP_BUTTON, this._trayIcon._stopItem);
        this.initButton(this._consoleForm._STOP_TIMER_BUTTON, this._trayIcon._stopTimerItem);
        this.initButton(this._consoleForm._THREAD_DUMP_BUTTON, this._trayIcon._threadDumpItem);
        this.initButton(this._consoleForm._GC_BUTTON, this._trayIcon._gcItem);
        this.initButton(this._consoleForm._DUMP_HEAP_BUTTON, this._trayIcon._dumpHeapItem);
        this.initButton(this._consoleForm._jbutton1, this._trayIcon._closeConsoleItem);
        this.initButton(this._consoleForm._PAUSE_OUTPUT_BUTTON, this._pauseOutputItem);
        this.initButton(this._consoleForm._START_OUTPUT_BUTTON, this._startOutputItem);
        this.initButton(this._consoleForm._CLEAR_OUTPUT_BUTTON, this._clearOutputItem);
    }

    private void initButton(JButton button, JMenuItem item) {
        button.setAction(item.getAction());
    }

    private void initPerformance() {
        executor.execute(new Runnable(){

            public void run() {
                while (!Console.this.stop) {
                    Console.this.setAppCpu(Console.this._trayIcon._process.getAppCpu());
                    Console.this.setAppHandles(Console.this._trayIcon._process.getAppHandles());
                    Console.this.setAppMemory(Console.this._trayIcon._process.getAppPMemory(), Console.this._trayIcon._process.getAppVMemory());
                    Console.this.setAppThreads(Console.this._trayIcon._process.getAppThreads());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        Thread.currentThread().interrupt();
                    }
                }
            }
        });
    }

    void setState(String state) {
        if (state != null) {
            this._consoleForm._state.setText(state);
        }
        this._consoleForm._state.repaint();
    }

    void setAppPid(int pid) {
        if (pid > 0) {
            this._consoleForm._appPid.setText("" + pid);
        } else {
            this._consoleForm._appPid.setText("?");
        }
    }

    void setWrapperPid(int pid) {
        if (pid > 0) {
            this._consoleForm._wPid.setText("" + pid);
        } else {
            this._consoleForm._wPid.setText("?");
        }
    }

    void setTrigger(String trigger) {
        if (trigger != null) {
            this._consoleForm._trigger.setText(trigger);
        }
    }

    void setAppStarted(Date time) {
        if (time != null) {
            this._consoleForm._appStartTime.setText(this._dateTimeFormat.format(time));
        }
    }

    void setAppStopped(Date time) {
        if (time != null) {
            this._consoleForm._appStopTime.setText(this._dateTimeFormat.format(time));
        }
    }

    void setAppRestartCount(int total, int count) {
        if (count > 0) {
            this._consoleForm._count.setText(total + "[" + count + "]");
        }
    }

    void setWrapperStarted(Date time) {
        if (time != null) {
            this._consoleForm._wStartTime.setText(this._dateTimeFormat.format(time));
        }
    }

    void setAppThreads(int count) {
        if (count > 0) {
            this._consoleForm._threads.setText("" + count);
        } else {
            this._consoleForm._threads.setText("?");
        }
    }

    void setAppHandles(int count) {
        if (count > 0) {
            this._consoleForm._handles.setText("" + count);
        } else {
            this._consoleForm._handles.setText("?");
        }
    }

    void setAppMemory(long pBytes, long vBytes) {
        String sPBytes = pBytes > 0L ? this._byteFormat.format(pBytes) : "?";
        String sVBytes = vBytes > 0L ? this._byteFormat.format(vBytes) : "?";
        this._consoleForm._memory.setText(sPBytes + "[" + sVBytes + "]");
    }

    void setAppCpu(int count) {
        if (count >= 0) {
            this._consoleForm._cpu.setText("" + count);
        } else {
            this._consoleForm._cpu.setText("?");
        }
    }

    void setExitCode(int code) {
        if (code >= 0) {
            this._consoleForm._exitCode.setText("" + code);
        }
    }

    void setWrapperType(String type) {
        this._consoleForm._wrapperType.setText(type);
    }

    void setCondition(boolean active) {
        if (active) {
            this._consoleForm._condition.setText("");
            this._consoleForm._condition.setIcon(this._okIcon);
        } else {
            this._consoleForm._condition.setText("-");
            this._consoleForm._condition.setIcon(null);
        }
    }

    void setTimer(boolean active) {
        if (active) {
            this._consoleForm._timer.setText("");
            this._consoleForm._timer.setIcon(this._okIcon);
        } else {
            this._consoleForm._timer.setText("-");
            this._consoleForm._timer.setIcon(null);
        }
    }

    private void initInput() {
        this._consoleForm._input.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (Console.this._trayIcon._process == null || !Console.this._trayIcon._process.hasOutput()) {
                        Console.this._consoleForm._input.setText("No input possible");
                        Console.this._consoleForm._input.selectAll();
                        return;
                    }
                    String txt = Console.this._consoleForm._input.getText();
                    Console.this._trayIcon._process.writeOutput(txt);
                    Console.this._consoleForm._input.selectAll();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void initOutput() {
        executor.execute(new Runnable(){

            public void run() {
                Console.this._trayIcon._process.startDrain();
                while (!Console.this.stop) {
                    if (!Console.this._outputPaused) {
                        String line;
                        Console.this._trayIcon.showState(Console.this._trayIcon._process.getState());
                        while ((line = Console.this._trayIcon._process.readDrainLine()) != null) {
                            Console.this.addLine(line);
                        }
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Console.this._trayIcon._process.stopDrain();
            }
        });
    }

    private void filterOutput() {
        executor.execute(new Runnable(){

            public void run() {
                Console.this._outputLock.lock();
                try {
                    Console.this._consoleForm._output.getDocument().remove(0, Console.this._consoleForm._output.getDocument().getLength());
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                for (String line : Console.this._outputLines) {
                    if (Console.this._outputFilter != null && !line.contains(Console.this._outputFilter)) continue;
                    Console.this.addToTextArea(line);
                }
                Console.this._outputLock.unlock();
            }
        });
    }

    private void clearOutput() {
        this._outputLock.lock();
        this._outputLines.clear();
        this.filterOutput();
        this._outputLock.unlock();
    }

    private void addLine(String line) {
        this._outputLock.lock();
        this._outputLines.addLast(line);
        if (this._outputLines.size() > this.maxLines) {
            this._outputLines.removeFirst();
        }
        if (this._outputFilter == null || line.contains(this._outputFilter)) {
            this.addToTextArea(line);
        }
        this._outputLock.unlock();
    }

    private void addToTextArea(String line) {
        JTextArea textArea = this._consoleForm._output;
        textArea.append(line + "\n");
        if (textArea.getLineCount() > this.maxLines) {
            Element root = textArea.getDocument().getDefaultRootElement();
            Element firstLine = root.getElement(0);
            try {
                textArea.getDocument().remove(0, firstLine.getEndOffset());
            }
            catch (Exception ble) {
                System.out.println(ble.getMessage());
            }
        }
        textArea.setCaretPosition(textArea.getDocument().getLength());
    }

    public void close() {
        this.stop = true;
        this.setVisible(false);
        this.dispose();
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            Console.this.close();
            Console.this._trayIcon.closeConsole();
        }
    }
}

