/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray;

import java.text.NumberFormat;

public class ByteFormat {
    private static NumberFormat nf = NumberFormat.getInstance();

    public String format(long number) {
        StorageUnit st = StorageUnit.of(number);
        return nf.format((double)number / (double)st.divider) + " " + st.symbol;
    }

    static {
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StorageUnit {
        BYTE("B", 1L),
        KILOBYTE("KB", 1024L),
        MEGABYTE("MB", 0x100000L),
        GIGABYTE("GB", 0x40000000L),
        TERABYTE("TB", 0x10000000000L),
        PETABYTE("PB", 0x4000000000000L),
        EXABYTE("EB", 0x1000000000000000L);

        public static final StorageUnit BASE;
        private final String symbol;
        private final long divider;

        private StorageUnit(String name, long divider) {
            this.symbol = name;
            this.divider = divider;
        }

        public static StorageUnit of(long number) {
            long n;
            long l = n = number > 0L ? -number : number;
            if (n > -1024L) {
                return BYTE;
            }
            if (n > -1048576L) {
                return KILOBYTE;
            }
            if (n > -1073741824L) {
                return MEGABYTE;
            }
            if (n > -1099511627776L) {
                return GIGABYTE;
            }
            if (n > -1125899906842624L) {
                return TERABYTE;
            }
            if (n > -1152921504606846976L) {
                return PETABYTE;
            }
            return EXABYTE;
        }

        static {
            BASE = BYTE;
        }
    }
}

