/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCLParser {
    List<String> _classpath = new ArrayList<String>();
    List<String> _vmOptions = new ArrayList<String>();
    List<String> _args = new ArrayList<String>();
    String _java = null;
    String _mainClass = null;
    String _jar = null;

    private JCLParser(String commandLine) {
        this.parseInternal(commandLine);
    }

    public static JCLParser parse(String commandLine) {
        JCLParser result = null;
        result = new JCLParser(commandLine);
        return result;
    }

    private void parseInternal(String commandLine) {
        int max;
        int posJ = 0;
        int posCp = 0;
        int posOpts = 0;
        int posclp = 0;
        int posJar = 0;
        Pattern p = Pattern.compile("\\A(\"[^\"]+\")|(\\S+) ");
        Matcher mr = p.matcher(commandLine);
        if (!mr.find()) {
            throw new RuntimeException("could not parse command line " + commandLine);
        }
        this._java = mr.group();
        this._java = this._java.replaceAll("\"", "");
        this._java = this._java.trim();
        posJ = mr.end() - 1;
        p = Pattern.compile(" -jar +((\"[^\"]+\")|(\\S+))");
        mr = p.matcher(commandLine);
        if (mr.find(posJ)) {
            this._jar = mr.group(1);
            this._jar = this._jar.replaceAll("\"", "");
            this._jar = this._jar.trim();
            posJar = mr.end() - 1;
        }
        if ((mr = (p = Pattern.compile("(( -cp)|( -classpath)|( \"-classpath\")) +((\"[^\"]+\")|(\\S+)) ")).matcher(commandLine)).find(posJ)) {
            String[] cpArr;
            String cp = mr.group().trim();
            posCp = mr.end() - 1;
            cp = cp.substring(cp.indexOf(32));
            for (String cc : cpArr = cp.split(File.pathSeparator)) {
                cc = cc.replaceAll("\"", "");
                this._classpath.add(cc.trim());
            }
        }
        if (this._jar == null && (mr = (p = Pattern.compile(" ([^- ])+( |$)")).matcher(commandLine)).find(max = Math.max(posJ, posCp))) {
            this._mainClass = mr.group();
            this._mainClass = this._mainClass.replaceAll("\"", "");
            this._mainClass = this._mainClass.trim();
            posclp = mr.end() - 1;
        }
        p = Pattern.compile("(( -\\S+)|( -\"[^\"]+\")|( \"-[^\"]+\")) ");
        mr = p.matcher(commandLine);
        max = Math.max(posJar, posclp);
        int pos = 0;
        while (mr.find(pos)) {
            String opt = mr.group().trim();
            pos = mr.end() - 1;
            if ((opt = opt.replaceAll("\"", "")).startsWith("-jar") || opt.startsWith("-cp") || opt.startsWith("-classpath") || mr.end() >= max) continue;
            this._vmOptions.add(opt);
            posOpts = mr.end();
        }
        p = Pattern.compile(" ((\"[^\"]+\")|(\\S+))( |$)");
        mr = p.matcher(commandLine);
        max = Math.max(posclp, posJar);
        if (mr.find(max = Math.max(max, posOpts))) {
            String arg = mr.group();
            arg = arg.replaceAll("\"", "");
            this._args.add(arg.trim());
            max = mr.end() - 1;
            while (mr.find(max)) {
                arg = mr.group();
                arg = arg.replaceAll("\"", "");
                if ((arg = arg.trim()).length() > 0) {
                    this._args.add(arg.trim());
                }
                max = mr.end() - 1;
            }
        }
        if (this._java == null || "".equals(this._java) || (this._mainClass == null || "".equals(this._mainClass)) && (this._jar == null || "".equals(this._jar))) {
            throw new RuntimeException("error parsing java command line ");
        }
    }

    public List<String> getClasspath() {
        return this._classpath;
    }

    public List<String> getVmOptions() {
        return this._vmOptions;
    }

    public List<String> getArgs() {
        return this._args;
    }

    public String getJava() {
        return this._java;
    }

    public String getMainClass() {
        return this._mainClass;
    }

    public String getJar() {
        return this._jar;
    }

    public static void main(String[] args) {
        String[] cmds;
        for (String cmd : cmds = new String[]{"\"java\" -cp \"C:\\Program Files\\yajsw-alpha-9.5\\bat\\/../wrapper.jar\" test.HelloWorld", "java -Xrs -jar \"Z:\\dev\\yajsw\\bat\\/..\\wrapper.jar\" -c conf/wrapper.conf       ", "java -cp wrapper.jar -Xrs x.Test -c conf/wrapper.conf       ", "\"java\" -cp \"C:\\Program Files\\yajsw-alpha-9.5\\bat\\/../wrapper.jar\" test.HelloWorld start \n ", "\"java\"  test.HelloWorld", "\"C:\\Program Files\\Java\\jre7\\bin\\javaw.exe\" -Xmx512m -jar \"C:\\automa tisation\\bin\\sendfile-server.jar\" abc ", "java -jar testJar.jar", "java -jar LogConsolidation-1.0.one-jar.jar", "java -Dlog4j.debug -Dlog4j.configuration=file:../conf/log4j.xml -jar myApp.jar start", "/usr/DAVIDweb/jdk1.6.0_18/bin/java -Dwrapper.teeName=6849389861148562201$1312438311981 -Dwrapper.config=/usr/DAVIDweb/Tomcat557_AAA-DHK_3/AAA-DHK_3/bin/conf/wrapper.conf -Dwrapper.key=6849389861148562201 -Dwrapper.visible=false -Dwrapper.pidfile=/var/run/wrapper.ApacheTomcatAAADHK3.pid -Dwrapper.port=15003 -Dwrapper.key=6849389861148562201 -Dwrapper.teeName=6849389861148562201$1312438311981 -Dwrapper.tmpPath=/tmp -classpath /usr/DAVIDweb/Tomcat557_AAA-DHK_3/AAA-DHK_3/bin/wrapper.jar:/usr/DAVIDweb/Tomcat557_AAA-DHK_3/bin/bootstrap.jar -server -Djava.endorsed.dirs=/DAVIDweb/Tomcat557_AAA-DHK_3/common/endorsed -Dcatalina.home=/DAVIDweb/Tomcat557_AAA-DHK_3 -Dcatalina.base=/DAVIDweb/Tomcat557_AAA-DHK_3/AAA-DHK_3 -Dcatalina.properties=/DAVIDweb/Tomcat557_AAA-DHK_3/AAA-DHK_3/conf/catalina.properties -Djava.io.tmpdir=/DAVIDweb/Tomcat557_AAA-DHK_3/AAA-DHK_3/temp -Dibr.debug=false -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/DAVIDweb/Tomcat557_AAA-DHK_3/AAA-DHK_3/webapps/AAA-DHK_3/logs -XX:+DisableExplicitGC -Xss1024k -Dibr.dhk.geoinfodok=gid600 -Dibr.dhk.lib=/DAVIDweb/Tomcat557_AAA-DHK_3/AAA-DHK_3/webapps/AAA-DHK_3/WEB-INF/lib/gid600 -Xrs -Dwrapper.service=true -Dwrapper.console.visible=false -Xms512m -Xmx512m org.rzo.yajsw.app.WrapperJVMMain"}) {
            System.out.println("---------------------");
            System.out.println(cmd);
            System.out.println("---------------------");
            JCLParser p = JCLParser.parse(cmd);
            System.out.println(" java:");
            System.out.println(p.getJava());
            System.out.println(" jar:");
            System.out.println(p.getJar());
            System.out.println(" main class:");
            System.out.println(p.getMainClass());
            System.out.println(" args:");
            System.out.println(p.getArgs());
            System.out.println(" classpath:");
            System.out.println(p.getClasspath());
            System.out.println(" options:");
            System.out.println(p.getVmOptions());
        }
    }
}

