/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.script;

import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.script.AbstractScript;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class ShellScript
extends AbstractScript {
    public ShellScript(String script, String id, WrappedProcess process, String[] args, int timeout) {
        super("scripts/" + script, id, process, args, timeout);
    }

    public Object execute(String line) {
        String id = this._id;
        String state = this._process.getStringState();
        String count = "" + this._process.getRestartCount();
        String pid = "" + this._process.getAppPid();
        String exitCode = "" + this._process.getExitCode();
        try {
            Process p = OperatingSystem.instance().processManagerInstance().createProcess();
            p.setCommand(this.getScript() + " " + id + " " + state + " " + count + " " + pid + " " + exitCode);
            p.setPipeStreams(false, false);
            p.start();
            p.waitFor(this.getTimeout());
            if (p.isRunning()) {
                p.kill(999);
            }
            if (p.getExitCode() != 0) {
                System.out.println("script " + this.getScript() + "returned " + p.getExitCode());
            }
            p.destroy();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public Object execute() {
        return this.execute("");
    }

    public Object executeWithTimeout() {
        return null;
    }
}

