/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.quartz;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.quartz.CronExpression;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.quartz.RestartJob;
import org.rzo.yajsw.quartz.StartJob;
import org.rzo.yajsw.quartz.StopJob;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class Timer {
    YajswConfigurationImpl _config;
    WrappedProcess _wp;
    static Scheduler _scheduler;
    MyCronTrigger _cronStart;
    MyCronTrigger _cronStop;
    MyCronTrigger _cronRestart;
    MySimpleTrigger _simpleStart;
    MySimpleTrigger _simpleStop;
    MySimpleTrigger _simpleRestart;
    boolean _hasTrigger = false;
    boolean _startImmediate = true;
    boolean _triggered = false;

    public Timer(YajswConfigurationImpl config, WrappedProcess wp) {
        this._config = config;
        this._wp = wp;
    }

    public synchronized void init() {
        Iterator keys = this._config.getKeys("wrapper.timer");
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.contains(".simple.")) {
                if (key.contains(".START.")) {
                    if (this._simpleStart != null) continue;
                    this._simpleStart = this.getSimpleTrigger(key);
                    continue;
                }
                if (key.contains(".STOP.")) {
                    if (this._simpleStop != null) continue;
                    this._simpleStop = this.getSimpleTrigger(key);
                    continue;
                }
                if (key.contains(".RESTART.")) {
                    if (this._simpleRestart != null) continue;
                    this._simpleRestart = this.getSimpleTrigger(key);
                    continue;
                }
                System.out.println("Cannot interpret timer property: " + key);
                continue;
            }
            if (key.contains(".cron.")) {
                if (key.contains(".START")) {
                    this._cronStart = this.getCronTrigger(key);
                    continue;
                }
                if (key.contains(".STOP")) {
                    this._cronStop = this.getCronTrigger(key);
                    continue;
                }
                if (key.contains(".RESTART")) {
                    this._cronRestart = this.getCronTrigger(key);
                    continue;
                }
                System.out.println("Cannot interpret timer property: " + key);
                continue;
            }
            System.out.println("Cannot interpret timer property: " + key);
        }
    }

    private MySimpleTrigger getSimpleTrigger(String key) {
        int interval;
        int repeatCount;
        JobDetail jobDetail = new JobDetail();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)"process", (Object)this._wp);
        jobDetail.setJobDataMap(jobDataMap);
        Class jobClass = this.getJobClass(key);
        if (jobClass == null) {
            return null;
        }
        jobDetail.setJobClass(jobClass);
        jobDetail.setName(key);
        MySimpleTrigger trigger = new MySimpleTrigger(jobDetail);
        Date startTime = this.getStartTime(key);
        if (startTime != null) {
            trigger.setStartTime(startTime);
        }
        if ((repeatCount = this.getRepeatCount(key)) > 0) {
            trigger.setRepeatCount(repeatCount);
        }
        if ((interval = this.getInterval(key)) > 0) {
            trigger.setRepeatInterval(interval * 1000);
        }
        this._hasTrigger = true;
        if (trigger != null) {
            trigger.setName(key);
        }
        this._startImmediate = false;
        trigger.setMisfireInstruction(1);
        return trigger;
    }

    private int getInterval(String key) {
        return this._config.getInt(key.substring(0, key.lastIndexOf(".")) + ".INTERVAL", -1);
    }

    private int getRepeatCount(String key) {
        return this._config.getInt(key.substring(0, key.lastIndexOf(".")) + ".COUNT", -1);
    }

    private Date getStartTime(String key) {
        String str = this._config.getString(key.substring(0, key.lastIndexOf(".")) + ".FIRST");
        if (str == null) {
            return new Date();
        }
        SimpleDateFormat df = null;
        df = str.contains(" ") ? new SimpleDateFormat("dd.MM.yyyy HH:mm:ss") : new SimpleDateFormat("HH:mm:ss");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Class getJobClass(String key) {
        if (key.contains(".RESTART")) {
            return RestartJob.class;
        }
        if (key.contains(".STOP")) {
            return StopJob.class;
        }
        if (key.contains(".START")) {
            return StartJob.class;
        }
        return null;
    }

    private MyCronTrigger getCronTrigger(String key) {
        JobDetail jobDetail = new JobDetail();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)"process", (Object)this._wp);
        jobDetail.setJobDataMap(jobDataMap);
        jobDetail.setName(key);
        Class jobClass = this.getJobClass(key);
        if (jobClass == null) {
            return null;
        }
        jobDetail.setJobClass(jobClass);
        MyCronTrigger trigger = new MyCronTrigger(jobDetail);
        CronExpression cronExpression = this.getCronExpression(key);
        if (cronExpression != null) {
            trigger.setCronExpression(cronExpression);
            if (jobClass.equals(StartJob.class)) {
                this._startImmediate = false;
            }
        } else {
            return null;
        }
        this._hasTrigger = true;
        trigger.setName(key);
        trigger.setMisfireInstruction(1);
        return trigger;
    }

    private CronExpression getCronExpression(String key) {
        String str = this._config.getString(key);
        if (str == null) {
            return null;
        }
        try {
            return new CronExpression(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void start() {
        if (!this._hasTrigger) {
            return;
        }
        if (this.getScheduler() == null) {
            return;
        }
        try {
            if (!_scheduler.isStarted()) {
                _scheduler.start();
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return;
        }
        if (this._cronStart != null) {
            this.startTrigger((Trigger)this._cronStart, this._cronStart.getJobDetail());
        }
        if (this._cronStop != null) {
            this.startTrigger((Trigger)this._cronStop, this._cronStop.getJobDetail());
        }
        if (this._cronRestart != null) {
            this.startTrigger((Trigger)this._cronRestart, this._cronRestart.getJobDetail());
        }
        if (this._simpleStart != null) {
            this.startTrigger((Trigger)this._simpleStart, this._simpleStart.getJobDetail());
        }
        if (this._simpleStop != null) {
            this.startTrigger((Trigger)this._simpleStop, this._simpleStop.getJobDetail());
        }
        if (this._simpleRestart != null) {
            this.startTrigger((Trigger)this._simpleRestart, this._simpleRestart.getJobDetail());
        }
        this._triggered = true;
    }

    private Scheduler getScheduler() {
        if (_scheduler == null) {
            StdSchedulerFactory schedFact = new StdSchedulerFactory();
            try {
                _scheduler = schedFact.getScheduler();
            }
            catch (SchedulerException e) {
                e.printStackTrace();
                _scheduler = null;
            }
        }
        return _scheduler;
    }

    private void startTrigger(Trigger trigger, JobDetail jobDetail) {
        if (trigger != null) {
            try {
                _scheduler.scheduleJob(jobDetail, trigger);
            }
            catch (SchedulerException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (!this._hasTrigger) {
            return;
        }
        this.stopTrigger((Trigger)this._cronStart);
        this.stopTrigger((Trigger)this._cronStop);
        this.stopTrigger((Trigger)this._cronRestart);
        this.stopTrigger((Trigger)this._simpleStart);
        this.stopTrigger((Trigger)this._simpleStop);
        this.stopTrigger((Trigger)this._simpleRestart);
    }

    private synchronized void stopTrigger(Trigger trigger) {
        try {
            _scheduler.shutdown();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return;
        }
        this._triggered = false;
    }

    public boolean isTriggered() {
        return this._triggered;
    }

    public boolean isStartImmediate() {
        return this._startImmediate;
    }

    public boolean isHasTrigger() {
        return this._hasTrigger;
    }

    class MySimpleTrigger
    extends SimpleTrigger {
        JobDetail _jobDetail;

        MySimpleTrigger(JobDetail jobDetail) {
            this._jobDetail = jobDetail;
        }

        JobDetail getJobDetail() {
            return this._jobDetail;
        }
    }

    class MyCronTrigger
    extends CronTrigger {
        JobDetail _jobDetail;

        MyCronTrigger(JobDetail jobDetail) {
            this._jobDetail = jobDetail;
        }

        JobDetail getJobDetail() {
            return this._jobDetail;
        }
    }
}

