/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix.solaris;

import com.sun.jna.Memory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.os.posix.PosixProcess;

public class SolarisProcess
extends PosixProcess {
    static int PRARGSZ = 80;

    public int getStdOutNo() {
        return 1;
    }

    public int getStdErrNo() {
        return 2;
    }

    public int getStdInNo() {
        return 3;
    }

    public static Process getProcess(int pid) {
        SolarisProcess result = null;
        File f = new File("/proc/" + pid);
        if (f.exists()) {
            result = new SolarisProcess();
            result._pid = pid;
            result._user = result.getUserInternal();
            result._cmd = result.getCommandInternal();
            result._workingDir = result.getWorkingDirInternal();
        }
        return result;
    }

    private String getCommandInternal() {
        String result = this._utils.osCommand(String.format("pargs -l %1$s", this._pid), 5000L);
        if (result == null) {
            result = "?";
        }
        return result;
    }

    public String getUserInternal() {
        if (this._pid < 0) {
            return null;
        }
        String cmd = String.format("ps -p %1$s -o user", this._pid);
        String res = this._utils.osCommand(cmd, 5000L);
        if (res == null) {
            return null;
        }
        String[] resx = res.split(System.getProperty("line.separator"));
        return resx[1];
    }

    private psinfo getPsinfo() {
        int size;
        FileChannel in;
        try {
            in = new FileInputStream(String.format("/proc/%1$s/psinfo", this._pid)).getChannel();
        }
        catch (FileNotFoundException e) {
            System.out.println("error in getCurrentThreads() " + e.getMessage());
            return null;
        }
        try {
            size = (int)in.size();
        }
        catch (IOException e) {
            System.out.println("error in getCurrentThreads() " + e.getMessage());
            return null;
        }
        ByteBuffer b = ByteBuffer.allocateDirect(size);
        b.order(ByteOrder.LITTLE_ENDIAN);
        try {
            in.read(b);
        }
        catch (IOException e) {
            System.out.println("error in getCurrent*() " + e.getMessage());
            return null;
        }
        psinfo s = new psinfo(b);
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public int getCurrentCpu() {
        int result = -1;
        if (!this.isRunning()) {
            return result;
        }
        psinfo s = this.getPsinfo();
        if (s == null) {
            return -1;
        }
        return s.getPctcpu();
    }

    public int getCurrentThreads() {
        int result = -1;
        if (!this.isRunning()) {
            return result;
        }
        psinfo s = this.getPsinfo();
        if (s == null) {
            return -1;
        }
        return s.getNlwp();
    }

    public int getCurrentVirtualMemory() {
        int result = -1;
        if (!this.isRunning()) {
            return result;
        }
        psinfo s = this.getPsinfo();
        if (s == null) {
            return -1;
        }
        return s.getPr_size() * 1024;
    }

    protected String getWorkingDirInternal() {
        String f = "/proc/" + this.getPid() + "/cwd";
        int BUFSIZE = 512;
        Memory result = new Memory((long)BUFSIZE);
        result.clear();
        short size = PosixProcess.CLibrary.INSTANCE.readlink(f, result, (short)(BUFSIZE - 1));
        if (size <= 0) {
            System.out.println("error reading process working dir -> please edit wrapper.working.dir in configuration file");
            return f;
        }
        result.setByte((long)size, (byte)0);
        return result.getString(0L);
    }

    public static class psinfo {
        ByteBuffer _b;

        psinfo(ByteBuffer b) {
            this._b = b;
        }

        int getPid() {
            return this._b.getInt(8);
        }

        int getNlwp() {
            return this._b.getInt(4);
        }

        int getPctcpu() {
            return (int)((double)this._b.getShort(60) * 100.0) / 32768;
        }

        int getPr_size() {
            return this._b.getInt(44);
        }
    }
}

