/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.rzo.yajsw.Constants;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.os.AbstractService;
import org.rzo.yajsw.os.JavaHome;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.os.posix.PosixProcess;
import org.rzo.yajsw.os.posix.UpdateRcParser;
import org.rzo.yajsw.os.posix.Utils;
import org.rzo.yajsw.os.posix.VelocityLog;

public class PosixService
extends AbstractService
implements Constants {
    protected String _daemonDir;
    String _daemonTemplate;
    String _daemonScript;
    String _wrapperPidFile;
    String _appPidFile;
    String _pidDir;
    String _confFile;
    int _stopTimeout;
    String[] _startCmd;
    String[] _execCmd;
    String[] _stopCmd;
    String[] _statusCmd;
    List<String> _ksLinks = new ArrayList<String>();
    UpdateRcParser _updateRcParser;
    Utils _utils = new Utils();

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this._utils.setLog(logger);
    }

    public void init() {
        String wrapperJar;
        block24: {
            String apidName;
            File pidFile;
            File daemonScript;
            File daemonTemplate;
            block23: {
                String pidName;
                File pidDir;
                block22: {
                    File f;
                    if (this._name == null) {
                        this._logger.warning("no name for daemon -> abort");
                        return;
                    }
                    this._daemonDir = this._config.getString("wrapper.daemon.dir", this.getDefaultDaemonDir());
                    File daemonDir = new File(this._daemonDir);
                    if (!daemonDir.exists() || !daemonDir.isDirectory()) {
                        this._logger.warning("Error " + this._daemonDir + " : is not a directory");
                        return;
                    }
                    this._pidDir = this._config.getString("wrapper.daemon.pid.dir", "/var/run");
                    pidDir = new File(this._pidDir);
                    if (!pidDir.exists() || !pidDir.isDirectory()) {
                        this._logger.warning("Error " + this._pidDir + " : is not a directory");
                        return;
                    }
                    wrapperJar = WrapperLoader.getWrapperJar().trim();
                    String wrapperHome = ".";
                    try {
                        wrapperHome = new File(wrapperJar).getParentFile().getCanonicalPath();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    String confFile = this._config.getString("wrapper.config");
                    String confDir = null;
                    if (confFile != null && (f = new File(confFile)).exists()) {
                        try {
                            confDir = f.getParentFile().getCanonicalPath();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (confDir == null) {
                        confDir = wrapperHome + "/conf";
                    }
                    if (confFile == null) {
                        this._logger.warning("no conf file found -> abort");
                        return;
                    }
                    try {
                        this._confFile = new File(confFile).getCanonicalPath();
                    }
                    catch (IOException e) {
                        this._logger.throwing(this.getClass().getName(), "init", e);
                    }
                    this._daemonTemplate = this._config.getString("wrapper.daemon.template", wrapperHome + "/templates/daemon.vm");
                    daemonTemplate = new File(this._daemonTemplate);
                    if (!daemonTemplate.exists() || !daemonTemplate.isFile()) {
                        if (this._logger != null) {
                            this._logger.warning("Error " + this._daemonTemplate + " : template file not found");
                        }
                        return;
                    }
                    daemonScript = this.getDaemonScript();
                    if (daemonScript.exists() && this._logger != null) {
                        this._logger.info(daemonScript.getAbsolutePath() + " already exists");
                    }
                    pidName = null;
                    try {
                        pidName = this._config.getString("wrapper.pidfile", new File(pidDir, "wrapper." + this.getName() + ".pid").getCanonicalPath());
                    }
                    catch (IOException e) {
                        if (this._logger == null) break block22;
                        this._logger.throwing(this.getClass().getName(), "init", e);
                    }
                }
                pidFile = new File(pidName);
                apidName = null;
                try {
                    apidName = this._config.getString("wrapper.java.pidfile", new File(pidDir, "wrapper.java." + this.getName() + ".pid").getCanonicalPath());
                }
                catch (IOException e) {
                    if (this._logger == null) break block23;
                    this._logger.throwing(this.getClass().getName(), "init", e);
                }
            }
            File apidFile = new File(apidName);
            try {
                this._daemonTemplate = daemonTemplate.getCanonicalPath();
                this._wrapperPidFile = pidFile.getCanonicalPath();
                this._appPidFile = apidFile.getCanonicalPath();
                this._daemonScript = daemonScript.getCanonicalPath();
            }
            catch (Exception ex) {
                if (this._logger == null) break block24;
                this._logger.throwing(this.getClass().getName(), "init", ex);
            }
        }
        JavaHome javaHome = OperatingSystem.instance().getJavaHome(this._config);
        String java = javaHome.findJava(this._config.getString("wrapper.ntservice.java.command"), this._config.getString("wrapper.java.customProcName"));
        this._startCmd = new String[10];
        this._startCmd[0] = java;
        this._startCmd[1] = "-Dwrapper.pidfile=" + this._wrapperPidFile;
        this._startCmd[2] = "-Dwrapper.service=true";
        this._startCmd[3] = "-Dwrapper.visible=false";
        this._startCmd[4] = null;
        this._startCmd[5] = null;
        this._startCmd[6] = "-jar";
        this._startCmd[7] = wrapperJar;
        this._startCmd[8] = "-tx";
        this._startCmd[9] = this._confFile;
        this._execCmd = (String[])this._startCmd.clone();
        this._execCmd[8] = "-c";
        if (this._config.getBoolean("wrapper.ntservice.debug", false)) {
            this._execCmd[4] = "-Xdebug";
            this._execCmd[5] = "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=1044";
        }
        this._stopCmd = (String[])this._startCmd.clone();
        this._stopCmd[8] = "-px";
        this._statusCmd = (String[])this._startCmd.clone();
        this._statusCmd[8] = "-qx";
        String defaultRunLevelDir = this._daemonDir + "/" + "rc5.d";
        String runLevelDir = this._config.getString("wrapper.daemon.run_level_dir", defaultRunLevelDir);
        this._updateRcParser = new UpdateRcParser(this._config.getString("wrapper.daemon.update_rc", null), runLevelDir, this.getName());
        this._ksLinks.addAll(this._updateRcParser.getStartLinks());
        this._ksLinks.addAll(this._updateRcParser.getStopLinks());
        this._stopTimeout = this._config.getInt("wrapper.shutdown.timeout", 30) * 1000;
    }

    protected String getDefaultDaemonDir() {
        return "/etc/init.d";
    }

    protected File getDaemonScript() {
        return new File(new File(this._daemonDir), this.getName());
    }

    public boolean install() {
        if (this._daemonScript == null) {
            if (this._logger != null) {
                this._logger.warning("Error : not initialized -> abort");
            }
            return false;
        }
        try {
            File daemonTemplate = new File(this._daemonTemplate);
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("resource.loader", (Object)"file");
            ve.setProperty("file.resource.loader.path", (Object)daemonTemplate.getParent());
            ve.setProperty("runtime.log.logsystem.class", (Object)VelocityLog.class.getCanonicalName());
            VelocityLog.setLogger(this._logger);
            ve.init();
            Template t = ve.getTemplate(daemonTemplate.getName());
            VelocityContext context = new VelocityContext();
            context.put("w_name", (Object)this._name);
            context.put("w_long_name", (Object)this._displayName);
            context.put("w_start_cmd", (Object)this.toStrCommand(this._startCmd));
            context.put("w_stop_cmd", (Object)this.toStrCommand(this._stopCmd));
            context.put("w_status_cmd", (Object)this.toStrCommand(this._statusCmd));
            context.put("w_description", (Object)this._description);
            context.put("w_conf_file", (Object)this._confFile);
            context.put("w_app_pid_file", (Object)this._appPidFile);
            context.put("w_wrapper_pid_file", (Object)this._wrapperPidFile);
            FileWriter writer = new FileWriter(this._daemonScript);
            t.merge((Context)context, (Writer)writer);
            writer.flush();
            writer.close();
            File daemonScript = new File(this._daemonScript);
            if (daemonScript.exists()) {
                if (this._logger != null) {
                    this._logger.warning("created daemon script: " + this._daemonScript);
                }
            } else if (this._logger != null) {
                this._logger.warning("error creating daemon script: " + this._daemonScript);
            }
            Runtime.getRuntime().exec("chmod 755 " + this._daemonScript);
            if ("AUTO_START".equals(this._config.getString("wrapper.ntservice.starttype", "AUTO_START")) || "DELAYED_AUTO_START".equals(this._config.getString("wrapper.ntservice.starttype", "AUTO_START"))) {
                for (String link : this._ksLinks) {
                    if (PosixProcess.CLibrary.INSTANCE.symlink(this._daemonScript, link) != 0) {
                        if (this._logger == null) continue;
                        this._logger.info("error on creating script link " + link);
                        continue;
                    }
                    if (new File(link).exists()) {
                        if (this._logger == null) continue;
                        this._logger.info("created link : " + link);
                        continue;
                    }
                    if (this._logger == null) continue;
                    this._logger.info("error on creating script link " + link);
                }
            }
        }
        catch (Exception ex) {
            if (this._logger != null) {
                this._logger.throwing(this.getClass().getName(), "install", ex);
            }
            return false;
        }
        return true;
    }

    private String toStrCommand(String[] cmd) {
        String tmp = "";
        for (String s : cmd) {
            if (s == null) continue;
            tmp = tmp + "\"" + s + "\" ";
        }
        return tmp;
    }

    public boolean isInstalled() {
        return this._daemonScript != null && new File(this._daemonScript).exists();
    }

    public boolean isRunning() {
        int pid = this.getPid();
        if (pid < 0) {
            return false;
        }
        Process p = OperatingSystem.instance().processManagerInstance().getProcess(pid);
        return p != null && p.isRunning();
    }

    public boolean start() {
        if (this.isRunning()) {
            if (this._logger != null) {
                this._logger.info("already running");
            }
            return true;
        }
        File f = new File(this._daemonScript);
        OperatingSystem.instance().setWorkingDir(f.getParent());
        String txt = this._utils.osCommand(this._daemonScript + " start", 45000L);
        if (this._logger != null) {
            this._logger.info(txt);
        }
        return this.isRunning();
    }

    public boolean stop() {
        if (this._logger != null) {
            this._logger.info(this._utils.osCommand(this._daemonScript + " stop", this._stopTimeout));
        }
        return !this.isRunning();
    }

    public boolean startProcess() {
        block4: {
            if (this.isRunning()) {
                this._logger.info("already running");
                return true;
            }
            try {
                if (this._logger != null) {
                    this._logger.info("calling " + this.toStrCommand(this._execCmd));
                }
                Runtime.getRuntime().exec(this.cleanCmd(this._execCmd));
            }
            catch (Exception e) {
                if (this._logger == null) break block4;
                this._logger.throwing(this.getClass().getName(), "startProcess", e);
            }
        }
        return true;
    }

    public boolean stopProcess() {
        int pid = this.getPid();
        if (this._logger != null) {
            this._logger.info("stop daemon with pid " + pid);
        }
        if (pid <= 0) {
            return false;
        }
        Process p = OperatingSystem.instance().processManagerInstance().getProcess(pid);
        if (p == null) {
            if (this._logger != null) {
                this._logger.info("process not running");
            }
            return true;
        }
        p.stop(this._stopTimeout, 0);
        int apid = this.getAppPid();
        if (this._logger != null) {
            this._logger.info("stop daemon app with pid " + apid);
        }
        if (apid <= 0) {
            return false;
        }
        Process ap = OperatingSystem.instance().processManagerInstance().getProcess(apid);
        if (ap != null) {
            ap.kill(999);
        }
        return true;
    }

    public boolean uninstall() {
        if (this.isRunning()) {
            this.stop();
        }
        new File(this._daemonScript).delete();
        for (String link : this._ksLinks) {
            new File(link).delete();
        }
        return true;
    }

    public int state() {
        int result = 0;
        if (new File(this._daemonScript).exists()) {
            result |= 1;
        }
        if (this.isRunning()) {
            result |= 2;
        }
        return result;
    }

    public int getPid() {
        block3: {
            this._logger.info("wrapper pid file: " + this._wrapperPidFile);
            if (this._wrapperPidFile != null && new File(this._wrapperPidFile).exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(this._wrapperPidFile));
                    String pid = reader.readLine();
                    reader.close();
                    return Integer.parseInt(pid);
                }
                catch (Exception e) {
                    if (this._logger == null) break block3;
                    this._logger.throwing(this.getClass().getName(), "getPid", e);
                }
            }
        }
        return -1;
    }

    public int getAppPid() {
        block3: {
            this._logger.info("app pid file: " + this._appPidFile);
            if (this._appPidFile != null && new File(this._appPidFile).exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(this._appPidFile));
                    String pid = reader.readLine();
                    reader.close();
                    return Integer.parseInt(pid);
                }
                catch (Exception e) {
                    if (this._logger == null) break block3;
                    this._logger.throwing(this.getClass().getName(), "getAppPid", e);
                }
            }
        }
        return -1;
    }

    public String[] cleanCmd(String[] cmd) {
        ArrayList<String> cmdl = new ArrayList<String>();
        for (String s : cmd) {
            if (s == null || "".equals(s)) continue;
            cmdl.add(s);
        }
        String[] result = new String[cmdl.size()];
        int i = 0;
        for (String s : cmdl) {
            result[i++] = s;
        }
        return result;
    }
}

