/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.bag.HashBag;
import org.apache.commons.lang.StringUtils;
import org.rzo.yajsw.os.ms.win.w32.PdhCounter;
import org.rzo.yajsw.os.ms.win.w32.ScriptCounter;

public class Pdh {
    static int MAX_COUNTER_PATH = 256;
    static int PDH_MAX_COUNTER_NAME = 1024;
    static int PDH_MAX_INSTANCE_NAME = 1024;
    static int PDH_MAX_COUNTER_PATH = 2048;
    static Map _indexes = null;

    public static List enumObjectItems(String objectName, boolean english) {
        if (english) {
            objectName = Pdh.translate(objectName);
        }
        HashBag bag = new HashBag();
        int pdhStatus = 0;
        Memory szCounterListBuffer = null;
        IntByReference dwCounterListSize = new IntByReference();
        Memory szInstanceListBuffer = null;
        IntByReference dwInstanceListSize = new IntByReference();
        String szThisInstance = null;
        pdhStatus = Pdhdll.INSTANCE.PdhEnumObjectItemsA(null, null, objectName, szCounterListBuffer, dwCounterListSize, szInstanceListBuffer, dwInstanceListSize, 400, 0);
        if (pdhStatus == -2147481646) {
            szCounterListBuffer = new Memory((long)(dwCounterListSize.getValue() * 4));
            szInstanceListBuffer = new Memory((long)(dwInstanceListSize.getValue() * 4));
            if (szCounterListBuffer != null && szInstanceListBuffer != null) {
                pdhStatus = Pdhdll.INSTANCE.PdhEnumObjectItemsA(null, null, objectName, szCounterListBuffer, dwCounterListSize, szInstanceListBuffer, dwInstanceListSize, 400, 0);
                if (pdhStatus == 0) {
                    int i = 0;
                    szThisInstance = szInstanceListBuffer.getString(0L);
                    while (szThisInstance != null && szThisInstance.length() > 0) {
                        bag.add((Object)szThisInstance);
                        szThisInstance = szInstanceListBuffer.getString((long)(i += szThisInstance.length() + 1));
                    }
                } else {
                    System.out.println("PdhEnumObjectItems failed with " + Integer.toHexString(pdhStatus));
                }
            } else {
                System.out.println("Unable to allocate buffers");
            }
        } else {
            System.out.println("PdhEnumObjectItems failed with " + Integer.toHexString(pdhStatus));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String str : bag.uniqueSet()) {
            result.add(str);
            for (int i = 1; i < bag.getCount((Object)str); ++i) {
                result.add(str + "#" + i);
            }
        }
        return result;
    }

    static void readIndexMap() {
        if (_indexes != null) {
            return;
        }
        _indexes = new HashMap();
        int ret = 0;
        IntByReference hkey = new IntByReference();
        ret = Advapi32.INSTANCE.RegOpenKeyExA(-2147483646, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Perflib\\009", 0, 131097, hkey);
        int BufferSize = 1;
        int BYTEINCREMENT = 1024;
        Memory PerfData = new Memory((long)BufferSize);
        PerfData.clear();
        IntByReference PBufferSize = new IntByReference();
        PBufferSize.setValue(BufferSize);
        ret = Advapi32.INSTANCE.RegQueryValueExA(hkey.getValue(), "Counter", null, null, (Pointer)PerfData, PBufferSize);
        while (ret == 234) {
            PBufferSize = new IntByReference();
            PBufferSize.setValue(BufferSize += BYTEINCREMENT);
            PerfData = new Memory((long)BufferSize);
            PerfData.clear();
            ret = Advapi32.INSTANCE.RegQueryValueExA(hkey.getValue(), "Counter", null, null, (Pointer)PerfData, PBufferSize);
        }
        if (ret != 0) {
            System.out.println("Error reading Registry entry SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Perflib\\009: " + Integer.toHexString(ret));
        } else {
            int i = 0;
            while (i < PBufferSize.getValue()) {
                String key = PerfData.getString((long)i);
                String counter = PerfData.getString((long)(i += key.length() + 1));
                i += counter.length() + 1;
                if (counter.length() <= 0 || key.length() <= 0) continue;
                try {
                    _indexes.put(counter, new Integer(Integer.parseInt(key)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        Advapi32.INSTANCE.RegCloseKey(hkey.getValue());
    }

    static String translate(String name) {
        Pdh.readIndexMap();
        Integer index = (Integer)_indexes.get(name);
        if (index == null) {
            return name;
        }
        Memory buff = new Memory(256L);
        IntByReference buffSize = new IntByReference();
        buffSize.setValue(256);
        if (Pdhdll.INSTANCE.PdhLookupPerfNameByIndexA(null, index, buff, buffSize) == 0) {
            return buff.getString(0L);
        }
        return name;
    }

    static Map readProcessMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        List processes = Pdh.enumObjectItems("Process", true);
        for (String process : processes) {
            PdhCounter c = Pdh.getEnglishCounter("\\Process(" + process + ")\\ID Process");
            int pid = c.getIntValue();
            c.close();
            result.put(new Integer(pid), process);
        }
        return result;
    }

    public static PdhCounter getEnglishCounter(String counter) {
        if (counter.startsWith("\\HddCounter")) {
            return new HddCounter(counter);
        }
        if (counter.startsWith("\\ScriptCounter")) {
            return new ScriptCounter(counter);
        }
        return new Counter(counter, true);
    }

    public static PdhCounter getLocaleCounter(String counter) {
        return new Counter(counter, false);
    }

    public static PdhCounter getProcessEnglishCounter(int pid, String counter) {
        Map m = Pdh.readProcessMap();
        String process = (String)m.get(new Integer(pid));
        if (process == null) {
            return null;
        }
        return Pdh.getEnglishCounter("\\Process(" + process + ")\\" + counter);
    }

    public static PdhCounter getProcessLocaleCounter(int pid, String counter) {
        Map m = Pdh.readProcessMap();
        String processObject = Pdh.translate("Process");
        String process = (String)m.get(new Integer(pid));
        if (process == null) {
            return null;
        }
        return Pdh.getLocaleCounter("\\" + processObject + "(" + process + ")\\" + counter);
    }

    public static class Counter
    implements PdhCounter {
        PointerByReference _hQuery = new PointerByReference();
        PointerByReference _hCounter = new PointerByReference();
        String _counter;

        Counter(String counter, boolean english) {
            int ret = Pdhdll.INSTANCE.PdhOpenQuery(null, null, this._hQuery);
            this._counter = counter;
            if (ret != 0) {
                System.out.println("Error in PdhOpenQuery " + counter + ": " + Integer.toHexString(ret));
            }
            if ((ret = english ? Pdhdll.INSTANCE.PdhAdd009CounterA(this._hQuery.getValue(), counter, 0, this._hCounter) : Pdhdll.INSTANCE.PdhAddCounterA(this._hQuery.getValue(), counter, 0, this._hCounter)) != 0) {
                throw new IllegalArgumentException("PdhCounter: " + counter + " " + ret);
            }
            this.getIntValue();
        }

        public boolean isValid() {
            return this._hCounter != null && this._hQuery != null && !this._hQuery.getValue().equals(null) && !this._hCounter.getValue().equals(null);
        }

        public double getDoubleValue() {
            if (!this.isValid()) {
                return -1.0;
            }
            PDH_FMT_COUNTERVALUE pdhCounterValue = new PDH_FMT_COUNTERVALUE();
            pdhCounterValue.size();
            int ret = Pdhdll.INSTANCE.PdhCollectQueryData(this._hQuery.getValue());
            if (ret != 0) {
                System.out.println("Error in PdhCollectQueryData " + this._counter + ": " + Integer.toHexString(ret));
            }
            PointerByReference result = new PointerByReference();
            ret = Pdhdll.INSTANCE.PdhGetFormattedCounterValue(this._hCounter.getValue(), 512, null, pdhCounterValue.getPointer());
            if (ret == 0) {
                pdhCounterValue.read();
                return pdhCounterValue.Value.doubleValue;
            }
            System.out.println("Error in PdhGetFormattedCounterValue " + this._counter + ": " + Integer.toHexString(ret));
            return -1.0;
        }

        public int getIntValue() {
            if (!this.isValid()) {
                return -1;
            }
            PDH_FMT_COUNTERVALUE pdhCounterValue = new PDH_FMT_COUNTERVALUE();
            pdhCounterValue.size();
            int ret = Pdhdll.INSTANCE.PdhCollectQueryData(this._hQuery.getValue());
            if (ret != 0) {
                System.out.println("Error in PdhCollectQueryData " + this._counter + ": " + Integer.toHexString(ret));
            }
            PointerByReference result = new PointerByReference();
            ret = Pdhdll.INSTANCE.PdhGetFormattedCounterValue(this._hCounter.getValue(), 256, null, pdhCounterValue.getPointer());
            if (ret == 0) {
                pdhCounterValue.read();
                return pdhCounterValue.Value.longValue;
            }
            System.out.println("Error in PdhGetFormattedCounterValue " + this._counter + ": " + Integer.toHexString(ret));
            return -1;
        }

        public void close() {
            if (!this.isValid()) {
                return;
            }
            if (this._hCounter != null) {
                Pdhdll.INSTANCE.PdhRemoveCounter(this._hCounter.getValue());
            }
            if (this._hQuery != null) {
                Pdhdll.INSTANCE.PdhCloseQuery(this._hQuery.getValue());
            }
            this._hQuery = null;
            this._hCounter = null;
        }
    }

    public static class HddCounter
    implements PdhCounter {
        private String _drive;
        private HDDInfoType _infoType = HDDInfoType.UnknownInfoType;

        public HddCounter(String counter) {
            this._drive = counter.substring(counter.indexOf(40) + 1, counter.indexOf(41));
            if (counter.endsWith("\\% free space")) {
                this._infoType = HDDInfoType.FreeSpaceInPercent;
            } else if (counter.endsWith("\\free space")) {
                this._infoType = HDDInfoType.FreeSpaceInBytes;
            } else if (counter.endsWith("\\used space")) {
                this._infoType = HDDInfoType.UsedSpaceInBytes;
            } else if (counter.endsWith("\\total space")) {
                this._infoType = HDDInfoType.TotalSpaceinBytes;
            }
        }

        public void close() {
        }

        public double getDoubleValue() {
            if (!this.isValid()) {
                throw new RuntimeException("Cannot find Harddisk drive " + this._drive);
            }
            org.rzo.yajsw.util.File file = new org.rzo.yajsw.util.File(this._drive);
            switch (this._infoType) {
                case FreeSpaceInPercent: {
                    return (double)file.getFreeSpace() / (double)file.getTotalSpace() * 100.0;
                }
                case FreeSpaceInBytes: {
                    return file.getFreeSpace();
                }
                case TotalSpaceinBytes: {
                    return file.getTotalSpace();
                }
                case UsedSpaceInBytes: {
                    return file.getTotalSpace() - file.getFreeSpace();
                }
            }
            return -1.0;
        }

        public int getIntValue() {
            return (int)this.getDoubleValue();
        }

        public boolean isValid() {
            return new org.rzo.yajsw.util.File(this._drive).exists() && !this._infoType.equals((Object)HDDInfoType.UnknownInfoType);
        }

        public static void main(String[] args) {
            File[] drives;
            PdhCounter cc = Pdh.getEnglishCounter("\\Process(MY_JAVA_VM_PROCESS)\\Handle Count");
            System.out.println("Handle Count: " + cc.getDoubleValue());
            cc = Pdh.getEnglishCounter("\\Process(MY_JAVA_VM_PROCESS)\\Thread Count");
            System.out.println("Thread Count: " + cc.getDoubleValue());
            cc = Pdh.getEnglishCounter("\\Process(MY_JAVA_VM_PROCESS)\\Private Bytes");
            System.out.println("Private Bytes: " + cc.getDoubleValue());
            for (File file : drives = org.rzo.yajsw.util.File.listRoots()) {
                PdhCounter c;
                String drive = file.getPath();
                drive = StringUtils.remove((String)drive, (char)'\\');
                System.out.println("Drive " + drive);
                try {
                    c = Pdh.getEnglishCounter("\\HddCounter(" + drive + ")\\used space");
                    System.out.println("\t UsedSpace  " + (long)c.getDoubleValue() / 0x100000L + " MB");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    c = Pdh.getEnglishCounter("\\HddCounter(" + drive + ")\\free space");
                    System.out.println("\t FreeSpace  " + (long)c.getDoubleValue() / 0x100000L + " MB");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    c = Pdh.getEnglishCounter("\\HddCounter(" + drive + ")\\total space");
                    System.out.println("\t TotalSpace " + (long)c.getDoubleValue() / 0x100000L + " MB");
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    c = Pdh.getEnglishCounter("\\HddCounter(" + drive + ")\\% free space");
                    System.out.println("\t FreeSpace  " + (long)c.getDoubleValue() + " %");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum HDDInfoType {
            FreeSpaceInPercent,
            FreeSpaceInBytes,
            UsedSpaceInBytes,
            TotalSpaceinBytes,
            UnknownInfoType;

        }
    }

    public static class COUNTER_PATH_ELEMENTS {
        public String szMachineName;
        public String szObjectName;
        public String szInstanceName;
        public int dwInstanceIndex;
        public String szCounterName;
    }

    public static class ValueUnion
    extends Union {
        public int longValue;
        public double doubleValue;
        public long largeValue;
        public String AnsiStringValue;
        public WString WideStringValue;
    }

    public static class PDH_FMT_COUNTERVALUE
    extends Structure {
        public int CStatus;
        public ValueUnion Value;
    }

    static interface Advapi32
    extends StdCallLibrary {
        public static final Advapi32 INSTANCE = (Advapi32)Native.loadLibrary((String)"Advapi32", Advapi32.class);
        public static final int HKEY_LOCAL_MACHINE = -2147483646;
        public static final int KEY_READ = 131097;
        public static final int HKEY_PERFORMANCE_DATA = -2147483644;
        public static final int ERROR_MORE_DATA = 234;

        public int RegOpenKeyExA(int var1, String var2, int var3, int var4, IntByReference var5);

        public int RegCloseKey(int var1);

        public int RegQueryValueExA(int var1, String var2, Pointer var3, IntByReference var4, Pointer var5, IntByReference var6);
    }

    static interface Pdhdll
    extends StdCallLibrary {
        public static final Pdhdll INSTANCE = (Pdhdll)Native.loadLibrary((String)"pdh", Pdhdll.class);
        public static final int ERROR_SUCCESS = 0;
        public static final int PDH_FMT_DOUBLE = 512;
        public static final int PDH_FMT_LONG = 256;
        public static final int PERF_DETAIL_WIZARD = 400;
        public static final int PDH_MORE_DATA = -2147481646;

        public int PdhOpenQuery(Pointer var1, Pointer var2, PointerByReference var3);

        public int PdhValidatePathA(String var1);

        public int PdhCollectQueryData(Pointer var1);

        public int PdhGetFormattedCounterValue(Pointer var1, int var2, IntByReference var3, Pointer var4);

        public int PdhAddCounterA(Pointer var1, String var2, int var3, PointerByReference var4);

        public int PdhAdd009CounterA(Pointer var1, String var2, int var3, PointerByReference var4);

        public int PdhRemoveCounter(Pointer var1);

        public int PdhCloseQuery(Pointer var1);

        public int PdhEnumObjectItemsA(String var1, String var2, String var3, Memory var4, IntByReference var5, Memory var6, IntByReference var7, int var8, int var9);

        public int PdhLookupPerfNameByIndexA(String var1, int var2, Memory var3, IntByReference var4);

        public int PdhParseCounterPathA(String var1, Pointer var2, IntByReference var3, int var4);
    }
}

