/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class FileUtils {
    static Logger log = Logger.getLogger(FileUtils.class.getName());

    public static long created(File file) {
        throw new UnsupportedOperationException("Sorry, not implemented in this verson");
    }

    public static long freeSpace(File file) {
        if (!file.isDirectory() || !file.exists()) {
            return -2L;
        }
        WinNT.LARGE_INTEGER.ByReference lpTotalNumberOfFreeBytes = new WinNT.LARGE_INTEGER.ByReference();
        lpTotalNumberOfFreeBytes.clear();
        boolean ret = Kernel32.INSTANCE.GetDiskFreeSpaceEx(file.getPath(), null, null, lpTotalNumberOfFreeBytes);
        if (ret) {
            return lpTotalNumberOfFreeBytes.getValue();
        }
        String s = Kernel32Util.formatMessageFromLastErrorCode((int)Kernel32.INSTANCE.GetLastError());
        log.severe("error in File.freeSpace getting for \"" + file.getPath() + "\" " + s);
        return -1L;
    }

    public static long totalSpace(File file) {
        if (!file.isDirectory() || !file.exists()) {
            return -2L;
        }
        WinNT.LARGE_INTEGER.ByReference lpTotalNumberOfBytes = new WinNT.LARGE_INTEGER.ByReference();
        lpTotalNumberOfBytes.clear();
        boolean ret = Kernel32.INSTANCE.GetDiskFreeSpaceEx(file.getPath(), null, lpTotalNumberOfBytes, null);
        if (ret) {
            return lpTotalNumberOfBytes.getValue();
        }
        String s = Kernel32Util.formatMessageFromLastErrorCode((int)Kernel32.INSTANCE.GetLastError());
        log.severe("error in File.totalSpace getting for \"" + file.getPath() + "\" " + s);
        return -1L;
    }

    public static Collection getFiles(String workingDir, String pattern) {
        ArrayList<File> result = new ArrayList<File>();
        File res = new File(pattern);
        if (res.exists() && res.isAbsolute()) {
            result.add(res);
            return result;
        }
        if (!res.isAbsolute() && (res = new File(workingDir, pattern)).exists()) {
            result.add(res);
            return result;
        }
        String[] s = pattern.split("[" + File.separator + "|/]");
        String[] sh = s.length == 1 ? new String[]{".", s[0]} : s;
        if (pattern.startsWith("/") && "".equals(sh[0])) {
            sh[0] = "/";
        }
        HashSet<String> paths = new HashSet<String>();
        paths.add(sh[0]);
        for (int i = 1; i < sh.length; ++i) {
            String file = sh[i];
            HashSet<String> newPaths = new HashSet<String>();
            for (String pathStr : paths) {
                File path;
                if (pathStr.endsWith(":")) {
                    pathStr = pathStr + "/";
                }
                if (!((path = new File(pathStr)).isDirectory() && path.exists() && path.isAbsolute())) {
                    path = new File(workingDir, pathStr);
                }
                Collection files = FileUtils.getWildcardFiles(path.getAbsolutePath(), file);
                for (File f : files) {
                    if (f.isDirectory()) {
                        newPaths.add(f.getPath());
                        continue;
                    }
                    if (!f.isFile()) continue;
                    result.add(f);
                }
            }
            paths = newPaths;
        }
        if (result.size() == 0) {
            log.warning("No files found for " + pattern);
        }
        return result;
    }

    private static Collection getWildcardFiles(String path, String file) {
        ArrayList<File> result = new ArrayList<File>();
        File fPath = new File(path);
        try {
            if (!fPath.isDirectory()) {
                log.warning("classpath directory " + fPath.getCanonicalPath() + " not found");
                return result;
            }
        }
        catch (Exception ex) {
            log.warning("classpath directory " + path + " error" + ex.getMessage());
            return result;
        }
        WildcardFileFilter fileFilter = new WildcardFileFilter(file);
        File[] thisFiles = fPath.listFiles((FileFilter)fileFilter);
        for (int i = 0; i < thisFiles.length; ++i) {
            File f = thisFiles[i];
            if (f.exists()) {
                result.add(f);
                continue;
            }
            log.warning("classpath file " + f.getName() + "not found");
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(FileUtils.freeSpace(new File("C:\\")));
        System.out.println(FileUtils.totalSpace(new File("C:\\")));
        Iterator it = FileUtils.getFiles(".", "lib/*/*/*jar").iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

