/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.rzo.yajsw.os.ms.win.w32.ClusterNodeChangeListener;
import org.rzo.yajsw.os.ms.win.w32.WindowsXPProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster {
    static Logger _log = Logger.getLogger(Cluster.class.getCanonicalName());
    ExecutorService threadPool = Executors.newSingleThreadExecutor();
    ArrayList<ClusterNodeChangeListener> _listeners = new ArrayList();
    boolean _stopped = true;

    public String getActiveNode() {
        String activeNode = null;
        try {
            Pointer cluster = Clusapi.INSTANCE.OpenCluster(null);
            Pointer hEnum = Clusapi.INSTANCE.ClusterOpenEnum(cluster, 8);
            int dwIndex = 0;
            IntByReference lpdwType = new IntByReference();
            IntByReference lpcchName = new IntByReference();
            Memory lpszName = new Memory(256L);
            lpszName.clear();
            lpcchName.setValue(256);
            int result = 0;
            do {
                String group2;
                ClusterGroupInfo info;
                if ((result = Clusapi.INSTANCE.ClusterEnum(hEnum, dwIndex, lpdwType, lpszName, lpcchName)) == 0 && (info = this.getGroupNodeInfo(cluster, group2 = lpszName.getString(0L, true))) != null) {
                    activeNode = info.getLocation();
                }
                ++dwIndex;
            } while (result == 0);
        }
        catch (Exception ex) {
            _log.log(Level.SEVERE, "Error getting cluster information", ex);
        }
        return activeNode;
    }

    private ClusterGroupInfo getGroupNodeInfo(Pointer cluster, String groupName) {
        ClusterGroupInfo result = null;
        try {
            Pointer hGroup = Clusapi.INSTANCE.OpenClusterGroup(cluster, new WString(groupName));
            if (hGroup == null) {
                throw new RuntimeException("Clusapi call to OpenClusterGroup returned err code " + WindowsXPProcess.MyKernel32.INSTANCE.GetLastError());
            }
            IntByReference lpcchNodeName = new IntByReference();
            Memory lpszNodeName = new Memory(256L);
            lpszNodeName.clear();
            lpcchNodeName.setValue(256);
            int state = Clusapi.INSTANCE.GetClusterGroupState(hGroup, lpszNodeName, lpcchNodeName);
            String location = lpszNodeName.getString(0L, true);
            if (state == -1) {
                _log.severe("unknown group state for group " + groupName + " err code " + WindowsXPProcess.MyKernel32.INSTANCE.GetLastError());
            }
            result = new ClusterGroupInfo(groupName, state, location);
            WindowsXPProcess.MyKernel32.INSTANCE.CloseHandle(hGroup);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error while getting GroupActiveNode", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClusterGroupInfo> getGroupInfo() {
        Pointer hCluster = Clusapi.INSTANCE.OpenCluster(null);
        if (hCluster == null) {
            throw new RuntimeException("Clusapi call to OpenClusterGroup returned err code " + WindowsXPProcess.MyKernel32.INSTANCE.GetLastError());
        }
        Pointer hEnum = Clusapi.INSTANCE.ClusterOpenEnum(hCluster, 8);
        if (hEnum == null) {
            throw new RuntimeException("Clusapi call to ClusterOpenEnum returned err code " + WindowsXPProcess.MyKernel32.INSTANCE.GetLastError());
        }
        LinkedHashSet<ClusterGroupInfo> result = new LinkedHashSet<ClusterGroupInfo>();
        try {
            IntByReference lpdwType = new IntByReference();
            IntByReference lpcchName = new IntByReference(0);
            Memory lpszName = new Memory(256L);
            int dwIndex = 0;
            int returnValue = 0;
            do {
                String group2;
                ClusterGroupInfo info;
                lpdwType.setValue(0);
                lpcchName.setValue(0);
                lpszName.clear();
                lpcchName.setValue(256);
                returnValue = Clusapi.INSTANCE.ClusterEnum(hEnum, dwIndex, lpdwType, lpszName, lpcchName);
                if (returnValue == 0 && (info = this.getGroupNodeInfo(hCluster, group2 = lpszName.getString(0L, true))) != null) {
                    result.add(info);
                }
                if (returnValue != 259 && returnValue != 0) {
                    _log.log(Level.SEVERE, "strange returnValue from ClusApi" + returnValue);
                }
                ++dwIndex;
            } while (returnValue == 0);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error while getting Cluster group information", e);
        }
        finally {
            WindowsXPProcess.MyKernel32.INSTANCE.CloseHandle(hEnum);
            WindowsXPProcess.MyKernel32.INSTANCE.CloseHandle(hCluster);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Runnable check = null;
        Cluster cluster = this;
        synchronized (cluster) {
            if (this._stopped) {
                check = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    public void run() {
                        IntByReference lpdwNotifyKey = new IntByReference();
                        IntByReference lpdwFilterType = new IntByReference();
                        IntByReference lpcchName = new IntByReference();
                        IntByReference dwNotifyKey = new IntByReference();
                        Memory lpszName = new Memory(256L);
                        Pointer minusOne = Pointer.createConstant((int)-1);
                        int dwMilliseconds = 300000;
                        int dwFilter = -1610059776;
                        while (!Cluster.this._stopped) {
                            long started;
                            Pointer hChange;
                            Pointer hCluster;
                            block21: {
                                hCluster = null;
                                hChange = null;
                                started = System.currentTimeMillis();
                                lpdwNotifyKey.setValue(0);
                                lpdwFilterType.setValue(0);
                                lpcchName.setValue(0);
                                dwNotifyKey.setValue(0);
                                lpszName.clear();
                                lpcchName.setValue(256);
                                hCluster = Clusapi.INSTANCE.OpenCluster(null);
                                if (hCluster == null) {
                                    _log.severe("ClusApi.OpenCluster returned err code " + WindowsXPProcess.MyKernel32.INSTANCE.GetLastError());
                                } else {
                                    hChange = Clusapi.INSTANCE.CreateClusterNotifyPort(minusOne, hCluster, -1610059776, dwNotifyKey);
                                    if (hChange == null) {
                                        _log.severe("ClusApi.CreateClusterNotifyPort returned err code " + WindowsXPProcess.MyKernel32.INSTANCE.GetLastError());
                                    }
                                }
                                if (hCluster == null || hChange == null) {
                                    Thread.sleep(5000L);
                                } else {
                                    int result = Clusapi.INSTANCE.GetClusterNotify(hChange, lpdwNotifyKey, lpdwFilterType, lpszName, lpcchName, dwMilliseconds);
                                    if (result == 0) {
                                        Cluster.this.doListeners(null, lpdwFilterType.getValue(), lpszName.getString(0L, true));
                                    } else if (result != 258) {
                                        _log.warning("ClusApi.GetClusterNotify result=" + result);
                                    }
                                }
                                _log.info("check cluster took " + (System.currentTimeMillis() - started) + " ms");
                                if (hChange == null) break block21;
                                try {
                                    Clusapi.INSTANCE.CloseClusterNotifyPort(hChange);
                                }
                                catch (Throwable e2) {
                                    e2.printStackTrace();
                                }
                                WindowsXPProcess.MyKernel32.INSTANCE.CloseHandle(hChange);
                            }
                            if (hCluster == null) continue;
                            WindowsXPProcess.MyKernel32.INSTANCE.CloseHandle(hCluster);
                            continue;
                            catch (Throwable e) {
                                block22: {
                                    try {
                                        _log.log(Level.SEVERE, "Error getting ClusterInformation", e);
                                        _log.info("check cluster took " + (System.currentTimeMillis() - started) + " ms");
                                        if (hChange == null) break block22;
                                    }
                                    catch (Throwable throwable) {
                                        _log.info("check cluster took " + (System.currentTimeMillis() - started) + " ms");
                                        if (hChange != null) {
                                            try {
                                                Clusapi.INSTANCE.CloseClusterNotifyPort(hChange);
                                            }
                                            catch (Throwable e2) {
                                                e2.printStackTrace();
                                            }
                                            WindowsXPProcess.MyKernel32.INSTANCE.CloseHandle(hChange);
                                        }
                                        if (hCluster != null) {
                                            WindowsXPProcess.MyKernel32.INSTANCE.CloseHandle(hCluster);
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        Clusapi.INSTANCE.CloseClusterNotifyPort(hChange);
                                    }
                                    catch (Throwable e2) {
                                        e2.printStackTrace();
                                    }
                                    WindowsXPProcess.MyKernel32.INSTANCE.CloseHandle(hChange);
                                }
                                if (hCluster == null) continue;
                                WindowsXPProcess.MyKernel32.INSTANCE.CloseHandle(hCluster);
                            }
                        }
                    }
                };
                this._stopped = false;
            }
        }
        new Thread(check, "cluster listener thread").start();
    }

    private void doListeners(String activeNode, int lpdwFilterType, String lpszName) {
        try {
            switch (lpdwFilterType) {
                case 16384: {
                    _log.severe("cluster group added: " + lpszName);
                    break;
                }
                case 8192: {
                    _log.severe("cluster group deleted: " + lpszName);
                    break;
                }
                case 4096: {
                    _log.severe("cluster group state changed: " + lpszName);
                    break;
                }
                case -2147483648: {
                    _log.severe("The queue receives a notification when a handle associated with a cluster object is closed. " + lpszName);
                    break;
                }
                case 524288: {
                    _log.severe("The queue receives a notification when the connection to the cluster identified by hCluster is reestablished after a brief disconnect. Some events generated immediately before or after this event may have been lost. val=" + lpszName);
                    break;
                }
                case 0x20000000: {
                    _log.severe("all attempts to communicate with the cluster failed, val=" + lpszName);
                    break;
                }
                default: {
                    _log.severe("unknown event id=" + Integer.toHexString(lpdwFilterType) + ", val=" + lpszName);
                    break;
                }
            }
        }
        catch (Throwable e) {
            _log.log(Level.SEVERE, "Error in Cluster Logging", e);
        }
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList<ClusterNodeChangeListener> listeners = new ArrayList<ClusterNodeChangeListener>();
                ArrayList<ClusterNodeChangeListener> arrayList = Cluster.this._listeners;
                synchronized (arrayList) {
                    listeners.addAll(Cluster.this._listeners);
                }
                for (ClusterNodeChangeListener l : listeners) {
                    try {
                        l.nodeChanged();
                    }
                    catch (Throwable e) {
                        _log.log(Level.SEVERE, "Error in ClusterNodeChangeListener.nodeChanged()", e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodeChangeListener(ClusterNodeChangeListener listener) {
        ArrayList<ClusterNodeChangeListener> arrayList = this._listeners;
        synchronized (arrayList) {
            this._listeners.add(listener);
        }
    }

    public void stop() {
        this._stopped = true;
    }

    public static void main(String[] args) throws UnknownHostException {
        final Cluster c = new Cluster();
        c.addNodeChangeListener(new ClusterNodeChangeListener(){

            public void nodeChanged() {
                try {
                    System.out.println("new GroupInfo" + c.getGroupInfo());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        c.start();
        try {
            Thread.sleep(Integer.MAX_VALUE);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public class ClusterGroupInfo {
        private final String _groupName;
        private final String _location;
        Clusapi.ClusterGroupState _state = Clusapi.ClusterGroupState.Unknown;

        public ClusterGroupInfo(String groupName, int state, String location) {
            this._groupName = groupName;
            this._location = location;
            this._state = Clusapi.ClusterGroupState.parse(state);
        }

        public String getGroupName() {
            return this._groupName;
        }

        public String getLocation() {
            return this._location;
        }

        public Clusapi.ClusterGroupState getState() {
            return this._state;
        }

        public boolean equals(ClusterGroupInfo info) {
            if (super.equals(info)) {
                return true;
            }
            return StringUtils.equals((String)this._location, (String)info._location) && StringUtils.equals((String)this._groupName, (String)info._groupName) && this._state == info._state;
        }

        public String toString() {
            return this._groupName + "(" + (Object)((Object)this._state) + ", " + this._location + ")";
        }
    }

    public static interface Clusapi
    extends StdCallLibrary {
        public static final Clusapi INSTANCE = (Clusapi)Native.loadLibrary((String)"ClusApi", Clusapi.class);
        public static final int CLUSTER_CHANGE_GROUP_STATE = 4096;
        public static final int CLUSTER_CHANGE_HANDLE_CLOSE = Integer.MIN_VALUE;
        public static final int CLUSTER_CHANGE_CLUSTER_RECONNECT = 524288;
        public static final int CLUSTER_CHANGE_CLUSTER_STATE = 0x20000000;
        public static final int CLUSTER_CHANGE_GROUP_DELETED = 8192;
        public static final int CLUSTER_CHANGE_GROUP_ADDED = 16384;
        public static final int WAIT_TIMEOUT = 258;
        public static final int ERROR_SUCCESS = 0;
        public static final int ERROR_NO_MORE_ITEMS = 259;
        public static final int CLUSTER_GROUP_STATE_UNKNOWN = -1;
        public static final int CLUSTER_GROUP_ONLINE = 0;
        public static final int CLUSTER_GROUP_OFFLINE = 1;
        public static final int CLUSTER_GROUP_FAILED = 2;
        public static final int CLUSTER_GROUP_PARTIAL_ONLINE = 3;
        public static final int CLUSTER_GROUP_PENDING = 4;
        public static final int CLUSTER_ENUM_NODE = 1;
        public static final int CLUSTER_ENUM_RESOURCE = 4;
        public static final int CLUSTER_ENUM_NETINTERFACE = 32;
        public static final int CLUSTER_ENUM_GROUP = 8;

        public Pointer OpenCluster(WString var1);

        public boolean CloseCluster(Pointer var1);

        public Pointer CreateClusterNotifyPort(Pointer var1, Pointer var2, int var3, IntByReference var4);

        public int GetClusterNotify(Pointer var1, IntByReference var2, IntByReference var3, Memory var4, IntByReference var5, int var6);

        public boolean CloseClusterNotifyPort(Pointer var1);

        public Pointer OpenClusterNode(Pointer var1, WString var2);

        public boolean CloseClusterNode(Pointer var1);

        public int GetClusterNodeState(Pointer var1);

        public Pointer ClusterOpenEnum(Pointer var1, int var2);

        public Pointer ClusterNodeOpenEnum(Pointer var1, int var2);

        public int ClusterCloseEnum(Pointer var1);

        public int ClusterEnum(Pointer var1, int var2, IntByReference var3, Memory var4, IntByReference var5);

        public int ClusterNodeEnum(Pointer var1, int var2, IntByReference var3, Memory var4, IntByReference var5);

        public Pointer OpenClusterResource(Pointer var1, WString var2);

        public Pointer OpenClusterGroup(Pointer var1, WString var2);

        public int GetClusterGroupState(Pointer var1, Memory var2, IntByReference var3);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ClusterGroupState {
            Unknown,
            Online,
            Offline,
            Failed,
            PartialOnline,
            Pending;


            public static ClusterGroupState parse(int val) {
                switch (val) {
                    case -1: {
                        return Unknown;
                    }
                    case 0: {
                        return Online;
                    }
                    case 1: {
                        return Offline;
                    }
                    case 2: {
                        return Failed;
                    }
                    case 3: {
                        return PartialOnline;
                    }
                    case 4: {
                        return Pending;
                    }
                }
                _log.severe("unknown cluster state: " + val);
                return Unknown;
            }
        }
    }
}

