/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os;

import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.rzo.yajsw.os.Process;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcess
implements Process {
    protected String _cmd;
    protected String[] _arrCmd;
    protected String _workingDir;
    protected int _priority = -99;
    protected boolean _visible = true;
    protected volatile int _pid = -1;
    protected volatile int _exitCode = -1;
    protected String _title = "";
    protected int _cpuAffinity = -99;
    protected boolean _pipeStreams = false;
    protected boolean _redirectErrorStream = false;
    protected InputStream _inputStream;
    protected OutputStream _outputStream;
    protected InputStream _errorStream;
    protected final FileDescriptor in_fd = new FileDescriptor();
    protected final FileDescriptor out_fd = new FileDescriptor();
    protected final FileDescriptor err_fd = new FileDescriptor();
    protected String _teeName;
    protected String _tmpPath;
    protected String _user;
    protected String _password;
    protected Logger _logger;
    protected List<String[]> _environment = new ArrayList<String[]>();
    protected boolean _debug = false;
    protected boolean _minimized = false;
    protected boolean _logonActiveSession = false;
    protected String _desktop = null;

    @Override
    public String getCommand() {
        return this._cmd;
    }

    @Override
    public void setCommand(String cmd) {
        this._cmd = cmd;
    }

    @Override
    public void setCommand(String[] cmds) {
        this._arrCmd = cmds;
        this._cmd = null;
    }

    @Override
    public List<String[]> getEnvironment() {
        return this._environment;
    }

    @Override
    public Map<String, String> getEnvironmentAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String[] entry : this._environment) {
            result.put(entry[0], entry[1]);
        }
        return result;
    }

    @Override
    public void setEnvironment(List<String[]> environment) {
        if (environment == null) {
            environment = new ArrayList<String[]>();
        }
        this._environment = environment;
    }

    @Override
    public int getExitCode() {
        return this._exitCode;
    }

    protected void setExitCode(int exitCode) {
        this._exitCode = exitCode;
    }

    @Override
    public int getPid() {
        return this._pid;
    }

    public void setPid(int pid) {
        this._pid = pid;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public void setPriority(int priority) {
        this._priority = priority;
    }

    @Override
    public boolean isVisible() {
        return this._visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this._visible = visible;
    }

    @Override
    public String getWorkingDir() {
        return this._workingDir;
    }

    @Override
    public void setWorkingDir(String workingDir) {
        this._workingDir = workingDir;
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public void setTitle(String title) {
        this._title = title;
    }

    public int getCpuAffinity() {
        return this._cpuAffinity;
    }

    @Override
    public void setCpuAffinity(int cpuAffinity) {
        this._cpuAffinity = cpuAffinity;
    }

    @Override
    public void setPipeStreams(boolean pipeStreams, boolean redirectErrorStream) {
        this._pipeStreams = pipeStreams;
        this._redirectErrorStream = redirectErrorStream;
    }

    @Override
    public InputStream getInputStream() {
        return this._inputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this._errorStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this._outputStream;
    }

    String getTeeName() {
        return this._teeName;
    }

    @Override
    public void setTeeName(String teeName) {
        this._teeName = teeName;
    }

    @Override
    public void setTmpPath(String tmpPath) {
        this._tmpPath = tmpPath;
    }

    @Override
    public String getUser() {
        return this._user;
    }

    @Override
    public void setUser(String user) {
        this._user = user;
    }

    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    protected void log(String msg) {
        if (this._logger != null) {
            this._logger.info(msg);
        } else {
            System.out.println(msg);
        }
    }

    protected void throwing(String cls, String method, Throwable ex) {
        if (this._logger != null) {
            this._logger.throwing(cls, method, ex);
        } else {
            ex.printStackTrace();
        }
    }

    @Override
    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    @Override
    public void setMinimized(boolean minimized) {
        this._minimized = minimized;
    }

    @Override
    public boolean isLogonActiveSession() {
        return this._logonActiveSession;
    }

    @Override
    public void setLogonActiveSession(boolean logonActiveSession) {
        this._logonActiveSession = logonActiveSession;
    }

    @Override
    public void setDesktop(String desktop) {
        this._desktop = desktop;
    }
}

