/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class CyclicBufferFilePrintStream
extends PrintStream {
    public static int length = 204800;

    public static OutputStream newOutputStream(final RandomAccessFile raf) throws IOException {
        return new OutputStream(){
            ByteBuffer buf;
            ByteBuffer posBuf;
            ByteBuffer lockBuf;
            {
                this.buf = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 5L, length - 5);
                this.posBuf = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 1L, 4L);
                this.lockBuf = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 1L);
            }

            public synchronized void close() throws IOException {
                super.close();
                raf.close();
            }

            private void lock() {
                this.lockBuf.position(0);
                this.lockBuf.put((byte)1);
            }

            private void unlock() {
                this.lockBuf.position(0);
                this.lockBuf.put((byte)0);
            }

            private void setPosition(int pos) {
                this.posBuf.position(0);
                this.posBuf.putInt(pos);
            }

            public synchronized void write(int b) throws IOException {
                this.lock();
                if (this.buf.remaining() == 0) {
                    this.buf.position(0);
                }
                this.buf.put((byte)b);
                this.setPosition(this.buf.position());
                this.unlock();
            }

            public synchronized void write(byte[] bytes, int off, int len) throws IOException {
                this.lock();
                int toWrite = this.buf.remaining() > len ? len : this.buf.remaining();
                this.buf.put(bytes, off, toWrite);
                if (toWrite != len) {
                    this.buf.position(0);
                    this.buf.put(bytes, off + toWrite, len - toWrite);
                }
                this.setPosition(this.buf.position());
                this.unlock();
            }
        };
    }

    public CyclicBufferFilePrintStream(File file) throws IOException {
        super(CyclicBufferFilePrintStream.newOutputStream(new RandomAccessFile(file, "rw")));
    }

    public static void main(String[] args) {
        try {
            CyclicBufferFilePrintStream writer = new CyclicBufferFilePrintStream(new File("test.dat"));
            for (int i = 0; i < 10000000; ++i) {
                writer.println("test " + i);
                System.out.println("test " + i);
                if (i % 2000 != 0) continue;
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

