/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.io;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CircularBuffer
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    private Lock lock = new ReentrantLock();
    private Condition notEmpty = this.lock.newCondition();
    private Condition notFull = this.lock.newCondition();
    private byte[] buffer;
    private int size = 0;
    private int putIndex = 0;
    private int getIndex = 0;
    boolean blocking = true;
    byte[] fullIndicator;
    boolean fullIndocatorWritten = false;
    boolean writeBlocking;
    int fullIndicatorIndex = -1;

    public CircularBuffer(int bufferSize, boolean blocking) {
        this.buffer = new byte[bufferSize];
        this.blocking = blocking;
        this.writeBlocking = blocking;
    }

    public void setWriteBlocking(boolean blocking) {
        this.writeBlocking = blocking;
    }

    public CircularBuffer() {
        this.buffer = new byte[512];
    }

    public void put(byte value) {
        this.lock.lock();
        try {
            while (this.size == this.buffer.length) {
                if (this.writeBlocking) {
                    this.notFull.await();
                    continue;
                }
                this.lock.unlock();
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.buffer[this.putIndex] = value;
        this.putByte(value);
        this.notEmpty.signal();
        this.lock.unlock();
    }

    private void writeFullIndicator() {
        this.fullIndocatorWritten = true;
    }

    public void put(byte[] buf, int off, int len) {
        this.lock.lock();
        for (int i = off; i < off + len - 1; ++i) {
            this.putByte(buf[i]);
        }
        this.notEmpty.signal();
        this.lock.unlock();
    }

    private void putByte(byte value) {
        this.buffer[this.putIndex] = value;
        ++this.putIndex;
        if (this.putIndex >= this.buffer.length) {
            this.putIndex -= this.buffer.length;
        }
        ++this.size;
        if (this.size > this.buffer.length) {
            ++this.getIndex;
            if (this.getIndex >= this.buffer.length) {
                this.getIndex -= this.buffer.length;
            }
            this.size = this.buffer.length;
            if (this.fullIndicator != null && !this.fullIndocatorWritten) {
                this.writeFullIndicator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte get() {
        byte result = 0;
        this.lock.lock();
        try {
            while (this.size == 0) {
                if (this.blocking) {
                    this.notEmpty.await();
                    continue;
                }
                this.lock.unlock();
                byte by = 0;
                return by;
            }
            result = this.getByte();
            this.notFull.signal();
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
            Thread.currentThread().interrupt();
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    public int get(byte[] buf, int off, int len) {
        this.lock.lock();
        int i = 0;
        try {
            while (this.size == 0) {
                this.notEmpty.await();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (i < len && i < this.size) {
            buf[off + i] = this.getByte();
            ++i;
        }
        this.notFull.signal();
        this.lock.unlock();
        return i;
    }

    private byte getByte() {
        if (this.fullIndocatorWritten) {
            ++this.fullIndicatorIndex;
            if (this.fullIndicatorIndex < this.fullIndicator.length) {
                return this.fullIndicator[this.fullIndicatorIndex];
            }
            this.fullIndicatorIndex = -1;
            this.fullIndocatorWritten = false;
        }
        if (this.size == 0) {
            return 0;
        }
        byte result = this.buffer[this.getIndex];
        ++this.getIndex;
        if (this.getIndex >= this.buffer.length) {
            this.getIndex -= this.buffer.length;
        }
        --this.size;
        return result;
    }

    public int size() {
        return this.size;
    }

    public void close() {
        this.lock.lock();
        this.notFull.signal();
        this.notEmpty.signal();
        this.size = 0;
        this.putIndex = 0;
        this.getIndex = 0;
        this.lock.unlock();
    }

    public static void main(String[] args) {
        CircularBuffer b = new CircularBuffer(2, true);
        b.put((byte)1);
        b.put((byte)2);
        b.put((byte)3);
        System.out.println(b.get());
        System.out.println(b.get());
        b.put(new byte[]{1, 2, 3, 4}, 0, 4);
        System.out.println(b.get(new byte[10], 0, 10));
        System.out.println(b.get(new byte[10], 0, 10));
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        this.lock.lock();
        int i = 0;
        try {
            while (this.size == 0) {
                if (this.blocking) {
                    this.notEmpty.await();
                    continue;
                }
                this.lock.unlock();
                return -1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (i < len && i < this.size) {
            cbuf[off + i] = (char)this.getByte();
            ++i;
        }
        this.notFull.signal();
        this.lock.unlock();
        return i;
    }

    public void write(char[] cbuf, int off, int len) {
        this.lock.lock();
        for (int i = off; i < off + len - 1; ++i) {
            this.putByte((byte)cbuf[i]);
        }
        this.notEmpty.signal();
        this.lock.unlock();
    }

    public void write(String str) {
        char[] dst = new char[str.length() + 2];
        str.getChars(0, str.length(), dst, 0);
        dst[str.length()] = 13;
        dst[str.length()] = 10;
        this.write(dst, 0, dst.length);
    }

    public void setFullIndicator(String text) {
        this.fullIndicator = text.getBytes();
    }
}

