/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.controller.runtime;

import java.util.Collections;
import org.apache.commons.collections.MultiHashMap;
import org.rzo.yajsw.controller.AbstractController;
import org.rzo.yajsw.wrapper.WrappedProcess;
import org.rzo.yajsw.wrapper.WrappedRuntimeProcess;

public class RuntimeController
extends AbstractController {
    static final int STATE_IDLE = 0;
    static final int STATE_RUNNING = 1;
    public static final int STATE_STOPPED = 2;
    static final int STATE_USER_STOP_REQUEST = 3;
    public static final int STATE_USER_STOPPED = 4;
    static final int STATE_STARTUP_TIMEOUT = 5;

    public RuntimeController(WrappedProcess process) {
        super(process);
    }

    public boolean start() {
        return true;
    }

    public void processStarted() {
        this.getLog().info("process started");
        executor.execute(new Runnable(){

            public void run() {
                RuntimeController.this.getLog().info("process run started");
                RuntimeController.this._wrappedProcess.setAppReportedReady(true);
                RuntimeController.this.setState(1);
                ((WrappedRuntimeProcess)RuntimeController.this._wrappedProcess)._osProcess.waitFor();
                RuntimeController.this.getLog().info("process exited");
                if (RuntimeController.this._state == 3) {
                    RuntimeController.this.setState(4);
                } else {
                    RuntimeController.this.setState(2);
                }
                RuntimeController.this.getLog().info("all terminated");
            }
        });
    }

    public void stop(int state, String reason) {
        this.setState(state);
    }

    public void reset() {
        this._listeners = Collections.synchronizedMap(new MultiHashMap());
        this.setState(0);
    }

    public String stateAsStr(int state) {
        switch (state) {
            case 0: {
                return "IDLE";
            }
            case 1: {
                return "RUNNING";
            }
            case 2: {
                return "STOPPED";
            }
            case 3: {
                return "USER_STOP_REQUEST";
            }
            case 4: {
                return "USER_STOPPED";
            }
            case 5: {
                return "STARTUP_TIMEOUT";
            }
        }
        return "?";
    }

    public void logStateChange(int state) {
        if (state == 5) {
            this.getLog().warning("startup of java application timed out. if this is due to server overload consider increasing wrapper.startup.timeout");
        }
    }

    public void processFailed() {
        this.stop(2, null);
    }

    public void beginWaitForStartup() {
    }
}

