/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.controller.jvm;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.rzo.yajsw.controller.AbstractController;
import org.rzo.yajsw.controller.Message;
import org.rzo.yajsw.controller.jvm.ControllerPipelineFactory;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.util.Cycler;
import org.rzo.yajsw.util.DaemonThreadFactory;
import org.rzo.yajsw.wrapper.WrappedJavaProcess;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class JVMController
extends AbstractController {
    static final int STATE_UNKNOWN = 0;
    static final int STATE_WAITING = 1;
    static final int STATE_ESTABLISHED = 2;
    static final int STATE_LOGGED_ON = 3;
    public static final int STATE_STARTUP_TIMEOUT = 4;
    public static final int STATE_WAITING_CLOSED = 5;
    public static final int STATE_USER_STOP = 6;
    public static final int STATE_PING_TIMEOUT = 7;
    public static final int STATE_PROCESS_KILLED = 8;
    int _port = 15003;
    int _minPort = 15003;
    int _maxPort = 65535;
    int _startupTimeout = 30000;
    String _key;
    int _pingTimeout = 10;
    boolean _pingOK = false;
    static Executor _pingExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory("pinger"));
    Channel _channel;
    ServerBootstrap _acceptor = null;
    Channel _parentChannel;
    boolean _init = false;
    static final Set _usedPorts = Collections.synchronizedSet(new TreeSet());
    private static final ScheduledExecutorService _scheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("controller.scheduler"));
    volatile ScheduledFuture<?> _timeoutHandle;
    Cycler _pingCheck;
    ExecutorService workerExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory("controller-worker"));
    Runnable _serviceStartupListener;
    private volatile boolean _waitingForProcessTermination = false;

    public JVMController(WrappedProcess wrappedJavaProcess) {
        super(wrappedJavaProcess);
    }

    public void init() {
        if (this._pingCheck == null) {
            this._pingCheck = new Cycler(this._pingTimeout, this._pingTimeout, _pingExecutor, new Runnable(){

                public void run() {
                    if (!JVMController.this._pingOK) {
                        JVMController.this.getLog().info("Missing wrapper ping within timeout of " + JVMController.this._pingTimeout);
                        executor.execute(new Runnable(){

                            public void run() {
                                JVMController.this.stop(7, "PING_TIMEOUT");
                            }
                        });
                    } else {
                        JVMController.this._pingOK = false;
                    }
                }
            });
        }
    }

    private void initInternal() {
        this._acceptor = null;
        this._acceptor = new ServerBootstrap((ChannelFactory)new OioServerSocketChannelFactory(executor, executor));
        this._acceptor.setOption("reuseAddress", (Object)false);
        this._acceptor.setOption("tcpNoDelay", (Object)true);
        this._acceptor.setPipelineFactory((ChannelPipelineFactory)new ControllerPipelineFactory(this, this._debug));
        this._init = true;
    }

    public boolean start() {
        int myPort = -1;
        try {
            myPort = Integer.parseInt((String)System.getProperties().get("wrapper.port"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (myPort != -1) {
            _usedPorts.add(myPort);
        }
        try {
            this.initInternal();
            this.setState(0);
            if (this._parentChannel != null && this._parentChannel.isBound()) {
                this.setState(1);
                if (this.isDebug()) {
                    this.getLog().info("binding successfull");
                }
                return true;
            }
            this._port = this._minPort;
            while (this.getState() < 1 && this._port <= this._maxPort) {
                if (_usedPorts.contains(this._port)) {
                    ++this._port;
                    continue;
                }
                try {
                    _usedPorts.add(this._port);
                    if (this.isDebug()) {
                        this.getLog().info("binding to port " + this._port);
                    }
                    this._parentChannel = this._acceptor.bind((SocketAddress)new InetSocketAddress(this._port));
                    this.setState(1);
                    if (this.isDebug()) {
                        this.getLog().info("binding successfull");
                    }
                    return true;
                }
                catch (Exception ex) {
                    this.getLog().info("binding error: " + ex.getMessage() + " -> retry with another port");
                    _usedPorts.remove(this._port);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        this.getLog().info("sleep interrupted in JVMcontroller start");
                        Thread.currentThread().interrupt();
                        return false;
                    }
                    ++this._port;
                }
            }
            this.getLog().severe("could not find a free port in the range " + this._minPort + "..." + this._maxPort);
            return false;
        }
        catch (Exception ex) {
            this.getLog().severe("JVMController start " + ex);
            return false;
        }
    }

    public void beginWaitForStartup() {
        if (this._startupTimeout <= 0) {
            return;
        }
        Runnable timeOutAction = new Runnable(){

            public void run() {
                if (JVMController.this.isDebug()) {
                    JVMController.this.getLog().severe("WrapperManger did not log on within timeout of " + JVMController.this._startupTimeout);
                }
                JVMController.this.stop(4, "STARTUP_TIMEOUT");
            }
        };
        this._timeoutHandle = _scheduler.schedule(timeOutAction, (long)this._startupTimeout, TimeUnit.MILLISECONDS);
    }

    void schedulePingCheck() {
        this._pingOK = false;
        this._pingCheck.start();
    }

    void stopPingCheck() {
        if (this._pingCheck != null) {
            this._pingCheck.stop();
        }
    }

    void pingReceived() {
        this._pingOK = true;
    }

    void serviceStartup() {
        this._wrappedProcess.setAppReportedReady(true);
        if (this._serviceStartupListener != null) {
            this._serviceStartupListener.run();
        } else {
            this.getLog().info("cannot report service startup: listener is null");
        }
    }

    public void stop(int state, String reason) {
        this.stopPingCheck();
        if (this._timeoutHandle != null) {
            this._timeoutHandle.cancel(false);
        }
        if (this._parentChannel != null) {
            int i = 0;
            while (this._channel != null && this._channel.isConnected() && i < 3) {
                ++i;
                this.getLog().info("controller sending a stop command");
                if (this._channel != null) {
                    String txt = null;
                    if (reason != null && reason.length() > 0) {
                        txt = ":" + reason;
                    }
                    this._channel.write((Object)new Message(101, txt));
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ex) {}
            }
            if (this._channel != null && this._channel.isOpen()) {
                try {
                    ChannelFuture cf = this._channel.close();
                    this.getLog().info("controller close session");
                    cf.await(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.getLog().info("session close wait interrupted in JVMController");
                }
            }
        }
        this.setState(state);
    }

    void startupOK() {
        if (this._timeoutHandle == null) {
            return;
        }
        this._timeoutHandle.cancel(false);
        this.schedulePingCheck();
        this._timeoutHandle = null;
    }

    public static void main(String[] args) {
        JVMController c = new JVMController(null);
        c.setDebug(true);
        c.setKey("123");
        c.start();
        c.stop(0, null);
        JVMController c1 = new JVMController(null);
        c1.setDebug(true);
        c1.setKey("123");
        c1.start();
    }

    public int getPort() {
        return this._port;
    }

    public void setMinPort(int port) {
        if (port > 0 && port < 65536) {
            this._minPort = port;
        } else {
            this.getLog().info("port out of range " + port);
        }
    }

    public void setMaxPort(int port) {
        if (port > 0 && port < 65536 && port >= this._minPort) {
            this._maxPort = port;
        } else {
            this.getLog().info("port out of range " + port);
        }
    }

    public void setPort(int port) {
        this._port = port;
    }

    boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public String getKey() {
        return this._key;
    }

    public void setKey(String key) {
        this._key = key;
    }

    int getStartupTimeout() {
        return this._startupTimeout;
    }

    public void setStartupTimeout(int startupTimeout) {
        this._startupTimeout = startupTimeout;
    }

    int getPingTimeout() {
        return this._pingTimeout;
    }

    public void setPingTimeout(int pingTimeout) {
        this._pingTimeout = pingTimeout;
    }

    public boolean waitFor(long timeout) {
        long end = System.currentTimeMillis() + 10000L;
        while (this._state != 3) {
            if (this._state == 4) {
                return false;
            }
            if (System.currentTimeMillis() > end) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.getLog().info("sleep interrupted in JVMController.waitfor");
                return false;
            }
        }
        return true;
    }

    public void requestThreadDump() {
        if (this._channel != null) {
            this._channel.write((Object)new Message(118, null));
        }
    }

    public void requestGc() {
        if (this._channel != null) {
            this._channel.write((Object)new Message(120, null));
        }
    }

    public void requestDumpHeap(String fileName) {
        if (this._channel != null) {
            this._channel.write((Object)new Message(121, fileName));
        }
    }

    public void reset() {
        this.stop(0, "RESTART");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.reset();
        }
        finally {
            super.finalize();
        }
    }

    public void processStarted() {
        while (this._waitingForProcessTermination) {
            try {
                this.getLog().info("should not happen: waiting for termination thread");
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this._waitingForProcessTermination = true;
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Process osProcess;
                try {
                    osProcess = ((WrappedJavaProcess)JVMController.this._wrappedProcess)._osProcess;
                    JVMController.this.getLog().info("waiting for termination of process");
                    if (osProcess != null) {
                        osProcess.waitFor();
                    }
                    JVMController.this.getLog().info("process terminated");
                }
                finally {
                    JVMController.this._waitingForProcessTermination = false;
                }
                JVMController.this._wrappedProcess.osProcessTerminated();
                if (JVMController.this._state == 3 || JVMController.this._state == 5 || osProcess == null || osProcess.isTerminated()) {
                    JVMController.this.stopPingCheck();
                    executor.execute(new Runnable(){

                        public void run() {
                            JVMController.this.setState(8);
                        }
                    });
                }
            }
        });
    }

    public String stateAsStr(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "WAITING";
            }
            case 2: {
                return "ESTABLISHED";
            }
            case 3: {
                return "LOGGED_ON";
            }
            case 4: {
                return "STARTUP_TIMEOUT";
            }
            case 5: {
                return "WAITING_CLOSED";
            }
            case 6: {
                return "USER_STOP";
            }
            case 7: {
                return "PING_TIMEOUT";
            }
            case 8: {
                return "PROCESS_KILLED";
            }
        }
        return "?";
    }

    public void logStateChange(int state) {
        if (state == 4) {
            this.getLog().warning("startup of java application timed out. if this is due to server overload consider increasing wrapper.startup.timeout");
        } else if (state == 7) {
            this.getLog().warning("ping between java application and wrapper timed out. if this this is due to server overload consider increasing wrapper.ping.timeout");
        }
    }

    public void processFailed() {
        this.stop(8, null);
    }

    public void setServiceStartupListener(Runnable serviceStartupListener) {
        this._serviceStartupListener = serviceStartupListener;
    }
}

