/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.controller.jvm;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.rzo.yajsw.controller.Message;
import org.rzo.yajsw.controller.jvm.ControllerHandler;
import org.rzo.yajsw.controller.jvm.JVMController;
import org.rzo.yajsw.controller.jvm.MessageDecoder;
import org.rzo.yajsw.controller.jvm.MessageEncoder;
import org.rzo.yajsw.nettyutils.ChannelGroupFilter;
import org.rzo.yajsw.nettyutils.Condition;
import org.rzo.yajsw.nettyutils.ConditionFilter;
import org.rzo.yajsw.nettyutils.LoggingFilter;
import org.rzo.yajsw.nettyutils.WhitelistFilter;

class ControllerPipelineFactory
implements ChannelPipelineFactory {
    JVMController _controller;
    boolean _debug = false;

    ControllerPipelineFactory(JVMController controller, boolean debug) {
        this._controller = controller;
        this._debug = debug;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this._debug) {
            pipeline.addLast("logging1", (ChannelHandler)new LoggingFilter(this._controller.getLog(), "controller"));
        }
        pipeline.addLast("checkWaiting", (ChannelHandler)new ConditionFilter(new Condition(){

            public boolean isOk(ChannelHandlerContext ctx, ChannelEvent e) {
                boolean result = true;
                int currentState = ControllerPipelineFactory.this._controller.getState();
                if (currentState == 3) {
                    ControllerPipelineFactory.this._controller.getLog().info("app already logged on -> rejecting new connedction");
                    result = false;
                }
                return result;
            }
        }));
        WhitelistFilter firewall = new WhitelistFilter();
        try {
            firewall.allowAll(InetAddress.getAllByName("127.0.0.1"));
            firewall.allow(InetAddress.getLocalHost());
            pipeline.addLast("firewall", (ChannelHandler)firewall);
        }
        catch (UnknownHostException e) {
            this._controller.getLog().throwing(JVMController.class.getName(), "start", e);
        }
        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(8192, true, Delimiters.nulDelimiter()));
        pipeline.addLast("messageEncoder", (ChannelHandler)new MessageEncoder());
        pipeline.addLast("messageDecoder", (ChannelHandler)new MessageDecoder());
        if (this._controller.isDebug()) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingFilter(this._controller.getLog(), "controller"));
            this._controller.getLog().info("Logging ON");
        }
        pipeline.addLast("removeConnected", (ChannelHandler)new ChannelGroupFilter(new Condition(){

            public boolean isOk(ChannelHandlerContext ctx, ChannelEvent e) {
                boolean result = false;
                if (e instanceof MessageEvent) {
                    Message m = (Message)((MessageEvent)e).getMessage();
                    result = m.getCode() == 116;
                }
                return result;
            }
        }));
        pipeline.addLast("handler", (ChannelHandler)new ControllerHandler(this._controller));
        return pipeline;
    }
}

