/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationBinding;
import org.apache.commons.configuration.Interpolator;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public class GInterpolator
implements Interpolator {
    Binding _binding;
    GroovyShell _shell;
    Configuration _conf;
    Map _cache = null;
    String[] _imports = null;
    InternalLogger log = InternalLoggerFactory.getInstance(this.getClass().getName());

    public GInterpolator(Configuration conf, boolean cache, String[] imports, Map utils) {
        this._conf = conf;
        this._binding = new ConfigurationBinding(conf, utils);
        this._shell = new GroovyShell(this._binding);
        this.setCache(cache);
        this._imports = imports;
    }

    public GInterpolator(Configuration conf) {
        this(conf, false, null, null);
    }

    public void setCache(boolean cache) {
        if (cache) {
            this._cache = new HashMap();
        }
    }

    public Object interpolate(Object value) {
        Object cachedResult;
        if (!(value instanceof String)) {
            return value;
        }
        if (this._cache != null && (cachedResult = this._cache.get(value)) != null) {
            return cachedResult;
        }
        String result = (String)value;
        int i = result.lastIndexOf("${");
        while (i != -1) {
            int r = this.getExpression(result, i + 2);
            String expression = result.substring(i + 2, r);
            String eval = this.evaluate(expression);
            String p1 = result.substring(0, i);
            String p2 = result.substring(r + 1);
            result = p1 + eval + p2;
            i = result.lastIndexOf("${");
        }
        if (this._cache != null) {
            this._cache.put(value, result);
        }
        return result;
    }

    private int getExpression(String value, int i) {
        int i1 = value.indexOf(123, i);
        int i2 = value.indexOf(125, i);
        while (i1 != -1 && i2 > i1) {
            i2 = value.indexOf(125, i1);
            i1 = value.indexOf(123, i1 + 1);
        }
        return i2;
    }

    private String evaluate(String value) {
        String result = null;
        Exception caught = null;
        try {
            result = (String)this._binding.getVariable(value);
        }
        catch (Exception ex) {
            caught = ex;
            try {
                result = this._conf.getString(value);
            }
            catch (Exception ex1) {
                caught = ex1;
            }
        }
        if (result == null) {
            try {
                if (this._imports != null) {
                    for (String im : this._imports) {
                        value = "import " + im + "\n" + value;
                    }
                }
                result = this._shell.evaluate(value).toString();
            }
            catch (Exception ex) {
                caught = ex;
            }
        }
        if (result == null) {
            result = "?unresolved?";
            if (caught != null) {
                this.log.warn("error evaluating " + value, (Throwable)caught);
            } else {
                this.log.warn("error evaluating " + value);
            }
        }
        return result;
    }

    public Binding getBinding() {
        return this._binding;
    }
}

