/*
 * Decompiled with CFR 0.152.
 */
package secmgr.manager;

import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.ArrayList;

public class ProfilingSecurityManager
extends SecurityManager {
    private final String thisClassName;
    private final String thisCodeSourceURLString;
    private final String psmMsg = "ProfilingSecurityManager";
    private final ArrayList<String> cacheList = new ArrayList();

    public ProfilingSecurityManager() {
        this.thisClassName = this.getClass().getName();
        CodeSource thisCodeSource = this.getClass().getProtectionDomain().getCodeSource();
        this.thisCodeSourceURLString = thisCodeSource.getLocation().toString();
    }

    @Override
    public void checkPermission(Permission permission) {
        Throwable t = new Throwable("Profiler stack probe");
        StackTraceElement[] stack = t.getStackTrace();
        if (!this.isRecur(stack)) {
            this.buildRules(permission, AccessController.getContext());
        }
    }

    @Override
    public void checkPermission(Permission permission, Object context) {
        this.buildRules(permission, (AccessControlContext)context);
    }

    private void buildRules(Permission permission, AccessControlContext ctx) {
        try {
            ProtectionDomain[] protectionDomain = this.getProtectionDomains(ctx);
            if (null != protectionDomain) {
                for (int i = 0; i < protectionDomain.length; ++i) {
                    String grant = this.formatRule(permission, protectionDomain[i]);
                    if (null == grant || this.isCached(grant)) continue;
                    System.out.println(grant);
                }
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    private boolean isRecur(StackTraceElement[] st) {
        boolean v = false;
        for (int i = st.length - 1; i >= 1; --i) {
            boolean c = st[i].getClassName().equals(this.thisClassName);
            boolean m = st[i].getMethodName().equals("buildRules");
            if (!c || !m) continue;
            v = true;
            break;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtectionDomain[] getProtectionDomains(AccessControlContext context) throws IllegalStateException {
        ProtectionDomain[] pda = null;
        try {
            Field[] fields = AccessControlContext.class.getDeclaredFields();
            if (null == fields) {
                throw new IllegalStateException("No fields");
            }
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals("context")) continue;
                fields[i].setAccessible(true);
                Object o = fields[i].get(context);
                pda = (ProtectionDomain[])o;
                break;
            }
            if (null == pda) {
                throw new IllegalStateException("No \"context\" Field found!");
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        finally {
            return pda;
        }
    }

    private String formatRule(Permission permission, ProtectionDomain pd) {
        CodeSource cs = pd.getCodeSource();
        if (null == cs) {
            return null;
        }
        URL url = cs.getLocation();
        if (null == url) {
            return null;
        }
        if (url.toString().equals(this.thisCodeSourceURLString)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("grant codeBase \"");
        sb.append(url.toString());
        sb.append("\" {");
        sb.append("permission ");
        sb.append(" ");
        sb.append(permission.getClass().getName());
        sb.append(" ");
        sb.append("\"");
        String permissionName = permission.getName();
        String escapedPermissionName = permissionName.replace("\"", "\\\"").replace("\r", "\\\r");
        sb.append(escapedPermissionName);
        sb.append("\", ");
        sb.append("\"");
        sb.append(permission.getActions());
        sb.append("\";");
        sb.append("};");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCached(String candidate) {
        ArrayList<String> arrayList = this.cacheList;
        synchronized (arrayList) {
            for (String s : this.cacheList) {
                if (!s.equals(candidate)) continue;
                return true;
            }
            this.cacheList.add(candidate);
        }
        return false;
    }

    public String toString() {
        return "SecurityManager:  ProfilingSecurityManager";
    }
}

