/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.util;

import org.apache.commons.vfs.cache.SoftRefFilesCache;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.rzo.yajsw.util.File;

public class VFSUtils {
    static DefaultFileSystemManager fsManager = null;
    static FileSystemOptions opts = new FileSystemOptions();
    static FileObject res;
    static String yajswBase;
    private static boolean resolveRes;

    public static void init() throws FileSystemException {
        block5: {
            if (fsManager != null) {
                return;
            }
            fsManager = (DefaultFileSystemManager)VFS.getManager();
            String httpProxy = System.getProperty("http.proxyHost");
            String httpPort = System.getProperty("http.proxyPort");
            yajswBase = System.getProperty("wrapper.base.dir", "../../yajsw-base/");
            String jarResFlag = System.getProperty("wrapper.usejarresources");
            boolean bl = resolveRes = jarResFlag == null || !jarResFlag.equals("false");
            if (resolveRes) {
                Logger.getLogger(SoftRefFilesCache.class).setLevel(Level.ERROR);
                Logger.getLogger(org.apache.commons.vfs2.cache.SoftRefFilesCache.class).setLevel(Level.ERROR);
                res = fsManager.resolveFile("res:resources");
                boolean bl2 = resolveRes = res != null;
            }
            if (httpProxy == null) break block5;
            HttpFileSystemConfigBuilder.getInstance().setProxyHost(opts, httpProxy);
            int port = 8080;
            if (httpPort != null) {
                try {
                    port = Integer.parseInt(httpPort);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            HttpFileSystemConfigBuilder.getInstance().setProxyPort(opts, port);
        }
    }

    public static FileObject resolveFile(String base, String file) throws FileSystemException {
        VFSUtils.init();
        FileObject basef = null;
        FileObject basefUp = null;
        if (base != null) {
            basef = fsManager.resolveFile(new File("."), base);
            basefUp = fsManager.resolveFile(new File(yajswBase), base);
        }
        FileObject result = VFSUtils.resolveFile(new FileObject[]{basef, basefUp}, file);
        return result;
    }

    private static boolean isReal(FileObject fo) throws FileSystemException {
        return fo != null && fo.getType() != FileType.IMAGINARY;
    }

    private static FileObject realest(FileObject[] fo) throws FileSystemException {
        FileObject realest = null;
        for (FileObject cand : fo) {
            if (cand == null) continue;
            if (realest == null) {
                realest = cand;
                continue;
            }
            if (cand.getType() == FileType.IMAGINARY) continue;
            realest = cand;
            break;
        }
        return realest;
    }

    public static FileObject resolveFile(FileObject basef, String file) throws FileSystemException {
        return VFSUtils.resolveFile(new FileObject[]{basef}, file);
    }

    public static FileObject resolveFile(FileObject[] baseflist, String file) throws FileSystemException {
        VFSUtils.init();
        FileObject result = null;
        for (FileObject basef : baseflist) {
            FileObject resultTemp = VFSUtils.resolveFileFinal(basef, file);
            if (VFSUtils.isReal(resultTemp)) {
                result = resultTemp;
                break;
            }
            if (result != null) continue;
            result = resultTemp;
        }
        if (!VFSUtils.isReal(result) && resolveRes) {
            FileObject resultRes = res.resolveFile(file);
            if (result == null || VFSUtils.isReal(resultRes)) {
                result = resultRes;
            }
        }
        return result;
    }

    private static FileObject resolveFileFinal(FileObject basef, String file) throws FileSystemException {
        FileObject result = basef != null ? fsManager.resolveFile(basef, file, opts) : fsManager.resolveFile(file, opts);
        return result;
    }

    static {
        resolveRes = true;
    }
}

