/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray.ahessian.client;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServerConnection;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.util.HashedWheelTimer;
import org.rzo.netty.ahessian.application.jmx.remote.service.AsyncMBeanServerConnection;
import org.rzo.netty.ahessian.application.jmx.remote.service.MBeanServerConnectionAsyncAdapter;
import org.rzo.netty.ahessian.rpc.client.BootstrapProvider;
import org.rzo.netty.ahessian.rpc.client.HessianProxyFactory;
import org.rzo.netty.mcast.discovery.DiscoveryClient;
import org.rzo.netty.mcast.discovery.DiscoveryListener;
import org.rzo.yajsw.tray.ahessian.client.AHessianClientPipelineFactory;

public class AHessianJmxClient
implements BootstrapProvider {
    boolean stop = false;
    DiscoveryClient discovery = null;
    ExecutorService executor = Executors.newCachedThreadPool();
    ClientBootstrap bootstrap = new ClientBootstrap(new NioClientSocketChannelFactory(this.executor, this.executor));
    MBeanServerConnection mbeanServer;
    final Lock lock = new ReentrantLock();
    final Condition connected = this.lock.newCondition();
    String currentHost = null;
    HessianProxyFactory factory = new HessianProxyFactory(this.executor, "AHessianJMX", null);

    public AHessianJmxClient(String discoveryName, int port) throws Exception {
        this.factory.setDisconnectedListener(new Runnable(){

            @Override
            public void run() {
                try {
                    AHessianJmxClient.this.close();
                    if (AHessianJmxClient.this.discovery != null) {
                        if (AHessianJmxClient.this.currentHost != null) {
                            AHessianJmxClient.this.discovery.removeHost(AHessianJmxClient.this.currentHost);
                        }
                        AHessianJmxClient.this.discovery.start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.factory.setConnectedListener(new Runnable(){

            @Override
            public void run() {
                AHessianJmxClient.this.doConnected();
            }
        });
        this.bootstrap.setOption("reuseAddress", true);
        if (port == 0) {
            this.discovery = new DiscoveryClient();
            this.bootstrap.setPipelineFactory(new AHessianClientPipelineFactory(this.executor, this.factory, null));
            this.discovery.setName(discoveryName);
            this.discovery.addListener(new DiscoveryListener(){

                @Override
                public void newHost(String name, String host) {
                    try {
                        String[] x = host.split("&");
                        int port = Integer.parseInt(x[2]);
                        String hostName = x[1];
                        ChannelFuture future = AHessianJmxClient.this.bootstrap.connect(new InetSocketAddress(hostName, port));
                        AHessianJmxClient.this.discovery.stop();
                        AHessianJmxClient.this.currentHost = host;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.discovery.init();
            this.discovery.start();
        } else {
            this.bootstrap.setOption("remoteAddress", new InetSocketAddress("localhost", port));
            this.bootstrap.setPipelineFactory(new AHessianClientPipelineFactory(this.executor, this.factory, this, new HashedWheelTimer()));
            this.bootstrap.connect();
        }
    }

    private void doConnected() {
        this.lock.lock();
        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
        options.put("sync", Boolean.valueOf(true));
        options.put("timeout", Long.valueOf(2000L));
        AsyncMBeanServerConnection asyncService = (AsyncMBeanServerConnection)this.factory.create(AsyncMBeanServerConnection.class, AHessianJmxClient.class.getClassLoader(), options);
        this.mbeanServer = new MBeanServerConnectionAsyncAdapter(asyncService);
        this.connected.signal();
        this.lock.unlock();
    }

    public MBeanServerConnection getMBeanServer() {
        while (this.mbeanServer == null && !this.stop) {
            this.lock.lock();
            try {
                this.connected.await(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.lock.unlock();
        }
        return this.mbeanServer;
    }

    public void close() {
        this.factory.setBlocked(true);
        this.factory.invalidateAllPendingCalls();
        this.factory.invalidateProxies();
        this.mbeanServer = null;
        if (this.factory.getChannel() != null && this.factory.getChannel().isConnected()) {
            this.factory.getChannel().close();
        }
    }

    public void open() {
        this.factory.setBlocked(false);
    }

    public void stop() {
        this.stop = true;
    }

    @Override
    public ClientBootstrap getBootstrap() {
        return this.bootstrap;
    }
}

