/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tools;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.tools.JCLParser;

public class ConfigGenerator {
    private static final String WRAPPER_APP_PARAMETER = "wrapper.app.parameter.";

    private static void usage() {
        System.out.println("Usage: java -cp wrapper.jar org.rzo.yajsw.ConfigurationGenerator <pid> <output file>");
        System.exit(-1);
    }

    public static void generate(int pid, File input, File output) {
        ConfigGenerator.generate(pid, input, output, new HashMap<String, String>());
    }

    public static void generate(int pid, File input, File output, Map<String, String> map) {
        Process p = OperatingSystem.instance().processManagerInstance().getProcess(pid);
        if (p == null) {
            System.out.println("cannot find process " + pid);
            return;
        }
        String cmd = p.getCommand().trim();
        if (cmd == null) {
            System.out.println("cannot get command line of process");
            return;
        }
        System.out.println();
        System.out.println("process command line:");
        System.out.println(p.getCommand());
        System.out.println();
        ConfigGenerator.createConfigFile(p, input, output, cmd);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            ConfigGenerator.usage();
        }
        int pid = -1;
        try {
            pid = Integer.parseInt(args[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ConfigGenerator.usage();
        }
        File output = null;
        try {
            output = new File(args[1]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ConfigGenerator.usage();
        }
        File input = null;
        try {
            input = new File(args[2]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        ConfigGenerator.generate(pid, input, output);
    }

    private static void createConfigFile(Process p, File input, File output, String cmd) {
        if (ConfigGenerator.isJavaCmd(p)) {
            ConfigGenerator.createJavaConfigFile(p, input, output);
        } else {
            ConfigGenerator.createImageConfigFile(p, input, output);
        }
        System.out.println("-----------------");
        System.out.println("Output file: " + output.getAbsolutePath());
        System.out.println("-----------------");
        System.out.println("NOTE: check/edit the following properties in the config file!");
        System.out.println();
        System.out.println("wrapper.app.account, wrapper.app.password: either set the password or remove the account");
        System.out.println("wrapper.java.command");
        System.out.println("wrapper.working.dir");
        System.out.println("wrapper.ntservice.name, wrapper.ntservice.displayname, wrapper.ntservice.description");
        System.out.println("-----------------");
    }

    private static boolean isJavaCmd(Process p) {
        return p.getCommand().contains("java");
    }

    private static void createImageConfigFile(Process p, File input, File output) {
        System.out.println("creating image configuration file");
        System.out.println("NOT YET IMPLEMENTED");
    }

    private static void createJavaConfigFile(Process p, File input, File output) {
        System.out.println("creating java configuration file");
        try {
            PropertiesConfiguration conf = ConfigGenerator.generateConfFromProcess(p, input, true, true);
            conf.save(output);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static PropertiesConfiguration generateConfFromProcess(Process p, File input, boolean includeArgs, boolean updateTitles) throws ConfigurationException {
        PropertiesConfiguration conf = input == null ? new PropertiesConfiguration() : new PropertiesConfiguration(input);
        return ConfigGenerator.updateConfWithProcessDetails(p, includeArgs, updateTitles, conf);
    }

    public static PropertiesConfiguration generateConfFromProcess(Process p, URL input, boolean includeArgs, boolean updateTitles) throws ConfigurationException {
        PropertiesConfiguration conf = input == null ? new PropertiesConfiguration() : new PropertiesConfiguration(input);
        return ConfigGenerator.updateConfWithProcessDetails(p, includeArgs, updateTitles, conf);
    }

    private static PropertiesConfiguration updateConfWithProcessDetails(Process p, boolean includeArgs, boolean updateTitles, PropertiesConfiguration conf) {
        String title;
        String workingDir = p.getWorkingDir();
        String cmd = p.getCommand();
        JCLParser parsedCmd = JCLParser.parse(cmd);
        if (parsedCmd.getMainClass() != null) {
            conf.setProperty("wrapper.java.app.mainclass", parsedCmd.getMainClass());
        } else {
            conf.setProperty("wrapper.java.app.jar", ConfigGenerator.relativeString(parsedCmd.getJar(), workingDir));
        }
        conf.setProperty("wrapper.java.command", parsedCmd.getJava());
        int i = 1;
        List<String> classpathList = parsedCmd.getClasspath();
        if (classpathList == null || classpathList.isEmpty()) {
            classpathList = ConfigGenerator.getClasspathFromEnvironment(p);
        }
        if (classpathList.isEmpty() && parsedCmd.getJar() == null) {
            classpathList.add(".");
        }
        for (String classpath : classpathList) {
            classpath = ConfigGenerator.relativeString(classpath, workingDir);
            if ((classpath = ConfigGenerator.confString(classpath)).endsWith("*")) {
                classpath = classpath + ".jar";
            }
            conf.setProperty("wrapper.java.classpath." + i++, classpath);
        }
        if (includeArgs) {
            ConfigGenerator.setArgsUnsafe(conf, parsedCmd.getArgs(), workingDir);
        }
        i = 1;
        for (String opt : parsedCmd.getVmOptions()) {
            opt = ConfigGenerator.relativeString(opt, workingDir);
            opt = ConfigGenerator.confString(opt);
            conf.setProperty("wrapper.java.additional." + i++, opt);
        }
        if (ConfigGenerator.isNotNullEmpty(workingDir)) {
            workingDir = ConfigGenerator.confString(workingDir);
            conf.setProperty("wrapper.working.dir", workingDir);
        }
        if (cmd.equals(title = p.getTitle())) {
            title = parsedCmd.getMainClass();
        }
        if (ConfigGenerator.isNotNullEmpty(title) && updateTitles) {
            title = ConfigGenerator.confString(title);
            conf.setProperty("wrapper.console.title", title);
            conf.setProperty("wrapper.ntservice.name", title);
            conf.setProperty("wrapper.ntservice.displayname", title);
            conf.setProperty("wrapper.ntservice.description", title);
        }
        return conf;
    }

    private static void setArgsUnsafe(PropertiesConfiguration conf, List<String> args, String workingDir) {
        int i = 1;
        for (String arg : args) {
            arg = ConfigGenerator.relativeString(arg, workingDir);
            arg = ConfigGenerator.confString(arg);
            conf.setProperty(WRAPPER_APP_PARAMETER + i++, arg);
        }
    }

    public static void setArgs(PropertiesConfiguration conf, List<String> args, String workingDir) {
        ConfigGenerator.clearArgs(conf, 1);
        ConfigGenerator.setArgsUnsafe(conf, args, workingDir);
    }

    private static void clearArgs(PropertiesConfiguration conf, int i) {
        Properties props;
        while (!(props = conf.getProperties(WRAPPER_APP_PARAMETER + i)).isEmpty()) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                conf.clearProperty(e.nextElement().toString());
            }
        }
    }

    private static List<String> getClasspathFromEnvironment(Process p) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String[] cpArr;
            String cp = p.getEnvironmentAsMap().get("CLASSPATH");
            if (cp == null) {
                return result;
            }
            for (String cc : cpArr = cp.split(File.pathSeparator)) {
                cc = cc.replaceAll("\"", "");
                result.add(cc.trim());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static List splitArgs(String jvmArgs) {
        ArrayList<String> result = new ArrayList<String>();
        while (jvmArgs.length() > 0) {
            String arg;
            int index;
            if ((jvmArgs = jvmArgs.trim()).startsWith("\"")) {
                jvmArgs = jvmArgs.substring(1);
                index = jvmArgs.indexOf("\"");
                arg = jvmArgs.substring(0, index);
                jvmArgs = jvmArgs.substring(index + 1);
            } else {
                index = jvmArgs.indexOf(" ");
                int index2 = jvmArgs.indexOf("\"");
                if (index2 < index && index2 != -1) {
                    index = jvmArgs.indexOf("\"", index);
                }
                if (index > -1) {
                    arg = jvmArgs.substring(0, index);
                    jvmArgs = jvmArgs.substring(index + 1);
                } else {
                    arg = jvmArgs;
                    jvmArgs = "";
                }
            }
            arg = arg.trim();
            if ((arg = arg.replaceAll("\"", "")).length() <= 0) continue;
            result.add(arg);
        }
        return result;
    }

    private static String relativeString(String str, String base) {
        if (ConfigGenerator.isNotNullEmpty(base)) {
            String baseRegEx = base.replaceAll("\\\\", "\\\\\\\\");
            baseRegEx = baseRegEx.replaceAll("\\.", "\\.");
            String sep = "\\".equals(File.separator) ? "\\\\" : File.separator;
            String result = str.replaceAll(baseRegEx, "." + sep);
            return result;
        }
        return str;
    }

    public static String confString(String str) {
        String result = str.replaceAll("\\\\", "\\\\");
        result = result.replaceAll(",", "\\,");
        return result;
    }

    public static boolean isNotNullEmpty(String str) {
        return str != null && !"".equals(str) && !"Unknown".equals(str);
    }
}

