/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.script;

import java.util.List;
import org.jboss.netty.logging.InternalLogger;
import org.rzo.yajsw.script.GroovyScript;
import org.rzo.yajsw.script.Script;
import org.rzo.yajsw.script.ShellScript;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class ScriptFactory {
    public static Script createScript(String script, String id, WrappedProcess process, String[] args, InternalLogger log, int timeout) {
        block6: {
            if (script == null || "".equals(script)) {
                return null;
            }
            if (log != null) {
                log.info("create script: " + script);
            }
            if (script.endsWith(".bat") || script.endsWith(".sh")) {
                return new ShellScript(script, id, process, args, timeout);
            }
            if (script.endsWith(".gv") || script.endsWith(".groovy")) {
                try {
                    return new GroovyScript(script, id, process, args, timeout, log);
                }
                catch (Throwable e) {
                    if (log == null) break block6;
                    log.info("Error in createScript " + script, e);
                }
            }
        }
        return null;
    }

    public static Script createScript(String script, String id, WrappedProcess process, List args, InternalLogger log, int timeout) {
        String[] argsArr = new String[]{};
        if (args != null && args.size() > 0) {
            argsArr = new String[args.size()];
            for (int i = 0; i < argsArr.length; ++i) {
                argsArr[i] = args.get(i).toString();
            }
        }
        return ScriptFactory.createScript(script, id, process, argsArr, log, timeout);
    }
}

