/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.script;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jboss.netty.logging.InternalLogger;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.script.AbstractScript;
import org.rzo.yajsw.util.VFSUtils;
import org.rzo.yajsw.wrapper.WrappedJavaProcess;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class GroovyScript
extends AbstractScript {
    public static Map context = Collections.synchronizedMap(new HashMap());
    Binding binding;
    WrappedProcess process;
    InternalLogger _logger;
    GroovyObject _script;
    static GroovyClassLoader groovyClassLoader;

    public GroovyScript(String script, String id, WrappedProcess process, String[] args, int timeout, InternalLogger logger) throws CompilationFailedException, IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(script, id, process, args, timeout);
        this._script = this.getScriptInstance(script);
        this.binding = (Binding)this._script.invokeMethod("getBinding", null);
        this.binding.setVariable("args", args);
        this.binding.setVariable("callCount", 0);
        this.binding.setVariable("context", context);
        this._logger = process != null && logger == null ? process.getInternalWrapperLogger() : logger;
        this.binding.setVariable("logger", this._logger);
    }

    private void setGroovyClasspath(GroovyClassLoader loader) {
        ArrayList cp = WrapperLoader.getGroovyClasspath();
        ListIterator it = cp.listIterator();
        while (it.hasNext()) {
            loader.addURL((URL)it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GroovyObject getScriptInstance(String scriptFileName) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        FileObject fileObject = VFSUtils.resolveFile(".", scriptFileName);
        FileName fileName = fileObject.getName();
        long lastModified = fileObject.getContent().getLastModifiedTime();
        String scriptName = StringUtils.removeEnd(fileName.getBaseName(), "." + fileName.getExtension()) + "_" + lastModified;
        Class<GroovyScript> clazz = GroovyScript.class;
        synchronized (GroovyScript.class) {
            if (groovyClassLoader == null) {
                groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader());
                this.setGroovyClasspath(groovyClassLoader);
            }
            try {
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return (GroovyObject)Class.forName(scriptName, true, groovyClassLoader).newInstance();
            }
            catch (ClassNotFoundException e) {
                InputStream in = null;
                String scriptSrc = null;
                try {
                    in = fileObject.getContent().getInputStream();
                    scriptSrc = IOUtils.toString(in, "UTF-8");
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return (GroovyObject)groovyClassLoader.parseClass(scriptSrc, scriptName + ".groovy").newInstance();
            }
        }
    }

    @Override
    public Object execute(String line) {
        Object result = null;
        if (this._script == null) {
            System.out.println("cannot execute script " + this._name);
            return null;
        }
        this.binding.setVariable("id", this._id);
        if (this._process != null) {
            this.binding.setVariable("state", this._process.getStringState());
            this.binding.setVariable("count", this._process.getRestartCount());
            this.binding.setVariable("pid", this._process.getAppPid());
            this.binding.setVariable("exitCode", this._process.getExitCode());
            this.binding.setVariable("line", line);
            this.binding.setVariable("process", this._process);
        }
        try {
            result = this._script.invokeMethod("run", new Object[0]);
        }
        catch (Throwable e) {
            if (this._logger != null) {
                this._logger.info("execption in script " + this._name, e);
            }
            e.printStackTrace();
        }
        this.binding.setVariable("callCount", (Integer)this.binding.getVariable("callCount") + 1);
        return result;
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        WrappedJavaProcess w = new WrappedJavaProcess();
        w.getLocalConfiguration().setProperty("wrapper.config", "conf/wrapper.helloworld.conf");
        w.init();
        GroovyScript script = new GroovyScript("./scripts/timeCondition.gv", "id", w, new String[]{"11", "12"}, 0, null);
        script.execute();
        script.execute();
        script = new GroovyScript("./scripts/fileCondition.gv", "id", w, new String[]{"anchor.lck"}, 0, null);
        script.execute();
        script.execute();
        script = new GroovyScript("./scripts/snmpTrap.gv", "id", w, new String[]{"192.168.0.1", "1", "msg"}, 0, null);
        script.execute();
    }

    @Override
    public Object execute() {
        return this.execute("");
    }

    @Override
    public Object executeWithTimeout() {
        return this.executeWithTimeout("");
    }
}

