/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.ms.win.w32;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import jnacontrib.win32.Registry;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.jboss.netty.logging.InternalLogger;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.os.JavaHome;

public class WindowsJavaHome
implements JavaHome {
    Configuration _config;
    InternalLogger _logger;

    @Override
    public void setLogger(InternalLogger logger) {
        this._logger = logger;
    }

    WindowsJavaHome(Configuration config) {
        this._config = config;
    }

    @Override
    public String findJava(String wrapperJava, String customProcName) {
        String java = null;
        if (wrapperJava != null && !wrapperJava.endsWith(".exe") && !wrapperJava.endsWith("}")) {
            wrapperJava = wrapperJava + ".exe";
        }
        try {
            if (wrapperJava != null) {
                File f = new File(wrapperJava);
                if (!f.isAbsolute()) {
                    File f2 = new File(WrapperLoader.getWrapperHome(), wrapperJava);
                    if (f2.exists()) {
                        try {
                            wrapperJava = f2.getCanonicalPath();
                        }
                        catch (IOException e) {
                            this._logger.warn("Exception in findJava()", e);
                        }
                    }
                } else if (!new File(wrapperJava = new File(wrapperJava).getCanonicalPath()).exists()) {
                    this._logger.error("java file does not exist: " + wrapperJava);
                    return null;
                }
            }
        }
        catch (Exception e) {
            this._logger.warn("Error in JavaHome.findJava(): ", e);
        }
        java = wrapperJava;
        boolean useJavaw = this._config.getBoolean("wrapper.java.command.javaw", wrapperJava != null && wrapperJava.endsWith("javaw.exe"));
        if (java == null) {
            String minVersion = this._config.getString("wrapper.java.command.minVersion");
            String maxVersion = this._config.getString("wrapper.java.command.maxVersion");
            boolean b64bit = this._config.getBoolean("wrapper.java.command.64bit", false);
            boolean jreOnly = this._config.getBoolean("wrapper.java.command.jreOnly", false);
            boolean preferJdk = this._config.getBoolean("wrapper.java.command.preferJdk", false);
            boolean preferJre = this._config.getBoolean("wrapper.java.command.preferJre", !preferJdk);
            boolean jdkOnly = this._config.getBoolean("wrapper.java.command.jdkOnly", false);
            if (!jdkOnly && (jreOnly || preferJre)) {
                java = this.findJavaInRegistry(new String[]{"SOFTWARE\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\IBM\\Java2 Runtime Environment"}, minVersion, maxVersion, b64bit);
            }
            if (java == null && !jreOnly) {
                java = this.findJavaInRegistry(new String[]{"SOFTWARE\\JavaSoft\\Java Development Kit", "SOFTWARE\\IBM\\Java Development Kit"}, minVersion, maxVersion, b64bit);
            }
        } else if (customProcName != null) {
            String h = java;
            File f = new File(h);
            java = f.exists() ? f.getParentFile().getParentFile().getAbsolutePath() : this.findJavaFromPath(java);
        } else {
            return java;
        }
        if (java == null) {
            return null;
        }
        File javaFile = new File(java);
        if (!javaFile.exists()) {
            return null;
        }
        java = javaFile.getAbsolutePath() + "/bin";
        java = !useJavaw ? java + "/java.exe" : java + "/javaw.exe";
        if (customProcName != null) {
            java = this.copyTotmp(java, customProcName);
        }
        this._logger.info("using java: " + java);
        return java;
    }

    private String findJavaFromPath(String java) {
        String[] paths;
        File javaFile;
        if (java != null && (javaFile = new File(java)).exists()) {
            return java;
        }
        for (String path : paths = System.getenv("path").split(";")) {
            File javaFile2;
            if (!path.contains("jdk") && !path.contains("jre") || !(javaFile2 = new File(path)).exists()) continue;
            return path.substring(0, path.length() - 4);
        }
        return null;
    }

    private String copyTotmp(String java, String customProcName) {
        try {
            boolean isTmp = true;
            File javaFile = new File(java);
            File tmpJavaFile = null;
            try {
                File fc = new File(customProcName);
                if (fc.isAbsolute() && fc.getParentFile().exists()) {
                    tmpJavaFile = fc;
                    isTmp = false;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            customProcName = customProcName.endsWith(".exe") ? customProcName.substring(0, customProcName.length() - 4) : customProcName;
            String exeName = "java_" + customProcName + "_";
            if (tmpJavaFile == null) {
                try {
                    tmpJavaFile = File.createTempFile(exeName, ".exe");
                    this.copyFile(javaFile, tmpJavaFile);
                }
                catch (Exception ex) {
                    this._logger.error("error creating tmp file: " + exeName, ex);
                }
            }
            if (!tmpJavaFile.exists()) {
                this.copyFile(javaFile, tmpJavaFile);
            }
            if (isTmp) {
                tmpJavaFile.deleteOnExit();
            }
            return tmpJavaFile.getAbsolutePath();
        }
        catch (Throwable e) {
            this._logger.error("error copying java: " + java + " -> " + customProcName, e);
            return null;
        }
    }

    void copyFile(File in, File out) throws IOException {
        this._logger.info("copying java: " + in.getAbsolutePath() + " -> " + out.getAbsolutePath());
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    private String findJavaFromJavaHomeEnv() {
        return System.getenv("JAVA_HOME");
    }

    private String findJavaInRegistry(String[] keys, String minVersion, String maxVersion, boolean b64bit) {
        String[] values = null;
        String result = null;
        String resultKey = null;
        String resultDir = null;
        minVersion = minVersion == null ? "1.1.0" : minVersion;
        maxVersion = maxVersion == null ? "99.99.99" : maxVersion;
        for (String key : keys) {
            try {
                for (String value : values = Registry.getSubKeys(Registry.REGISTRY_ROOT_KEY.LOCAL_MACHINE, key)) {
                    String dir = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.LOCAL_MACHINE, key + "\\" + value, "JavaHome");
                    boolean exists = false;
                    try {
                        exists = dir != null && new File(dir).exists();
                    }
                    catch (Exception ex) {
                        System.out.println("wrong registry key value: " + dir);
                    }
                    if (!exists || value.compareTo(maxVersion) > 0 || value.compareTo(minVersion) < 0) continue;
                    if (result == null) {
                        result = value;
                        resultKey = key;
                        resultDir = dir;
                        continue;
                    }
                    if (value.compareTo(result) < 0) continue;
                    result = value;
                    resultKey = key;
                    resultDir = dir;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultDir;
    }

    public static void main(String[] args) {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setProperty("wrapper.java.command", "java");
        WindowsJavaHome javaHome = new WindowsJavaHome(conf);
        System.out.println(javaHome.findJava(conf.getString("wrapper.java.command"), conf.getString("wrapper.java.command")));
        conf.setProperty("wrapper.java.customProcName", "test");
        javaHome = new WindowsJavaHome(conf);
        System.out.println(javaHome.findJava(conf.getString("wrapper.java.command"), conf.getString("wrapper.java.command")));
        conf.setProperty("wrapper.java.command", "javaw");
        javaHome = new WindowsJavaHome(conf);
        System.out.println(javaHome.findJava(conf.getString("wrapper.java.command"), conf.getString("wrapper.java.command")));
        conf.clear();
        conf.setProperty("wrapper.java.minversion", "1.5.0");
        conf.setProperty("wrapper.java.maxversion", "1.5.99");
        conf.setProperty("wrapper.java.customProcName", "test");
        javaHome = new WindowsJavaHome(conf);
        System.out.println(javaHome.findJava(conf.getString("wrapper.java.command"), conf.getString("wrapper.java.command")));
        conf.clear();
        conf.setProperty("wrapper.java.minversion", "1.6.0");
        conf.setProperty("wrapper.java.customProcName", "test");
        conf.setProperty("wrapper.java.preferJdk", true);
        javaHome = new WindowsJavaHome(conf);
        System.out.println(javaHome.findJava(conf.getString("wrapper.java.command"), conf.getString("wrapper.java.command")));
    }
}

