/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.nettyutils;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

@ChannelPipelineCoverage(value="all")
public class WhitelistFilter
extends SimpleChannelUpstreamHandler {
    private final List<InetAddress> whitelist = new CopyOnWriteArrayList<InetAddress>();

    public void allowAll(InetAddress[] addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        for (int i = 0; i < addresses.length; ++i) {
            InetAddress addr = addresses[i];
            this.allow(addr);
        }
    }

    public void allowAll(Iterable<InetAddress> addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses");
        }
        for (InetAddress address : addresses) {
            this.allow(address);
        }
    }

    public void allow(InetAddress address) {
        this.whitelist.add(address);
    }

    public void remove(InetAddress address) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.whitelist.remove(address);
    }

    @Override
    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (!this.isBlocked(ctx.getChannel())) {
            ctx.sendUpstream(e);
        } else {
            System.out.println("connection refused : " + ctx.getChannel().getRemoteAddress());
            this.blockSession(ctx.getChannel());
        }
    }

    private void blockSession(Channel session) {
        SocketAddress remoteAddress = session.getRemoteAddress();
        session.close();
    }

    private boolean isBlocked(Channel session) {
        SocketAddress remoteAddress = session.getRemoteAddress();
        return !(remoteAddress instanceof InetSocketAddress) || !this.whitelist.contains(((InetSocketAddress)remoteAddress).getAddress());
    }
}

