/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.controller.jvm;

import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.rzo.yajsw.Constants;
import org.rzo.yajsw.controller.Message;
import org.rzo.yajsw.controller.jvm.JVMController;

@ChannelPipelineCoverage(value="one")
public class ControllerHandler
extends SimpleChannelUpstreamHandler
implements Constants {
    JVMController _controller;

    ControllerHandler(JVMController controller) {
        this._controller = controller;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Message message = (Message)e.getMessage();
        switch (message.getCode()) {
            case 110: {
                if (this._controller._key.equals(message.getMessage())) {
                    this._controller.setState(3);
                    this._controller.startupOK();
                    ctx.getChannel().write(new Message(116, "" + this._controller._wrappedProcess.getAppPid()));
                    if (!this._controller.isDebug()) break;
                    this._controller.getLog().info("Correct key");
                    break;
                }
                if (this._controller.isDebug()) {
                    this._controller.getLog().info("Wrong key -> closing session");
                }
                ctx.getChannel().write(new Message(111, null));
                ctx.getChannel().close();
                break;
            }
            case 101: {
                if (this._controller._wrappedProcess == null) break;
                this._controller._wrappedProcess.stop("APPLICATION");
                break;
            }
            case 117: {
                if (this._controller._wrappedProcess == null) break;
                this._controller._wrappedProcess.stopTimer();
                break;
            }
            case 102: {
                if (this._controller._wrappedProcess == null) break;
                this._controller._wrappedProcess.restartInternal();
                break;
            }
            case 103: {
                this._controller.pingReceived();
                break;
            }
            case 119: {
                this._controller.serviceStartup();
                break;
            }
            case 104: {
                if (this._controller._wrappedProcess == null) break;
                this._controller._wrappedProcess.signalStopping(Long.valueOf(message.getMessage()));
            }
        }
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this._controller._channel != null && this._controller._channel != ctx.getChannel()) {
            if (this._controller.isDebug()) {
                this._controller.getLog().info("session already established -> ignore further sessions");
            }
            ctx.getChannel().close();
        } else if (this._controller._channel == null) {
            this._controller.setState(2);
            this._controller._channel = ctx.getChannel();
        }
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this._controller._channel == ctx.getChannel()) {
            this._controller.workerExecutor.shutdownNow();
            this._controller._channel = null;
            this._controller.setState(5);
            if (this._controller.isDebug()) {
                this._controller.getLog().info("session closed -> waiting");
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (this._controller.isDebug()) {
            this._controller.getLog().info(e.getCause().getMessage());
        }
    }
}

